/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import org.openstreetmap.josm.data.projection.CustomProjection;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionChoice;

public abstract class AbstractProjectionChoice
implements ProjectionChoice {
    protected String name;
    protected String id;
    protected String cacheDir;

    public AbstractProjectionChoice(String string, String string2, String string3) {
        this.name = string;
        this.id = string2;
        this.cacheDir = string3;
    }

    public AbstractProjectionChoice(String string, String string2) {
        this(string, string2, null);
        if (!string2.startsWith("core:")) {
            throw new IllegalArgumentException(string2 + " does not start with core:");
        }
        this.cacheDir = string2.substring(5);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getCacheDir() {
        return this.cacheDir;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public abstract String getCurrentCode();

    public abstract String getProjectionName();

    @Override
    public Projection getProjection() {
        String string = this.getCurrentCode();
        String string2 = Projections.getInit(string);
        if (string2 == null) {
            throw new AssertionError((Object)"Error: Unknown projection code");
        }
        return new CustomProjection(this.getProjectionName(), string, string2, this.getCacheDir());
    }
}

