/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.splitbybookmarks;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.splitbybookmarks.BookmarksLevelComboBox;
import org.pdfsam.splitbybookmarks.SplitByOutlineLevelParametersBuilder;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.ui.help.HelpUtils;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workspace.RestorableView;

class SplitOptionsPane
extends VBox
implements TaskParametersBuildStep<SplitByOutlineLevelParametersBuilder>,
RestorableView {
    private BookmarksLevelComboBox levelCombo = new BookmarksLevelComboBox();
    private TextField regexpField = new TextField();

    SplitOptionsPane() {
        super(5.0);
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        I18nContext ctx = DefaultI18nContext.getInstance();
        this.levelCombo.setId("bookmarksLevel");
        this.regexpField.setId("bookmarksRegexp");
        this.regexpField.setPromptText(ctx.i18n("Regular expression the bookmark has to match"));
        this.regexpField.setPrefWidth(350.0);
        this.getChildren().addAll((Object[])new Node[]{this.createLine(new Node[]{new Label(ctx.i18n("Split at this bookmark level:")), this.levelCombo}), this.createLine(new Node[]{new Label(ctx.i18n("Matching regular expression:")), this.regexpField, HelpUtils.helpIcon((Region)new TextFlow(new Node[]{new Text(ctx.i18n("A regular expression the bookmark text has to match") + System.lineSeparator()), new Text(ctx.i18n("Example: use .*Chapter.* to match bookmarks containing the word \"Chapter\""))}))})});
    }

    void setMaxBookmarkLevel(int max) {
        this.levelCombo.setMaxBookmarkLevel(max);
    }

    private HBox createLine(Node ... items) {
        HBox item = new HBox(items);
        item.getStyleClass().addAll((Object[])Style.VITEM.css());
        item.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        return item;
    }

    @Override
    public void apply(SplitByOutlineLevelParametersBuilder builder, Consumer<String> onError) {
        this.levelCombo.apply(builder, onError);
        if (StringUtils.isNotBlank(this.regexpField.getText())) {
            builder.regexp(this.regexpField.getText());
        }
    }

    @Override
    public void saveStateTo(Map<String, String> data) {
        data.put("regexp", StringUtils.defaultString(this.regexpField.getText()));
        this.levelCombo.saveStateTo(data);
    }

    @Override
    public void restoreStateFrom(Map<String, String> data) {
        this.regexpField.setText(Optional.ofNullable(data.get("regexp")).orElse(""));
        this.levelCombo.restoreStateFrom(data);
    }
}

