/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.command;

import com.baselet.control.HandlerElementMap;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.config.SharedConfig;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.element.Relation;
import com.baselet.element.sticking.StickingPolygon;
import com.baselet.gui.command.Command;
import com.baselet.gui.command.OldMoveLinePoint;
import com.baselet.gui.command.OldRelationLinePoint;
import java.util.List;
import java.util.Vector;

@Deprecated
public class OldResize
extends Command {
    private int current_id = 0;
    private int id;
    private final int diffx;
    private final int diffy;
    private final int diffw;
    private final int diffh;
    private Vector<OldRelationLinePoint> linepoints;
    private final Vector<OldMoveLinePoint> move_commands;
    private final GridElement entity;

    private int getDiffx() {
        return this.diffx * HandlerElementMap.getHandlerForElement(this.entity).getGridSize();
    }

    private int getDiffy() {
        return this.diffy * HandlerElementMap.getHandlerForElement(this.entity).getGridSize();
    }

    private int getDiffw() {
        return this.diffw * HandlerElementMap.getHandlerForElement(this.entity).getGridSize();
    }

    private int getDiffh() {
        return this.diffh * HandlerElementMap.getHandlerForElement(this.entity).getGridSize();
    }

    public OldResize(GridElement entity, int diffx, int diffy, int diffw, int diffh) {
        this(entity, diffx, diffy, diffw, diffh, null);
    }

    private OldResize(GridElement entity, int id, int diffx, int diffy, int diffw, int diffh, Vector<OldMoveLinePoint> move_commands, Vector<OldMoveLinePoint> move_commands2) {
        this.entity = entity;
        this.id = id;
        this.move_commands = move_commands;
        this.move_commands.addAll(move_commands2);
        this.diffx = diffx / HandlerElementMap.getHandlerForElement(entity).getGridSize();
        this.diffy = diffy / HandlerElementMap.getHandlerForElement(entity).getGridSize();
        this.diffw = diffw / HandlerElementMap.getHandlerForElement(entity).getGridSize();
        this.diffh = diffh / HandlerElementMap.getHandlerForElement(entity).getGridSize();
    }

    public OldResize(GridElement entity, int diffx, int diffy, int diffw, int diffh, OldResize first) {
        this.entity = entity;
        this.move_commands = new Vector();
        this.diffx = diffx / HandlerElementMap.getHandlerForElement(entity).getGridSize();
        this.diffy = diffy / HandlerElementMap.getHandlerForElement(entity).getGridSize();
        this.diffw = (diffw - diffx) / HandlerElementMap.getHandlerForElement(entity).getGridSize();
        this.diffh = (diffh - diffy) / HandlerElementMap.getHandlerForElement(entity).getGridSize();
        Rectangle entityRect = this.entity.getRectangle();
        StickingPolygon from = this.entity.generateStickingBorder(entityRect);
        Rectangle newRect = new Rectangle(entityRect.x + diffx, entityRect.y + diffy, entityRect.width + this.getDiffw(), entityRect.height + this.getDiffh());
        StickingPolygon to = this.entity.generateStickingBorder(newRect);
        if (first != null) {
            this.id = first.id;
            this.linepoints = first.linepoints;
        } else {
            this.id = this.current_id++;
            this.linepoints = OldResize.getStickingRelationLinePoints(HandlerElementMap.getHandlerForElement(this.entity), from);
        }
        for (OldRelationLinePoint lp : this.linepoints) {
            Relation r = lp.getRelation();
            Point p = r.getLinePoints().get(lp.getLinePointId());
            PointDouble diff = from.getLine(lp.getStickingLineId()).diffToLine(to.getLine(lp.getStickingLineId()), p.x + r.getRectangle().x, p.y + r.getRectangle().y);
            DiagramHandler handler = HandlerElementMap.getHandlerForElement(entity);
            this.move_commands.add(new OldMoveLinePoint(lp.getRelation(), lp.getLinePointId(), handler.realignToGrid(diff.x), handler.realignToGrid(diff.y)));
        }
    }

    @Override
    public void execute(DiagramHandler handler) {
        super.execute(handler);
        this.entity.setLocationDifference(this.getDiffx(), this.getDiffy());
        this.entity.setSize(this.entity.getRectangle().width + this.getDiffw(), this.entity.getRectangle().height + this.getDiffh());
        if (SharedConfig.getInstance().isStickingEnabled()) {
            for (OldMoveLinePoint c : this.move_commands) {
                c.execute(handler);
            }
        }
    }

    @Override
    public void undo(DiagramHandler handler) {
        super.undo(handler);
        this.entity.setLocationDifference(-this.getDiffx(), -this.getDiffy());
        this.entity.setSize(this.entity.getRectangle().width + -this.getDiffw(), this.entity.getRectangle().height + -this.getDiffh());
        for (OldMoveLinePoint c : this.move_commands) {
            c.undo(handler);
        }
        CurrentDiagram.getInstance().getDiagramHandler().getDrawPanel().updatePanelAndScrollbars();
    }

    @Override
    public boolean isMergeableTo(Command c) {
        if (!(c instanceof OldResize)) {
            return false;
        }
        OldResize r = (OldResize)c;
        return this.id == r.id;
    }

    @Override
    public Command mergeTo(Command c) {
        OldResize tmp = (OldResize)c;
        return new OldResize(this.entity, Math.max(this.id, tmp.id), this.getDiffx() + tmp.getDiffx(), this.getDiffy() + tmp.getDiffy(), this.getDiffw() + tmp.getDiffw(), this.getDiffh() + tmp.getDiffh(), this.move_commands, tmp.move_commands);
    }

    public static Vector<OldRelationLinePoint> getStickingRelationLinePoints(DiagramHandler handler, StickingPolygon stickingPolygon) {
        Vector<OldRelationLinePoint> lpts = new Vector<OldRelationLinePoint>();
        List<Relation> rels = handler.getDrawPanel().getOldRelations();
        for (Relation r : rels) {
            PointDouble l1 = r.getAbsoluteCoorStart();
            PointDouble l2 = r.getAbsoluteCoorEnd();
            int c1 = stickingPolygon.isConnected(l1, handler.getGridSize());
            int c2 = stickingPolygon.isConnected(l2, handler.getGridSize());
            if (c1 >= 0) {
                lpts.add(new OldRelationLinePoint(r, 0, c1));
            }
            if (c2 < 0) continue;
            lpts.add(new OldRelationLinePoint(r, r.getLinePoints().size() - 1, c2));
        }
        return lpts;
    }
}

