/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.AbstractStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModelEvent;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModelListener;
import org.zaproxy.zap.extension.httppanel.view.text.HttpPanelTextArea;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchableHttpPanelView;
import org.zaproxy.zap.view.messagecontainer.http.DefaultSingleHttpMessageContainer;

public abstract class HttpPanelTextView
implements HttpPanelView,
HttpPanelViewModelListener,
SearchableHttpPanelView {
    public static final String DEFAULT_MESSAGE_CONTAINER_NAME = "HttpMessagePanel";
    public static final String NAME = "HttpPanelTextView";
    private static final String CAPTION_NAME = Constant.messages.getString("http.panel.view.text.name");
    private HttpPanelTextArea httpPanelTextArea;
    private JPanel mainPanel;
    private AbstractStringHttpPanelViewModel model;
    private final String messageContainerName;

    public HttpPanelTextView(AbstractStringHttpPanelViewModel abstractStringHttpPanelViewModel) {
        this(DEFAULT_MESSAGE_CONTAINER_NAME, abstractStringHttpPanelViewModel);
    }

    public HttpPanelTextView(String string, AbstractStringHttpPanelViewModel abstractStringHttpPanelViewModel) {
        this.model = abstractStringHttpPanelViewModel;
        this.messageContainerName = string;
        this.init();
        this.model.addHttpPanelViewModelListener(this);
    }

    private void init() {
        this.httpPanelTextArea = this.createHttpPanelTextArea();
        this.httpPanelTextArea.setEditable(false);
        this.httpPanelTextArea.setLineWrap(true);
        this.httpPanelTextArea.setComponentPopupMenu(new CustomPopupMenu());
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)new JScrollPane(this.httpPanelTextArea), "Center");
    }

    protected abstract HttpPanelTextArea createHttpPanelTextArea();

    @Override
    public void setSelected(boolean bl) {
        if (bl) {
            this.httpPanelTextArea.requestFocusInWindow();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getCaptionName() {
        return CAPTION_NAME;
    }

    @Override
    public String getTargetViewName() {
        return "";
    }

    @Override
    public int getPosition() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean isEnabled(Message message) {
        return true;
    }

    @Override
    public boolean hasChanged() {
        return true;
    }

    @Override
    public JComponent getPane() {
        return this.mainPanel;
    }

    @Override
    public boolean isEditable() {
        return this.httpPanelTextArea.isEditable();
    }

    @Override
    public void setEditable(boolean bl) {
        this.httpPanelTextArea.setEditable(bl);
        if (!bl) {
            this.httpPanelTextArea.discardAllEdits();
        }
    }

    @Override
    public HttpPanelViewModel getModel() {
        return this.model;
    }

    @Override
    public void dataChanged(HttpPanelViewModelEvent httpPanelViewModelEvent) {
        this.httpPanelTextArea.setMessage(this.model.getMessage());
        this.httpPanelTextArea.setText(this.model.getData());
        this.httpPanelTextArea.setCaretPosition(0);
    }

    @Override
    public void save() {
        this.model.setData(this.httpPanelTextArea.getText());
    }

    @Override
    public void search(Pattern pattern, List<SearchMatch> list) {
        this.httpPanelTextArea.search(pattern, list);
    }

    @Override
    public void highlight(SearchMatch searchMatch) {
        this.httpPanelTextArea.highlight(searchMatch);
    }

    @Override
    public void setParentConfigurationKey(String string) {
    }

    @Override
    public void loadConfiguration(FileConfiguration fileConfiguration) {
    }

    @Override
    public void saveConfiguration(FileConfiguration fileConfiguration) {
    }

    protected class CustomPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        protected CustomPopupMenu() {
        }

        @Override
        public void show(Component component, int n, int n2) {
            if (!HttpPanelTextView.this.httpPanelTextArea.isFocusOwner()) {
                HttpPanelTextView.this.httpPanelTextArea.requestFocusInWindow();
            }
            if (HttpPanelTextView.this.httpPanelTextArea.getMessage() instanceof HttpMessage) {
                DefaultSingleHttpMessageContainer defaultSingleHttpMessageContainer = new DefaultSingleHttpMessageContainer(HttpPanelTextView.this.messageContainerName, HttpPanelTextView.this.httpPanelTextArea, (HttpMessage)HttpPanelTextView.this.httpPanelTextArea.getMessage());
                View.getSingleton().getPopupMenu().show(defaultSingleHttpMessageContainer, n, n2);
            } else {
                View.getSingleton().getPopupMenu().show(HttpPanelTextView.this.httpPanelTextArea, n, n2);
            }
        }
    }
}

