/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.session;

import net.sf.json.JSONObject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.HttpState;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.AbstractSessionManagementMethodOptionsPanel;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.SessionManagementMethodType;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.utils.ApiUtils;

public class HttpAuthSessionManagementMethodType
extends SessionManagementMethodType {
    private static final int METHOD_IDENTIFIER = 1;
    private static final Logger log = Logger.getLogger(HttpAuthSessionManagementMethod.class);
    private static final String METHOD_NAME = Constant.messages.getString("sessionmanagement.method.ha.name");
    private static final String API_METHOD_NAME = "httpAuthSessionManagement";

    @Override
    public SessionManagementMethod createSessionManagementMethod(int n) {
        return new HttpAuthSessionManagementMethod();
    }

    @Override
    public String getName() {
        return METHOD_NAME;
    }

    @Override
    public int getUniqueIdentifier() {
        return 1;
    }

    @Override
    public AbstractSessionManagementMethodOptionsPanel buildOptionsPanel(Context context) {
        return null;
    }

    @Override
    public boolean hasOptionsPanel() {
        return false;
    }

    @Override
    public boolean isTypeForMethod(SessionManagementMethod sessionManagementMethod) {
        return sessionManagementMethod instanceof HttpAuthSessionManagementMethod;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
    }

    @Override
    public SessionManagementMethod loadMethodFromSession(Session session, int n) throws DatabaseException {
        return new HttpAuthSessionManagementMethod();
    }

    @Override
    public void persistMethodToSession(Session session, int n, SessionManagementMethod sessionManagementMethod) throws SessionManagementMethodType.UnsupportedSessionManagementMethodException, DatabaseException {
    }

    @Override
    public void exportData(Configuration configuration, SessionManagementMethod sessionManagementMethod) {
    }

    @Override
    public void importData(Configuration configuration, SessionManagementMethod sessionManagementMethod) throws ConfigurationException {
    }

    @Override
    public ApiDynamicActionImplementor getSetMethodForContextApiAction() {
        return new ApiDynamicActionImplementor(API_METHOD_NAME, null, null){

            @Override
            public void handleAction(JSONObject jSONObject) throws ApiException {
                Context context = ApiUtils.getContextByParamId(jSONObject, "contextId");
                context.setSessionManagementMethod(HttpAuthSessionManagementMethodType.this.createSessionManagementMethod(context.getIndex()));
            }
        };
    }

    public static class HttpAuthSession
    extends WebSession {
        private static int generatedNameIndex;

        public HttpAuthSession(String string) {
            super(string, new HttpState());
        }

        public HttpAuthSession() {
            super("Http Auth Session " + generatedNameIndex++, new HttpState());
        }
    }

    public static class HttpAuthSessionManagementMethod
    implements SessionManagementMethod {
        @Override
        public boolean isConfigured() {
            return true;
        }

        @Override
        public SessionManagementMethodType getType() {
            return new HttpAuthSessionManagementMethodType();
        }

        @Override
        public WebSession extractWebSession(HttpMessage httpMessage) {
            return new HttpAuthSession();
        }

        @Override
        public WebSession createEmptyWebSession() {
            return new HttpAuthSession();
        }

        @Override
        public void clearWebSessionIdentifiers(HttpMessage httpMessage) {
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            return new ApiResponseElement("methodName", HttpAuthSessionManagementMethodType.API_METHOD_NAME);
        }

        @Override
        public void processMessageToMatchSession(HttpMessage httpMessage, WebSession webSession) throws SessionManagementMethod.UnsupportedWebSessionException {
        }

        @Override
        public SessionManagementMethod clone() {
            return new HttpAuthSessionManagementMethod();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

