/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    ImageList imageList;

    public TabFolder(Composite composite, int n) {
        super(composite, TabFolder.checkStyle(n));
    }

    static int checkStyle(int n) {
        n = TabFolder.checkBits(n, 128, 1024, 0, 0, 0, 0);
        return n & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    long childStyle() {
        long l = OS.gtk_widget_get_modifier_style(this.handle);
        if ((OS.gtk_rc_style_get_color_flags(l, 0) & 2) != 0) {
            return 0L;
        }
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_widget_get_style(this.handle);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    long clientHandle() {
        int n = OS.gtk_notebook_get_current_page(this.handle);
        if (n != -1 && this.items[n] != null) {
            return this.items[n].pageHandle;
        }
        return this.handle;
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        Point point = super.computeSize(n, n2, bl);
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        boolean bl2 = OS.gtk_notebook_get_scrollable(this.handle);
        OS.gtk_notebook_set_scrollable(this.handle, false);
        Point point2 = this.computeNativeSize(this.handle, n, n2, bl);
        OS.gtk_notebook_set_scrollable(this.handle, bl2);
        if (OS.GTK_VERSION >= OS.VERSION(3, 2, 0)) {
            int[] nArray = new int[1];
            OS.gtk_widget_style_get(this.handle, OS.initial_gap, nArray, 0L);
            point2.x += nArray[0] * 2;
        }
        point.x = Math.max(point2.x, point.x);
        point.y = Math.max(point2.y, point.y);
        return point;
    }

    @Override
    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.forceResize();
        long l = this.clientHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(l, gtkAllocation);
        int n5 = gtkAllocation.x;
        int n6 = gtkAllocation.y;
        n -= n5;
        n2 -= n6;
        n3 += n5 + n5;
        if ((this.style & 0x400) != 0) {
            int n7 = gtkAllocation.height;
            OS.gtk_widget_get_allocation(this.handle, gtkAllocation);
            int n8 = gtkAllocation.height;
            n4 += n8 - n7;
        } else {
            n4 += n5 + n6;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    @Override
    public Rectangle getClientArea() {
        Rectangle rectangle = super.getClientArea();
        if (OS.GTK3) {
            rectangle.x = 0;
            rectangle.y = 0;
        }
        return rectangle;
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_notebook_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        OS.gtk_notebook_set_show_tabs(this.handle, true);
        OS.gtk_notebook_set_scrollable(this.handle, true);
        if ((this.style & 0x400) != 0) {
            OS.gtk_notebook_set_tab_pos(this.handle, 3);
        }
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.items = new TabItem[4];
    }

    void createItem(TabItem tabItem, int n) {
        long l;
        long l2;
        long l3;
        long l4 = OS.gtk_container_get_children(this.handle);
        int n2 = 0;
        if (l4 != 0L) {
            n2 = OS.g_list_length(l4);
            OS.g_list_free(l4);
        }
        if (0 > n || n > n2) {
            this.error(6);
        }
        if (n2 == this.items.length) {
            TabItem[] tabItemArray = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, tabItemArray, 0, this.items.length);
            this.items = tabItemArray;
        }
        if ((l3 = this.gtk_box_new(0, false, 0)) == 0L) {
            this.error(2);
        }
        if ((l2 = OS.gtk_label_new_with_mnemonic(null)) == 0L) {
            this.error(2);
        }
        if ((l = OS.gtk_image_new()) == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(l3, l);
        OS.gtk_container_add(l3, l2);
        long l5 = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (l5 == 0L) {
            this.error(2);
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        OS.gtk_notebook_insert_page(this.handle, l5, l3, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        OS.gtk_widget_show(l3);
        OS.gtk_widget_show(l2);
        OS.gtk_widget_show(l5);
        tabItem.state |= 8;
        tabItem.handle = l3;
        tabItem.labelHandle = l2;
        tabItem.imageHandle = l;
        tabItem.pageHandle = l5;
        System.arraycopy(this.items, n, this.items, n + 1, n2++ - n);
        this.items[n] = tabItem;
        if ((this.state & 0x1000) != 0) {
            tabItem.setForegroundColor(this.getForegroundColor());
        }
        if ((this.state & 0x4000) != 0) {
            tabItem.setFontDescription(this.getFontDescription());
        }
        if (n2 == 1) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
            OS.gtk_notebook_set_current_page(this.handle, 0);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
            Event event = new Event();
            event.item = this.items[0];
            this.sendSelectionEvent(13, event, false);
        }
    }

    void destroyItem(TabItem tabItem) {
        int n;
        int n2;
        int n3 = this.getItemCount();
        for (n2 = 0; n2 < n3 && this.items[n2] != tabItem; ++n2) {
        }
        if (n2 == n3) {
            this.error(15);
        }
        int n4 = OS.gtk_notebook_get_current_page(this.handle);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        OS.gtk_notebook_remove_page(this.handle, n2);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        System.arraycopy(this.items, n2 + 1, this.items, n2, --n3 - n2);
        this.items[n3] = null;
        if (n2 == n4 && (n = OS.gtk_notebook_get_current_page(this.handle)) != -1) {
            Control control = this.items[n].getControl();
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            Event event = new Event();
            event.item = this.items[n];
            this.sendSelectionEvent(13, event, true);
        }
    }

    @Override
    long eventHandle() {
        return this.handle;
    }

    public TabItem getItem(int n) {
        long l;
        this.checkWidget();
        if (0 > n || n >= this.getItemCount()) {
            this.error(6);
        }
        if ((l = OS.gtk_container_get_children(this.handle)) == 0L) {
            this.error(8);
        }
        int n2 = OS.g_list_length(l);
        OS.g_list_free(l);
        if (0 > n || n >= n2) {
            this.error(8);
        }
        return this.items[n];
    }

    public TabItem getItem(Point point) {
        long l;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((l = OS.gtk_container_get_children(this.handle)) == 0L) {
            return null;
        }
        int n = OS.g_list_length(l);
        OS.g_list_free(l);
        for (int i = 0; i < n; ++i) {
            TabItem tabItem = this.items[i];
            Rectangle rectangle = tabItem.getBounds();
            if (!rectangle.contains(point)) continue;
            return tabItem;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        long l = OS.gtk_container_get_children(this.handle);
        if (l == 0L) {
            return 0;
        }
        int n = OS.g_list_length(l);
        OS.g_list_free(l);
        return n;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        TabItem[] tabItemArray = new TabItem[n];
        System.arraycopy(this.items, 0, tabItemArray, 0, n);
        return tabItemArray;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int n = OS.gtk_notebook_get_current_page(this.handle);
        if (n == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[n]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.gtk_notebook_get_current_page(this.handle);
    }

    @Override
    long gtk_focus(long l, long l2) {
        return 0L;
    }

    @Override
    long gtk_switch_page(long l, long l2, long l3) {
        Control control;
        Widget widget;
        int n = OS.gtk_notebook_get_current_page(this.handle);
        if (n != -1 && (widget = this.items[n].getControl()) != null && !widget.isDisposed()) {
            ((Control)widget).setVisible(false);
        }
        if ((control = ((TabItem)(widget = this.items[(int)l3])).getControl()) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
        Event event = new Event();
        event.item = widget;
        this.sendSelectionEvent(13, event, false);
        return 0L;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.switch_page, this.display.getClosure(49), false);
    }

    public int indexOf(TabItem tabItem) {
        long l;
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        if ((l = OS.gtk_container_get_children(this.handle)) == 0L) {
            return -1;
        }
        int n = OS.g_list_length(l);
        OS.g_list_free(l);
        for (int i = 0; i < n; ++i) {
            if (this.items[i] != tabItem) continue;
            return i;
        }
        return -1;
    }

    @Override
    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = OS.GTK3 ? this._getChildren(this.clientHandle()) : this._getChildren();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < controlArray.length; ++i) {
            SerializableCompatibility serializableCompatibility;
            Control control = controlArray[i];
            int n5 = 0;
            int n6 = 0;
            long l = OS.gtk_container_get_children(this.handle);
            if (l != 0L) {
                n6 = OS.g_list_length(l);
                OS.g_list_free(l);
            }
            while (n5 < n6 && this.items[n5].control != control) {
                ++n5;
            }
            if (n5 == n6) {
                serializableCompatibility = control.getBounds();
                n3 = Math.max(n3, serializableCompatibility.x + serializableCompatibility.width);
                n4 = Math.max(n4, serializableCompatibility.y + serializableCompatibility.height);
                continue;
            }
            serializableCompatibility = control.computeSize(n, n2, bl);
            n3 = Math.max(n3, ((Point)serializableCompatibility).x);
            n4 = Math.max(n4, ((Point)serializableCompatibility).y);
        }
        return new Point(n3, n4);
    }

    @Override
    boolean mnemonicHit(char c) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            long l = this.items[i].labelHandle;
            if (l == 0L || !this.mnemonicHit(l, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char c) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            long l = this.items[i].labelHandle;
            if (l == 0L || !this.mnemonicHit(l, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                TabItem tabItem = this.items[i];
                if (tabItem == null || tabItem.isDisposed()) continue;
                tabItem.release(false);
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            TabItem tabItem = this.items[i];
            if (tabItem.control != control) continue;
            tabItem.setControl(null);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    void reskinChildren(int n) {
        long l;
        if (this.items != null && (l = OS.gtk_container_get_children(this.handle)) != 0L) {
            int n2 = OS.g_list_length(l);
            OS.g_list_free(l);
            for (int i = 0; i < n2; ++i) {
                TabItem tabItem = this.items[i];
                if (tabItem == null) continue;
                tabItem.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        int n6 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if ((n6 & 0x100) != 0 && (n5 = this.getSelectionIndex()) != -1) {
            TabItem tabItem = this.items[n5];
            Control control = tabItem.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
            }
        }
        return n6;
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        TabItem[] tabItemArray = this.getItems();
        for (int i = 0; i < tabItemArray.length; ++i) {
            if (tabItemArray[i] == null) continue;
            tabItemArray[i].setFontDescription(l);
        }
    }

    @Override
    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        TabItem[] tabItemArray = this.getItems();
        for (int i = 0; i < tabItemArray.length; ++i) {
            if (tabItemArray[i] == null) continue;
            tabItemArray[i].setForegroundColor(gdkColor);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                this.items[i].setOrientation(bl);
            }
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        if (0 > n || n >= this.getItemCount()) {
            return;
        }
        this.setSelection(n, false);
    }

    void setSelection(int n, boolean bl) {
        Widget widget;
        if (n < 0) {
            return;
        }
        int n2 = OS.gtk_notebook_get_current_page(this.handle);
        if (n2 == n) {
            return;
        }
        if (n2 != -1) {
            TabItem tabItem = this.items[n2];
            widget = tabItem.control;
            if (widget != null && !widget.isDisposed()) {
                widget.setVisible(false);
            }
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        OS.gtk_notebook_set_current_page(this.handle, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        int n3 = OS.gtk_notebook_get_current_page(this.handle);
        if (n3 != -1) {
            widget = this.items[n3];
            Control control = ((TabItem)widget).control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (bl) {
                Event event = new Event();
                event.item = widget;
                this.sendSelectionEvent(13, event, true);
            }
        }
    }

    public void setSelection(TabItem tabItem) {
        if (tabItem == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{tabItem});
    }

    public void setSelection(TabItem[] tabItemArray) {
        this.checkWidget();
        if (tabItemArray == null) {
            this.error(4);
        }
        if (tabItemArray.length == 0) {
            this.setSelection(-1, false);
        } else {
            for (int i = tabItemArray.length - 1; i >= 0; --i) {
                int n = this.indexOf(tabItemArray[i]);
                if (n == -1) continue;
                this.setSelection(n, false);
            }
        }
    }

    @Override
    boolean traversePage(boolean bl) {
        if (bl) {
            OS.gtk_notebook_next_page(this.handle);
        } else {
            OS.gtk_notebook_prev_page(this.handle);
        }
        return true;
    }
}

