/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.memory.MemoryCCTManager;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.PresoObjLivenessCCTNode;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.ReverseMemCallGraphPanel;
import org.netbeans.lib.profiler.utils.StringUtils;

public class LiveReverseMemCallGraphPanel
extends ReverseMemCallGraphPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String NO_STACKS_MSG = messages.getString("LiveReverseMemCallGraphPanel_NoStacksMsg");
    private static final String TREETABLE_ACCESS_NAME = messages.getString("LiveReverseMemCallGraphPanel_TreeTableAccessName");
    protected MemoryCCTManager callGraphManager;
    protected ProfilingSessionStatus status;
    protected int classId;
    private AbstractTreeTableModel abstractTreeTableModel;

    public LiveReverseMemCallGraphPanel(ProfilingSessionStatus profilingSessionStatus, MemoryResUserActionsHandler memoryResUserActionsHandler) {
        super(memoryResUserActionsHandler, profilingSessionStatus.currentInstrType == 6);
        this.status = profilingSessionStatus;
    }

    public void setCallGraph(MemoryCCTManager memoryCCTManager, int n) {
        this.callGraphManager = memoryCCTManager;
        this.classId = n;
        if (!memoryCCTManager.isEmpty()) {
            this.customBarCellRenderer = new CustomBarCellRenderer(0L, memoryCCTManager.getRootNode().totalObjSize);
            this.columnRenderers[1] = this.customBarCellRenderer;
        }
    }

    @Override
    public void prepareResults() {
        if (this.callGraphManager.isEmpty()) {
            this.removeAll();
            this.add((Component)new JLabel(NO_STACKS_MSG), "Center");
        } else {
            this.abstractTreeTableModel = new AbstractTreeTableModel((CCTNode)this.callGraphManager.getRootNode(), 1, false){

                @Override
                public int getColumnCount() {
                    return LiveReverseMemCallGraphPanel.this.columnNames.length;
                }

                @Override
                public String getColumnName(int n) {
                    return LiveReverseMemCallGraphPanel.this.columnNames[n];
                }

                @Override
                public Class getColumnClass(int n) {
                    if (n == 0) {
                        return TreeTableModel.class;
                    }
                    return Object.class;
                }

                @Override
                public Object getValueAt(Object object, int n) {
                    if (LiveReverseMemCallGraphPanel.this.extendedResults) {
                        PresoObjLivenessCCTNode presoObjLivenessCCTNode = (PresoObjLivenessCCTNode)object;
                        switch (n) {
                            case 0: {
                                return presoObjLivenessCCTNode.toString();
                            }
                            case 1: {
                                return new Long(presoObjLivenessCCTNode.totalObjSize);
                            }
                            case 2: {
                                long l = ((PresoObjLivenessCCTNode)this.root).totalObjSize;
                                return LiveReverseMemCallGraphPanel.this.intFormat.format(presoObjLivenessCCTNode.totalObjSize) + " B (" + (l == 0L ? "-%" : LiveReverseMemCallGraphPanel.this.percentFormat.format((float)presoObjLivenessCCTNode.totalObjSize / (float)l)) + ")";
                            }
                            case 3: {
                                long l = ((PresoObjLivenessCCTNode)this.root).nLiveObjects;
                                return LiveReverseMemCallGraphPanel.this.intFormat.format(presoObjLivenessCCTNode.nLiveObjects) + " (" + (l == 0L ? "-%" : LiveReverseMemCallGraphPanel.this.percentFormat.format((float)presoObjLivenessCCTNode.nLiveObjects / (float)l)) + ")";
                            }
                            case 4: {
                                return LiveReverseMemCallGraphPanel.this.intFormat.format(presoObjLivenessCCTNode.nCalls);
                            }
                            case 5: {
                                return StringUtils.floatPerCentToString((float)presoObjLivenessCCTNode.avgObjectAge);
                            }
                            case 6: {
                                return LiveReverseMemCallGraphPanel.this.intFormat.format(presoObjLivenessCCTNode.survGen);
                            }
                        }
                    } else {
                        PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)object;
                        switch (n) {
                            case 0: {
                                return presoObjAllocCCTNode.getNodeName();
                            }
                            case 1: {
                                return new Long(presoObjAllocCCTNode.totalObjSize);
                            }
                            case 2: {
                                long l = ((PresoObjAllocCCTNode)this.root).totalObjSize;
                                return LiveReverseMemCallGraphPanel.this.intFormat.format(presoObjAllocCCTNode.totalObjSize) + " B (" + (l == 0L ? "-%" : LiveReverseMemCallGraphPanel.this.percentFormat.format((float)presoObjAllocCCTNode.totalObjSize / (float)l)) + ")";
                            }
                            case 3: {
                                long l = ((PresoObjAllocCCTNode)this.root).nCalls;
                                return LiveReverseMemCallGraphPanel.this.intFormat.format(presoObjAllocCCTNode.nCalls) + " (" + (l == 0L ? "-%" : LiveReverseMemCallGraphPanel.this.percentFormat.format((float)presoObjAllocCCTNode.nCalls / (float)l)) + ")";
                            }
                        }
                    }
                    return null;
                }

                @Override
                public String getColumnToolTipText(int n) {
                    return LiveReverseMemCallGraphPanel.this.columnToolTips[n];
                }

                @Override
                public void sortByColumn(int n, boolean bl) {
                    if (LiveReverseMemCallGraphPanel.this.extendedResults) {
                        PresoObjLivenessCCTNode presoObjLivenessCCTNode = (PresoObjLivenessCCTNode)this.root;
                        switch (n) {
                            case 0: {
                                presoObjLivenessCCTNode.sortChildren(6, bl);
                                break;
                            }
                            case 1: 
                            case 2: {
                                presoObjLivenessCCTNode.sortChildren(1, bl);
                                break;
                            }
                            case 3: {
                                presoObjLivenessCCTNode.sortChildren(2, bl);
                                break;
                            }
                            case 4: {
                                presoObjLivenessCCTNode.sortChildren(3, bl);
                                break;
                            }
                            case 5: {
                                presoObjLivenessCCTNode.sortChildren(4, bl);
                                break;
                            }
                            case 6: {
                                presoObjLivenessCCTNode.sortChildren(5, bl);
                            }
                        }
                    } else {
                        PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)this.root;
                        switch (n) {
                            case 0: {
                                presoObjAllocCCTNode.sortChildren(1, bl);
                                break;
                            }
                            case 1: 
                            case 2: {
                                presoObjAllocCCTNode.sortChildren(2, bl);
                                break;
                            }
                            case 3: {
                                presoObjAllocCCTNode.sortChildren(3, bl);
                            }
                        }
                    }
                }

                @Override
                public boolean getInitialSorting(int n) {
                    switch (n) {
                        case 0: {
                            return true;
                        }
                    }
                    return false;
                }
            };
            this.treeTableModel = new ExtendedTreeTableModel(this.abstractTreeTableModel);
            this.treeTable = new JTreeTable(this.treeTableModel){

                @Override
                public void doLayout() {
                    int n = 0;
                    int n2 = -1;
                    TableColumnModel tableColumnModel = this.getColumnModel();
                    for (int i = 0; i < LiveReverseMemCallGraphPanel.this.treeTableModel.getColumnCount(); ++i) {
                        int n3 = LiveReverseMemCallGraphPanel.this.treeTableModel.getRealColumn(i);
                        if (n3 == 0) {
                            n2 = i;
                            continue;
                        }
                        n += tableColumnModel.getColumn(i).getPreferredWidth();
                    }
                    if (n2 != -1) {
                        tableColumnModel.getColumn(n2).setPreferredWidth(Math.max(this.getWidth() - n, LiveReverseMemCallGraphPanel.this.minNamesColumnWidth));
                    }
                    super.doLayout();
                }
            };
            this.treeTable.getAccessibleContext().setAccessibleName(TREETABLE_ACCESS_NAME);
            this.treeTable.setRowSelectionAllowed(true);
            this.treeTable.setSelectionMode(0);
            this.treeTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
            this.treeTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
            this.treeTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
            this.treeTable.setShowHorizontalLines(false);
            this.treeTable.setShowVerticalLines(true);
            this.treeTable.setRowMargin(0);
            this.treeTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
            this.setColumnsData();
            UIUtils.autoExpandRoot(this.treeTable.getTree());
            UIUtils.makeTreeAutoExpandable(this.treeTable.getTree());
            this.treeTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getModifiers() == 4) {
                        LiveReverseMemCallGraphPanel.this.treePath = LiveReverseMemCallGraphPanel.this.treeTable.getTree().getPathForRow(LiveReverseMemCallGraphPanel.this.treeTable.rowAtPoint(mouseEvent.getPoint()));
                        if (LiveReverseMemCallGraphPanel.this.treePath != null) {
                            LiveReverseMemCallGraphPanel.this.treeTable.getTree().setSelectionPath(LiveReverseMemCallGraphPanel.this.treePath);
                        }
                    }
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    LiveReverseMemCallGraphPanel.this.treePath = LiveReverseMemCallGraphPanel.this.treeTable.getTree().getPathForRow(LiveReverseMemCallGraphPanel.this.treeTable.rowAtPoint(mouseEvent.getPoint()));
                    if (LiveReverseMemCallGraphPanel.this.treePath == null) {
                        if (mouseEvent.getModifiers() == 4) {
                            LiveReverseMemCallGraphPanel.this.treeTable.getTree().clearSelection();
                        }
                    } else {
                        LiveReverseMemCallGraphPanel.this.treeTable.getTree().setSelectionPath(LiveReverseMemCallGraphPanel.this.treePath);
                        if (mouseEvent.getModifiers() == 4) {
                            LiveReverseMemCallGraphPanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        } else if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2 && LiveReverseMemCallGraphPanel.this.treeTableModel.isLeaf(LiveReverseMemCallGraphPanel.this.treePath.getPath()[LiveReverseMemCallGraphPanel.this.treePath.getPath().length - 1])) {
                            LiveReverseMemCallGraphPanel.this.performDefaultAction(LiveReverseMemCallGraphPanel.this.treePath);
                        }
                    }
                }
            });
            this.removeAll();
            this.treeTablePanel = new JTreeTablePanel(this.treeTable);
            this.treeTablePanel.setCorner("UPPER_RIGHT_CORNER", this.cornerButton);
            this.add((Component)this.treeTablePanel, "Center");
        }
    }
}

