/* data.hh
 * This file is part of cdbxx library
 * Copyright (c) 2004 by Stanislav Ievlev
 *
 * This file is covered by the GNU Library General Public License,
 * which should be included with libcdbxx as the file COPYING.
 */
#ifndef CDB_XX_DATA_HH__
#define CDB_XX_DATA_HH__

extern "C"
{
#include <cdb.h>
}


#include <utility>

namespace cdbxx
{
	typedef const unsigned char* mem_pos;

	/**
	 * simple containter of database data
	 */
	struct data
	{
		data():
		    len_(0),
		    data_(0)
		{}
		
		template <class T> T as() const
		{
			return *(reinterpret_cast<T*>(data_));
		}

		template <class T> const T* as_ptr() const
		{
			return (reinterpret_cast<T*>(data_));
		}
		cdbi_t	len_;
		mem_pos	data_;
	};

	typedef std::pair<data, data> data_pair;
}

#endif
