

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Interpolate between trackpoints (interpolate){/block}
  {block name=body}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Interpolate between trackpoints (interpolate)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="filter_radius.html">Prev</a> </td><th width="60%" align="center">Chapter 4. Data Filters</th><td width="20%" align="right"> <a accesskey="n" href="filter_height.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="filter_interpolate"></a>Interpolate between trackpoints (interpolate)</h2></div></div></div><p>
This filter modifies any tracks so that either the distance or the time
between consecutive points is no less than the specified interval. Where
points are missing, the filter fills them in by following a straight 
line (actually a great circle) between the adjacent points.  You
must specify either the 
<code class="option">distance</code> or the <code class="option">time</code> option.
</p><div class="example"><a id="example_interpolate_filter"></a><p class="title"><strong>Example 4.5. Using the interpolate filter</strong></p><div class="example-contents"><p>
This command line reads track.gpx and inserts points wherever two adjacent
trackpoints are more than 10 seconds apart:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f track.gpx -x interpolate,time=10 -o gpx -F newtrack.gpx</code></strong></p><p>
This command reads track.gpx and inserts points wherever two adjacent
trackpoints are more than 15 kilometers apart:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f track.gpx -x interpolate,distance=15k -o gpx -F newtrack.gpx</code></strong></p><p>
This command reads track.gpx and inserts points wherever two adjacent
trackpoints are more than 2 miles apart:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f track.gpx -x interpolate,distance=2m -o gpx -F newtrack.gpx</code></strong></p></div></div><br class="example-break" /><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_interpolate_o_time"></a>time option</h3></div></div></div><p>
      Time interval in seconds.
    </p><p>
This option specifies the maximum allowable time interval between points in the
track.  If two points in the track are further apart than this value, new
points will be inserted between them.
</p><p>
This value is always specified in units of seconds.
</p><p>
Either this option or the <code class="option">distance</code> must be specified.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_interpolate_o_distance"></a>distance option</h3></div></div></div><p>
      Distance interval in miles or kilometers.
    </p><p>
This option specifies the maximum allowable distance between points in the
track.  If two points in the track are further apart than this value, new
points will be inserted between them.
</p><p>
This value may be specified in units of miles (3M) or kilometers (5K).  If
no units are specified, the units are assumed to be miles.
</p><p>
Either this option or the <code class="option">time</code> must be specified.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_interpolate_o_route"></a>route option</h3></div></div></div><p>
      Interpolate routes instead.
    </p><p>
If this option is specified, the interpolate filter interpolates routes 
rather than tracks.  Because route points do not have time stamps, it is an
error to use this option with the <code class="option">time</code> option.
</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="filter_radius.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Data_Filters.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="filter_height.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Include Only Points Within Radius (radius) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Manipulate altitudes (height)</td></tr></table></div>
  
      {/block}
  