

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Introduction to GPSBabel Styles{/block}
  {block name=body}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Introduction to GPSBabel Styles</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="Styles.html">Prev</a> </td><th width="60%" align="center">Appendix C. GPSBabel XCSV Style Files</th><td width="20%" align="right"> <a accesskey="n" href="style_intro2.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="styles_intro"></a>Introduction to GPSBabel Styles</h2></div></div></div><p>
Often it is desirable to add a new file format for "one-off" work (perhaps
you want to export something to a spreadsheet or graphing program) or to read
a format that GPSBabel does not yet support.   For suitably simple formats,
this can be done by a user with no programming experience by providing a 
GPSBabel style file.
</p><p>
For a format to be described by a style file, it must be predictable and 
generally readable by humant.  Formats with binary or unreadable content 
are not good fits for this scheme.  It should have:
</p><table border="0" summary="Simple list" class="simplelist"><tr><td>A fixed header at the beginning, if it has any at all. This is called a 'prologue'.</td></tr><tr><td>Waypoints that are grouped by fixed separators, often a newline.  In style file parlance, this is called a 'record'.</td></tr><tr><td>Traits of that waypoint described in that record.  In the style files, these are called 'fields' and examples may include longitude or a name.</td></tr><tr><td>Fields that are grouped by fixed separators, often a comma or a tab.  In the style files, this is called the field separator. Fields may be enclosed by characters, such as a double quote.</td></tr><tr><td>A fixed footer at the end, if it has any at all.  This is called the 'epilogue'.</td></tr></table><p>
</p><p>
Once you have created a style file that describes the file format you have
or want, you must tell GPSBabel to use the xcsv format and have the xcsv 
format use that file.  If you created a new style file called 
"mystyle.style" and you want to write the  waypoints from
a GPX file named "mine.gpx" to it, you would issue a command like:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f mine.gpx -o xcsv,style=mystyle.style -F mine.new</code></strong></p><p>
You might then examine <code class="filename">mine.new</code> to see if it met
your expectations.  If not, you could continue to tweak 
<code class="filename">mystyle.style</code> until it did, rerunning the above
command each time.  If 'mystyle' is a format 
that describes a popular program or is likely to be of use to others, you can
then share <code class="filename">mystyle.style</code> with other GPSBabel users.
Send it along with a coherent description to the GPSBabel-misc mailing 
list for consideration to be included in a future version.
</p></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="Styles.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Styles.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="style_intro2.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Appendix C. GPSBabel XCSV Style Files </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Style file overview</td></tr></table></div>
  
      {/block}
  