/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.sejda.common.LookupTable;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.model.pdf.form.AcroFormPolicy;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.form.PDField;
import org.sejda.sambox.pdmodel.interactive.form.PDFieldFactory;
import org.sejda.sambox.pdmodel.interactive.form.PDNonTerminalField;
import org.sejda.sambox.pdmodel.interactive.form.PDTerminalField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcroFormsMerger {
    private static final Logger LOG = LoggerFactory.getLogger(AcroFormsMerger.class);
    private static final COSName[] FIELD_KEYS = new COSName[]{COSName.FT, COSName.PARENT, COSName.KIDS, COSName.T, COSName.TU, COSName.TM, COSName.FF, COSName.V, COSName.DV, COSName.DA, COSName.Q, COSName.DS, COSName.RV, COSName.OPT, COSName.MAX_LEN, COSName.TI, COSName.I, COSName.LOCK, COSName.SV, COSName.DATAPREP};
    private static final COSName[] WIDGET_KEYS = new COSName[]{COSName.TYPE, COSName.SUBTYPE, COSName.RECT, COSName.CONTENTS, COSName.P, COSName.NM, COSName.M, COSName.F, COSName.AP, COSName.AS, COSName.BORDER, COSName.C, COSName.STRUCT_PARENT, COSName.OC, COSName.AF, COSName.BM, COSName.H, COSName.MK, COSName.A, COSName.BS, COSName.PMD};
    private AcroFormPolicy policy;
    private PDAcroForm form;
    private String random = Long.toString(UUID.randomUUID().getMostSignificantBits(), 36);
    private Long counter = 0L;
    private final BiFunction<PDTerminalField, LookupTable<PDField>, PDTerminalField> createOrReuseTerminalField = (existing, fieldsLookup) -> {
        PDField previouslyCreated = Optional.ofNullable(this.form.getField(existing.getFullyQualifiedName())).orElseGet(() -> fieldsLookup.lookup(existing));
        if (previouslyCreated == null) {
            previouslyCreated = PDFieldFactory.createFielAddingChildToParent(this.form, existing.getCOSObject().duplicate(), fieldsLookup.lookup(existing.getParent()));
            previouslyCreated.getCOSObject().removeItem(COSName.KIDS);
            fieldsLookup.addLookupEntry(existing, previouslyCreated);
        }
        if (!previouslyCreated.isTerminal()) {
            LOG.warn("Cannot merge terminal field because a non terminal field with the same name already exsts: " + existing.getFullyQualifiedName());
            return null;
        }
        return (PDTerminalField)previouslyCreated;
    };
    private final BiFunction<PDTerminalField, LookupTable<PDField>, PDTerminalField> createRenamingTerminalField = (existing, fieldsLookup) -> {
        PDTerminalField newField = (PDTerminalField)PDFieldFactory.createFielAddingChildToParent(this.form, existing.getCOSObject().duplicate(), fieldsLookup.lookup(existing.getParent()));
        if (this.form.getField(existing.getFullyQualifiedName()) != null || fieldsLookup.hasLookupFor(existing)) {
            Object[] objectArray = new Object[3];
            objectArray[0] = existing.getPartialName();
            objectArray[1] = this.random;
            this.counter = this.counter + 1L;
            objectArray[2] = this.counter;
            newField.setPartialName(String.format("%s%s%d", objectArray));
            LOG.info("Existing terminal field renamed from {} to {}", (Object)existing.getPartialName(), (Object)newField.getPartialName());
        }
        newField.getCOSObject().removeItem(COSName.KIDS);
        fieldsLookup.addLookupEntry(existing, newField);
        return newField;
    };
    private final BiConsumer<PDField, LookupTable<PDField>> createOrReuseNonTerminalField = (field, fieldsLookup) -> {
        if (this.form.getField(field.getFullyQualifiedName()) == null && !fieldsLookup.hasLookupFor(field)) {
            fieldsLookup.addLookupEntry(field, PDFieldFactory.createFielAddingChildToParent(this.form, field.getCOSObject().duplicate(), fieldsLookup.lookup(field.getParent())));
        }
    };
    private final BiConsumer<PDField, LookupTable<PDField>> createRenamingNonTerminalField = (field, fieldsLookup) -> {
        PDField newField = PDFieldFactory.createFielAddingChildToParent(this.form, field.getCOSObject().duplicate(), fieldsLookup.lookup(field.getParent()));
        if (this.form.getField(field.getFullyQualifiedName()) != null || fieldsLookup.hasLookupFor(field)) {
            Object[] objectArray = new Object[3];
            objectArray[0] = field.getPartialName();
            objectArray[1] = this.random;
            this.counter = this.counter + 1L;
            objectArray[2] = this.counter;
            newField.setPartialName(String.format("%s%s%d", objectArray));
            LOG.info("Existing non terminal field renamed from {} to {}", (Object)field.getPartialName(), (Object)newField.getPartialName());
        }
        fieldsLookup.addLookupEntry(field, newField);
    };

    public AcroFormsMerger(AcroFormPolicy policy, PDDocument destination) {
        this.policy = policy;
        this.form = new PDAcroForm(destination);
    }

    public void mergeForm(PDAcroForm originalForm, LookupTable<PDAnnotation> annotationsLookup) {
        if (originalForm != null) {
            if (originalForm.hasXFA()) {
                LOG.warn("Merge of XFA forms is not supported");
            } else {
                LOG.debug("Merging acroforms with policy {}", (Object)this.policy);
                switch (this.policy) {
                    case MERGE_RENAMING_EXISTING_FIELDS: {
                        this.filterNonWidgetsFields(annotationsLookup);
                        this.updateForm(originalForm, annotationsLookup, this.createRenamingTerminalField, this.createRenamingNonTerminalField);
                        break;
                    }
                    case MERGE: {
                        this.filterNonWidgetsFields(annotationsLookup);
                        this.updateForm(originalForm, annotationsLookup, this.createOrReuseTerminalField, this.createOrReuseNonTerminalField);
                        break;
                    }
                    default: {
                        LOG.debug("Discarding acroform");
                        break;
                    }
                }
            }
        } else {
            LOG.debug("Skipped acroform merge, nothing to merge");
        }
    }

    private void filterNonWidgetsFields(LookupTable<PDAnnotation> annotationsLookup) {
        for (PDAnnotation current : annotationsLookup.values()) {
            if (!(current instanceof PDAnnotationWidget)) continue;
            current.getCOSObject().removeItems(FIELD_KEYS);
        }
        LOG.debug("Removed fields keys from widget annotations");
    }

    private void updateForm(PDAcroForm originalForm, LookupTable<PDAnnotation> widgets, BiFunction<PDTerminalField, LookupTable<PDField>, PDTerminalField> getTerminalField, BiConsumer<PDField, LookupTable<PDField>> createNonTerminalField) {
        this.mergeFormDictionary(originalForm);
        LookupTable fieldsLookup = new LookupTable();
        for (PDField field : originalForm.getFieldTree()) {
            if (!field.isTerminal()) {
                createNonTerminalField.accept(field, fieldsLookup);
                continue;
            }
            List<PDAnnotationWidget> relevantWidgets = this.findMappedWidgetsFor((PDTerminalField)field, widgets);
            if (!relevantWidgets.isEmpty()) {
                PDTerminalField terminalField = getTerminalField.apply((PDTerminalField)field, fieldsLookup);
                if (!Objects.nonNull(terminalField)) continue;
                for (PDAnnotationWidget widget : relevantWidgets) {
                    terminalField.addWidgetIfMissing(widget);
                }
                terminalField.getCOSObject().removeItems(WIDGET_KEYS);
                continue;
            }
            LOG.info("Discarded not relevant field {}", (Object)field.getPartialName());
        }
        this.form.addFields(originalForm.getFields().stream().map(fieldsLookup::lookup).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private void mergeFormDictionary(PDAcroForm originalForm) {
        int quadding;
        if (!this.form.isNeedAppearances() && originalForm.isNeedAppearances()) {
            this.form.setNeedAppearances(true);
        }
        String da = originalForm.getDefaultAppearance();
        if (StringUtils.isBlank(this.form.getDefaultAppearance()) && !StringUtils.isBlank(da)) {
            this.form.setDefaultAppearance(da);
        }
        if ((quadding = originalForm.getCOSObject().getInt(COSName.Q)) != -1 && !this.form.getCOSObject().containsKey(COSName.Q)) {
            this.form.setQuadding(quadding);
        }
        COSDictionary formResources = Optional.ofNullable(this.form.getCOSObject().getDictionaryObject(COSName.DR)).map(r -> (COSDictionary)r).orElseGet(COSDictionary::new);
        Optional.ofNullable(originalForm.getCOSObject().getDictionaryObject(COSName.DR)).map(r -> (COSDictionary)r).ifPresent(dr -> {
            for (COSName currentKey : dr.keySet()) {
                Optional.ofNullable(dr.getDictionaryObject(currentKey)).ifPresent(value -> {
                    if (value instanceof COSDictionary) {
                        this.mergeResourceDictionaryValue(formResources, (COSDictionary)value, currentKey);
                    } else if (value instanceof COSArray) {
                        this.mergeResourceArrayValue(formResources, (COSArray)value, currentKey);
                    } else {
                        LOG.warn("Unsupported resource dictionary type {}", value);
                    }
                });
            }
        });
        this.form.getCOSObject().setItem(COSName.DR, (COSBase)formResources);
        LOG.debug("Merged AcroForm dictionary");
    }

    private void mergeResourceArrayValue(COSDictionary formResources, COSArray value, COSName currentKey) {
        COSArray currentItem = Optional.ofNullable(formResources.getDictionaryObject(currentKey)).map(i -> (COSArray)i).orElseGet(COSArray::new);
        for (COSBase item : value) {
            if (currentItem.contains(item)) continue;
            currentItem.add(item);
        }
        formResources.setItem(currentKey, (COSBase)currentItem);
    }

    private void mergeResourceDictionaryValue(COSDictionary formResources, COSDictionary value, COSName currentKey) {
        COSDictionary currentItem = Optional.ofNullable(formResources.getDictionaryObject(currentKey)).map(i -> (COSDictionary)i).orElseGet(COSDictionary::new);
        currentItem.mergeWithoutOverwriting(value);
        formResources.setItem(currentKey, (COSBase)currentItem);
    }

    private List<PDAnnotationWidget> findMappedWidgetsFor(PDTerminalField field, LookupTable<PDAnnotation> widgets) {
        return field.getWidgets().stream().map(widgets::lookup).filter(w -> w instanceof PDAnnotationWidget).map(w -> (PDAnnotationWidget)w).collect(Collectors.toList());
    }

    public boolean hasForm() {
        return !this.form.getFields().isEmpty();
    }

    public PDAcroForm getForm() {
        for (PDField current : this.form.getFieldTree()) {
            if (!current.isTerminal() && !((PDNonTerminalField)current).hasChildren()) {
                LOG.info("Removing non terminal field with no child {}", (Object)current.getPartialName());
                if (Objects.nonNull(current.getParent())) {
                    current.getParent().removeChild(current);
                    continue;
                }
                this.form.removeField(current);
                continue;
            }
            if (!SignatureClipper.clipSignature(current)) continue;
            this.form.setSignaturesExist(true);
        }
        return this.form;
    }
}

