/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.optimizaton;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.sejda.core.writer.model.ImageOptimizer;
import org.sejda.impl.sambox.component.ReadOnlyFilteredCOSStream;
import org.sejda.model.optimization.Optimization;
import org.sejda.model.parameter.OptimizeParameters;
import org.sejda.sambox.contentstream.PDFStreamEngine;
import org.sejda.sambox.contentstream.operator.DrawObject;
import org.sejda.sambox.contentstream.operator.MissingOperandException;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.contentstream.operator.OperatorProcessor;
import org.sejda.sambox.contentstream.operator.state.Concatenate;
import org.sejda.sambox.contentstream.operator.state.Restore;
import org.sejda.sambox.contentstream.operator.state.Save;
import org.sejda.sambox.contentstream.operator.state.SetGraphicsStateParameters;
import org.sejda.sambox.contentstream.operator.state.SetMatrix;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.IndirectCOSObjectIdentifier;
import org.sejda.sambox.encryption.MessageDigests;
import org.sejda.sambox.pdmodel.MissingResourceException;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;
import org.sejda.sambox.pdmodel.graphics.image.JPEGFactory;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImagesOptimizer
extends PDFStreamEngine
implements Consumer<PDPage> {
    private static final Logger LOG = LoggerFactory.getLogger(ImagesOptimizer.class);
    private Map<String, ReadOnlyFilteredCOSStream> optimizedByHash = new HashMap<String, ReadOnlyFilteredCOSStream>();
    private Map<IndirectCOSObjectIdentifier, ReadOnlyFilteredCOSStream> optimizedById = new HashMap<IndirectCOSObjectIdentifier, ReadOnlyFilteredCOSStream>();
    private OptimizeParameters parameters;

    ImagesOptimizer(OptimizeParameters parameters) {
        this.parameters = parameters;
        this.addOperator(new Concatenate());
        this.addOperator(new DrawObject());
        this.addOperator(new SetGraphicsStateParameters());
        this.addOperator(new Save());
        this.addOperator(new Restore());
        this.addOperator(new SetMatrix());
        this.addOperator(new XObjectOperator());
    }

    @Override
    public void accept(PDPage page) {
        try {
            this.processPage(page);
            for (PDAnnotation annotation : page.getAnnotations()) {
                this.showAnnotation(annotation);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to optimize page, skipping and continuing with next.", e);
        }
    }

    public static ReadOnlyFilteredCOSStream createFromJpegFile(File file) throws IOException {
        BufferedImage awtImage = JPEGFactory.readJpegFile(file);
        if (awtImage.getColorModel().hasAlpha()) {
            throw new UnsupportedOperationException("alpha channel not implemented");
        }
        return ReadOnlyFilteredCOSStream.readOnlyJpegImage(file, awtImage.getWidth(), awtImage.getHeight(), awtImage.getColorModel().getComponentSize(0), JPEGFactory.getColorSpaceFromAWT(awtImage));
    }

    public static boolean canOptimizeFor(Optimization o) {
        return o == Optimization.COMPRESS_IMAGES || o == Optimization.DISCARD_ALTERNATE_IMAGES || o == Optimization.DISCARD_PIECE_INFO || o == Optimization.DISCARD_METADATA;
    }

    private class XObjectOperator
    extends OperatorProcessor {
        private XObjectOperator() {
        }

        @Override
        public void process(Operator operator, List<COSBase> operands) throws IOException {
            if (operands.size() < 1) {
                throw new MissingOperandException(operator, operands);
            }
            COSBase operand = operands.get(0);
            if (operand instanceof COSName) {
                COSName objectName = (COSName)operand;
                COSBase existing = Optional.ofNullable(this.context.getResources().getCOSObject().getDictionaryObject(COSName.XOBJECT, COSDictionary.class)).map(d -> d.getDictionaryObject(objectName)).orElseThrow(() -> new MissingResourceException("Missing XObject: " + objectName.getName()));
                if (!(existing instanceof ReadOnlyFilteredCOSStream)) {
                    COSStream stream = (COSStream)existing;
                    String subtype = stream.getNameAsString(COSName.SUBTYPE);
                    if (COSName.IMAGE.getName().equals(subtype)) {
                        long unfilteredSize = stream.getFilteredLength();
                        this.removeMetadataIfNeeded(stream);
                        this.removeAlternatesIfNeeded(stream);
                        if (ImagesOptimizer.this.parameters.getOptimizations().contains(Optimization.COMPRESS_IMAGES)) {
                            boolean jbig2Image = stream.hasFilter(COSName.JBIG2_DECODE);
                            if (jbig2Image) {
                                LOG.debug("Skipping JBIG2 encoded image");
                            }
                            if (unfilteredSize > (long)ImagesOptimizer.this.parameters.getImageMinBytesSize() && !jbig2Image) {
                                long start = System.currentTimeMillis();
                                PDXObject xobject = PDXObject.createXObject(stream.getCOSObject(), this.context.getResources());
                                long elapsed = System.currentTimeMillis() - start;
                                if (elapsed > 500L) {
                                    LOG.debug("Loading PDXObject took " + elapsed + "ms");
                                }
                                PDImageXObject image = (PDImageXObject)xobject;
                                Matrix ctmNew = ImagesOptimizer.this.getGraphicsState().getCurrentTransformationMatrix();
                                float imageXScale = ctmNew.getScalingFactorX();
                                float imageYScale = ctmNew.getScalingFactorY();
                                int displayHeight = (int)(imageYScale / 72.0f * (float)ImagesOptimizer.this.parameters.getImageDpi());
                                int displayWidth = (int)(imageXScale / 72.0f * (float)ImagesOptimizer.this.parameters.getImageDpi());
                                LOG.debug("Found image {}x{} (displayed as {}x{}, scaled as {}x{}) with size {}", image.getHeight(), image.getWidth(), displayHeight, displayWidth, Float.valueOf(imageYScale), Float.valueOf(imageXScale), unfilteredSize);
                                this.optimize(objectName, image, stream.id(), displayWidth, displayHeight);
                            }
                        }
                    } else if (COSName.FORM.getName().equals(subtype)) {
                        PDXObject xobject = PDXObject.createXObject(existing.getCOSObject(), this.context.getResources());
                        this.removeMetadataIfNeeded(xobject.getCOSObject());
                        this.removePieceInfoIfNeeded(xobject.getCOSObject());
                        ImagesOptimizer.this.showForm((PDFormXObject)xobject);
                    }
                }
            }
        }

        private void optimize(COSName objectName, PDImageXObject image, IndirectCOSObjectIdentifier id, int displayWidth, int displayHeight) {
            try {
                LOG.debug("Optimizing image {} {} with dimensions {}x{}", objectName.getName(), id.toString(), image.getImage().getWidth(), image.getImage().getHeight());
                ReadOnlyFilteredCOSStream optimizedImage = (ReadOnlyFilteredCOSStream)ImagesOptimizer.this.optimizedById.get(id);
                if (optimizedImage == null) {
                    long start = System.currentTimeMillis();
                    File tmpImageFile = ImageOptimizer.optimize(image.getImage(), ImagesOptimizer.this.parameters.getImageQuality(), ImagesOptimizer.this.parameters.getImageDpi(), displayWidth, displayHeight);
                    long elapsed = System.currentTimeMillis() - start;
                    if (elapsed > 500L) {
                        LOG.debug("Optimizing image took " + elapsed + "ms");
                    }
                    optimizedImage = ReadOnlyFilteredCOSStream.readOnly(image.getCOSObject());
                    double sizeRate = (double)tmpImageFile.length() * 100.0 / (double)image.getCOSObject().getFilteredLength();
                    if (sizeRate < 100.0) {
                        String hash = Base64.getEncoder().encodeToString(MessageDigests.md5().digest(Files.readAllBytes(tmpImageFile.toPath())));
                        optimizedImage = (ReadOnlyFilteredCOSStream)ImagesOptimizer.this.optimizedByHash.get(hash);
                        if (Objects.isNull(optimizedImage)) {
                            LOG.debug(String.format("Compressed image to %.2f%% of original size", sizeRate));
                            optimizedImage = ImagesOptimizer.createFromJpegFile(tmpImageFile);
                            ImagesOptimizer.this.optimizedByHash.put(hash, optimizedImage);
                            ImagesOptimizer.this.optimizedById.put(id, optimizedImage);
                        } else {
                            LOG.debug("Reusing previously optimized image");
                        }
                    } else {
                        LOG.debug(String.format("Skipping already compressed image, result is %.2f%% of original size", sizeRate));
                    }
                } else {
                    LOG.debug(String.format("Skipping already compressed image with id %s", id));
                }
                COSDictionary resources = this.context.getResources().getCOSObject();
                COSDictionary xobjects = Optional.ofNullable(resources.getDictionaryObject(COSName.XOBJECT)).filter(b -> b instanceof COSDictionary).map(b -> (COSDictionary)b).orElseGet(() -> {
                    COSDictionary ret = new COSDictionary();
                    resources.setItem(COSName.XOBJECT, (COSBase)ret);
                    return ret;
                });
                xobjects.setItem(objectName, (COSBase)optimizedImage);
                image.getCOSObject().unDecode();
            }
            catch (IOException | RuntimeException ex) {
                LOG.warn("Failed to optimize image, skipping and continuing with next.", ex);
            }
        }

        private void removeMetadataIfNeeded(COSStream cosObject) {
            if (ImagesOptimizer.this.parameters.getOptimizations().contains(Optimization.DISCARD_METADATA)) {
                cosObject.removeItem(COSName.METADATA);
            }
        }

        private void removePieceInfoIfNeeded(COSStream cosObject) {
            if (ImagesOptimizer.this.parameters.getOptimizations().contains(Optimization.DISCARD_PIECE_INFO)) {
                cosObject.removeItem(COSName.PIECE_INFO);
            }
        }

        private void removeAlternatesIfNeeded(COSStream cosObject) {
            if (ImagesOptimizer.this.parameters.getOptimizations().contains(Optimization.DISCARD_ALTERNATE_IMAGES)) {
                cosObject.removeItem(COSName.getPDFName("Alternates"));
            }
        }

        @Override
        public String getName() {
            return "Do";
        }
    }
}

