

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:DeLorme .an1 (drawing) file (an1){/block}
  {block name=body}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">DeLorme .an1 (drawing) file (an1)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="fmt_iblue757.html">Prev</a> </td><th width="60%" align="center">Chapter 3. The Formats</th><td width="20%" align="right"> <a accesskey="n" href="fmt_gpl.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="fmt_an1"></a>DeLorme .an1 (drawing) file (an1)</h2></div></div></div><p class="fmtcapshdr">
    This format can...
    </p><div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p class="fmtcapsitem">
          read and write waypoints
        </p></li><li class="listitem"><p class="fmtcapsitem">
          write tracks
        </p></li><li class="listitem"><p class="fmtcapsitem">
          read and write routes
        </p></li></ul></div><p>This format has the following options: <a class="link" href="fmt_an1.html#fmt_an1_o_type" title="type option">type</a>, <a class="link" href="fmt_an1.html#fmt_an1_o_road" title="road option">road</a>, <a class="link" href="fmt_an1.html#fmt_an1_o_nogc" title="nogc option">nogc</a>, <a class="link" href="fmt_an1.html#fmt_an1_o_nourl" title="nourl option">nourl</a>, <a class="link" href="fmt_an1.html#fmt_an1_o_deficon" title="deficon option">deficon</a>, <a class="link" href="fmt_an1.html#fmt_an1_o_color" title="color option">color</a>, <a class="link" href="fmt_an1.html#fmt_an1_o_zoom" title="zoom option">zoom</a>, <a class="link" href="fmt_an1.html#fmt_an1_o_wpt_type" title="wpt_type option">wpt_type</a>, <a class="link" href="fmt_an1.html#fmt_an1_o_radius" title="radius option">radius</a> .</p><p> 
This format supports the <a class="ulink" href="http://www.delorme.com" target="_top">DeLorme</a> ".an1" drawing file format used by their desktop software like Topo USA.  It can 
currently be used to either read or write drawing files.  If you use 
this format to create drawing files with routes or waypoints from another 
source, by default it will create "Red Flag" symbols for waypoints, and 
thick red lines for routes or tracks.  It is possible to merge two drawing 
layers by doing something like this:
</p><p><strong class="userinput"><code>gpsbabel -i an1 -f one.an1 -f two.an1 -o an1 -F merged.an1</code></strong></p><p> 
In this case, the merged data will contain all of the
properties of the original data.
</p><p>
GPSBabel has a page describing <a class="ulink" href="/formats/delorme-new-interstate/" target="_top">creating routable onramps in Street Atlas with GPSBabel</a>.
</p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_an1_o_type"></a><code class="option">type</code> option</h3></div></div></div><p>
      Type of .an1 file.
    </p><p> This option specifies the type of the drawing layer
to be created.  The supported values are "drawing", "road", "trail",
"waypoint", or "track".  If you do not specify a type, the default
will be either the type of the previous an1 file or "drawing" if there
is no previous file. This lets you merge, for example, two road layers
without having to specify "type=road" for the output.  </p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_an1_o_road"></a><code class="option">road</code> option</h3></div></div></div><p>
      Road type changes.
    </p><p>
If you are creating a road layer, you may use the "road" option, which 
allows you to change the types of roads based on their names.  You can 
change multiple roads at the same time.  Currently supported types are 
</p><p>
</p><div class="segmentedlist"><table border="0"><thead><tr class="segtitle"><th>Type</th><th>Meaning</th></tr></thead><tbody><tr class="seglistitem"><td class="seg">limited</td><td class="seg">Limited-access freeways</td></tr><tr class="seglistitem"><td class="seg">toll</td><td class="seg">Limited-access toll highways</td></tr><tr class="seglistitem"><td class="seg">ramp</td><td class="seg">Access ramps for limited-access highways</td></tr><tr class="seglistitem"><td class="seg">us</td><td class="seg">National highways (e.g. US routes)</td></tr><tr class="seglistitem"><td class="seg">primary</td><td class="seg">Primary State/Provincial routes</td></tr><tr class="seglistitem"><td class="seg">state</td><td class="seg">State/Provincial routes</td></tr><tr class="seglistitem"><td class="seg">major</td><td class="seg">Major Connectors</td></tr><tr class="seglistitem"><td class="seg">ferry</td><td class="seg">Ferry Routes</td></tr><tr class="seglistitem"><td class="seg">local</td><td class="seg">Local Roads</td></tr><tr class="seglistitem"><td class="seg">editable</td><td class="seg">User-drawn Roads</td></tr></tbody></table></div><p>
</p><p>
GPSBabel defaults to creating editable roads.  These are routed just like 
local roads, but may be edited with the drawing tools in Street Atlas.
</p><p> 
This option has a special format that is best demonstrated by example:
</p><pre class="screen"> "road=I-599!limited!Beecher St.!major" </pre><p>
This option will cause any road named "I-599" to become a limited-access 
highway and any road named "Beecher St." to become a major connector.  Note 
that roads that have had their types changed in this way are not editable 
in Street Atlas, so make sure they are where you want them before you 
change them, and make sure to keep a backup of your original road layer.  
Note that the ! is a shell metacharacter in bash and possibly other shells, 
so you may have to use single quotes or some other escape mechanism.
</p><p>
There is a tutorial on 
<a class="ulink" href="http://www.gpsbabel.org/formats/delorme-new-interstate/" target="_top">how 
to create an onramp for a limited access highway in Street Atlas USA 
using GPSBabel.</a>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_an1_o_nogc"></a><code class="option">nogc</code> option</h3></div></div></div><p>
      Do not add geocache data to description.
    </p><p>
If your original data contains geocaching-specific information such as 
difficulty and terrain, GPSBabel will automatically include that information 
in the waypoint descriptions in the generated drawing file.  If you do not 
want that, specify the "nogc" option on the command line:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f 12345.gpx -o an1,nogc -F 12345.an1</code></strong></p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_an1_o_nourl"></a><code class="option">nourl</code> option</h3></div></div></div><p>
      Do not add URLs to description.
    </p><p>
If your original waypoint data contains URLs, GPSBabel will include them as
links in the generated drawing file.  This causes the waypoint symbol to have
a blue border, and it causes the waypoint text to be drawn in blue with an 
underline.
</p><p>
If you do not want this behavior, specify the "nourl" option on the command
line:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f 12345.gpx -o an1,nourl -F 12345.an1</code></strong></p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_an1_o_deficon"></a><code class="option">deficon</code> option</h3></div></div></div><p>
      Symbol to use for point data.
    </p><p>
This option allows you to specify which symbol to use for points that 
don't have a symbol already.  It defaults to "Red Flag" but it accepts 
any symbol name you can put in a DeLorme export file.  To find the name 
of a specific symbol in Street Atlas, let the mouse pointer hover over 
it for a few seconds and the name will be displayed.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_an1_o_color"></a><code class="option">color</code> option</h3></div></div></div><p>
      Color for lines or mapnotes.
    </p><p>This option allows you to specify the color for
line or mapnote data.  It accepts color names of the form "#FF0000" (red) or any
of the color names from the Cascading Style Sheets (CSS)
specification.</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_an1_o_zoom"></a><code class="option">zoom</code> option</h3></div></div></div><p>
      Zoom level to reduce points.
    </p><p>
This option specifies at what zoom level Street Atlas will begin showing 
reduced versions of your symbols. The default is 10.  Setting zoom to 0 will 
disable this feature.  Setting it to anything but the default will override 
the zoom level specified on any waypoints that were read from an existing 
an1 file; this is by design.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_an1_o_wpt_type"></a><code class="option">wpt_type</code> option</h3></div></div></div><p>
      Waypoint type.
    </p><p>
This option specifies how to represent point data in the draw file.  
Valid waypoint types are "symbol", "text", "mapnote", "circle", and "image".  
The default is "symbol". 
</p><p>
If you specify a waypoint type of "image", you should make sure that the
icon descriptions of your waypoints are the full names, including drive letters
and full path, of image files in a format that works with your DeLorme 
product.  Note that this means that the .an1 file you generate will not work
on any computer that does not have those images in the same place; this is 
part of the design of the an1 format and cannot be avoided.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_an1_o_radius"></a><code class="option">radius</code> option</h3></div></div></div><p>
      Radius for circles.
    </p><p>
If the waypoint type is "circle", the "radius" option specifies
the radius of the circles.  By default, this is in miles, but it may be
specified in kilometers by adding a 'k'.  The default radius is 1/10 mile.
</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="fmt_iblue757.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="The_Formats.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="fmt_gpl.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Data Logger iBlue757 csv (iblue757) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> DeLorme GPL (gpl)</td></tr></table></div>
  
      {/block}
  