/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.Certificate;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.x509store.X509Aux;

public class X509AuxCertificate
extends X509Certificate
implements Cloneable {
    private static final long serialVersionUID = -909543379295427515L;
    private final X509Certificate cert;
    final X509Aux aux;
    private boolean valid = false;
    private int ex_flags = 0;

    public X509AuxCertificate(Certificate wrap) throws IOException, CertificateException {
        CertificateFactory factory = SecurityHelper.getCertificateFactory("X.509");
        ByteArrayInputStream bis = new ByteArrayInputStream(wrap.getEncoded());
        this.cert = (X509Certificate)factory.generateCertificate(bis);
        this.aux = null;
    }

    public X509AuxCertificate(X509Certificate wrap) {
        this(wrap, null);
    }

    X509AuxCertificate(X509Certificate wrap, X509Aux aux) {
        this.cert = wrap;
        this.aux = aux;
    }

    public final X509AuxCertificate clone() {
        try {
            return (X509AuxCertificate)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    final X509AuxCertificate cloneForCache() {
        X509AuxCertificate clone = this.clone();
        clone.valid = false;
        clone.ex_flags = 0;
        return clone;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean v) {
        this.valid = v;
    }

    public int getExFlags() {
        return this.ex_flags;
    }

    public void setExFlags(int ex_flags) {
        this.ex_flags = ex_flags;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.cert.checkValidity();
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.cert.checkValidity(date);
    }

    @Override
    public int getBasicConstraints() {
        return this.cert.getBasicConstraints();
    }

    @Override
    public List<String> getExtendedKeyUsage() throws CertificateParsingException {
        return this.cert.getExtendedKeyUsage();
    }

    @Override
    public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        return this.cert.getIssuerAlternativeNames();
    }

    @Override
    public Principal getIssuerDN() {
        return this.cert.getIssuerDN();
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        return this.cert.getIssuerUniqueID();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.cert.getIssuerX500Principal();
    }

    @Override
    public boolean[] getKeyUsage() {
        return this.cert.getKeyUsage();
    }

    @Override
    public Date getNotAfter() {
        return this.cert.getNotAfter();
    }

    @Override
    public Date getNotBefore() {
        return this.cert.getNotBefore();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.cert.getSerialNumber();
    }

    @Override
    public String getSigAlgName() {
        return this.cert.getSigAlgName();
    }

    @Override
    public String getSigAlgOID() {
        return this.cert.getSigAlgOID();
    }

    @Override
    public byte[] getSigAlgParams() {
        return this.cert.getSigAlgParams();
    }

    @Override
    public byte[] getSignature() {
        return this.cert.getSignature();
    }

    @Override
    public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        return this.cert.getSubjectAlternativeNames();
    }

    @Override
    public Principal getSubjectDN() {
        return this.cert.getSubjectDN();
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        return this.cert.getSubjectUniqueID();
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return this.cert.getSubjectX500Principal();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.cert.getTBSCertificate();
    }

    @Override
    public int getVersion() {
        return this.cert.getVersion();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.cert.getEncoded();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    @Override
    public String toString() {
        return this.cert.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof X509AuxCertificate) {
            X509AuxCertificate o = (X509AuxCertificate)other;
            return this.cert.equals(o.cert) && (this.aux == null ? o.aux == null : this.aux.equals(o.aux));
        }
        return false;
    }

    @Override
    public int hashCode() {
        int ret = this.cert.hashCode();
        return ret += 3 * (this.aux == null ? 1 : this.aux.hashCode());
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.cert.verify(key);
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.cert.verify(key, sigProvider);
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return this.cert.getCriticalExtensionOIDs();
    }

    @Override
    public byte[] getExtensionValue(String oid2) {
        return this.cert.getExtensionValue(oid2);
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return this.cert.getNonCriticalExtensionOIDs();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.cert.hasUnsupportedCriticalExtension();
    }

    public Integer getNsCertType() throws CertificateException {
        String NS_CERT_TYPE_OID = "2.16.840.1.113730.1.1";
        byte[] bytes = this.getExtensionValue("2.16.840.1.113730.1.1");
        if (bytes == null) {
            return null;
        }
        try {
            ASN1Primitive o = new ASN1InputStream(bytes).readObject();
            if (o instanceof DERBitString) {
                return ((DERBitString)o).intValue();
            }
            if (o instanceof DEROctetString) {
                ASN1InputStream in = new ASN1InputStream(((DEROctetString)o).getOctets());
                o = in.readObject();
                return ((DERBitString)o).intValue();
            }
            throw new CertificateException("unknown type from ASN1InputStream.readObject: " + o);
        }
        catch (IOException ioe) {
            throw new CertificateEncodingException(ioe.getMessage(), ioe);
        }
    }
}

