/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

public enum CompatVersion {
    RUBY1_8,
    RUBY1_9,
    RUBY2_0,
    RUBY2_1,
    BOTH;


    public boolean is1_9() {
        return this == RUBY1_9 || this == RUBY2_0 || this == RUBY2_1;
    }

    public boolean is2_0() {
        return this == RUBY2_0 || this == RUBY2_1;
    }

    public static CompatVersion getVersionFromString(String compatString) {
        if (compatString.equalsIgnoreCase("RUBY1_8")) {
            return RUBY1_8;
        }
        if (compatString.equalsIgnoreCase("1.8")) {
            return RUBY1_8;
        }
        if (compatString.equalsIgnoreCase("RUBY1_9")) {
            return RUBY1_9;
        }
        if (compatString.equalsIgnoreCase("1.9")) {
            return RUBY1_9;
        }
        if (compatString.equalsIgnoreCase("RUBY2_0")) {
            return RUBY2_0;
        }
        if (compatString.equalsIgnoreCase("2.0")) {
            return RUBY2_0;
        }
        if (compatString.equalsIgnoreCase("RUBY2_1")) {
            return RUBY2_1;
        }
        if (compatString.equalsIgnoreCase("2.1")) {
            return RUBY2_1;
        }
        return null;
    }

    public static boolean shouldBindMethod(CompatVersion runtimeVersion, CompatVersion methodVersion) {
        if (runtimeVersion == RUBY1_8) {
            return methodVersion == RUBY1_8 || methodVersion == BOTH;
        }
        if (runtimeVersion == RUBY1_9) {
            return methodVersion == RUBY1_9 || methodVersion == BOTH;
        }
        if (runtimeVersion == RUBY2_0) {
            return methodVersion == RUBY1_9 || methodVersion == RUBY2_0 || methodVersion == BOTH;
        }
        if (runtimeVersion == RUBY2_1) {
            return methodVersion == RUBY1_9 || methodVersion == RUBY2_0 || methodVersion == RUBY2_1 || methodVersion == BOTH;
        }
        return false;
    }
}

