/*
 * Decompiled with CFR 0.152.
 */
package plugins.collaboration.socket;

import freemind.common.NumberProperty;
import freemind.common.StringProperty;
import freemind.controller.actions.generated.instance.CollaborationUserInformation;
import freemind.extensions.PermanentNodeHook;
import freemind.main.Resources;
import freemind.modes.mindmapmode.MindMapController;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Vector;
import plugins.collaboration.socket.ClientCommunication;
import plugins.collaboration.socket.SocketBasics;
import plugins.collaboration.socket.SocketConnectionHook;

public class MindMapClient
extends SocketBasics {
    private static final String HOST_PROPERTY = "plugins.collaboration.database.host";

    @Override
    public void startupMapHook() {
        super.startupMapHook();
        MindMapController controller = this.getMindMapController();
        StringProperty passwordProperty = new StringProperty("plugins.collaboration.socket.SocketBasics.password.description", "plugins.collaboration.socket.SocketBasics.password");
        StringProperty hostProperty = new StringProperty("plugins.collaboration.socket.SocketBasics.host.description", "plugins.collaboration.socket.SocketBasics.host");
        NumberProperty portProperty = this.getPortProperty();
        try {
            SocketConnectionHook connectionHook = this.isConnected();
            if (connectionHook != null) {
                logger.info("Deregister filter.");
                connectionHook.deregisterFilter();
                logger.info("Shutting down the permanent hook.");
                MindMapClient.togglePermanentHook(controller, "plugins/collaboration/socket/socket_slave_plugin");
                return;
            }
            hostProperty.setValue(controller.getFrame().getProperty(HOST_PROPERTY));
            Vector<Object> controls = new Vector<Object>();
            controls.add(passwordProperty);
            controls.add(hostProperty);
            controls.add(portProperty);
            SocketBasics.FormDialog dialog = new SocketBasics.FormDialog(controller);
            dialog.setUp(controls);
            if (!dialog.isSuccess()) {
                return;
            }
            logger.info("Connect...");
            this.setPortProperty(portProperty);
            controller.getFrame().setProperty(HOST_PROPERTY, hostProperty.getValue());
            this.mPassword = passwordProperty.getValue();
            logger.info("Starting client thread...");
            int port = portProperty.getIntValue();
            Socket serverConnection = new Socket(hostProperty.getValue(), port);
            serverConnection.setSoTimeout(500);
            ClientCommunication clientCommunication = new ClientCommunication("Client Communication", serverConnection, this.getMindMapController(), this.mPassword);
            clientCommunication.start();
        }
        catch (UnknownHostException e) {
            Resources.getInstance().logException((Throwable)e);
            controller.getController().errorMessage((Object)Resources.getInstance().format("plugins.collaboration.socket.SocketBasics.unknown_host_exception", new Object[]{e.getMessage()}));
            return;
        }
        catch (ConnectException e) {
            Resources.getInstance().logException((Throwable)e);
            controller.getController().errorMessage((Object)Resources.getInstance().format("plugins.collaboration.socket.SocketBasics.connection_exception", new Object[]{portProperty.getValue(), hostProperty.getValue(), e.getMessage()}));
            return;
        }
        catch (Exception e) {
            Resources.getInstance().logException((Throwable)e);
            controller.getController().errorMessage((Object)(e.getClass().getName() + ": " + e.getLocalizedMessage()));
            return;
        }
    }

    private SocketConnectionHook isConnected() {
        Collection activatedHooks = this.getMindMapController().getRootNode().getActivatedHooks();
        for (PermanentNodeHook hook : activatedHooks) {
            if (!(hook instanceof SocketConnectionHook)) continue;
            return (SocketConnectionHook)hook;
        }
        return null;
    }

    @Override
    public Integer getRole() {
        return ROLE_SLAVE;
    }

    @Override
    public int getPort() {
        return 0;
    }

    @Override
    protected String lock(String pUserName) throws SocketBasics.UnableToGetLockException, InterruptedException {
        return null;
    }

    @Override
    protected void broadcastCommand(String pDoAction, String pUndoAction, String pLockId) throws Exception {
    }

    @Override
    protected void unlock() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public CollaborationUserInformation getMasterInformation() {
        return null;
    }
}

