/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.coor.LatLon;

public final class Ellipsoid {
    public static final Ellipsoid Airy = Ellipsoid.create_a_b(6377563.396, 6356256.91);
    public static final Ellipsoid AiryMod = Ellipsoid.create_a_b(6377340.189, 6356034.446);
    public static final Ellipsoid AustSA = Ellipsoid.create_a_rf(6378160.0, 298.25);
    public static final Ellipsoid Bessel1841 = Ellipsoid.create_a_rf(6377397.155, 299.1528128);
    public static final Ellipsoid BesselNamibia = Ellipsoid.create_a_rf(6377483.865, 299.1528128);
    public static final Ellipsoid Clarke1866 = Ellipsoid.create_a_b(6378206.4, 6356583.8);
    public static final Ellipsoid Clarke1880 = Ellipsoid.create_a_rf(6378249.145, 293.4663);
    public static final Ellipsoid ClarkeIGN = Ellipsoid.create_a_b(6378249.2, 6356515.0);
    public static final Ellipsoid EverestSabahSarawak = Ellipsoid.create_a_rf(6377298.556, 300.8017);
    public static final Ellipsoid GRS67 = Ellipsoid.create_a_rf(6378160.0, 298.247167427);
    public static final Ellipsoid GRS80 = Ellipsoid.create_a_rf(6378137.0, 298.257222101);
    public static final Ellipsoid Hayford = Ellipsoid.create_a_rf(6378388.0, 297.0);
    public static final Ellipsoid Helmert = Ellipsoid.create_a_rf(6378200.0, 298.3);
    public static final Ellipsoid Krassowsky = Ellipsoid.create_a_rf(6378245.0, 298.3);
    public static final Ellipsoid WGS66 = Ellipsoid.create_a_rf(6378145.0, 298.25);
    public static final Ellipsoid WGS72 = Ellipsoid.create_a_rf(6378135.0, 298.26);
    public static final Ellipsoid WGS84 = Ellipsoid.create_a_rf(6378137.0, 298.257223563);
    public final double a;
    public final double b;
    public final double e;
    public final double e2;
    public final double eb2;
    public final boolean spherical;

    private Ellipsoid(double d, double d2, double d3, double d4, double d5, boolean bl) {
        this.a = d;
        this.b = d2;
        this.e = d3;
        this.e2 = d4;
        this.eb2 = d5;
        this.spherical = bl;
    }

    public static Ellipsoid create_a_b(double d, double d2) {
        double d3 = (d * d - d2 * d2) / (d * d);
        double d4 = Math.sqrt(d3);
        double d5 = d3 / (1.0 - d3);
        return new Ellipsoid(d, d2, d4, d3, d5, d == d2);
    }

    public static Ellipsoid create_a_es(double d, double d2) {
        double d3 = d * Math.sqrt(1.0 - d2);
        double d4 = Math.sqrt(d2);
        double d5 = d2 / (1.0 - d2);
        return new Ellipsoid(d, d3, d4, d2, d5, d2 == 0.0);
    }

    public static Ellipsoid create_a_f(double d, double d2) {
        double d3 = d * (1.0 - d2);
        double d4 = d2 * (2.0 - d2);
        double d5 = Math.sqrt(d4);
        double d6 = d4 / (1.0 - d4);
        return new Ellipsoid(d, d3, d5, d4, d6, d2 == 0.0);
    }

    public static Ellipsoid create_a_rf(double d, double d2) {
        return Ellipsoid.create_a_f(d, 1.0 / d2);
    }

    public String toString() {
        return "Ellipsoid{a=" + this.a + ", b=" + this.b + '}';
    }

    public double verticalRadiusOfCurvature(double d) {
        return this.a / Math.sqrt(1.0 - this.e2 * Ellipsoid.sqr(Math.sin(d)));
    }

    private static double sqr(double d) {
        return d * d;
    }

    public double meridionalArc(double d) {
        double d2 = Math.sin(2.0 * d);
        double d3 = Math.sin(4.0 * d);
        double d4 = Math.sin(6.0 * d);
        double d5 = Math.sin(8.0 * d);
        double d6 = 0.0033528106647474805;
        double d7 = d6 / (2.0 - d6);
        double d8 = d7 * d7;
        double d9 = d8 * d7;
        double d10 = d9 * d7;
        double d11 = d10 * d7;
        double d12 = d7 - d8;
        double d13 = d8 - d9;
        double d14 = d9 - d10;
        double d15 = d10 - d11;
        double d16 = this.a * (1.0 - d7 + 1.25 * d13 + 1.265625 * d15);
        double d17 = 1.5 * this.a * (d12 + 0.875 * d14 + 0.859375 * d11);
        double d18 = 0.9375 * this.a * (d13 + 0.75 * d15);
        double d19 = 0.7291666666666666 * this.a * (d14 + 0.6875 * d11);
        double d20 = 0.615234375 * this.a * d15;
        return d16 * d - d17 * d2 + d18 * d3 - d19 * d4 + d20 * d5;
    }

    public double meridionalRadiusOfCurvature(double d) {
        return this.verticalRadiusOfCurvature(d) / (1.0 + this.eb2 * Ellipsoid.sqr(Math.cos(d)));
    }

    public double latitudeIsometric(double d, double d2) {
        double d3 = 1.0 - d2 * Math.sin(d);
        double d4 = 1.0 + d2 * Math.sin(d);
        return Math.log(Math.tan(0.7853981633974483 + d / 2.0) * Math.pow(d3 / d4, d2 / 2.0));
    }

    public double latitudeIsometric(double d) {
        double d2 = 1.0 - this.e * Math.sin(d);
        double d3 = 1.0 + this.e * Math.sin(d);
        return Math.log(Math.tan(0.7853981633974483 + d / 2.0) * Math.pow(d2 / d3, this.e / 2.0));
    }

    public double latitude(double d, double d2, double d3) {
        double d4;
        double d5 = d4 = 2.0 * Math.atan(Math.exp(d)) - 1.5707963267948966;
        double d6 = 1.0;
        while (Math.abs(d6 - d5) >= d3) {
            d5 = d6;
            double d7 = 1.0 + d2 * Math.sin(d5);
            double d8 = 1.0 - d2 * Math.sin(d5);
            d6 = 2.0 * Math.atan(Math.pow(d7 / d8, d2 / 2.0) * Math.exp(d)) - 1.5707963267948966;
        }
        return d6;
    }

    public LatLon cart2LatLon(double[] dArray) {
        return this.cart2LatLon(dArray, 1.0E-11);
    }

    public LatLon cart2LatLon(double[] dArray, double d) {
        double d2 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        double d3 = 2.0 * Math.atan(dArray[1] / (dArray[0] + d2));
        double d4 = Math.atan(dArray[2] / (d2 * (1.0 - this.a * this.e2 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]))));
        double d5 = 1.0;
        while (d5 > d) {
            double d6 = Math.sin(d4);
            d6 *= d6;
            double d7 = Math.atan(dArray[2] / d2 / (1.0 - this.a * this.e2 * Math.cos(d4) / (d2 * Math.sqrt(1.0 - this.e2 * d6))));
            d5 = Math.abs(d7 - d4);
            d4 = d7;
        }
        return new LatLon(Math.toDegrees(d4), Math.toDegrees(d3));
    }

    public double[] latLon2Cart(LatLon latLon) {
        double d = Math.toRadians(latLon.lat());
        double d2 = Math.toRadians(latLon.lon());
        double d3 = this.a / Math.sqrt(1.0 - this.e2 * Math.pow(Math.sin(d), 2.0));
        double[] dArray = new double[]{d3 * Math.cos(d) * Math.cos(d2), d3 * Math.cos(d) * Math.sin(d2), d3 * (1.0 - this.e2) * Math.sin(d)};
        return dArray;
    }
}

