/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.NoteReader;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class BoundingBoxDownloader
extends OsmServerReader {
    protected final double lat1;
    protected final double lon1;
    protected final double lat2;
    protected final double lon2;
    protected final boolean crosses180th;

    public BoundingBoxDownloader(Bounds bounds) {
        CheckParameterUtil.ensureParameterNotNull(bounds, "downloadArea");
        this.lat1 = bounds.getMinLat();
        this.lon1 = bounds.getMinLon();
        this.lat2 = bounds.getMaxLat();
        this.lon2 = bounds.getMaxLon();
        this.crosses180th = bounds.crosses180thMeridian();
    }

    private GpxData downloadRawGps(Bounds bounds, ProgressMonitor progressMonitor) throws IOException, OsmTransferException, SAXException {
        boolean bl = false;
        GpxData gpxData = null;
        String string = "trackpoints?bbox=" + bounds.getMinLon() + ',' + bounds.getMinLat() + ',' + bounds.getMaxLon() + ',' + bounds.getMaxLat() + "&page=";
        int n = 0;
        while (!bl && !this.isCanceled()) {
            block24: {
                Throwable throwable;
                progressMonitor.subTask(I18n.tr("Downloading points {0} to {1}...", n * 5000, (n + 1) * 5000));
                try {
                    throwable = null;
                    try (InputStream inputStream = this.getInputStream(string + n, progressMonitor.createSubTaskMonitor(1, true));){
                        if (inputStream == null) break;
                        progressMonitor.setTicks(0);
                        GpxReader gpxReader = new GpxReader(inputStream);
                        this.gpxParsedProperly = gpxReader.parse(false);
                        GpxData gpxData2 = gpxReader.getGpxData();
                        if (gpxData == null) {
                            gpxData = gpxData2;
                        } else if (gpxData2.hasTrackPoints()) {
                            gpxData.mergeFrom(gpxData2);
                        } else {
                            bl = true;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (OsmApiException osmApiException) {
                    throw osmApiException;
                }
                catch (SocketException | OsmTransferException exception) {
                    if (!this.isCanceled()) break block24;
                    throwable = new OsmTransferCanceledException("Operation canceled");
                    throwable.initCause(exception);
                    Main.warn(throwable);
                }
            }
            this.activeConnection = null;
            ++n;
        }
        if (gpxData != null) {
            gpxData.fromServer = true;
            gpxData.dataSources.add(new DataSource(bounds, "OpenStreetMap server"));
        }
        return gpxData;
    }

    @Override
    public GpxData parseRawGps(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask("", 1);
        try {
            progressMonitor.indeterminateSubTask(this.getTaskName());
            if (this.crosses180th) {
                GpxData gpxData = this.downloadRawGps(new Bounds(this.lat1, this.lon1, this.lat2, 180.0), progressMonitor);
                gpxData.mergeFrom(this.downloadRawGps(new Bounds(this.lat1, -180.0, this.lat2, this.lon2), progressMonitor));
                GpxData gpxData2 = gpxData;
                return gpxData2;
            }
            GpxData gpxData = this.downloadRawGps(new Bounds(this.lat1, this.lon1, this.lat2, this.lon2), progressMonitor);
            return gpxData;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw new OsmTransferException("Illegal characters within the HTTP-header response.", illegalArgumentException);
        }
        catch (IOException iOException) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw new OsmTransferException(iOException);
        }
        catch (SAXException sAXException) {
            throw new OsmTransferException(sAXException);
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (RuntimeException runtimeException) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw runtimeException;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected String getTaskName() {
        return I18n.tr("Contacting OSM Server...", new Object[0]);
    }

    protected String getRequestForBbox(double d, double d2, double d3, double d4) {
        return "map?bbox=" + d + ',' + d2 + ',' + d3 + ',' + d4;
    }

    protected DataSet parseDataSet(InputStream inputStream, ProgressMonitor progressMonitor) throws IllegalDataException {
        return OsmReader.parseDataSet(inputStream, progressMonitor);
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(this.getTaskName(), 10);
        try {
            Object object;
            DataSet dataSet = null;
            progressMonitor.indeterminateSubTask(null);
            if (this.crosses180th) {
                object = null;
                try (InputStream inputStream = this.getInputStream(this.getRequestForBbox(this.lon1, this.lat1, 180.0, this.lat2), progressMonitor.createSubTaskMonitor(9, false));){
                    if (inputStream == null) {
                        DataSet dataSet2 = null;
                        return dataSet2;
                    }
                    dataSet = this.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, false));
                }
                inputStream = this.getInputStream(this.getRequestForBbox(-180.0, this.lat1, this.lon2, this.lat2), progressMonitor.createSubTaskMonitor(9, false));
                var5_8 = null;
                try {
                    if (inputStream == null) {
                        DataSet dataSet3 = null;
                        return dataSet3;
                    }
                    object = this.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, false));
                }
                catch (Throwable throwable) {
                    var5_8 = throwable;
                    throw throwable;
                }
                finally {
                    if (inputStream != null) {
                        if (var5_8 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {
                                var5_8.addSuppressed(throwable);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
                if (object == null) {
                    inputStream = null;
                    return inputStream;
                }
                dataSet.mergeFrom((DataSet)object);
            } else {
                object = this.getInputStream(this.getRequestForBbox(this.lon1, this.lat1, this.lon2, this.lat2), progressMonitor.createSubTaskMonitor(9, false));
                Throwable throwable = null;
                try {
                    if (object == null) {
                        DataSet dataSet4 = null;
                        return dataSet4;
                    }
                    dataSet = this.parseDataSet((InputStream)object, progressMonitor.createSubTaskMonitor(1, false));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((InputStream)object).close();
                        }
                    }
                }
            }
            object = dataSet;
            return object;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (IOException | IllegalDataException exception) {
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
            this.activeConnection = null;
        }
    }

    @Override
    public List<Note> parseNotes(int n, int n2, ProgressMonitor progressMonitor) throws OsmTransferException, MoreNotesException {
        progressMonitor.beginTask(I18n.tr("Downloading notes", new Object[0]));
        CheckParameterUtil.ensureThat(n > 0, "Requested note limit is less than 1.");
        CheckParameterUtil.ensureThat(n <= 10000, "Requested note limit is over API hard limit of 10000.");
        CheckParameterUtil.ensureThat(n2 >= -1, "Requested note limit is less than -1.");
        String string = "notes?limit=" + n + "&closed=" + n2 + "&bbox=" + this.lon1 + ',' + this.lat1 + ',' + this.lon2 + ',' + this.lat2;
        try {
            InputStream inputStream = this.getInputStream(string, progressMonitor.createSubTaskMonitor(1, false));
            NoteReader noteReader = new NoteReader(inputStream);
            List<Note> list = noteReader.parse();
            if (list.size() == n) {
                throw new MoreNotesException(list, n);
            }
            List<Note> list2 = list;
            return list2;
        }
        catch (IOException | SAXException exception) {
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public static class MoreNotesException
    extends RuntimeException {
        public final transient List<Note> notes;
        public final int limit;

        public MoreNotesException(List<Note> list, int n) {
            this.notes = list;
            this.limit = n;
        }
    }
}

