/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.BaseLoader;
import com.ibm.xmi.framework.Feature;
import com.ibm.xmi.framework.ObjectInfo;
import com.ibm.xmi.framework.ReaderAdapter;
import com.ibm.xmi.framework.XMIFile;
import java.util.HashSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class BaseLoader2
extends BaseLoader {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean setXMIFile = false;
    private HashSet predefinedElements = new HashSet();

    public BaseLoader2(XMIFile xMIFile, int n, ReaderAdapter readerAdapter) {
        super(xMIFile, n, readerAdapter);
        this.predefinedElements.add("xmi:Documentation");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.debug) {
            System.out.println("startElement2 " + string3);
        }
        if (this.isXMI2(attributes)) {
            this.handleXMI2Elements(string3, attributes);
        } else if (this.isNull(attributes)) {
            this.types.push("nullProperty");
        } else {
            if (string3.equals("xmi:Model")) {
                super.startElement(string, string2, string3, attributes);
                return;
            }
            if (!this.isPredefinedElement(string3)) {
                this.isContent = this.isContent();
                if (!this.setXMIFile && !this.tagNames.isEmpty() && this.tagNames.peek().equals("xmi:XMI")) {
                    this.adapter.setXMIFile(this.file);
                    this.setXMIFile = true;
                }
                super.startElement(string, string2, string3, attributes);
                return;
            }
        }
        this.tagNames.push(string3);
    }

    protected boolean isPredefinedElement(String string) {
        return this.predefinedElements.contains(string);
    }

    private void handleXMI2Elements(String string, Attributes attributes) {
        this.file.setXMIVersion("2.0");
        if (!this.setXMIFile && !string.equals("xmi:XMI")) {
            this.adapter.setXMIFile(this.file);
            this.setXMIFile = true;
        }
        this.processNamespaceAttributes(attributes);
    }

    protected void processNamespaceAttributes(Attributes attributes) {
        int n = 0;
        while (n < attributes.getLength()) {
            this.processNamespaceAttrib(attributes.getQName(n), attributes.getValue(n));
            ++n;
        }
    }

    protected boolean isContent() {
        if (!this.tagNames.isEmpty() && this.tagNames.peek().equals("xmi:XMI")) {
            return true;
        }
        return !this.objects.isEmpty();
    }

    protected String getXMIID() {
        return "xmi:id";
    }

    protected String getXMIUUID() {
        return "xmi:uuid";
    }

    protected String getXMILabel() {
        return "xmi:label";
    }

    protected boolean addToFile() {
        return this.objects.isEmpty();
    }

    protected boolean isNull(Attributes attributes) {
        return attributes.getValue("xsi:nil") != null;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.debug) {
            System.out.println("endElement2 " + string3);
        }
        if (this.isContent && this.isNilProperty()) {
            String string4 = (String)this.tagNames.peek();
            this.valueInfo.clear();
            this.valueInfo.setObject(this.objects.peek());
            this.valueInfo.setClassName(this.getClassName(string4));
            this.valueInfo.setXMIName(this.getSimpleName(string4));
            this.valueInfo.setNamespace(this.getNamespace(string4));
            this.valueInfo.setValue(null);
            this.createFeature(this.valueInfo, this.getPropertyType(), null);
            this.tagNames.pop();
            if (!this.types.isEmpty()) {
                this.types.pop();
            }
        } else {
            super.endElement(string, string2, string3);
        }
    }

    protected boolean isNilProperty() {
        return !this.types.isEmpty() && this.types.peek().equals("nullProperty");
    }

    protected void handleContent(String string, Attributes attributes) {
        if (this.debug) {
            System.out.println("handleContent2 " + string);
        }
        if (!this.objects.isEmpty() && !this.types.isEmpty() && this.types.peek().equals("Object") && this.isObjectFeature(attributes)) {
            this.createObjectFeature(string, attributes);
            return;
        }
        super.handleContent(string, attributes);
    }

    protected boolean isObjectFeature(Attributes attributes) {
        if (attributes.getValue(this.getXMIID()) != null || attributes.getValue(this.getXMILabel()) != null || attributes.getValue(this.getXMIUUID()) != null || attributes.getValue("xmi:type") != null) {
            return true;
        }
        if (attributes.getValue("xsi:nil") != null) {
            return false;
        }
        return attributes.getLength() > 0;
    }

    protected void createObjectFeature(String string, Attributes attributes) {
        this.createObjectForFeature(string, attributes);
    }

    protected void createObjectForFeature(String string, Attributes attributes) {
        Object object;
        if (this.debug) {
            System.out.println("createObjectForFeature " + string);
        }
        this.objectInfo.clear();
        String[] stringArray = this.processAttribs(this.objectInfo, attributes);
        String string2 = string;
        if (this.objectInfo.getXMIName() != null) {
            string2 = this.objectInfo.getXMIName();
            this.objectInfo.setXMIName(this.stripNamespace(string2));
        }
        this.objectInfo.setNamespace(this.getNamespace(string2));
        this.valueInfo.clear();
        this.valueInfo.setObject(this.objects.peek());
        this.valueInfo.setXMIName(this.stripNamespace(string));
        this.valueInfo.setNamespace(this.getNamespace(string));
        int n = this.adapter.getType(this.valueInfo);
        if (this.valueInfo.getDefiner() != null && this.objectInfo.getXMIName() == null && this.valueInfo.getDefiner() instanceof Feature && (object = ((Feature)this.valueInfo.getDefiner()).getXMIType()) != null) {
            this.objectInfo.setXMIName(this.stripNamespace(object.getXMIName()));
            this.objectInfo.setNamespace(object.getXMINamespace());
        }
        object = this.createObject(this.objectInfo);
        this.handleFeatureForObjectFeature(object, n, this.objectInfo.getIdref());
        this.types.push("Object");
        if (object != null) {
            this.objects.push(object);
            this.processOtherAttribs(object, stringArray, this.objectInfo.getXMIName());
        } else {
            this.objects.push(new Object());
        }
    }

    protected String[] processAttribs(ObjectInfo objectInfo, Attributes attributes) {
        String[] stringArray = super.processAttribs(objectInfo, attributes);
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length - 1) {
            if (stringArray[n2] != null && stringArray[n2].equals("xmi:type")) {
                objectInfo.setXMIName(stringArray[n2 + 1]);
            } else {
                stringArray2[n++] = stringArray[n2];
                stringArray2[n++] = stringArray[n2 + 1];
            }
            n2 += 2;
        }
        return stringArray2;
    }

    protected void handleFeatureForObjectFeature(Object object, int n, String string) {
        this.valueInfo.setValue(object);
        this.createFeature(this.valueInfo, n, string);
    }

    protected String getExtensionName() {
        return "xmi:Extension";
    }

    protected String getExtenderName() {
        return "extender";
    }

    protected String getExtenderIDName() {
        return "extenderID";
    }

    protected String getImportElementName() {
        return "xmi:import";
    }

    protected String getModelElementName() {
        return "xmi:Model";
    }

    protected String getMetamodelElementName() {
        return "xmi:metamodel";
    }

    protected String getExporterName() {
        return "exporter";
    }

    protected String getExporterVersionName() {
        return "exporterVersion";
    }

    protected String getOwnerName() {
        return "owner";
    }

    protected String getContactName() {
        return "contact";
    }

    protected String getNoticeName() {
        return "notice";
    }

    protected String getLongDescriptionName() {
        return "longDescription";
    }

    protected String getShortDescriptionName() {
        return "shortDescription";
    }

    protected String getNameAttrib() {
        return "name";
    }

    protected String getVersionAttrib() {
        return "version";
    }
}

