/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.CLIHandler;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.ExitDialog;
import org.netbeans.core.NbLifecycleManager;
import org.netbeans.core.NbLoaderPool;
import org.netbeans.core.WindowSystem;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.layers.SessionManager;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

final class NbLifeExit
implements Runnable {
    private static final RequestProcessor RP = new RequestProcessor("Nb Exit");
    private final int type;
    private final int status;
    private final Future<Boolean> waitFor;
    private final CountDownLatch onExit;

    NbLifeExit(int n, int n2, CountDownLatch countDownLatch) {
        this(n, n2, null, countDownLatch);
    }

    private NbLifeExit(int n, int n2, Future<Boolean> future, CountDownLatch countDownLatch) {
        this.type = n;
        this.status = n2;
        this.waitFor = future;
        this.onExit = countDownLatch;
        NbLifecycleManager.LOG.log(Level.FINE, "NbLifeExit({0}, {1}, {2}, {3}) = {4}", new Object[]{n, n2, future, countDownLatch, this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NbLifecycleManager.LOG.log(Level.FINE, "{0}.run()", this);
        switch (this.type) {
            case 0: {
                this.doExit(this.status);
                break;
            }
            case 1: {
                this.doStopInfra(this.status);
                break;
            }
            case 2: {
                int n = 3;
                try {
                    if (this.waitFor != null && this.waitFor.get().booleanValue()) {
                        n = 4;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    Exceptions.printStackTrace((Throwable)executionException);
                }
                Mutex.EVENT.readAccess((Runnable)new NbLifeExit(n, this.status, null, this.onExit));
                break;
            }
            case 3: 
            case 4: {
                this.doApproved(this.type == 4, this.status);
                break;
            }
            case 5: {
                try {
                    boolean bl = !Boolean.getBoolean("netbeans.close.no.exit");
                    NbLifecycleManager.LOG.log(Level.FINE, "Calling exit: {0}", bl);
                    if (!bl) break;
                    TopSecurityManager.exit((int)this.status);
                    break;
                }
                finally {
                    NbLifecycleManager.LOG.log(Level.FINE, "After exit!");
                    this.onExit.countDown();
                }
            }
            default: {
                throw new IllegalStateException("Type: " + this.type);
            }
        }
    }

    private void doExit(int n) {
        Future future = System.getProperty("netbeans.close") != null || ExitDialog.showDialog() ? Main.getModuleSystem().shutDownAsync((Runnable)new NbLifeExit(1, n, null, this.onExit)) : null;
        RP.post((Runnable)new NbLifeExit(2, n, future, this.onExit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStopInfra(int n) {
        CLIHandler.stopServer();
        WindowSystem windowSystem = (WindowSystem)Lookup.getDefault().lookup(WindowSystem.class);
        boolean bl = CLIOptions.isGui();
        if (windowSystem != null && bl) {
            windowSystem.hide();
            windowSystem.save();
        }
        if (Boolean.getBoolean("netbeans.close.when.invisible")) {
            try {
                TopSecurityManager.exit((int)n);
            }
            finally {
                this.onExit.countDown();
            }
        }
    }

    private void doApproved(boolean bl, int n) throws ThreadDeath {
        if (bl) {
            try {
                try {
                    NbLoaderPool.store();
                }
                catch (IOException iOException) {
                    Logger.getLogger(NbLifecycleManager.class.getName()).log(Level.WARNING, null, iOException);
                }
                SessionManager.getDefault().close();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Exceptions.printStackTrace((Throwable)throwable);
            }
            Task task = new Task((Runnable)new NbLifeExit(5, n, null, this.onExit));
            RP.post((Runnable)task);
        } else {
            this.onExit.countDown();
        }
    }
}

