# -*- Mode: Python -*-
# vi:si:et:sw=4:sts=4:ts=4

# Flumotion - a streaming media server
# Copyright (C) 2004,2005,2006,2007,2008,2009 Fluendo, S.L.
# Copyright (C) 2010,2011 Flumotion Services, S.A.
# All rights reserved.
#
# This file may be distributed and/or modified under the terms of
# the GNU Lesser General Public License version 2.1 as published by
# the Free Software Foundation.
# This file is distributed without any warranty; without even the implied
# warranty of merchantability or fitness for a particular purpose.
# See "LICENSE.LGPL" in the source distribution for more information.
#
# Headers in this file shall remain intact.


import os

CORTADO_PREFIX = ""


def getCortadoFilename():
    directories = ['/usr/local', '/usr']
    prefix = CORTADO_PREFIX[:]
    if prefix:
        if prefix.endswith('/'):
            prefix = prefix[1:]
        directories.insert(0, CORTADO_PREFIX)
    for directory in directories:
        # Debian/Ubuntu
        name = os.path.join(directory, 'share', 'cortado', 'cortado-ovt.jar')
        if os.path.exists(name):
            return name
        # OpenSuSE
        name = os.path.join(directory, 'share',
                            'java', 'cortado', 'cortado-ovt.jar')
        if os.path.exists(name):
            return name
        # ant install_applet
        for version in ['0.2.2', '0.2.1', '0.2.0']:
            name = os.path.join(
                directory, 'share', 'cortado',
                'cortado-ovt-stripped-%s.1.jar' % (version, ))
            if os.path.exists(name):
                return name
    return None
