/*! grafana - v3.0.4 - 2016-06-01
 * Copyright (c) 2016 Torkel Ödegaard; Licensed Apache-2.0 */

System.register(["test/lib/common","../elastic_response"],function(a){var b,c;return{setters:[function(a){b=a},function(a){c=a}],execute:function(){b.describe("ElasticResponse",function(){var a,d,e;b.describe("simple query and count",function(){b.beforeEach(function(){a=[{refId:"A",metrics:[{type:"count",id:"1"}],bucketAggs:[{type:"date_histogram",field:"@timestamp",id:"2"}]}],d={responses:[{aggregations:{2:{buckets:[{doc_count:10,key:1e3},{doc_count:15,key:2e3}]}}}]},e=new c["default"](a,d).getTimeSeries()}),b.it("should return 1 series",function(){b.expect(e.data.length).to.be(1),b.expect(e.data[0].target).to.be("Count"),b.expect(e.data[0].datapoints.length).to.be(2),b.expect(e.data[0].datapoints[0][0]).to.be(10),b.expect(e.data[0].datapoints[0][1]).to.be(1e3)})}),b.describe("simple query count & avg aggregation",function(){var e;b.beforeEach(function(){a=[{refId:"A",metrics:[{type:"count",id:"1"},{type:"avg",field:"value",id:"2"}],bucketAggs:[{type:"date_histogram",field:"@timestamp",id:"3"}]}],d={responses:[{aggregations:{3:{buckets:[{2:{value:88},doc_count:10,key:1e3},{2:{value:99},doc_count:15,key:2e3}]}}}]},e=new c["default"](a,d).getTimeSeries()}),b.it("should return 2 series",function(){b.expect(e.data.length).to.be(2),b.expect(e.data[0].datapoints.length).to.be(2),b.expect(e.data[0].datapoints[0][0]).to.be(10),b.expect(e.data[0].datapoints[0][1]).to.be(1e3),b.expect(e.data[1].target).to.be("Average value"),b.expect(e.data[1].datapoints[0][0]).to.be(88),b.expect(e.data[1].datapoints[1][0]).to.be(99)})}),b.describe("single group by query one metric",function(){var e;b.beforeEach(function(){a=[{refId:"A",metrics:[{type:"count",id:"1"}],bucketAggs:[{type:"terms",field:"host",id:"2"},{type:"date_histogram",field:"@timestamp",id:"3"}]}],d={responses:[{aggregations:{2:{buckets:[{3:{buckets:[{doc_count:1,key:1e3},{doc_count:3,key:2e3}]},doc_count:4,key:"server1"},{3:{buckets:[{doc_count:2,key:1e3},{doc_count:8,key:2e3}]},doc_count:10,key:"server2"}]}}}]},e=new c["default"](a,d).getTimeSeries()}),b.it("should return 2 series",function(){b.expect(e.data.length).to.be(2),b.expect(e.data[0].datapoints.length).to.be(2),b.expect(e.data[0].target).to.be("server1"),b.expect(e.data[1].target).to.be("server2")})}),b.describe("single group by query two metrics",function(){var e;b.beforeEach(function(){a=[{refId:"A",metrics:[{type:"count",id:"1"},{type:"avg",field:"@value",id:"4"}],bucketAggs:[{type:"terms",field:"host",id:"2"},{type:"date_histogram",field:"@timestamp",id:"3"}]}],d={responses:[{aggregations:{2:{buckets:[{3:{buckets:[{4:{value:10},doc_count:1,key:1e3},{4:{value:12},doc_count:3,key:2e3}]},doc_count:4,key:"server1"},{3:{buckets:[{4:{value:20},doc_count:1,key:1e3},{4:{value:32},doc_count:3,key:2e3}]},doc_count:10,key:"server2"}]}}}]},e=new c["default"](a,d).getTimeSeries()}),b.it("should return 2 series",function(){b.expect(e.data.length).to.be(4),b.expect(e.data[0].datapoints.length).to.be(2),b.expect(e.data[0].target).to.be("server1 Count"),b.expect(e.data[1].target).to.be("server1 Average @value"),b.expect(e.data[2].target).to.be("server2 Count"),b.expect(e.data[3].target).to.be("server2 Average @value")})}),b.describe("with percentiles ",function(){var e;b.beforeEach(function(){a=[{refId:"A",metrics:[{type:"percentiles",settings:{percents:[75,90]},id:"1"}],bucketAggs:[{type:"date_histogram",field:"@timestamp",id:"3"}]}],d={responses:[{aggregations:{3:{buckets:[{1:{values:{75:3.3,90:5.5}},doc_count:10,key:1e3},{1:{values:{75:2.3,90:4.5}},doc_count:15,key:2e3}]}}}]},e=new c["default"](a,d).getTimeSeries()}),b.it("should return 2 series",function(){b.expect(e.data.length).to.be(2),b.expect(e.data[0].datapoints.length).to.be(2),b.expect(e.data[0].target).to.be("p75"),b.expect(e.data[1].target).to.be("p90"),b.expect(e.data[0].datapoints[0][0]).to.be(3.3),b.expect(e.data[0].datapoints[0][1]).to.be(1e3),b.expect(e.data[1].datapoints[1][0]).to.be(4.5)})}),b.describe("with extended_stats",function(){var e;b.beforeEach(function(){a=[{refId:"A",metrics:[{type:"extended_stats",meta:{max:!0,std_deviation_bounds_upper:!0},id:"1"}],bucketAggs:[{type:"terms",field:"host",id:"3"},{type:"date_histogram",id:"4"}]}],d={responses:[{aggregations:{3:{buckets:[{key:"server1",4:{buckets:[{1:{max:10.2,min:5.5,std_deviation_bounds:{upper:3,lower:-2}},doc_count:10,key:1e3}]}},{key:"server2",4:{buckets:[{1:{max:10.2,min:5.5,std_deviation_bounds:{upper:3,lower:-2}},doc_count:10,key:1e3}]}}]}}}]},e=new c["default"](a,d).getTimeSeries()}),b.it("should return 4 series",function(){b.expect(e.data.length).to.be(4),b.expect(e.data[0].datapoints.length).to.be(1),b.expect(e.data[0].target).to.be("server1 Max"),b.expect(e.data[1].target).to.be("server1 Std Dev Upper"),b.expect(e.data[0].datapoints[0][0]).to.be(10.2),b.expect(e.data[1].datapoints[0][0]).to.be(3)})}),b.describe("single group by with alias pattern",function(){var e;b.beforeEach(function(){a=[{refId:"A",metrics:[{type:"count",id:"1"}],alias:"{{term @host}} {{metric}} and!",bucketAggs:[{type:"terms",field:"@host",id:"2"},{type:"date_histogram",field:"@timestamp",id:"3"}]}],d={responses:[{aggregations:{2:{buckets:[{3:{buckets:[{doc_count:1,key:1e3},{doc_count:3,key:2e3}]},doc_count:4,key:"server1"},{3:{buckets:[{doc_count:2,key:1e3},{doc_count:8,key:2e3}]},doc_count:10,key:"server2"}]}}}]},e=new c["default"](a,d).getTimeSeries()}),b.it("should return 2 series",function(){b.expect(e.data.length).to.be(2),b.expect(e.data[0].datapoints.length).to.be(2),b.expect(e.data[0].target).to.be("server1 Count and!"),b.expect(e.data[1].target).to.be("server2 Count and!")})}),b.describe("with two filters agg",function(){var e;b.beforeEach(function(){a=[{refId:"A",metrics:[{type:"count",id:"1"}],bucketAggs:[{id:"2",type:"filters",settings:{filters:[{query:"@metric:cpu"},{query:"@metric:logins.count"}]}},{type:"date_histogram",field:"@timestamp",id:"3"}]}],d={responses:[{aggregations:{2:{buckets:{"@metric:cpu":{3:{buckets:[{doc_count:1,key:1e3},{doc_count:3,key:2e3}]}},"@metric:logins.count":{3:{buckets:[{doc_count:2,key:1e3},{doc_count:8,key:2e3}]}}}}}}]},e=new c["default"](a,d).getTimeSeries()}),b.it("should return 2 series",function(){b.expect(e.data.length).to.be(2),b.expect(e.data[0].datapoints.length).to.be(2),b.expect(e.data[0].target).to.be("@metric:cpu"),b.expect(e.data[1].target).to.be("@metric:logins.count")})}),b.describe("with dropfirst and last aggregation",function(){b.beforeEach(function(){a=[{refId:"A",metrics:[{type:"avg",id:"1"},{type:"count"}],bucketAggs:[{id:"2",type:"date_histogram",field:"host",settings:{trimEdges:1}}]}],d={responses:[{aggregations:{2:{buckets:[{1:{value:1e3},key:1,doc_count:369},{1:{value:2e3},key:2,doc_count:200},{1:{value:2e3},key:3,doc_count:200}]}}}]},e=new c["default"](a,d).getTimeSeries()}),b.it("should remove first and last value",function(){b.expect(e.data.length).to.be(2),b.expect(e.data[0].datapoints.length).to.be(1)})}),b.describe("No group by time",function(){b.beforeEach(function(){a=[{refId:"A",metrics:[{type:"avg",id:"1"},{type:"count"}],bucketAggs:[{id:"2",type:"terms",field:"host"}]}],d={responses:[{aggregations:{2:{buckets:[{1:{value:1e3},key:"server-1",doc_count:369},{1:{value:2e3},key:"server-2",doc_count:200}]}}}]},e=new c["default"](a,d).getTimeSeries()}),b.it("should return table",function(){b.expect(e.data.length).to.be(1),b.expect(e.data[0].type).to.be("docs"),b.expect(e.data[0].datapoints.length).to.be(2),b.expect(e.data[0].datapoints[0].host).to.be("server-1"),b.expect(e.data[0].datapoints[0].Average).to.be(1e3),b.expect(e.data[0].datapoints[0].Count).to.be(369),b.expect(e.data[0].datapoints[1].host).to.be("server-2"),b.expect(e.data[0].datapoints[1].Average).to.be(2e3)})}),b.describe("Raw documents query",function(){b.beforeEach(function(){a=[{refId:"A",metrics:[{type:"raw_document",id:"1"}],bucketAggs:[]}],d={responses:[{hits:{total:100,hits:[{_id:"1",_type:"type",_index:"index",_source:{sourceProp:"asd"},fields:{fieldProp:"field"}},{_source:{sourceProp:"asd2"},fields:{fieldProp:"field2"}}]}}]},e=new c["default"](a,d).getTimeSeries()}),b.it("should return docs",function(){b.expect(e.data.length).to.be(1),b.expect(e.data[0].type).to.be("docs"),b.expect(e.data[0].total).to.be(100),b.expect(e.data[0].datapoints.length).to.be(2),b.expect(e.data[0].datapoints[0].sourceProp).to.be("asd"),b.expect(e.data[0].datapoints[0].fieldProp).to.be("field")})})})}}});