/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Arrays;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.java.BS;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;

public class CrystalReader
extends AtomSetCollectionReader {
    private boolean isVersion3;
    private boolean isPrimitive;
    private boolean isPolymer;
    private boolean isSlab;
    private boolean isMolecular;
    private boolean haveCharges;
    private boolean inputOnly;
    private boolean isLongMode;
    private boolean getLastConventional;
    private boolean havePrimitiveMapping;
    private boolean isProperties;
    private int ac;
    private int atomIndexLast;
    private int[] atomFrag;
    private int[] primitiveToIndex;
    private float[] nuclearCharges;
    private Lst<String> vCoords;
    private Double energy;
    private P3 ptOriginShift = new P3();
    private M3 primitiveToCryst;
    private V3[] directLatticeVectors;
    private String spaceGroupName;
    private float primitiveVolume;
    private float primitiveDensity;
    private Lst<String> vPrimitiveMapping;

    @Override
    protected void initializeReader() throws Exception {
        this.doProcessLines = false;
        this.inputOnly = this.checkFilterKey("INPUT");
        this.isPrimitive = !this.inputOnly && !this.checkFilterKey("CONV");
        this.addVibrations &= !this.inputOnly;
        this.getLastConventional = !this.isPrimitive && this.desiredModelNumber == 0;
        this.setFractionalCoordinates(this.readHeader());
        this.asc.checkLatticeOnly = true;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" LATTICE PARAMETER")) {
            boolean isConvLattice;
            boolean bl = isConvLattice = this.line.indexOf("- CONVENTIONAL") >= 0;
            if (isConvLattice) {
                if (this.isPrimitive) {
                    return true;
                }
                this.readLatticeParams(true);
            } else if (!(this.isPrimitive || this.havePrimitiveMapping || this.getLastConventional)) {
                this.readLines(3);
                this.readPrimitiveMapping();
                if (this.setPrimitiveMapping()) {
                    return true;
                }
            }
            this.readLatticeParams(true);
            if (!this.isPrimitive) {
                this.discardLinesUntilContains(" TRANSFORMATION");
                this.readTransformationMatrix();
                this.discardLinesUntilContains(" CRYSTALLOGRAPHIC");
                this.readLatticeParams(false);
                this.discardLinesUntilContains(" CRYSTALLOGRAPHIC");
                this.readCoordLines();
                if (!this.getLastConventional) {
                    if (this.doGetModel(++this.modelNumber, null)) {
                        this.createAtomsFromCoordLines();
                    } else {
                        this.vCoords = null;
                        this.checkLastModel();
                    }
                }
            }
            return true;
        }
        if (!this.isPrimitive) {
            if (this.line.startsWith(" SHIFT OF THE ORIGIN")) {
                return this.readShift();
            }
            if (this.line.startsWith(" INPUT COORDINATES")) {
                this.readCoordLines();
                if (this.inputOnly) {
                    this.continuing = false;
                }
                return true;
            }
        }
        if (this.line.startsWith(" DIRECT LATTICE VECTOR")) {
            return this.setDirect();
        }
        if (this.line.indexOf("DIMENSIONALITY OF THE SYSTEM") >= 0) {
            if (this.line.indexOf("2") >= 0) {
                this.isSlab = true;
            }
            if (this.line.indexOf("1") >= 0) {
                this.isPolymer = true;
            }
            return true;
        }
        if (this.addVibrations && this.line.startsWith(" FREQUENCIES COMPUTED ON A FRAGMENT")) {
            return this.readFreqFragments();
        }
        if (this.line.indexOf("CONSTRUCTION OF A NANOTUBE FROM A SLAB") >= 0) {
            this.isPolymer = true;
            this.isSlab = false;
            return true;
        }
        if (this.line.indexOf("* CLUSTER CALCULATION") >= 0) {
            this.isMolecular = true;
            this.isSlab = false;
            this.isPolymer = false;
            return true;
        }
        if ((this.isPrimitive || this.isMolecular) && this.line.startsWith(" ATOMS IN THE ASYMMETRIC UNIT") || this.isProperties && this.line.startsWith("   ATOM N.AT.")) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            return this.readAtoms();
        }
        if (this.line.startsWith(" * SUPERCELL OPTION")) {
            this.discardLinesUntilContains("GENERATED");
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith(" TOTAL ENERGY(")) {
            this.line = PT.rep(this.line, "( ", "(");
            String[] tokens = this.getTokens();
            this.energy = Double.parseDouble(tokens[2]);
            this.setEnergy();
            this.rd();
            if (this.line.startsWith(" ********")) {
                this.discardLinesUntilContains("SYMMETRY ALLOWED");
            } else if (this.line.startsWith(" TTTTTTTT")) {
                this.discardLinesUntilContains2("PREDICTED ENERGY CHANGE", "HHHHHHH");
            }
            return true;
        }
        if (this.line.startsWith(" TYPE OF CALCULATION")) {
            this.calculationType = this.line.substring(this.line.indexOf(":") + 1).trim();
            return true;
        }
        if (this.line.startsWith(" MULLIKEN POPULATION ANALYSIS")) {
            return this.readPartialCharges();
        }
        if (this.line.startsWith(" TOTAL ATOMIC CHARGES")) {
            return this.readTotalAtomicCharges();
        }
        if (this.addVibrations && this.line.contains(this.isVersion3 ? "EIGENVALUES (EV) OF THE MASS" : "EIGENVALUES (EIGV) OF THE MASS") || this.line.indexOf("LONGITUDINAL OPTICAL (LO)") >= 0) {
            this.createAtomsFromCoordLines();
            this.isLongMode = this.line.indexOf("LONGITUDINAL OPTICAL (LO)") >= 0;
            return this.readFrequencies();
        }
        if (this.line.startsWith(" MAX GRADIENT")) {
            return this.readGradient();
        }
        if (this.line.startsWith(" ATOMIC SPINS SET")) {
            return this.readData("spin", 3);
        }
        if (this.line.startsWith(" TOTAL ATOMIC SPINS  :")) {
            return this.readData("magneticMoment", 1);
        }
        if (this.line.startsWith(" BORN CHARGE TENSOR.")) {
            return this.readBornChargeTensors();
        }
        if (!this.isProperties) {
            return true;
        }
        if (this.line.startsWith(" DEFINITION OF TRACELESS")) {
            return this.getQuadrupoleTensors();
        }
        if (this.line.startsWith(" MULTIPOLE ANALYSIS BY ATOMS")) {
            this.appendLoadNote("Multipole Analysis");
            return true;
        }
        return true;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.createAtomsFromCoordLines();
        if (this.energy != null) {
            this.setEnergy();
        }
        this.finalizeReaderASCR();
    }

    private boolean setDirect() throws Exception {
        boolean isBohr = this.line.indexOf("(BOHR") >= 0;
        this.directLatticeVectors = this.read3Vectors(isBohr);
        V3 a = new V3();
        V3 b = new V3();
        if (this.isPrimitive) {
            a = this.directLatticeVectors[0];
            b = this.directLatticeVectors[1];
        } else {
            if (this.primitiveToCryst == null) {
                return true;
            }
            M3 mp = new M3();
            mp.setColumnV(0, this.directLatticeVectors[0]);
            mp.setColumnV(1, this.directLatticeVectors[1]);
            mp.setColumnV(2, this.directLatticeVectors[2]);
            mp.mul(this.primitiveToCryst);
            a = new V3();
            b = new V3();
            mp.getColumnV(0, a);
            mp.getColumnV(1, b);
        }
        this.matUnitCellOrientation = Quat.getQuaternionFrame(new P3(), a, b).getMatrix();
        Logger.info("oriented unit cell is in model " + this.asc.atomSetCount);
        return !this.isProperties;
    }

    private void readTransformationMatrix() throws Exception {
        this.primitiveToCryst = M3.newA9(this.fillFloatArray(null, 0, new float[9]));
    }

    private boolean readShift() {
        String[] tokens = this.getTokens();
        int pt = tokens.length - 3;
        this.ptOriginShift.set(PT.parseFloatFraction(tokens[pt++]), PT.parseFloatFraction(tokens[pt++]), PT.parseFloatFraction(tokens[pt]));
        return true;
    }

    private void setPrimitiveVolumeAndDensity() {
        if (this.primitiveVolume != 0.0f) {
            this.asc.setAtomSetModelProperty("volumePrimitive", DF.formatDecimal(this.primitiveVolume, 3));
        }
        if (this.primitiveDensity != 0.0f) {
            this.asc.setAtomSetModelProperty("densityPrimitive", DF.formatDecimal(this.primitiveDensity, 3));
        }
    }

    private boolean readHeader() throws Exception {
        String name;
        this.discardLinesUntilContains("*******************************************************************************");
        this.readLines(2);
        this.isVersion3 = this.line.indexOf("CRYSTAL03") >= 0;
        this.discardLinesUntilContains("EEEEEEEEEE");
        if (this.rd().length() == 0) {
            name = this.readLines(2).trim();
        } else {
            name = this.line.trim();
            this.rd();
        }
        String type = this.rd().trim();
        int pt = type.indexOf("- PROPERTIES");
        if (pt >= 0) {
            this.isProperties = true;
            type = type.substring(0, pt).trim();
        }
        if (type.indexOf("EXTERNAL FILE") >= 0) {
            type = this.rd().trim();
            this.isPolymer = type.equals("1D - POLYMER");
            this.isSlab = type.equals("2D - SLAB");
        } else {
            this.isPolymer = type.equals("POLYMER CALCULATION");
            this.isSlab = type.equals("SLAB CALCULATION");
        }
        this.asc.setCollectionName(name + (!this.isProperties && this.desiredModelNumber == 0 ? " (optimized)" : ""));
        this.asc.setInfo("symmetryType", type);
        if ((this.isPolymer || this.isSlab) && !this.isPrimitive) {
            Logger.error("Cannot use FILTER \"conventional\" with POLYMER or SLAB");
            this.isPrimitive = true;
        }
        this.asc.setInfo("unitCellType", this.isPrimitive ? "primitive" : "conventional");
        if (type.indexOf("MOLECULAR") >= 0) {
            this.doProcessLines = true;
            this.isMolecular = true;
            this.rd();
            this.asc.setInfo("molecularCalculationPointGroup", this.line.substring(this.line.indexOf(" OR ") + 4).trim());
            return false;
        }
        this.spaceGroupName = "P1";
        if (!this.isPrimitive) {
            this.discardLinesUntilContains2("SPACE GROUP", "****");
            pt = this.line.indexOf(":");
            if (pt >= 0) {
                this.spaceGroupName = this.line.substring(pt + 1).trim();
            }
        }
        this.doApplySymmetry = this.isProperties;
        return !this.isProperties;
    }

    private void readLatticeParams(boolean isNewSet) throws Exception {
        float f;
        float f2 = f = this.line.indexOf("(BOHR") >= 0 ? 0.5291772f : 1.0f;
        if (isNewSet) {
            this.newAtomSet();
        }
        if (this.isPolymer && !this.isPrimitive) {
            this.setUnitCell(this.parseFloatStr(this.line.substring(this.line.indexOf("CELL") + 4)) * f, -1.0f, -1.0f, 90.0f, 90.0f, 90.0f);
        } else {
            while (this.rd().indexOf("GAMMA") < 0) {
                if (this.line.indexOf("VOLUME=") < 0) continue;
                this.primitiveVolume = this.parseFloatStr(this.line.substring(43));
                this.primitiveDensity = this.parseFloatStr(this.line.substring(66));
            }
            String[] tokens = PT.getTokens(this.rd());
            if (this.isSlab) {
                if (this.isPrimitive) {
                    this.setUnitCell(this.parseFloatStr(tokens[0]) * f, this.parseFloatStr(tokens[1]) * f, -1.0f, this.parseFloatStr(tokens[3]), this.parseFloatStr(tokens[4]), this.parseFloatStr(tokens[5]));
                } else {
                    this.setUnitCell(this.parseFloatStr(tokens[0]) * f, this.parseFloatStr(tokens[1]) * f, -1.0f, 90.0f, 90.0f, this.parseFloatStr(tokens[2]));
                }
            } else if (this.isPolymer) {
                this.setUnitCell(this.parseFloatStr(tokens[0]) * f, -1.0f, -1.0f, this.parseFloatStr(tokens[3]), this.parseFloatStr(tokens[4]), this.parseFloatStr(tokens[5]));
            } else {
                this.setUnitCell(this.parseFloatStr(tokens[0]) * f, this.parseFloatStr(tokens[1]) * f, this.parseFloatStr(tokens[2]) * f, this.parseFloatStr(tokens[3]), this.parseFloatStr(tokens[4]), this.parseFloatStr(tokens[5]));
            }
        }
    }

    private void readPrimitiveMapping() throws Exception {
        if (this.havePrimitiveMapping) {
            return;
        }
        this.vPrimitiveMapping = new Lst();
        while (this.rd() != null && this.line.indexOf("NUMBER") < 0) {
            this.vPrimitiveMapping.addLast(this.line);
        }
    }

    private boolean setPrimitiveMapping() throws Exception {
        int i;
        if (this.vCoords == null || this.vPrimitiveMapping == null || this.havePrimitiveMapping) {
            return false;
        }
        this.havePrimitiveMapping = true;
        BS bsInputAtomsIgnore = new BS();
        int n = this.vCoords.size();
        int[] indexToPrimitive = new int[n];
        this.primitiveToIndex = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            indexToPrimitive[i2] = -1;
        }
        int nPrim = 0;
        for (int iLine = 0; iLine < this.vPrimitiveMapping.size(); ++iLine) {
            this.line = (String)this.vPrimitiveMapping.get(iLine);
            if (this.line.indexOf(" NOT IRREDUCIBLE") >= 0) {
                bsInputAtomsIgnore.set(this.parseIntRange(this.line, 21, 25) - 1);
                continue;
            }
            while (this.rd() != null && this.line.indexOf("NUMBER") < 0) {
                int iAtom;
                if (this.line.length() < 2 || this.line.indexOf("ATOM") >= 0 || indexToPrimitive[iAtom = this.parseIntRange(this.line, 4, 8) - 1] >= 0) continue;
                indexToPrimitive[iAtom] = nPrim++;
            }
        }
        if (bsInputAtomsIgnore.nextSetBit(0) >= 0) {
            i = n;
            while (--i >= 0) {
                if (!bsInputAtomsIgnore.get(i)) continue;
                this.vCoords.remove(i);
            }
        }
        this.ac = this.vCoords.size();
        Logger.info(nPrim + " primitive atoms and " + this.ac + " conventionalAtoms");
        this.primitiveToIndex = new int[nPrim];
        for (i = 0; i < nPrim; ++i) {
            this.primitiveToIndex[i] = -1;
        }
        i = this.ac;
        while (--i >= 0) {
            int iPrim = indexToPrimitive[this.parseIntStr(((String)this.vCoords.get(i)).substring(0, 4)) - 1];
            if (iPrim < 0) continue;
            this.primitiveToIndex[iPrim] = i;
        }
        this.vPrimitiveMapping = null;
        return true;
    }

    private boolean readAtoms() throws Exception {
        if (this.isMolecular) {
            this.newAtomSet();
        }
        this.vCoords = null;
        while (this.rd() != null && this.line.indexOf("*") < 0) {
            if (this.line.indexOf("X(ANGSTROM") < 0) continue;
            this.setFractionalCoordinates(false);
            this.isMolecular = true;
        }
        int i = this.atomIndexLast;
        boolean doNormalizePrimitive = false;
        this.atomIndexLast = this.asc.ac;
        while (this.rd() != null && this.line.length() > 0 && this.line.indexOf(this.isPrimitive ? "*" : "=") < 0) {
            Atom atom = this.asc.addNewAtom();
            String[] tokens = this.getTokens();
            int pt = this.isProperties ? 1 : 2;
            atom.elementSymbol = CrystalReader.getElementSymbol(this.getAtomicNumber(tokens[pt++]));
            atom.atomName = CrystalReader.fixAtomName(tokens[pt++]);
            if (this.isProperties) {
                // empty if block
            }
            int n = ++pt;
            float x = this.parseFloatStr(tokens[n]);
            int n2 = ++pt;
            float y = this.parseFloatStr(tokens[n2]);
            float z = this.parseFloatStr(tokens[++pt]);
            if (this.haveCharges) {
                atom.partialCharge = this.asc.atoms[i++].partialCharge;
            }
            if (this.iHaveFractionalCoordinates && !this.isProperties) {
                if (x < 0.0f && (this.isPolymer || this.isSlab || doNormalizePrimitive)) {
                    x += 1.0f;
                }
                if (y < 0.0f && (this.isSlab || doNormalizePrimitive)) {
                    y += 1.0f;
                }
                if (z < 0.0f && doNormalizePrimitive) {
                    z += 1.0f;
                }
            }
            this.setAtomCoordXYZ(atom, x, y, z);
        }
        this.ac = this.asc.ac - this.atomIndexLast;
        return true;
    }

    private static String fixAtomName(String s) {
        return s.length() > 1 && PT.isLetter(s.charAt(1)) ? s.substring(0, 1) + Character.toLowerCase(s.charAt(1)) + s.substring(2) : s;
    }

    private int getAtomicNumber(String token) {
        return this.parseIntStr(token) % 100;
    }

    private void readCoordLines() throws Exception {
        this.rd();
        this.rd();
        this.vCoords = new Lst();
        while (this.rd() != null && this.line.length() > 0) {
            this.vCoords.addLast(this.line);
        }
    }

    private void createAtomsFromCoordLines() throws Exception {
        if (this.vCoords == null) {
            return;
        }
        this.ac = this.vCoords.size();
        for (int i = 0; i < this.ac; ++i) {
            int offset;
            int atomicNumber;
            Atom atom = this.asc.addNewAtom();
            String[] tokens = PT.getTokens((String)this.vCoords.get(i));
            atom.atomSerial = this.parseIntStr(tokens[0]);
            if (tokens.length == 7) {
                atomicNumber = this.getAtomicNumber(tokens[2]);
                offset = 2;
            } else {
                atomicNumber = this.getAtomicNumber(tokens[1]);
                offset = 0;
            }
            float x = this.parseFloatStr(tokens[2 + offset]) + this.ptOriginShift.x;
            float y = this.parseFloatStr(tokens[3 + offset]) + this.ptOriginShift.y;
            float z = this.parseFloatStr(tokens[4 + offset]) + this.ptOriginShift.z;
            this.setAtomCoordXYZ(atom, x, y, z);
            atom.elementSymbol = CrystalReader.getElementSymbol(atomicNumber);
        }
        this.vCoords = null;
        this.setPrimitiveVolumeAndDensity();
    }

    private void newAtomSet() throws Exception {
        if (this.ac > 0 && this.asc.ac > 0) {
            this.applySymmetryAndSetTrajectory();
            this.asc.newAtomSet();
        }
        if (this.spaceGroupName != null) {
            this.setSpaceGroupName(this.spaceGroupName);
        }
        this.ac = 0;
    }

    private void setEnergy() {
        this.asc.setAtomSetEnergy("" + this.energy, this.energy.floatValue());
        this.asc.setCurrentModelInfo("Energy", this.energy);
        this.asc.setInfo("Energy", this.energy);
        this.asc.setAtomSetName("Energy = " + this.energy + " Hartree");
    }

    private boolean readPartialCharges() throws Exception {
        if (this.haveCharges || this.asc.ac == 0) {
            return true;
        }
        this.haveCharges = true;
        this.readLines(3);
        Atom[] atoms = this.asc.atoms;
        int i0 = this.asc.getLastAtomSetAtomIndex();
        int iPrim = 0;
        while (this.rd() != null && this.line.length() > 3) {
            if (this.line.charAt(3) == ' ') continue;
            int iConv = this.getAtomIndexFromPrimitiveIndex(iPrim);
            if (iConv >= 0) {
                atoms[i0 + iConv].partialCharge = this.parseFloatRange(this.line, 9, 11) - this.parseFloatRange(this.line, 12, 18);
            }
            ++iPrim;
        }
        return true;
    }

    private boolean readTotalAtomicCharges() throws Exception {
        SB data = new SB();
        while (this.rd() != null && this.line.indexOf("T") < 0) {
            data.append(this.line);
        }
        String[] tokens = PT.getTokens(data.toString());
        float[] charges = new float[tokens.length];
        if (this.nuclearCharges == null) {
            this.nuclearCharges = charges;
        }
        if (this.asc.ac == 0) {
            return true;
        }
        Atom[] atoms = this.asc.atoms;
        int i0 = this.asc.getLastAtomSetAtomIndex();
        for (int i = 0; i < charges.length; ++i) {
            int iConv = this.getAtomIndexFromPrimitiveIndex(i);
            if (iConv < 0) continue;
            charges[i] = this.parseFloatStr(tokens[i]);
            atoms[i0 + iConv].partialCharge = this.nuclearCharges[i] - charges[i];
        }
        return true;
    }

    private int getAtomIndexFromPrimitiveIndex(int iPrim) {
        return this.primitiveToIndex == null ? iPrim : this.primitiveToIndex[iPrim];
    }

    private boolean readFreqFragments() throws Exception {
        int numAtomsFrag = this.parseIntRange(this.line, 39, 44);
        if (numAtomsFrag < 0) {
            return true;
        }
        this.atomFrag = new int[numAtomsFrag];
        String Sfrag = "";
        while (this.rd() != null && this.line.indexOf("(") >= 0) {
            Sfrag = Sfrag + this.line;
        }
        Sfrag = PT.rep(Sfrag, "(", " ");
        Sfrag = PT.rep(Sfrag, ")", " ");
        String[] tokens = PT.getTokens(Sfrag);
        int i = 0;
        int pos = 0;
        while (i < numAtomsFrag) {
            this.atomFrag[i] = this.getAtomIndexFromPrimitiveIndex(this.parseIntStr(tokens[pos]) - 1);
            ++i;
            pos += 3;
        }
        Arrays.sort(this.atomFrag);
        return true;
    }

    private boolean readFrequencies() throws Exception {
        int i;
        this.energy = null;
        this.discardLinesUntilContains("MODES");
        boolean haveIntensities = this.line.indexOf("INTENS") >= 0;
        this.rd();
        Lst<String[]> vData = new Lst<String[]>();
        int freqAtomCount = this.ac;
        while (this.rd() != null && this.line.length() > 0) {
            int i0 = this.parseIntRange(this.line, 1, 5);
            int i1 = this.parseIntRange(this.line, 6, 10);
            String irrep = (this.isLongMode ? this.line.substring(48, 51) : this.line.substring(49, 52)).trim();
            String intens = !haveIntensities ? "not available" : (this.isLongMode ? this.line.substring(53, 61) : this.line.substring(59, 69).replace(')', ' ')).trim();
            String irActivity = this.isLongMode ? "A" : this.line.substring(55, 58).trim();
            String ramanActivity = this.isLongMode ? "I" : this.line.substring(71, 73).trim();
            String[] data = new String[]{irrep, intens, irActivity, ramanActivity};
            for (i = i0; i <= i1; ++i) {
                vData.addLast(data);
            }
        }
        this.discardLinesUntilContains(this.isLongMode ? "LO MODES FOR IRREP" : (this.isVersion3 ? "THE CORRESPONDING MODES" : "NORMAL MODES NORMALIZED TO CLASSICAL AMPLITUDES"));
        this.rd();
        int lastAtomCount = -1;
        while (this.rd() != null && this.line.startsWith(" FREQ(CM**-1)")) {
            String[] tokens = PT.getTokens(this.line.substring(15));
            float[] frequencies = new float[tokens.length];
            int frequencyCount = frequencies.length;
            for (int i2 = 0; i2 < frequencyCount; ++i2) {
                frequencies[i2] = this.parseFloatStr(tokens[i2]);
                if (!this.debugging) continue;
                Logger.debug(this.vibrationNumber + i2 + " frequency=" + frequencies[i2]);
            }
            boolean[] ignore = new boolean[frequencyCount];
            int iAtom0 = 0;
            int nData = vData.size();
            for (i = 0; i < frequencyCount; ++i) {
                tokens = (String[])vData.get(this.vibrationNumber % nData);
                boolean bl = ignore[i] = !this.doGetVibration(++this.vibrationNumber) || tokens == null;
                if (ignore[i]) continue;
                this.applySymmetryAndSetTrajectory();
                lastAtomCount = this.cloneLastAtomSet(this.ac, null);
                if (i == 0) {
                    iAtom0 = this.asc.getLastAtomSetAtomIndex();
                }
                this.setFreqValue(frequencies[i], tokens);
            }
            this.rd();
            this.fillFrequencyData(iAtom0, freqAtomCount, lastAtomCount, ignore, false, 14, 10, this.atomFrag, 0);
            this.rd();
        }
        return true;
    }

    private void setFreqValue(float freq, String[] data) {
        String activity = "IR: " + data[2] + ", Ram.: " + data[3];
        this.asc.setAtomSetFrequency(null, activity, "" + freq, null);
        this.asc.setAtomSetModelProperty("IRintensity", data[1] + " km/Mole");
        this.asc.setAtomSetModelProperty("vibrationalSymmetry", data[0]);
        this.asc.setAtomSetModelProperty("IRactivity", data[2]);
        this.asc.setAtomSetModelProperty("Ramanactivity", data[3]);
        this.asc.setAtomSetName((this.isLongMode ? "LO " : "") + data[0] + " " + DF.formatDecimal(freq, 2) + " cm-1 (" + DF.formatDecimal(PT.fVal(data[1]), 0) + " km/Mole), " + activity);
    }

    private boolean readGradient() throws Exception {
        String key = null;
        while (this.line != null) {
            String[] tokens = this.getTokens();
            if (this.line.indexOf("MAX GRAD") >= 0) {
                key = "maxGradient";
            } else if (this.line.indexOf("RMS GRAD") >= 0) {
                key = "rmsGradient";
            } else if (this.line.indexOf("MAX DISP") >= 0) {
                key = "maxDisplacement";
            } else {
                if (this.line.indexOf("RMS DISP") < 0) break;
                key = "rmsDisplacement";
            }
            if (this.asc.ac > 0) {
                this.asc.setAtomSetModelProperty(key, tokens[2]);
            }
            this.rd();
        }
        return true;
    }

    private boolean readData(String name, int nfields) throws Exception {
        this.createAtomsFromCoordLines();
        float[] f = new float[this.ac];
        for (int i = 0; i < this.ac; ++i) {
            f[i] = 0.0f;
        }
        String data = "";
        while (this.rd() != null && (this.line.length() < 4 || PT.isDigit(this.line.charAt(3)))) {
            data = data + this.line;
        }
        data = PT.rep(data, "-", " -");
        String[] tokens = PT.getTokens(data);
        int i = 0;
        int pt = nfields - 1;
        while (i < this.ac) {
            int iConv = this.getAtomIndexFromPrimitiveIndex(i);
            if (iConv >= 0) {
                f[iConv] = this.parseFloatStr(tokens[pt]);
            }
            ++i;
            pt += nfields;
        }
        this.asc.setAtomProperties(name, f, -1, false);
        return true;
    }

    private boolean getQuadrupoleTensors() throws Exception {
        this.readLines(6);
        Atom[] atoms = this.asc.atoms;
        while (this.rd() != null && this.line.startsWith(" *** ATOM")) {
            String[] tokens = this.getTokens();
            int index = this.parseIntStr(tokens[3]) - 1;
            tokens = PT.getTokens(this.readLines(3));
            V3[] vectors = new V3[3];
            for (int i = 0; i < 3; ++i) {
                vectors[i] = V3.newV(this.directLatticeVectors[i]);
                vectors[i].normalize();
            }
            atoms[index].addTensor(new Tensor().setFromEigenVectors(vectors, new float[]{this.parseFloatStr(tokens[1]), this.parseFloatStr(tokens[3]), this.parseFloatStr(tokens[5])}, "quadrupole", atoms[index].atomName, null), null, false);
            this.rd();
        }
        this.appendLoadNote("Ellipsoids set \"quadrupole\": Quadrupole tensors");
        return true;
    }

    private boolean readBornChargeTensors() throws Exception {
        this.createAtomsFromCoordLines();
        this.rd();
        Atom[] atoms = this.asc.atoms;
        while (this.rd().startsWith(" ATOM")) {
            int index = this.parseIntAt(this.line, 5) - 1;
            Atom atom = atoms[index];
            this.readLines(2);
            double[][] a = new double[3][3];
            for (int i = 0; i < 3; ++i) {
                String[] tokens = PT.getTokens(this.rd());
                for (int j = 0; j < 3; ++j) {
                    a[i][j] = this.parseFloatStr(tokens[j + 1]);
                }
            }
            atom.addTensor(new Tensor().setFromAsymmetricTensor(a, "charge", atom.elementSymbol + (index + 1)), null, false);
            this.rd();
        }
        this.appendLoadNote("Ellipsoids set \"charge\": Born charge tensors");
        return false;
    }
}

