/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.kernel;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.kernel.TruffleKernelNodes;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=TruffleKernelNodes.class)
public final class TruffleKernelNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AtExitSystemNodeFactory.getInstance(), LoadNodeFactory.getInstance());
    }

    @GeneratedBy(value=TruffleKernelNodes.LoadNode.class)
    public static final class LoadNodeFactory
    extends NodeFactoryBase<TruffleKernelNodes.LoadNode> {
        private static LoadNodeFactory loadNodeFactoryInstance;

        private LoadNodeFactory() {
            super(TruffleKernelNodes.LoadNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        @Override
        public TruffleKernelNodes.LoadNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return LoadNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleKernelNodes.LoadNode> getInstance() {
            if (loadNodeFactoryInstance == null) {
                loadNodeFactoryInstance = new LoadNodeFactory();
            }
            return loadNodeFactoryInstance;
        }

        public static TruffleKernelNodes.LoadNode create(RubyNode file, RubyNode wrap) {
            return new LoadNodeGen(file, wrap);
        }

        @GeneratedBy(value=TruffleKernelNodes.LoadNode.class)
        public static final class LoadNodeGen
        extends TruffleKernelNodes.LoadNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode file_;
            @Node.Child
            private RubyNode wrap_;
            @CompilerDirectives.CompilationFinal
            private Class<?> wrapType_;
            @Node.Child
            private BaseNode_ specialization_;

            private LoadNodeGen(RubyNode file, RubyNode wrap) {
                this.file_ = file;
                this.wrap_ = this.coerceToBoolean(wrap);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="load(VirtualFrame, DynamicObject, boolean, IndirectCallNode, BranchProfile)", value=TruffleKernelNodes.LoadNode.class)
            private static final class LoadNode_
            extends BaseNode_ {
                @Node.Child
                private IndirectCallNode callNode;
                private final BranchProfile errorProfile;

                LoadNode_(LoadNodeGen root, IndirectCallNode callNode, BranchProfile errorProfile) {
                    super(root, 1);
                    this.callNode = callNode;
                    this.errorProfile = errorProfile;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean(frameValue);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    boolean wrapValue_;
                    DynamicObject fileValue_;
                    try {
                        fileValue_ = this.root.file_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object wrapValue = this.executeWrap_(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), wrapValue);
                    }
                    try {
                        wrapValue_ = this.root.wrap_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, fileValue_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(fileValue_)) {
                        return this.root.load(frameValue, fileValue_, wrapValue_, this.callNode, this.errorProfile);
                    }
                    return this.getNext().executeBoolean_(frameValue, fileValue_, wrapValue_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object fileValue, Object wrapValue) {
                    if (fileValue instanceof DynamicObject && wrapValue instanceof Boolean) {
                        DynamicObject fileValue_ = (DynamicObject)fileValue;
                        boolean wrapValue_ = (Boolean)wrapValue;
                        if (RubyGuards.isRubyString(fileValue_)) {
                            return this.root.load(frameValue, fileValue_, wrapValue_, this.callNode, this.errorProfile);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, fileValue, wrapValue);
                }

                static BaseNode_ create(LoadNodeGen root, IndirectCallNode callNode, BranchProfile errorProfile) {
                    return new LoadNode_(root, callNode, errorProfile);
                }
            }

            @GeneratedBy(value=TruffleKernelNodes.LoadNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LoadNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object fileValue, Object wrapValue) {
                    return (Boolean)this.uninitialized((Frame)frameValue, fileValue, wrapValue);
                }

                static BaseNode_ create(LoadNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=TruffleKernelNodes.LoadNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LoadNodeGen root;

                BaseNode_(LoadNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (LoadNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.file_, this.root.wrap_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object fileValue, Object wrapValue) {
                    return this.executeBoolean_((VirtualFrame)frameValue, fileValue, wrapValue);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object fileValue_ = this.root.file_.execute(frameValue);
                    Object wrapValue_ = this.executeWrap_(frameValue);
                    return this.executeBoolean_(frameValue, fileValue_, wrapValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object fileValue, Object wrapValue) {
                    DynamicObject fileValue_;
                    if (fileValue instanceof DynamicObject && wrapValue instanceof Boolean && RubyGuards.isRubyString(fileValue_ = (DynamicObject)fileValue)) {
                        IndirectCallNode callNode1 = IndirectCallNode.create();
                        BranchProfile errorProfile1 = BranchProfile.create();
                        return LoadNode_.create(this.root, callNode1, errorProfile1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeWrap_(Frame frameValue) {
                    Object object;
                    Class wrapType_ = this.root.wrapType_;
                    if (wrapType_ == Boolean.TYPE) {
                        return this.root.wrap_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (wrapType_ != null) return this.root.wrap_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.wrap_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.wrapType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.wrapType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.wrapType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=TruffleKernelNodes.AtExitSystemNode.class)
    public static final class AtExitSystemNodeFactory
    extends NodeFactoryBase<TruffleKernelNodes.AtExitSystemNode> {
        private static AtExitSystemNodeFactory atExitSystemNodeFactoryInstance;

        private AtExitSystemNodeFactory() {
            super(TruffleKernelNodes.AtExitSystemNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public TruffleKernelNodes.AtExitSystemNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AtExitSystemNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleKernelNodes.AtExitSystemNode> getInstance() {
            if (atExitSystemNodeFactoryInstance == null) {
                atExitSystemNodeFactoryInstance = new AtExitSystemNodeFactory();
            }
            return atExitSystemNodeFactoryInstance;
        }

        public static TruffleKernelNodes.AtExitSystemNode create(RubyNode[] arguments) {
            return new AtExitSystemNodeGen(arguments);
        }

        @GeneratedBy(value=TruffleKernelNodes.AtExitSystemNode.class)
        public static final class AtExitSystemNodeGen
        extends TruffleKernelNodes.AtExitSystemNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AtExitSystemNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                boolean arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.atExit(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }
}

