/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.backtrace.Activation;
import org.jruby.truffle.language.backtrace.Backtrace;
import org.jruby.truffle.language.backtrace.InternalRootNode;
import org.jruby.truffle.language.exceptions.DisablingBacktracesNode;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.util.Memo;

public class CallStackManager {
    private final RubyContext context;

    public CallStackManager(RubyContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public FrameInstance getCallerFrameIgnoringSend() {
        final Memo firstFrame = new Memo((Object)true);
        FrameInstance fi = Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<FrameInstance>(){

            @Override
            public FrameInstance visitFrame(FrameInstance frameInstance) {
                if (((Boolean)firstFrame.get()).booleanValue()) {
                    firstFrame.set((Object)false);
                    return null;
                }
                InternalMethod method = CallStackManager.this.getMethod(frameInstance);
                assert (method != null);
                if (!CallStackManager.this.context.getCoreLibrary().isSend(method)) {
                    return frameInstance;
                }
                return null;
            }
        });
        return fi;
    }

    @CompilerDirectives.TruffleBoundary
    public InternalMethod getCallingMethodIgnoringSend() {
        return this.getMethod(this.getCallerFrameIgnoringSend());
    }

    @CompilerDirectives.TruffleBoundary
    public Node getTopMostUserCallNode() {
        final Memo firstFrame = new Memo((Object)true);
        return Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<Node>(){

            @Override
            public Node visitFrame(FrameInstance frameInstance) {
                if (((Boolean)firstFrame.get()).booleanValue()) {
                    firstFrame.set((Object)false);
                    return null;
                }
                SourceSection sourceSection = frameInstance.getCallNode().getEncapsulatingSourceSection();
                if (sourceSection.getSource() == null) {
                    return null;
                }
                return frameInstance.getCallNode();
            }
        });
    }

    private InternalMethod getMethod(FrameInstance frame) {
        return RubyArguments.getMethod(frame.getFrame(FrameInstance.FrameAccess.READ_ONLY, true));
    }

    public Backtrace getBacktrace(Node currentNode, Throwable javaThrowable) {
        return this.getBacktrace(currentNode, 0, false, null, javaThrowable);
    }

    public Backtrace getBacktrace(Node currentNode) {
        return this.getBacktrace(currentNode, 0, false, null, null);
    }

    public Backtrace getBacktrace(Node currentNode, int omit) {
        return this.getBacktrace(currentNode, omit, false, null, null);
    }

    public Backtrace getBacktrace(Node currentNode, int omit, DynamicObject exception) {
        return this.getBacktrace(currentNode, omit, false, exception, null);
    }

    public Backtrace getBacktrace(Node currentNode, int omit, boolean filterNullSourceSection, DynamicObject exception) {
        return this.getBacktrace(currentNode, omit, filterNullSourceSection, exception, null);
    }

    @CompilerDirectives.TruffleBoundary
    public Backtrace getBacktrace(Node currentNode, final int omit, final boolean filterNullSourceSection, DynamicObject exception, Throwable javaThrowable) {
        if (exception != null && this.context.getOptions().BACKTRACES_OMIT_UNUSED && DisablingBacktracesNode.areBacktracesDisabled() && ModuleOperations.assignableTo(Layouts.BASIC_OBJECT.getLogicalClass(exception), this.context.getCoreLibrary().getStandardErrorClass())) {
            return new Backtrace(new Activation[]{Activation.OMITTED_UNUSED}, null);
        }
        final int limit = this.context.getOptions().BACKTRACES_LIMIT;
        final ArrayList<Activation> activations = new ArrayList<Activation>();
        if (omit == 0 && currentNode != null && Truffle.getRuntime().getCurrentFrame() != null) {
            InternalMethod method = RubyArguments.tryGetMethod(Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, true));
            activations.add(new Activation(currentNode, method));
        }
        final Memo firstFrame = new Memo((Object)true);
        Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<Object>(){
            int depth = 1;

            @Override
            public Object visitFrame(FrameInstance frameInstance) {
                if (((Boolean)firstFrame.get()).booleanValue()) {
                    firstFrame.set((Object)false);
                    return null;
                }
                if (this.depth > limit) {
                    activations.add(Activation.OMITTED_LIMIT);
                    return new Object();
                }
                if (!CallStackManager.this.ignoreFrame(frameInstance) && this.depth >= omit && (!filterNullSourceSection || frameInstance.getCallNode().getEncapsulatingSourceSection() != null && frameInstance.getCallNode().getEncapsulatingSourceSection().getSource() != null)) {
                    InternalMethod method = RubyArguments.getMethod(frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY, true));
                    activations.add(new Activation(frameInstance.getCallNode(), method));
                }
                ++this.depth;
                return null;
            }
        });
        if (!activations.isEmpty()) {
            activations.remove(activations.size() - 1);
        }
        if (this.context.getOptions().EXCEPTIONS_STORE_JAVA || this.context.getOptions().BACKTRACES_INTERLEAVE_JAVA) {
            if (javaThrowable == null) {
                javaThrowable = new Exception();
            }
        } else {
            javaThrowable = null;
        }
        return new Backtrace(activations.toArray(new Activation[activations.size()]), javaThrowable);
    }

    private boolean ignoreFrame(FrameInstance frameInstance) {
        Node callNode = frameInstance.getCallNode();
        if (callNode == null) {
            return true;
        }
        SourceSection sourceSection = callNode.getEncapsulatingSourceSection();
        if (sourceSection != null && sourceSection.getShortDescription().endsWith("#run_jruby_root")) {
            return true;
        }
        if (callNode.getRootNode() instanceof InternalRootNode) {
            return true;
        }
        return callNode.getEncapsulatingSourceSection() == null;
    }
}

