/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.contrib.DragNDropTool;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.DragTracker;
import CH.ifa.draw.standard.HandleTracker;
import CH.ifa.draw.standard.SelectAreaTracker;
import CH.ifa.draw.util.UndoableHandle;
import CH.ifa.draw.util.UndoableTool;
import java.awt.event.MouseEvent;

public class SelectionTool
extends AbstractTool {
    private Tool fChild = null;

    public SelectionTool(DrawingEditor newDrawingEditor) {
        super(newDrawingEditor);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        if (this.fChild != null) {
            return;
        }
        this.view().freezeView();
        Handle handle = this.view().findHandle(e.getX(), e.getY());
        if (handle != null) {
            this.fChild = this.createHandleTracker(this.view(), handle);
        } else {
            Figure figure = this.drawing().findFigure(e.getX(), e.getY());
            if (figure != null) {
                this.fChild = this.createDragTracker(figure);
            } else {
                if (!e.isShiftDown()) {
                    this.view().clearSelection();
                }
                this.fChild = this.createAreaTracker();
            }
        }
        this.fChild.mouseDown(e, x, y);
        this.fChild.activate();
    }

    public void mouseMove(MouseEvent evt, int x, int y) {
        DragNDropTool.setCursor(evt.getX(), evt.getY(), this.view());
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this.fChild != null) {
            this.fChild.mouseDrag(e, x, y);
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        this.view().unfreezeView();
        if (this.fChild != null) {
            this.fChild.mouseUp(e, x, y);
            this.fChild.deactivate();
            this.fChild = null;
        }
    }

    protected Tool createHandleTracker(DrawingView view, Handle handle) {
        return new HandleTracker(this.editor(), new UndoableHandle(handle, view));
    }

    protected Tool createDragTracker(Figure f) {
        return new UndoableTool(new DragTracker(this.editor(), f));
    }

    protected Tool createAreaTracker() {
        return new SelectAreaTracker(this.editor());
    }
}

