/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.DefinitionWriter;
import com.ibm.xmi.framework.Enum;
import com.ibm.xmi.framework.PrintXML;
import com.ibm.xmi.framework.WriterFactory;
import java.util.Iterator;
import java.util.Vector;

class PackageWriter
extends DefinitionWriter {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String ELEMENT_PROPERTIES = "%XMI.element.att;";
    private static final String LINK_PROPERTIES = "%XMI.link.att;";
    private static final String XMI_EXTENSION = "XMI.extension";

    public PackageWriter(Object object) {
        super(object);
    }

    protected String getContent() {
        Object object = this.getDefinition();
        Iterator iterator = this.wrapper.getContents(object).iterator();
        String string = "";
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.isEnumeration(e)) continue;
            string = string.equals("") ? this.stripNamespace(this.wrapper.getFullName(e, 500)) : string + " | " + this.stripNamespace(this.wrapper.getFullName(e, 500));
        }
        string = string.equals("") ? "(XMI.extension)*" : "(" + string + " | XMI.extension)*";
        return string;
    }

    protected boolean isEnumeration(Object object) {
        return object instanceof Enum;
    }

    public void write(int n, int n2) throws Exception {
        Object object;
        super.write(n, n2);
        Object object2 = this.getDefinition();
        PrintXML.printComment("PACKAGE: " + this.stripNamespace(this.wrapper.getXMIName(object2)), true);
        PrintXML.printBlankLine();
        Iterator iterator = this.wrapper.getContents(object2).iterator();
        while (iterator.hasNext()) {
            object = WriterFactory.makeDeclWriter(iterator.next(), this.getDTD().getXMIVersion(), "DTD");
            ((DefinitionWriter)object).setDTD(this.getDTD());
            ((DefinitionWriter)object).setWrapper(this.wrapper);
            ((DefinitionWriter)object).write(n, n2);
        }
        PrintXML.printBlankLine();
        object = this.getContent();
        Vector<String> vector = new Vector<String>(2);
        vector.addElement(ELEMENT_PROPERTIES);
        vector.addElement(LINK_PROPERTIES);
        if (this.getDTD().getXMIVersion().equals("1.0")) {
            PrintXML.printElementDecl(this.stripNamespace(this.wrapper.getFullName(object2, 500)), (String)object, null, vector, n, n2);
        } else {
            PrintXML.printElementDecl(this.wrapper.getXMIName(object2), (String)object, null, vector, n, n2);
        }
    }
}

