/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Stack;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveEntry;

class ClientVector
extends Stack<KeepAliveEntry> {
    private static final long serialVersionUID = -8680532108106489459L;
    int nap;

    ClientVector(int nap) {
        this.nap = nap;
    }

    synchronized HttpClient get() {
        if (this.empty()) {
            return null;
        }
        HttpClient hc = null;
        long currentTime = System.currentTimeMillis();
        do {
            KeepAliveEntry e = (KeepAliveEntry)this.pop();
            if (currentTime - e.idleStartTime > (long)this.nap) {
                e.hc.closeServer();
                continue;
            }
            hc = e.hc;
        } while (hc == null && !this.empty());
        return hc;
    }

    synchronized void put(HttpClient h) {
        if (this.size() >= KeepAliveCache.getMaxConnections()) {
            h.closeServer();
        } else {
            this.push(new KeepAliveEntry(h, System.currentTimeMillis()));
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }
}

