/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style;

import java.util.Arrays;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.StyleRule;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.input.style.parser.StyleSheetParserUtil;
import org.jfree.layouting.input.style.values.CSSValue;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public abstract class CSSDeclarationRule
extends StyleRule {
    private CSSValue[] styleValues;
    private boolean[] importantValues;
    private StyleSheetParserUtil styleSheetParserUtil;

    protected CSSDeclarationRule(StyleSheet styleSheet, StyleRule styleRule) {
        super(styleSheet, styleRule);
    }

    public boolean isImportant(StyleKey styleKey) {
        if (styleKey == null) {
            throw new NullPointerException();
        }
        if (this.importantValues == null) {
            return false;
        }
        return this.importantValues[styleKey.index];
    }

    public void setImportant(StyleKey styleKey, boolean bl) {
        if (styleKey == null) {
            throw new NullPointerException();
        }
        if (this.importantValues == null) {
            StyleKeyRegistry styleKeyRegistry = this.getStyleKeyRegistry();
            this.importantValues = new boolean[styleKeyRegistry.getKeyCount()];
        }
        this.importantValues[styleKey.index] = bl;
    }

    public CSSValue getPropertyCSSValue(StyleKey styleKey) {
        if (styleKey == null) {
            throw new NullPointerException();
        }
        if (this.styleValues == null) {
            return null;
        }
        return this.styleValues[styleKey.index];
    }

    public void setPropertyValueAsString(String string, String string2) {
        Object object;
        CSSStyleRule cSSStyleRule;
        StyleSheet styleSheet;
        StyleSheet styleSheet2 = this.getParentStyle();
        ResourceKey resourceKey = styleSheet2 == null ? null : styleSheet2.getSource();
        if (this.styleSheetParserUtil == null) {
            this.styleSheetParserUtil = new StyleSheetParserUtil();
        }
        if ((styleSheet = this.getParentStyle()) != null) {
            cSSStyleRule = this.styleSheetParserUtil.parseStyles(styleSheet.getNamespaces(), string, string2, styleSheet.getResourceManager(), resourceKey, this);
        } else {
            object = new ResourceManager();
            object.registerDefaults();
            cSSStyleRule = this.styleSheetParserUtil.parseStyles(null, string, string2, (ResourceManager)object, resourceKey, this);
        }
        if (cSSStyleRule != null) {
            if (cSSStyleRule.isEmpty()) {
                return;
            }
            object = cSSStyleRule.getImportantValues();
            CSSValue[] cSSValueArray = cSSStyleRule.getStyleValues();
            StyleKey[] styleKeyArray = cSSStyleRule.getPropertyKeysAsArray();
            for (int i = 0; i < cSSValueArray.length; ++i) {
                CSSValue cSSValue = cSSValueArray[i];
                if (cSSValue == null) continue;
                this.setPropertyValue(styleKeyArray[i], cSSValue, (boolean)object[i]);
            }
        }
    }

    public void setPropertyValueAsString(StyleKey styleKey, String string) {
        this.setPropertyValueAsString(styleKey.getName(), string);
    }

    public void setPropertyValue(StyleKey styleKey, CSSValue cSSValue) {
        this.setPropertyValue(styleKey, cSSValue, false);
    }

    public void setPropertyValue(StyleKey styleKey, CSSValue cSSValue, boolean bl) {
        if (this.styleValues == null) {
            StyleKeyRegistry styleKeyRegistry = this.getStyleKeyRegistry();
            this.styleValues = new CSSValue[styleKeyRegistry.getKeyCount()];
        }
        this.styleValues[styleKey.index] = cSSValue;
        this.setImportant(styleKey, bl);
    }

    public void removeProperty(StyleKey styleKey) {
        if (this.styleValues == null) {
            return;
        }
        this.setPropertyValue(styleKey, null);
    }

    public void clear() {
        if (this.styleValues != null) {
            Arrays.fill(this.styleValues, null);
        }
        if (this.importantValues != null) {
            Arrays.fill(this.importantValues, false);
        }
    }

    public StyleKey[] getPropertyKeysAsArray() {
        return this.getStyleKeyRegistry().getKeys();
    }

    public CSSValue[] getStyleValues() {
        if (this.styleValues == null) {
            StyleKeyRegistry styleKeyRegistry = this.getStyleKeyRegistry();
            this.styleValues = new CSSValue[styleKeyRegistry.getKeyCount()];
        }
        return (CSSValue[])this.styleValues.clone();
    }

    public boolean[] getImportantValues() {
        if (this.importantValues == null) {
            this.importantValues = new boolean[this.getStyleKeyRegistry().getKeyCount()];
        }
        return (boolean[])this.importantValues.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        CSSDeclarationRule cSSDeclarationRule = (CSSDeclarationRule)super.clone();
        if (this.importantValues != null) {
            cSSDeclarationRule.importantValues = (boolean[])this.importantValues.clone();
        }
        if (this.styleValues != null) {
            cSSDeclarationRule.styleValues = (CSSValue[])this.styleValues.clone();
        }
        return cSSDeclarationRule;
    }

    public boolean isEmpty() {
        return this.importantValues == null && this.styleValues == null;
    }
}

