/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

import java.util.ArrayList;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class OfficeUtil
implements OfficeConstants {
    public static Node[] parseText(String text, Document parentDoc) {
        ArrayList<Node> nodeVec = new ArrayList<Node>();
        while (text.indexOf("  ") != -1 || text.indexOf(9) != 1) {
            int nrSpaces;
            int closerIndex;
            int spaceIndex = text.indexOf("  ");
            int tabIndex = text.indexOf(9);
            if (spaceIndex == -1 && tabIndex == -1) break;
            if (spaceIndex == -1) {
                closerIndex = tabIndex;
            } else if (tabIndex == -1) {
                closerIndex = spaceIndex;
            } else {
                int n = closerIndex = spaceIndex > tabIndex ? tabIndex : spaceIndex;
            }
            if (closerIndex > 0) {
                String beginningText = text.substring(0, closerIndex);
                Text textNode = parentDoc.createTextNode(beginningText);
                nodeVec.add(textNode);
            }
            text = text.substring(closerIndex);
            if (closerIndex == tabIndex) {
                Element tabNode = parentDoc.createElement("text:tab-stop");
                nodeVec.add(tabNode);
                text = text.substring(1);
                continue;
            }
            for (nrSpaces = 2; nrSpaces < text.length() && text.substring(nrSpaces, nrSpaces + 1).equals(" "); ++nrSpaces) {
            }
            Element spaceNode = parentDoc.createElement("text:s");
            spaceNode.setAttribute("text:c", Integer.toString(nrSpaces));
            nodeVec.add(spaceNode);
            text = text.substring(nrSpaces);
        }
        if (text.length() > 0) {
            Text textNode = parentDoc.createTextNode(text);
            nodeVec.add(textNode);
        }
        Node[] nodes = nodeVec.toArray(new Node[nodeVec.size()]);
        return nodes;
    }
}

