/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items;
    ExpandItem lastFocus;
    int itemCount;
    int spacing;
    int yCurrentScroll;

    public ExpandBar(Composite composite, int n) {
        super(composite, n);
    }

    public void addExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(expandListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if (point.x == 0 && n == -1) {
            point.x = 64;
        }
        if (point.y == 0 && n2 == -1) {
            point.y = 64;
        }
        int n3 = OS.gtk_container_get_border_width(this.handle);
        point.x += 2 * n3;
        point.y += 2 * n3;
        return point;
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        this.handle = this.gtk_box_new(1, false, 0);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x200) != 0) {
            this.scrolledHandle = OS.gtk_scrolled_window_new(0, 0);
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
            OS.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, 1);
            OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            if (OS.GTK_VERSION < OS.VERSION(3, 8, 0)) {
                OS.gtk_scrolled_window_add_with_viewport(this.scrolledHandle, this.handle);
            } else {
                OS.gtk_container_add(this.scrolledHandle, this.handle);
            }
            int n2 = OS.gtk_bin_get_child(this.scrolledHandle);
            OS.gtk_viewport_set_shadow_type(n2, 0);
        } else {
            OS.gtk_container_add(this.fixedHandle, this.handle);
        }
        OS.gtk_container_set_border_width(this.handle, 0);
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    void createItem(ExpandItem expandItem, int n, int n2) {
        if (0 > n2 || n2 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ExpandItem[] expandItemArray = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, expandItemArray, 0, this.items.length);
            this.items = expandItemArray;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount - n2);
        this.items[n2] = expandItem;
        ++this.itemCount;
        expandItem.width = Math.max(0, this.getClientArea().width - this.spacing * 2);
        this.layoutItems(n2, true);
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.items = new ExpandItem[4];
    }

    void destroyItem(ExpandItem expandItem) {
        int n;
        for (n = 0; n < this.itemCount && this.items[n] != expandItem; ++n) {
        }
        if (n == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        expandItem.redraw();
        this.layoutItems(n, true);
    }

    @Override
    int eventHandle() {
        return this.fixedHandle;
    }

    @Override
    boolean forceFocus(int n) {
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem expandItem = this.items[i];
            if (!expandItem.setFocus()) continue;
            return true;
        }
        return super.forceFocus(n);
    }

    @Override
    boolean hasFocus() {
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem expandItem = this.items[i];
            if (!expandItem.hasFocus()) continue;
            return true;
        }
        return super.hasFocus();
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (this.scrolledHandle != 0) {
            OS.g_signal_connect_closure(this.scrolledHandle, OS.size_allocate, this.display.getClosure(47), true);
        }
    }

    int getBandHeight() {
        if (this.font == null) {
            return 24;
        }
        GC gC = new GC(this);
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        return Math.max(24, fontMetrics.getHeight());
    }

    public ExpandItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] expandItemArray = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, expandItemArray, 0, this.itemCount);
        return expandItemArray;
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    @Override
    int gtk_key_press_event(int n, int n2) {
        int n3;
        int n4;
        if (!this.hasFocus()) {
            return 0;
        }
        int n5 = super.gtk_key_press_event(n, n2);
        if (n5 != 0) {
            return n5;
        }
        for (n4 = 0; n4 < this.itemCount && !this.items[n4].hasFocus(); ++n4) {
        }
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
        boolean bl = false;
        switch (gdkEventKey.keyval) {
            case 65361: 
            case 65362: {
                bl = false;
                break;
            }
            case 65363: 
            case 65364: {
                bl = true;
                break;
            }
            default: {
                return n5;
            }
        }
        int n6 = n4;
        int n7 = n3 = bl ? 1 : -1;
        while ((n4 = (n4 + n3 + this.itemCount) % this.itemCount) != n6) {
            ExpandItem expandItem = this.items[n4];
            if (!expandItem.setFocus()) continue;
            return n5;
        }
        return n5;
    }

    public int indexOf(ExpandItem expandItem) {
        this.checkWidget();
        if (expandItem == null) {
            this.error(4);
        }
        for (int i = 0; i < this.itemCount; ++i) {
            if (this.items[i] != expandItem) continue;
            return i;
        }
        return -1;
    }

    void layoutItems(int n, boolean bl) {
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem expandItem = this.items[i];
            if (expandItem == null) continue;
            expandItem.resizeControl(this.yCurrentScroll);
        }
    }

    @Override
    int gtk_size_allocate(int n, int n2) {
        int n3 = super.gtk_size_allocate(n, n2);
        this.layoutItems(0, false);
        return n3;
    }

    @Override
    int parentingHandle() {
        return this.fixedHandle;
    }

    @Override
    void releaseChildren(boolean bl) {
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem expandItem = this.items[i];
            if (expandItem == null || expandItem.isDisposed()) continue;
            expandItem.release(false);
        }
        super.releaseChildren(bl);
    }

    public void removeExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, expandListener);
        this.eventTable.unhook(18, expandListener);
    }

    @Override
    void reskinChildren(int n) {
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                ExpandItem expandItem = this.items[i];
                if (expandItem == null) continue;
                expandItem.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    @Override
    void setFontDescription(int n) {
        super.setFontDescription(n);
        for (int i = 0; i < this.itemCount; ++i) {
            this.items[i].setFontDescription(n);
        }
        this.layoutItems(0, true);
    }

    @Override
    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        for (int i = 0; i < this.itemCount; ++i) {
            this.items[i].setForegroundColor(gdkColor);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                this.items[i].setOrientation(bl);
            }
        }
    }

    void setScrollbar() {
        Object object;
        int n;
        if (this.itemCount == 0) {
            return;
        }
        if ((this.style & 0x200) == 0) {
            return;
        }
        int n2 = this.getClientArea().height;
        ExpandItem expandItem = this.items[this.itemCount - 1];
        int n3 = expandItem.y + this.getBandHeight() + this.spacing;
        if (expandItem.expanded) {
            n3 += expandItem.height;
        }
        int n4 = OS.gtk_scrolled_window_get_vadjustment(this.scrolledHandle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(n4, gtkAdjustment);
        this.yCurrentScroll = (int)gtkAdjustment.value;
        if (this.yCurrentScroll > 0 && n2 > n3) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + n3 - n2);
            this.layoutItems(0, false);
        }
        gtkAdjustment.value = Math.min(this.yCurrentScroll, n3 += this.yCurrentScroll);
        gtkAdjustment.upper = n3;
        gtkAdjustment.page_size = n2;
        OS.gtk_adjustment_configure(n4, gtkAdjustment.value, gtkAdjustment.lower, gtkAdjustment.upper, gtkAdjustment.step_increment, gtkAdjustment.page_increment, gtkAdjustment.page_size);
        int n5 = n3 > n2 ? 0 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, n5);
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.fixedHandle, gtkAllocation);
        int n6 = gtkAllocation.width - this.spacing * 2;
        if (n5 == 0) {
            n = 0;
            n = OS.gtk_scrolled_window_get_vscrollbar(this.scrolledHandle);
            object = new GtkRequisition();
            this.gtk_widget_get_preferred_size(n, (GtkRequisition)object);
            n6 -= ((GtkRequisition)object).width;
        }
        n6 = Math.max(0, n6);
        for (n = 0; n < this.itemCount; ++n) {
            object = this.items[n];
            ((ExpandItem)object).setBounds(0, 0, n6, ((ExpandItem)object).height, false, true);
        }
    }

    public void setSpacing(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n == this.spacing) {
            return;
        }
        this.spacing = n;
        OS.gtk_box_set_spacing(this.handle, n);
        OS.gtk_container_set_border_width(this.handle, n);
    }

    void showItem(ExpandItem expandItem) {
        Control control = expandItem.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(expandItem.expanded);
        }
        expandItem.redraw();
        int n = this.indexOf(expandItem);
        this.layoutItems(n + 1, true);
    }

    @Override
    void updateScrollBarValue(ScrollBar scrollBar) {
        this.yCurrentScroll = scrollBar.getSelection();
        this.layoutItems(0, false);
    }
}

