/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.cumulativesum;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorStreams;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class CumulativeSumPipelineAggregator
extends PipelineAggregator {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("cumulative_sum");
    public static final PipelineAggregatorStreams.Stream STREAM = new PipelineAggregatorStreams.Stream(){

        @Override
        public CumulativeSumPipelineAggregator readResult(StreamInput in) throws IOException {
            CumulativeSumPipelineAggregator result = new CumulativeSumPipelineAggregator();
            result.readFrom(in);
            return result;
        }
    };
    private ValueFormatter formatter;

    public static void registerStreams() {
        PipelineAggregatorStreams.registerStream(STREAM, TYPE.stream());
    }

    public CumulativeSumPipelineAggregator() {
    }

    public CumulativeSumPipelineAggregator(String name, String[] bucketsPaths, ValueFormatter formatter, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.formatter = formatter;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalHistogram histo = (InternalHistogram)aggregation;
        List buckets = histo.getBuckets();
        InternalHistogram.Factory factory = histo.getFactory();
        ArrayList newBuckets = new ArrayList();
        double sum = 0.0;
        for (InternalHistogram.Bucket bucket : buckets) {
            Double thisBucketValue = BucketHelpers.resolveBucketValue(histo, (MultiBucketsAggregation.Bucket)bucket, this.bucketsPaths()[0], BucketHelpers.GapPolicy.INSERT_ZEROS);
            ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>(CollectionUtils.eagerTransform(bucket.getAggregations().asList(), AGGREGATION_TRANFORM_FUNCTION));
            aggs.add(new InternalSimpleValue(this.name(), sum += thisBucketValue.doubleValue(), this.formatter, new ArrayList<PipelineAggregator>(), this.metaData()));
            Object newBucket = factory.createBucket(bucket.getKey(), bucket.getDocCount(), new InternalAggregations(aggs), bucket.getKeyed(), bucket.getFormatter());
            newBuckets.add(newBucket);
        }
        return factory.create(newBuckets, histo);
    }

    @Override
    public void doReadFrom(StreamInput in) throws IOException {
        this.formatter = ValueFormatterStreams.readOptional(in);
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        ValueFormatterStreams.writeOptional(this.formatter, out);
    }

    public static class Factory
    extends PipelineAggregatorFactory {
        private final ValueFormatter formatter;

        public Factory(String name, String[] bucketsPaths, ValueFormatter formatter) {
            super(name, TYPE.name(), bucketsPaths);
            this.formatter = formatter;
        }

        @Override
        protected PipelineAggregator createInternal(Map<String, Object> metaData) throws IOException {
            return new CumulativeSumPipelineAggregator(this.name, this.bucketsPaths, this.formatter, metaData);
        }

        @Override
        public void doValidate(AggregatorFactory parent, AggregatorFactory[] aggFactories, List<PipelineAggregatorFactory> pipelineAggregatorFactories) {
            if (this.bucketsPaths.length != 1) {
                throw new IllegalStateException(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + " must contain a single entry for aggregation [" + this.name + "]");
            }
            if (!(parent instanceof HistogramAggregator.Factory)) {
                throw new IllegalStateException("cumulative sum aggregation [" + this.name + "] must have a histogram or date_histogram as parent");
            }
            HistogramAggregator.Factory histoParent = (HistogramAggregator.Factory)parent;
            if (histoParent.minDocCount() != 0L) {
                throw new IllegalStateException("parent histogram of cumulative sum aggregation [" + this.name + "] must have min_doc_count of 0");
            }
        }
    }
}

