/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class BreakpointFactory {
    private static final boolean TRACE = Boolean.getBoolean("truffle.debug.trace");
    private static final PrintStream OUT = System.out;
    private static final String TRACE_PREFIX = "Brkpt";
    private final Map<Object, BreakpointImpl> breakpoints = new HashMap<Object, BreakpointImpl>();
    private static final Comparator<Map.Entry<Object, BreakpointImpl>> BREAKPOINT_COMPARATOR = new Comparator<Map.Entry<Object, BreakpointImpl>>(){

        @Override
        public int compare(Map.Entry<Object, BreakpointImpl> entry1, Map.Entry<Object, BreakpointImpl> entry2) {
            Object key1 = entry1.getKey();
            Object key2 = entry2.getKey();
            if (key1 instanceof LineLocation && key2 instanceof LineLocation) {
                LineLocation line1 = (LineLocation)key1;
                LineLocation line2 = (LineLocation)key2;
                int nameOrder = line1.getSource().getShortName().compareTo(line2.getSource().getShortName());
                if (nameOrder != 0) {
                    return nameOrder;
                }
                return Integer.compare(line1.getLineNumber(), line2.getLineNumber());
            }
            return key1.toString().compareTo(key2.toString());
        }
    };
    @CompilerDirectives.CompilationFinal
    boolean breakpointsActive = true;
    private final CyclicAssumption breakpointsActiveUnchanged = new CyclicAssumption("All breakpoints globally active");
    private final Instrumenter instrumenter;
    private final Debugger.BreakpointCallback breakpointCallback;
    private final Debugger.WarningLog warningLog;

    @CompilerDirectives.TruffleBoundary
    private static void trace(String format, Object ... args) {
        if (TRACE) {
            OUT.println(String.format("%s: %s", TRACE_PREFIX, String.format(format, args)));
        }
    }

    BreakpointFactory(Instrumenter instrumenter, Debugger.BreakpointCallback breakpointCallback, Debugger.WarningLog warningLog) {
        this.instrumenter = instrumenter;
        this.breakpointCallback = breakpointCallback;
        this.warningLog = warningLog;
    }

    void setActive(boolean breakpointsActive) {
        if (this.breakpointsActive != breakpointsActive) {
            this.breakpointsActiveUnchanged.invalidate();
            this.breakpointsActive = breakpointsActive;
        }
    }

    Breakpoint create(int ignoreCount, LineLocation lineLocation, boolean oneShot) throws IOException {
        BreakpointImpl breakpoint = this.breakpoints.get(lineLocation);
        if (breakpoint == null) {
            SourceSectionFilter query = SourceSectionFilter.newBuilder().sourceIs(lineLocation.getSource()).lineStartsIn(SourceSectionFilter.IndexRange.byLength(lineLocation.getLineNumber(), 1)).tagIs(StandardTags.StatementTag.class).build();
            breakpoint = this.createBreakpoint(lineLocation, query, ignoreCount, oneShot);
            if (TRACE) {
                BreakpointFactory.trace("NEW " + breakpoint.getShortDescription(), new Object[0]);
            }
            this.breakpoints.put(lineLocation, breakpoint);
        } else {
            if (ignoreCount == breakpoint.getIgnoreCount()) {
                throw new IOException("Breakpoint already set at location " + lineLocation);
            }
            breakpoint.setIgnoreCount(ignoreCount);
            if (TRACE) {
                BreakpointFactory.trace("CHANGED ignoreCount %s", breakpoint.getShortDescription());
            }
        }
        return breakpoint;
    }

    Breakpoint create(int ignoreCount, Class<?> tag, boolean oneShot) throws IOException {
        BreakpointImpl breakpoint = this.breakpoints.get(tag);
        if (breakpoint == null) {
            SourceSectionFilter query = SourceSectionFilter.newBuilder().tagIs(tag).build();
            breakpoint = this.createBreakpoint(tag, query, ignoreCount, oneShot);
            if (TRACE) {
                BreakpointFactory.trace("NEW " + breakpoint.getShortDescription(), new Object[0]);
            }
            this.breakpoints.put(tag, breakpoint);
        } else {
            if (ignoreCount == breakpoint.getIgnoreCount()) {
                throw new IOException("Breakpoint already set at location " + tag);
            }
            breakpoint.setIgnoreCount(ignoreCount);
            if (TRACE) {
                BreakpointFactory.trace("CHANGED ignoreCount %s", breakpoint.getShortDescription());
            }
        }
        return breakpoint;
    }

    Breakpoint get(Object key) {
        return this.breakpoints.get(key);
    }

    List<Breakpoint> getAll() {
        ArrayList<Map.Entry<Object, BreakpointImpl>> entries = new ArrayList<Map.Entry<Object, BreakpointImpl>>(this.breakpoints.entrySet());
        Collections.sort(entries, BREAKPOINT_COMPARATOR);
        ArrayList<Breakpoint> breakpointList = new ArrayList<Breakpoint>(entries.size());
        for (Map.Entry<Object, BreakpointImpl> entry : entries) {
            breakpointList.add(entry.getValue());
        }
        return breakpointList;
    }

    void disposeOneShots() {
        for (BreakpointImpl breakpoint : this.breakpoints.values()) {
            if (!breakpoint.isOneShot()) continue;
            breakpoint.dispose();
        }
    }

    private void forget(BreakpointImpl breakpoint) {
        assert (breakpoint.getState() == Breakpoint.State.DISPOSED);
        this.breakpoints.remove(breakpoint.getKey());
    }

    BreakpointImpl createBreakpoint(Object key, SourceSectionFilter query, int ignoreCount, boolean isOneShot) {
        BreakpointImpl breakpoint = new BreakpointImpl(key, query, ignoreCount, isOneShot);
        breakpoint.binding = this.instrumenter.attachListener(breakpoint.locationQuery, new BreakpointListener(breakpoint));
        return breakpoint;
    }

    private static final class BreakpointListener
    implements ExecutionEventListener {
        private final BreakpointImpl breakpoint;

        BreakpointListener(BreakpointImpl breakpoint) {
            this.breakpoint = breakpoint;
        }

        @Override
        public void onEnter(EventContext context, VirtualFrame frame) {
            if (TRACE) {
                BreakpointFactory.trace("hit breakpoint " + this.breakpoint.getShortDescription(), new Object[0]);
            }
            this.breakpoint.nodeEnter(context, frame);
        }

        @Override
        public void onReturnValue(EventContext context, VirtualFrame frame, Object result) {
        }

        @Override
        public void onReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
        }

        public String toString() {
            return this.breakpoint.getShortDescription();
        }
    }

    private final class BreakpointImpl
    extends Breakpoint
    implements ExecutionEventNodeFactory {
        private static final String SHOULD_NOT_HAPPEN = "BreakpointImpl:  should not happen";
        private final Object locationKey;
        private final SourceSectionFilter locationQuery;
        private final boolean isOneShot;
        private int ignoreCount;
        private int hitCount = 0;
        private Breakpoint.State state = Breakpoint.State.ENABLED_UNRESOLVED;
        private EventBinding binding;
        @CompilerDirectives.CompilationFinal
        private Assumption breakpointsActiveAssumption;
        @CompilerDirectives.CompilationFinal
        private boolean isEnabled;
        @CompilerDirectives.CompilationFinal
        private Assumption enabledUnchangedAssumption;
        private Source conditionSource;
        private Class<? extends TruffleLanguage> condLangClass;

        private BreakpointImpl(Object key, SourceSectionFilter query, int ignoreCount, boolean isOneShot) {
            this.ignoreCount = ignoreCount;
            this.isOneShot = isOneShot;
            this.locationKey = key;
            this.locationQuery = query;
            this.isEnabled = true;
            this.breakpointsActiveAssumption = BreakpointFactory.this.breakpointsActiveUnchanged.getAssumption();
            this.enabledUnchangedAssumption = Truffle.getRuntime().createAssumption("Breakpoint enabled state unchanged");
        }

        @Override
        public String getLocationDescription() {
            if (this.locationKey instanceof LineLocation) {
                return "Line: " + ((LineLocation)this.locationKey).getShortDescription();
            }
            return "Tag: " + this.locationKey.toString();
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (enabled != this.isEnabled) {
                switch (this.getState()) {
                    case ENABLED: {
                        assert (!enabled) : "BreakpointImpl:  should not happen";
                        this.doSetEnabled(false);
                        this.changeState(Breakpoint.State.DISABLED);
                        break;
                    }
                    case ENABLED_UNRESOLVED: {
                        assert (!enabled) : "BreakpointImpl:  should not happen";
                        this.doSetEnabled(false);
                        this.changeState(Breakpoint.State.DISABLED_UNRESOLVED);
                        break;
                    }
                    case DISABLED: {
                        assert (enabled) : "BreakpointImpl:  should not happen";
                        this.doSetEnabled(true);
                        this.changeState(Breakpoint.State.ENABLED);
                        break;
                    }
                    case DISABLED_UNRESOLVED: {
                        assert (enabled) : "BreakpointImpl:  should not happen";
                        this.doSetEnabled(true);
                        this.changeState(Breakpoint.State.DISABLED_UNRESOLVED);
                        break;
                    }
                    case DISPOSED: {
                        assert (false) : "breakpoint disposed";
                        break;
                    }
                    default: {
                        assert (false) : "BreakpointImpl:  should not happen";
                        break;
                    }
                }
            }
        }

        @Override
        public Source getCondition() {
            return this.conditionSource;
        }

        @Override
        public void setCondition(String expr) throws IOException {
            if (this.getState() == Breakpoint.State.DISPOSED) {
                throw new IllegalStateException("Attempt to modify a disposed breakpoint");
            }
            this.binding.dispose();
            if (expr == null) {
                this.conditionSource = null;
                this.binding = BreakpointFactory.this.instrumenter.attachListener(this.locationQuery, new BreakpointListener(this));
            } else {
                this.conditionSource = Source.fromText(expr, "breakpoint condition from text: " + expr);
                this.binding = BreakpointFactory.this.instrumenter.attachFactory(this.locationQuery, this);
            }
        }

        @Override
        public boolean isOneShot() {
            return this.isOneShot;
        }

        @Override
        public int getIgnoreCount() {
            return this.ignoreCount;
        }

        @Override
        public void setIgnoreCount(int ignoreCount) {
            this.ignoreCount = ignoreCount;
        }

        @Override
        public int getHitCount() {
            return this.hitCount;
        }

        @Override
        public Breakpoint.State getState() {
            return this.state;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void dispose() {
            if (this.getState() != Breakpoint.State.DISPOSED) {
                this.binding.dispose();
                this.changeState(Breakpoint.State.DISPOSED);
                BreakpointFactory.this.forget(this);
            }
        }

        @Override
        public ExecutionEventNode create(EventContext context) {
            assert (this.conditionSource != null);
            Node instrumentedNode = context.getInstrumentedNode();
            if (this.condLangClass == null) {
                this.condLangClass = Debugger.AccessorDebug.nodesAccess().findLanguage(instrumentedNode.getRootNode());
                if (this.condLangClass == null) {
                    BreakpointFactory.this.warningLog.addWarning("Unable to find language for condition: \"" + this.conditionSource.getCode() + "\" at " + this.getLocationDescription());
                    return null;
                }
            }
            try {
                CallTarget callTarget = Debugger.ACCESSOR.parse(this.condLangClass, this.conditionSource, instrumentedNode, new String[0]);
                DirectCallNode callNode = Truffle.getRuntime().createDirectCallNode(callTarget);
                return new BreakpointConditionEventNode(context, callNode);
            }
            catch (IOException e) {
                BreakpointFactory.this.warningLog.addWarning("Unable to parse breakpoint condition: \"" + this.conditionSource.getCode() + "\" at " + this.getLocationDescription());
                return null;
            }
        }

        private String getShortDescription() {
            if (this.locationKey instanceof LineLocation) {
                return "Breakpoint@" + ((LineLocation)this.locationKey).getShortDescription();
            }
            return "Breakpoint@" + this.locationKey.toString();
        }

        private void doSetEnabled(boolean enabled) {
            if (this.isEnabled != enabled) {
                this.enabledUnchangedAssumption.invalidate();
                this.isEnabled = enabled;
            }
        }

        private Object getKey() {
            return this.locationKey;
        }

        private void changeState(Breakpoint.State after) {
            if (TRACE) {
                BreakpointFactory.trace("STATE %s-->%s %s", new Object[]{this.getState().getName(), after.getName(), this.getShortDescription()});
            }
            this.state = after;
        }

        private void doBreak(EventContext context, VirtualFrame vFrame) {
            if (++this.hitCount > this.ignoreCount) {
                BreakpointFactory.this.breakpointCallback.haltedAt(context, vFrame.materialize(), "Breakpoint");
            }
        }

        private void nodeEnter(EventContext context, VirtualFrame vFrame) {
            try {
                this.breakpointsActiveAssumption.check();
            }
            catch (InvalidAssumptionException ex) {
                this.breakpointsActiveAssumption = BreakpointFactory.this.breakpointsActiveUnchanged.getAssumption();
            }
            try {
                this.enabledUnchangedAssumption.check();
            }
            catch (InvalidAssumptionException ex) {
                this.enabledUnchangedAssumption = Truffle.getRuntime().createAssumption("Breakpoint enabled state unchanged");
            }
            if (BreakpointFactory.this.breakpointsActive && this.isEnabled) {
                if (this.isOneShot()) {
                    this.dispose();
                }
                this.doBreak(context, vFrame);
            }
        }

        private void conditionFailure(EventContext context, VirtualFrame vFrame, Exception ex) {
            this.addExceptionWarning(ex);
            if (TRACE) {
                BreakpointFactory.trace("breakpoint failure = %s  %s", new Object[]{ex, this.getShortDescription()});
            }
            this.nodeEnter(context, vFrame);
        }

        @CompilerDirectives.TruffleBoundary
        private void addExceptionWarning(Exception ex) {
            BreakpointFactory.this.warningLog.addWarning(String.format("Exception in %s:  %s", this.getShortDescription(), ex.getMessage()));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
            sb.append(" state=");
            sb.append(this.getState() == null ? "<none>" : this.getState().getName());
            if (this.isOneShot()) {
                sb.append(", One-Shot");
            }
            if (this.getCondition() != null) {
                sb.append(", condition=\"" + this.getCondition() + "\"");
            }
            return sb.toString();
        }

        private class BreakpointConditionEventNode
        extends ExecutionEventNode {
            @Node.Child
            DirectCallNode callNode;
            final EventContext context;

            BreakpointConditionEventNode(EventContext context, DirectCallNode callNode) {
                this.context = context;
                this.callNode = callNode;
            }

            @Override
            protected void onEnter(VirtualFrame frame) {
                try {
                    Object result = this.callNode.call(frame, new Object[0]);
                    if (result instanceof Boolean) {
                        if (TRACE) {
                            BreakpointFactory.trace("breakpoint cond=%b %s %s", new Object[]{result, BreakpointImpl.this.conditionSource.getCode(), BreakpointImpl.this.getShortDescription()});
                        }
                        if (((Boolean)result).booleanValue()) {
                            BreakpointImpl.this.nodeEnter(this.context, frame);
                        }
                    } else {
                        BreakpointImpl.this.conditionFailure(this.context, frame, new RuntimeException("breakpoint condition failure: non-boolean result " + BreakpointImpl.this.conditionSource.getCode()));
                    }
                }
                catch (Exception ex) {
                    BreakpointImpl.this.conditionFailure(this.context, frame, new RuntimeException("breakpoint condition failure: " + BreakpointImpl.this.conditionSource.getCode() + ex.getMessage()));
                }
            }
        }
    }
}

