/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jruby.RubyInstanceConfig;
import org.jruby.exceptions.MainExitException;
import org.jruby.runtime.profile.builtin.ProfileOutput;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.cli.Options;
import org.jruby.util.cli.OutputStrings;
import org.jruby.util.func.Function2;

public class ArgumentProcessor {
    public static final String SEPARATOR = "(?<!jar:file|jar|file|classpath|uri:classloader|uri|http|https):";
    private List<Argument> arguments;
    private int argumentIndex = 0;
    private boolean processArgv;
    private final boolean rubyOpts;
    RubyInstanceConfig config;
    private boolean endOfArguments = false;
    private int characterIndex = 0;
    private static final Pattern VERSION_FLAG = Pattern.compile("^--[12]\\.[89012]$");
    private static final Set<String> KNOWN_PROPERTIES = new HashSet<String>();
    private static final List<String> KNOWN_PROPERTY_PREFIXES;
    private static final Map<String, Function2<Boolean, ArgumentProcessor, Boolean>> FEATURES;

    public ArgumentProcessor(String[] arguments, RubyInstanceConfig config) {
        this(arguments, true, false, false, config);
    }

    public ArgumentProcessor(String[] arguments, boolean processArgv, boolean dashed, boolean rubyOpts, RubyInstanceConfig config) {
        this.config = config;
        this.arguments = new ArrayList<Argument>();
        if (arguments != null && arguments.length > 0) {
            for (String argument : arguments) {
                this.arguments.add(new Argument(argument, dashed));
            }
        }
        this.processArgv = processArgv;
        this.rubyOpts = rubyOpts;
    }

    public void processArguments() {
        this.processArguments(true);
    }

    public void processArguments(boolean inline) {
        this.checkProperties();
        while (this.argumentIndex < this.arguments.size() && this.isInterpreterArgument(this.arguments.get((int)this.argumentIndex).originalValue)) {
            this.processArgument();
            ++this.argumentIndex;
        }
        if (inline && !this.config.isInlineScript() && this.config.getScriptFileName() == null && !this.config.isForceStdin() && this.argumentIndex < this.arguments.size()) {
            this.config.setScriptFileName(this.arguments.get((int)this.argumentIndex).originalValue);
            ++this.argumentIndex;
        }
        if (this.processArgv) {
            this.processArgv();
        }
    }

    private void processArgv() {
        ArrayList<String> arglist = new ArrayList<String>();
        while (this.argumentIndex < this.arguments.size()) {
            String arg2 = this.arguments.get((int)this.argumentIndex).originalValue;
            if (this.config.isArgvGlobalsOn() && arg2.startsWith("-")) {
                int split2 = (arg2 = arg2.substring(1)).indexOf(61);
                if (split2 > 0) {
                    String key2 = arg2.substring(0, split2);
                    String val = arg2.substring(split2 + 1);
                    String globalName = key2.replace('-', '_');
                    this.config.getOptionGlobals().put(globalName, val);
                } else {
                    this.config.getOptionGlobals().put(arg2, null);
                }
            } else {
                this.config.setArgvGlobalsOn(false);
                arglist.add(arg2);
            }
            ++this.argumentIndex;
        }
        arglist.addAll(Arrays.asList(this.config.getArgv()));
        this.config.setArgv(arglist.toArray(new String[arglist.size()]));
    }

    private boolean isInterpreterArgument(String argument) {
        return argument.length() > 0 && (argument.charAt(0) == '-' || argument.charAt(0) == '+') && !this.endOfArguments;
    }

    private String getArgumentError(String additionalError) {
        return "jruby: invalid argument\n" + additionalError + "\n";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processArgument() {
        String argument = this.arguments.get((int)this.argumentIndex).dashedValue;
        if (argument.length() == 1) {
            this.endOfArguments = true;
            this.config.setForceStdin(true);
            return;
        }
        this.characterIndex = 1;
        while (this.characterIndex < argument.length()) {
            switch (argument.charAt(this.characterIndex)) {
                case '0': {
                    this.disallowedInRubyOpts(argument);
                    String temp = this.grabOptionalValue();
                    if (null == temp) {
                        this.config.setRecordSeparator("\u0000");
                        return;
                    }
                    if (temp.equals("0")) {
                        this.config.setRecordSeparator("\n\n");
                        return;
                    }
                    if (temp.equals("777")) {
                        this.config.setRecordSeparator("\uffff");
                        return;
                    }
                    try {
                        int val = Integer.parseInt(temp, 8);
                        this.config.setRecordSeparator(String.valueOf((char)val));
                        return;
                    }
                    catch (Exception e) {
                        MainExitException mee = new MainExitException(1, this.getArgumentError(" -0 must be followed by either 0, 777, or a valid octal value"));
                        mee.setUsageError(true);
                        throw mee;
                    }
                }
                case 'a': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setSplit(true);
                    break;
                }
                case 'c': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setShouldCheckSyntax(true);
                    break;
                }
                case 'C': {
                    this.disallowedInRubyOpts(argument);
                    try {
                        String saved = this.grabValue(this.getArgumentError(" -C must be followed by a directory expression"));
                        File base = new File(this.config.getCurrentDirectory());
                        File newDir = new File(saved);
                        if (saved.startsWith("uri:classloader:")) {
                            this.config.setCurrentDirectory(saved);
                        } else if (newDir.isAbsolute()) {
                            this.config.setCurrentDirectory(newDir.getCanonicalPath());
                        } else {
                            this.config.setCurrentDirectory(new File(base, newDir.getPath()).getCanonicalPath());
                        }
                        if (new File(this.config.getCurrentDirectory()).isDirectory() || this.config.getCurrentDirectory().startsWith("uri:classloader:")) return;
                        throw new MainExitException(1, "jruby: Can't chdir to " + saved + " (fatal)");
                    }
                    catch (IOException e) {
                        throw new MainExitException(1, this.getArgumentError(" -C must be followed by a valid directory"));
                    }
                }
                case 'd': {
                    this.config.setDebug(true);
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    break;
                }
                case 'e': {
                    this.disallowedInRubyOpts(argument);
                    this.config.getInlineScript().append(this.grabValue(this.getArgumentError(" -e must be followed by an expression to report")));
                    this.config.getInlineScript().append('\n');
                    this.config.setHasInlineScript(true);
                    return;
                }
                case 'E': {
                    this.processEncodingOption(this.grabValue(this.getArgumentError("unknown encoding name")));
                    return;
                }
                case 'F': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setInputFieldSeparator(this.grabValue(this.getArgumentError(" -F must be followed by a pattern for input field separation")));
                    return;
                }
                case 'h': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setShouldPrintUsage(true);
                    this.config.setShouldRunInterpreter(false);
                    break;
                }
                case 'i': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setInPlaceBackupExtension(this.grabOptionalValue());
                    if (this.config.getInPlaceBackupExtension() != null) return;
                    this.config.setInPlaceBackupExtension("");
                    return;
                }
                case 'I': {
                    String s2 = this.grabValue(this.getArgumentError("-I must be followed by a directory name to add to lib path"));
                    String separator = File.pathSeparator;
                    if (":".equals(separator)) {
                        separator = SEPARATOR;
                    }
                    String[] ls = s2.split(separator);
                    this.config.getLoadPaths().addAll(Arrays.asList(ls));
                    return;
                }
                case 'J': {
                    String js = this.grabOptionalValue();
                    this.config.getError().println("warning: " + argument + " argument ignored (launched in same VM?)");
                    if (!js.equals("-cp") && !js.equals("-classpath")) return;
                    while (this.grabOptionalValue() != null) {
                    }
                    this.grabValue(this.getArgumentError(" -J-cp must be followed by a path expression"));
                    return;
                }
                case 'K': {
                    String eArg = this.grabValue(this.getArgumentError("provide a value for -K"));
                    this.config.setKCode(KCode.create(null, eArg));
                    this.config.setSourceEncoding(this.config.getKCode().getEncoding().toString());
                    if (this.config.getExternalEncoding() != null) break;
                    this.config.setExternalEncoding(this.config.getKCode().getEncoding().toString());
                    break;
                }
                case 'l': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setProcessLineEnds(true);
                    break;
                }
                case 'n': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setAssumeLoop(true);
                    this.config.setKernelGsubDefined(true);
                    break;
                }
                case 'p': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setAssumePrinting(true);
                    this.config.setAssumeLoop(true);
                    this.config.setKernelGsubDefined(true);
                    break;
                }
                case 'r': {
                    this.config.getRequiredLibraries().add(this.grabValue(this.getArgumentError("-r must be followed by a package to require")));
                    return;
                }
                case 's': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setArgvGlobalsOn(true);
                    break;
                }
                case 'G': {
                    this.config.setLoadGemfile(true);
                    break;
                }
                case 'S': {
                    this.disallowedInRubyOpts(argument);
                    this.runBinScript();
                    return;
                }
                case 'T': {
                    this.grabOptionalValue();
                    return;
                }
                case 'U': {
                    this.config.setInternalEncoding("UTF-8");
                    break;
                }
                case 'v': {
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    this.config.setShowVersion(true);
                    break;
                }
                case 'w': {
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    break;
                }
                case 'W': {
                    String temp = this.grabOptionalValue();
                    if (temp == null) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        return;
                    }
                    if (temp.equals("0")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.NIL);
                        return;
                    }
                    if (temp.equals("1")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.FALSE);
                        return;
                    }
                    if (temp.equals("2")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        return;
                    }
                    MainExitException mainExitException = new MainExitException(1, this.getArgumentError(" -W must be followed by either 0, 1, 2 or nothing"));
                    mainExitException.setUsageError(true);
                    throw mainExitException;
                }
                case 'x': {
                    this.disallowedInRubyOpts(argument);
                    try {
                        String saved = this.grabOptionalValue();
                        if (saved != null) {
                            File file2 = new File(this.config.getCurrentDirectory());
                            File newDir = new File(saved);
                            if (saved.startsWith("uri:classloader:")) {
                                this.config.setCurrentDirectory(saved);
                            } else if (newDir.isAbsolute()) {
                                this.config.setCurrentDirectory(newDir.getCanonicalPath());
                            } else {
                                this.config.setCurrentDirectory(new File(file2, newDir.getPath()).getCanonicalPath());
                            }
                            if (!new File(this.config.getCurrentDirectory()).isDirectory() && !this.config.getCurrentDirectory().startsWith("uri:classloader:")) {
                                throw new MainExitException(1, "jruby: Can't chdir to " + saved + " (fatal)");
                            }
                        }
                        this.config.setXFlag(true);
                        return;
                    }
                    catch (IOException e) {
                        throw new MainExitException(1, this.getArgumentError(" -x must be followed by a valid directory"));
                    }
                }
                case 'X': {
                    this.disallowedInRubyOpts(argument);
                    String extendedOption = this.grabOptionalValue();
                    if (extendedOption == null) {
                        if (!SafePropertyAccessor.getBoolean("jruby.launcher.nopreamble", false)) throw new MainExitException(0, "jruby: missing argument\n" + OutputStrings.getExtendedHelp());
                        throw new MainExitException(0, OutputStrings.getExtendedHelp());
                    }
                    if (extendedOption.equals("-O")) {
                        this.config.setObjectSpaceEnabled(false);
                        return;
                    }
                    if (extendedOption.equals("+O")) {
                        this.config.setObjectSpaceEnabled(true);
                        return;
                    }
                    if (extendedOption.equals("-C") || extendedOption.equals("-CIR")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
                        return;
                    }
                    if (extendedOption.equals("+C") || extendedOption.equals("+CIR")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
                        return;
                    }
                    if (extendedOption.equals("-T")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
                        Options.COMPILE_MODE.unforce();
                        this.config.setDisableGems(false);
                        return;
                    }
                    if (extendedOption.equals("+T")) {
                        Options.PARSER_WARN_GROUPED_EXPRESSIONS.force(Boolean.FALSE.toString());
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.TRUFFLE);
                        Options.COMPILE_MODE.force("TRUFFLE");
                        this.config.setDisableGems(true);
                        return;
                    }
                    if (extendedOption.endsWith("...")) {
                        Options.listPrefix(extendedOption.substring(0, extendedOption.length() - "...".length()));
                        this.config.setShouldRunInterpreter(false);
                        return;
                    }
                    if (extendedOption.endsWith("?")) {
                        Options.listContains(extendedOption.substring(0, extendedOption.length() - 1));
                        this.config.setShouldRunInterpreter(false);
                        return;
                    }
                    MainExitException mainExitException = new MainExitException(1, "jruby: invalid extended option " + extendedOption + " (-X will list valid options)\n");
                    mainExitException.setUsageError(true);
                    throw mainExitException;
                }
                case 'y': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setParserDebug(true);
                    return;
                }
                case '-': {
                    if (argument.equals("--command") || argument.equals("--bin")) {
                        this.characterIndex = argument.length();
                        this.runBinScript();
                        break;
                    }
                    if (argument.equals("--compat")) {
                        this.characterIndex = argument.length();
                        this.grabValue(this.getArgumentError("--compat takes an argument, but will be ignored"));
                        this.config.getError().println("warning: " + argument + " ignored");
                        return;
                    }
                    if (argument.equals("--copyright")) {
                        this.disallowedInRubyOpts(argument);
                        this.config.setShowCopyright(true);
                        this.config.setShouldRunInterpreter(false);
                        return;
                    }
                    if (argument.equals("--debug")) {
                        this.disallowedInRubyOpts(argument);
                        Options.DEBUG_FULLTRACE.force("true");
                        RubyInstanceConfig.FULL_TRACE_ENABLED = true;
                        this.config.setDebuggingFrozenStringLiteral(true);
                        return;
                    }
                    if (argument.startsWith("--debug=")) {
                        for (String debug : this.valueListFor(argument, "debug")) {
                            boolean all = debug.equals("all");
                            if (debug.equals("frozen-string-literal") || all) {
                                this.config.setDebuggingFrozenStringLiteral(true);
                                continue;
                            }
                            this.config.getError().println("warning: unknown argument for --debug: `" + debug + "'");
                        }
                        return;
                    }
                    if (argument.equals("--jdb")) {
                        this.config.setDebug(true);
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        break;
                    }
                    if (argument.equals("--help")) {
                        this.disallowedInRubyOpts(argument);
                        this.config.setShouldPrintUsage(true);
                        this.config.setShouldRunInterpreter(false);
                        break;
                    }
                    if (argument.equals("--properties")) {
                        this.config.setShouldPrintProperties(true);
                        this.config.setShouldRunInterpreter(false);
                        break;
                    }
                    if (argument.equals("--version")) {
                        this.disallowedInRubyOpts(argument);
                        this.config.setShowVersion(true);
                        this.config.setShouldRunInterpreter(false);
                        return;
                    }
                    if (argument.equals("--bytecode")) {
                        this.config.setShowBytecode(true);
                        return;
                    }
                    if (argument.equals("--fast")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
                        return;
                    }
                    if (argument.startsWith("--profile")) {
                        this.characterIndex = argument.length();
                        int n = argument.indexOf(46);
                        if (n == -1) {
                            this.config.setProfilingMode(RubyInstanceConfig.ProfilingMode.FLAT);
                            return;
                        }
                        String profilingMode = argument.substring(n + 1, argument.length());
                        if (profilingMode.equals("out")) {
                            String outputFile = this.grabValue(this.getArgumentError("--profile.out requires an output file argument"));
                            try {
                                this.config.setProfileOutput(new ProfileOutput(new File(outputFile)));
                                return;
                            }
                            catch (FileNotFoundException e) {
                                throw new MainExitException(1, String.format("jruby: %s", e.getMessage()));
                            }
                        }
                        if (profilingMode.equals("service")) {
                            String service = this.grabValue(this.getArgumentError("--profile.service requires an class name argument"));
                            this.config.setProfilingMode(RubyInstanceConfig.ProfilingMode.SERVICE);
                            this.config.setProfilingService(service);
                            return;
                        }
                        try {
                            this.config.setProfilingMode(RubyInstanceConfig.ProfilingMode.valueOf(profilingMode.toUpperCase()));
                            return;
                        }
                        catch (IllegalArgumentException e) {
                            throw new MainExitException(1, String.format("jruby: unknown profiler mode \"%s\"", profilingMode));
                        }
                    }
                    if (VERSION_FLAG.matcher(argument).matches()) {
                        this.config.getError().println("warning: " + argument + " ignored");
                        return;
                    }
                    if (argument.equals("--debug-frozen-string-literal")) {
                        this.config.setDebuggingFrozenStringLiteral(true);
                        return;
                    }
                    if (argument.startsWith("--disable")) {
                        if (argument.equals("--disable")) {
                            this.characterIndex = argument.length();
                            String string2 = this.grabValue(this.getArgumentError("missing argument for --disable"), false);
                            argument = "--disable=" + string2;
                        }
                        for (String disable2 : this.valueListFor(argument, "disable")) {
                            this.enableDisableFeature(disable2, false);
                        }
                        return;
                    }
                    if (argument.startsWith("--enable")) {
                        if (argument.equals("--enable")) {
                            this.characterIndex = argument.length();
                            String string3 = this.grabValue(this.getArgumentError("missing argument for --enable"), false);
                            argument = "--enable=" + string3;
                        }
                        for (String enable2 : this.valueListFor(argument, "enable")) {
                            this.enableDisableFeature(enable2, true);
                        }
                        return;
                    }
                    if (argument.equals("--gemfile")) {
                        this.config.setLoadGemfile(true);
                        return;
                    }
                    if (argument.equals("--dump")) {
                        this.characterIndex = argument.length();
                        String string4 = "--dump only supports [version, copyright, usage, yydebug, syntax, insns] on JRuby";
                        String dumpArg = this.grabValue(this.getArgumentError(string4));
                        if (dumpArg.equals("version")) {
                            this.config.setShowVersion(true);
                            this.config.setShouldRunInterpreter(false);
                            return;
                        }
                        if (dumpArg.equals("copyright")) {
                            this.config.setShowCopyright(true);
                            this.config.setShouldRunInterpreter(false);
                            return;
                        }
                        if (dumpArg.equals("usage")) {
                            this.config.setShouldPrintUsage(true);
                            this.config.setShouldRunInterpreter(false);
                            return;
                        }
                        if (dumpArg.equals("yydebug")) {
                            this.config.setParserDebug(true);
                            return;
                        }
                        if (dumpArg.equals("syntax")) {
                            this.config.setShouldCheckSyntax(true);
                            break;
                        }
                        if (dumpArg.equals("insns")) {
                            this.config.setShowBytecode(true);
                            break;
                        }
                        MainExitException mee = new MainExitException(1, string4);
                        mee.setUsageError(true);
                        throw mee;
                    }
                    if (argument.equals("--dev")) {
                        Options.COMPILE_INVOKEDYNAMIC.force("false");
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
                        return;
                    }
                    if (argument.equals("--server") || argument.equals("--client")) return;
                    if (argument.equals("--yydebug")) {
                        this.disallowedInRubyOpts(argument);
                        this.config.setParserDebug(true);
                    } else {
                        if (argument.equals("--verbose")) {
                            this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                            return;
                        }
                        if (!argument.equals("--")) throw new MainExitException(1, "jruby: unknown option " + argument);
                        this.endOfArguments = true;
                        break;
                    }
                }
                default: {
                    throw new MainExitException(1, "jruby: unknown option " + argument);
                }
            }
            ++this.characterIndex;
        }
    }

    private void enableDisableFeature(String name2, boolean enable2) {
        Function2<Boolean, ArgumentProcessor, Boolean> feature = FEATURES.get(name2);
        if (feature == null) {
            this.config.getError().println("warning: unknown argument for --" + (enable2 ? "enable" : "disable") + ": `" + name2 + "'");
        } else {
            feature.apply(this, enable2);
        }
    }

    private String[] valueListFor(String argument, String key2) {
        int length2 = key2.length() + 3;
        String[] values2 = argument.substring(length2).split(",");
        if (values2.length == 0) {
            this.errorMissingEquals(key2);
        }
        return values2;
    }

    private void disallowedInRubyOpts(String option) {
        if (this.rubyOpts) {
            throw new MainExitException(1, "jruby: invalid switch in RUBYOPT: " + option + " (RuntimeError)");
        }
    }

    private void errorMissingEquals(String label2) {
        MainExitException mee = new MainExitException(1, "missing argument for --" + label2 + "\n");
        mee.setUsageError(true);
        throw mee;
    }

    private void processEncodingOption(String value2) {
        String[] encodings = value2.split(":", 3);
        switch (encodings.length) {
            case 3: {
                throw new MainExitException(1, "extra argument for -E: " + encodings[2]);
            }
            case 2: {
                this.config.setInternalEncoding(encodings[1]);
            }
            case 1: {
                this.config.setExternalEncoding(encodings[0]);
            }
        }
    }

    private void runBinScript() {
        String scriptName = this.grabValue("jruby: provide a bin script to execute");
        if (scriptName.equals("irb")) {
            scriptName = "jirb";
        }
        this.config.setScriptFileName(this.resolveScript(scriptName));
        if (this.config.getScriptFileName() == null) {
            this.config.setScriptFileName(scriptName);
            this.config.getRequiredLibraries().add("jruby/commands");
            this.config.getInlineScript().append("JRuby::Commands.").append(scriptName);
            this.config.getInlineScript().append("\n");
            this.config.setHasInlineScript(true);
        }
        this.endOfArguments = true;
    }

    private String resolve(String path2, String scriptName) {
        if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
            this.config.getError().println("Trying path: " + path2);
        }
        try {
            FileResource fullName = JRubyFile.createRestrictedResource(path2, scriptName);
            if (fullName.exists() && fullName.isFile()) {
                if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
                    this.config.getError().println("Found: " + fullName.absolutePath());
                }
                return fullName.absolutePath();
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return null;
    }

    private String resolveScript(String scriptName) {
        String result2 = this.resolve(this.config.getCurrentDirectory(), scriptName);
        if (result2 != null) {
            return scriptName;
        }
        result2 = this.resolve(this.config.getJRubyHome() + "/bin", scriptName);
        if (result2 != null) {
            return result2;
        }
        result2 = this.resolve(this.config.getCurrentDirectory() + "/bin", scriptName);
        if (result2 != null) {
            return result2;
        }
        result2 = this.resolve("uri:classloader:/bin", scriptName);
        if (result2 != null) {
            return result2;
        }
        String maybePath = this.config.getEnvironment().get("PATH");
        if (maybePath != null) {
            String path2 = maybePath.toString();
            String[] paths = path2.split(System.getProperty("path.separator"));
            for (int i2 = 0; i2 < paths.length; ++i2) {
                result2 = this.resolve(new File(paths[i2]).getAbsolutePath(), scriptName);
                if (result2 == null) continue;
                return result2;
            }
        }
        if (this.config.isDebug()) {
            this.config.getError().println("warning: could not resolve -S script: " + scriptName);
        }
        return null;
    }

    public String resolveScriptUsingClassLoader(String scriptName) {
        if (RubyInstanceConfig.defaultClassLoader().getResourceAsStream("bin/" + scriptName) != null) {
            return "classpath:/bin/" + scriptName;
        }
        return null;
    }

    private String grabValue(String errorMessage) {
        return this.grabValue(errorMessage, true);
    }

    private String grabValue(String errorMessage, boolean usageError) {
        String optValue = this.grabOptionalValue();
        if (optValue != null) {
            return optValue;
        }
        ++this.argumentIndex;
        if (this.argumentIndex < this.arguments.size()) {
            return this.arguments.get((int)this.argumentIndex).originalValue;
        }
        MainExitException mee = new MainExitException(1, errorMessage);
        if (usageError) {
            mee.setUsageError(true);
        }
        throw mee;
    }

    private String grabOptionalValue() {
        ++this.characterIndex;
        String argValue = this.arguments.get((int)this.argumentIndex).originalValue;
        if (this.characterIndex < argValue.length()) {
            return argValue.substring(this.characterIndex);
        }
        return null;
    }

    private void logScriptResolutionSuccess(String path2) {
        if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
            this.config.getError().println("Found: " + path2);
        }
    }

    private void logScriptResolutionFailure(String path2) {
        if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
            this.config.getError().println("Searched: " + path2);
        }
    }

    private void checkProperties() {
        for (String propertyName : System.getProperties().stringPropertyNames()) {
            if (!propertyName.startsWith("jruby.") || this.isPropertySupported(propertyName)) continue;
            System.err.println("jruby: warning: unknown property " + propertyName);
        }
    }

    private boolean isPropertySupported(String propertyName) {
        if (KNOWN_PROPERTIES.contains(propertyName)) {
            return true;
        }
        for (String prefix : KNOWN_PROPERTY_PREFIXES) {
            if (!propertyName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static {
        KNOWN_PROPERTIES.addAll(Options.getPropertyNames());
        KNOWN_PROPERTIES.add("jruby.home");
        KNOWN_PROPERTIES.add("jruby.script");
        KNOWN_PROPERTIES.add("jruby.shell");
        KNOWN_PROPERTIES.add("jruby.lib");
        KNOWN_PROPERTIES.add("jruby.bindir");
        KNOWN_PROPERTIES.add("jruby.jar");
        KNOWN_PROPERTIES.add("jruby.compat.version");
        KNOWN_PROPERTIES.add("jruby.reflection");
        KNOWN_PROPERTIES.add("jruby.thread.pool.enabled");
        KNOWN_PROPERTIES.add("jruby.memory.max");
        KNOWN_PROPERTIES.add("jruby.stack.max");
        KNOWN_PROPERTY_PREFIXES = new ArrayList<String>();
        KNOWN_PROPERTY_PREFIXES.add("jruby.openssl.");
        HashMap<String, Function2<Boolean, ArgumentProcessor, Boolean>> features = new HashMap<String, Function2<Boolean, ArgumentProcessor, Boolean>>();
        features.put("all", new Function2<Boolean, ArgumentProcessor, Boolean>(){

            @Override
            public Boolean apply(ArgumentProcessor processor, Boolean enable2) {
                for (Map.Entry entry : FEATURES.entrySet()) {
                    if (((String)entry.getKey()).equals("all")) continue;
                    ((Function2)entry.getValue()).apply(processor, enable2);
                }
                return true;
            }
        });
        features.put("gems", new Function2<Boolean, ArgumentProcessor, Boolean>(){

            @Override
            public Boolean apply(ArgumentProcessor processor, Boolean enable2) {
                processor.config.setDisableGems(enable2 == false);
                return true;
            }
        });
        features.put("did-you-mean", new Function2<Boolean, ArgumentProcessor, Boolean>(){

            @Override
            public Boolean apply(ArgumentProcessor processor, Boolean enable2) {
                processor.config.setDisableDidYouMean(enable2 == false);
                return true;
            }
        });
        features.put("did_you_mean", new Function2<Boolean, ArgumentProcessor, Boolean>(){

            @Override
            public Boolean apply(ArgumentProcessor processor, Boolean enable2) {
                processor.config.setDisableDidYouMean(enable2 == false);
                return true;
            }
        });
        features.put("rubyopt", new Function2<Boolean, ArgumentProcessor, Boolean>(){

            @Override
            public Boolean apply(ArgumentProcessor processor, Boolean enable2) {
                processor.config.setDisableRUBYOPT(enable2 == false);
                return true;
            }
        });
        features.put("frozen-string-literal", new Function2<Boolean, ArgumentProcessor, Boolean>(){

            @Override
            public Boolean apply(ArgumentProcessor processor, Boolean enable2) {
                processor.config.setFrozenStringLiteral(enable2);
                return true;
            }
        });
        features.put("frozen_string_literal", new Function2<Boolean, ArgumentProcessor, Boolean>(){

            @Override
            public Boolean apply(ArgumentProcessor processor, Boolean enable2) {
                processor.config.setFrozenStringLiteral(enable2);
                return true;
            }
        });
        FEATURES = features;
    }

    private static final class Argument {
        public final String originalValue;
        public final String dashedValue;

        public Argument(String value2, boolean dashed) {
            this.originalValue = value2;
            this.dashedValue = dashed && !value2.startsWith("-") ? "-" + value2 : value2;
        }

        public String toString() {
            return this.dashedValue;
        }
    }
}

