/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm;

import edu.berkeley.nlp.lm.NgramLanguageModel;
import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.collections.BoundedList;
import edu.berkeley.nlp.lm.util.Annotations;
import java.util.List;

public interface ContextEncodedNgramLanguageModel<W>
extends NgramLanguageModel<W> {
    public float getLogProb(long var1, int var3, int var4, @Annotations.OutputParameter LmContextInfo var5);

    public LmContextInfo getOffsetForNgram(int[] var1, int var2, int var3);

    public int[] getNgramForOffset(long var1, int var3, int var4);

    public static class DefaultImplementations {
        public static <T> float scoreSentence(List<T> sentence, ContextEncodedNgramLanguageModel<T> lm) {
            float scoreNgram;
            List ngram;
            int i;
            BoundedList<T> sentenceWithBounds = new BoundedList<T>(sentence, lm.getWordIndexer().getStartSymbol(), lm.getWordIndexer().getEndSymbol());
            int lmOrder = lm.getLmOrder();
            float sentenceScore = 0.0f;
            for (i = 1; i < lmOrder - 1 && i <= sentenceWithBounds.size() + 1; ++i) {
                ngram = sentenceWithBounds.subList(-1, i);
                scoreNgram = lm.getLogProb(ngram);
                sentenceScore += scoreNgram;
            }
            for (i = lmOrder - 1; i < sentenceWithBounds.size() + 2; ++i) {
                ngram = sentenceWithBounds.subList(i - lmOrder, i);
                scoreNgram = lm.getLogProb(ngram);
                sentenceScore += scoreNgram;
            }
            return sentenceScore;
        }

        public static <T> float getLogProb(List<T> ngram, ContextEncodedNgramLanguageModel<T> lm) {
            LmContextInfo contextOutput = new LmContextInfo();
            WordIndexer<T> wordIndexer = lm.getWordIndexer();
            float score = Float.NaN;
            for (int i = 0; i < ngram.size(); ++i) {
                score = lm.getLogProb(contextOutput.offset, contextOutput.order, wordIndexer.getIndexPossiblyUnk(ngram.get(i)), contextOutput);
            }
            return score;
        }
    }

    public static class LmContextInfo {
        public long offset = -1L;
        public int order = -1;
    }
}

