/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.plugin.loader;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.umleditor.plugin.AbstractPlugin;
import ch.ehi.umleditor.plugin.loader.PluginLoader;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JARClassLoader
extends URLClassLoader {
    private String path;
    private JAR jar;
    private ArrayList pluginClasses = new ArrayList();

    public JARClassLoader(String path, PluginLoader pluginLoader) throws IOException {
        super(new URL[]{new URL("file", "", path)});
        URL u = new URL("jar", "", new URL("file", "", path) + "!/");
        JarURLConnection uc = (JarURLConnection)u.openConnection();
        JarFile zipFile = uc.getJarFile();
        this.jar = new JAR(path, this);
        Enumeration<JarEntry> entires = zipFile.entries();
        while (entires.hasMoreElements()) {
            ZipEntry entry = entires.nextElement();
            String name = entry.getName();
            if (!name.endsWith("Plugin.class")) continue;
            this.pluginClasses.add(name);
        }
        pluginLoader.addPluginJAR(this.jar);
    }

    void startAllPlugins() {
        boolean ok = true;
        for (int i = 0; i < this.pluginClasses.size(); ++i) {
            String name = (String)this.pluginClasses.get(i);
            name = JARClassLoader.fileToClass(name);
            try {
                Class<?> clazz = this.loadClass(name);
                AbstractPlugin plugin = (AbstractPlugin)clazz.newInstance();
                this.jar.addPlugin(plugin);
                continue;
            }
            catch (Throwable t) {
                EhiLogger.logError("Error while starting plugin " + name, t);
            }
        }
    }

    public static String fileToClass(String name) {
        char[] clsName = name.toCharArray();
        for (int i = clsName.length - 6; i >= 0; --i) {
            if (clsName[i] != '/') continue;
            clsName[i] = 46;
        }
        return new String(clsName, 0, clsName.length - 6);
    }

    public static class JAR {
        private String path;
        private JARClassLoader classLoader;
        private Vector plugins;

        public JARClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void addPlugin(AbstractPlugin plugin) {
            plugin.start();
            this.plugins.addElement(plugin);
        }

        public AbstractPlugin[] getPlugins() {
            Object[] array = new AbstractPlugin[this.plugins.size()];
            this.plugins.copyInto(array);
            return array;
        }

        public JAR(String path, JARClassLoader classLoader) {
            this.path = path;
            this.classLoader = classLoader;
            this.plugins = new Vector();
        }

        void getPlugins(Vector vector) {
            for (int i = 0; i < this.plugins.size(); ++i) {
                vector.addElement(this.plugins.elementAt(i));
            }
        }
    }
}

