/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram;

import com.baselet.control.basics.geom.DimensionDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.diagram.FontHandler;
import com.baselet.diagram.FormattedFont;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import javax.swing.JComponent;

public class DiagramNotification
extends JComponent {
    private static final int BORDER_DISTANCE = 5;
    private static final double VBUFFER = 1.0;
    private static final long serialVersionUID = 1L;
    private final String message;
    private final Rectangle drawPanelSize;
    private static final Font notificationFont = new Font("SansSerif", 0, 10);
    private static final FontRenderContext frc = new FontRenderContext(null, true, true);
    private final Color textColor;
    private final Color backgroundColor;

    public DiagramNotification(Rectangle drawPanelSize, String message, Color textColor, Color backgroundColor) {
        this.message = message;
        this.drawPanelSize = drawPanelSize;
        this.textColor = textColor;
        this.backgroundColor = backgroundColor;
        this.setSize(100, 20);
        this.adaptDimensions();
    }

    @Override
    public final void paint(Graphics g) {
        String[] line;
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        Composite old = g2.getComposite();
        g2.setColor(this.textColor);
        g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
        g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        Font drawFont = g2.getFont();
        g2.setFont(notificationFont);
        this.adaptDimensions();
        int textX = 5;
        double textY = 3.75;
        g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
        for (String element : line = this.safeSplit(this.message)) {
            g2.drawString(element, textX, (int)(textY += this.textSize(element).getHeight() + 1.0));
        }
        g2.setComposite(AlphaComposite.getInstance(3, 0.05f));
        g2.setColor(this.backgroundColor);
        g2.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g2.setComposite(old);
        g2.setFont(drawFont);
    }

    private void adaptDimensions() {
        DimensionDouble fullTextSize = this.getTextblockDimensions(this.message);
        int x = (int)((double)this.drawPanelSize.getX2() - fullTextSize.getWidth() - 20.0);
        int y = this.drawPanelSize.getY() + 10;
        this.setLocation(x, y);
        this.setSize((int)fullTextSize.getWidth() + 10, (int)Math.round(fullTextSize.getHeight() + 10.0));
    }

    private DimensionDouble textSize(String line) {
        return FontHandler.getTextSizeStatic(new FormattedFont(line, (double)notificationFont.getSize(), notificationFont, frc));
    }

    private String[] safeSplit(String message) {
        String[] line = message.split("\n");
        if (line.length == 0) {
            line = new String[]{message};
        }
        return line;
    }

    private DimensionDouble getTextblockDimensions(String message) {
        double maxWidth = 0.0;
        double heightAccumulator = 0.0;
        for (String line : this.safeSplit(message)) {
            DimensionDouble dim = this.textSize(line);
            maxWidth = Math.max(maxWidth, dim.getWidth());
            heightAccumulator += dim.getHeight() + 1.0;
        }
        return new DimensionDouble(maxWidth, heightAccumulator);
    }
}

