/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import org.elasticsearch.action.admin.cluster.snapshots.status.TransportNodesSnapshotsStatus;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardRepository;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryTypesRegistry;
import org.elasticsearch.repositories.fs.FsRepository;
import org.elasticsearch.repositories.uri.URLRepository;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.snapshots.SnapshotsService;

public class RepositoriesModule
extends AbstractModule {
    private final RepositoryTypesRegistry repositoryTypes = new RepositoryTypesRegistry();

    public RepositoriesModule() {
        this.registerRepository("fs", FsRepository.class, BlobStoreIndexShardRepository.class);
        this.registerRepository("url", URLRepository.class, BlobStoreIndexShardRepository.class);
    }

    public void registerRepository(String type, Class<? extends Repository> repositoryType, Class<? extends IndexShardRepository> shardRepositoryType) {
        this.repositoryTypes.registerRepository(type, repositoryType, shardRepositoryType);
    }

    @Override
    protected void configure() {
        this.bind(RepositoriesService.class).asEagerSingleton();
        this.bind(SnapshotsService.class).asEagerSingleton();
        this.bind(SnapshotShardsService.class).asEagerSingleton();
        this.bind(TransportNodesSnapshotsStatus.class).asEagerSingleton();
        this.bind(RestoreService.class).asEagerSingleton();
        this.bind(RepositoryTypesRegistry.class).toInstance(this.repositoryTypes);
    }
}

