/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.gradle.internal;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.plugins.buildcomparison.gradle.GradleBuildInvocationSpec;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.internal.outcomes.ProjectOutcomes;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparableGradleBuildExecuter {
    public static final GradleVersion PROJECT_OUTCOMES_MINIMUM_VERSION = GradleVersion.version((String)"1.2");
    public static final GradleVersion EXEC_MINIMUM_VERSION = GradleVersion.version((String)"1.0");
    private final GradleBuildInvocationSpec spec;

    public ComparableGradleBuildExecuter(GradleBuildInvocationSpec spec) {
        this.spec = spec;
    }

    public GradleBuildInvocationSpec getSpec() {
        return this.spec;
    }

    public boolean isExecutable() {
        return this.getGradleVersion().compareTo(EXEC_MINIMUM_VERSION) >= 0;
    }

    public GradleVersion getGradleVersion() {
        return GradleVersion.version((String)this.getSpec().getGradleVersion());
    }

    public boolean isCanObtainProjectOutcomesModel() {
        boolean isMinimumVersionOrHigher;
        GradleVersion version = this.getGradleVersion();
        boolean bl = isMinimumVersionOrHigher = version.compareTo(PROJECT_OUTCOMES_MINIMUM_VERSION) >= 0;
        if (isMinimumVersionOrHigher) {
            return true;
        }
        return version.getBaseVersion().equals((Object)PROJECT_OUTCOMES_MINIMUM_VERSION);
    }

    private List<String> getImpliedArguments() {
        List<String> rawArgs = this.getSpec().getArguments();
        if (rawArgs.contains("-u") || rawArgs.contains("--no-search-upward")) {
            return rawArgs;
        }
        ArrayList<String> ammendedArgs = new ArrayList<String>(rawArgs.size() + 1);
        ammendedArgs.add("--no-search-upward");
        ammendedArgs.addAll(rawArgs);
        return ammendedArgs;
    }

    public ProjectOutcomes executeWith(ProjectConnection connection) {
        List<String> tasksList = this.getSpec().getTasks();
        String[] tasks = tasksList.toArray(new String[0]);
        List<String> argumentsList = this.getImpliedArguments();
        String[] arguments = argumentsList.toArray(new String[0]);
        if (this.isCanObtainProjectOutcomesModel()) {
            ModelBuilder modelBuilder = connection.model(ProjectOutcomes.class);
            return (ProjectOutcomes)((ModelBuilder)modelBuilder.withArguments(arguments)).forTasks(tasks).get();
        }
        BuildLauncher buildLauncher = connection.newBuild();
        ((BuildLauncher)buildLauncher.withArguments(arguments)).forTasks(tasks).run();
        return null;
    }
}

