import { Observable } from '../Observable';
/**
 * Returns an observable of a single number that represents the number of items that either:
 * Match a provided predicate function, _or_ if a predicate is not provided, the number
 * represents the total count of all items in the source observable. The count is emitted
 * by the returned observable when the source observable completes.
 * @param {function} [predicate] a boolean function to select what values are to be counted.
 * it is provided with arguments of:
 *   - `value`: the value from the source observable
 *   - `index`: the "index" of the value from the source observable
 *   - `source`: the source observable instance itself.
 * @return {Observable} an observable of one number that represents the count as described
 * above
 * @method count
 * @owner Observable
 */
export declare function count<T>(predicate?: (value: T, index: number, source: Observable<T>) => boolean): Observable<number>;
export interface CountSignature<T> {
    (predicate?: (value: T, index: number, source: Observable<T>) => boolean): Observable<number>;
}
