/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.SB;
import org.jmol.jvxl.readers.MapFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class MrcBinaryReader
extends MapFileReader {
    protected String[] labels;
    private static byte[] b8 = new byte[8];

    MrcBinaryReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader brNull) {
        String fileName = (String)((Object[])sg.getReaderData())[0];
        this.init2MFR(sg, this.br);
        this.binarydoc = this.newBinaryDocument();
        this.setStream(fileName, true);
        this.nSurfaces = 1;
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.allowSigma = true;
    }

    @Override
    protected void readParameters() throws Exception {
        int i;
        byte[] extra = new byte[100];
        byte[] map = new byte[4];
        byte[] machst = new byte[4];
        this.nx = this.binarydoc.readInt();
        if (this.nx < 0 || this.nx > 256) {
            this.setStream(null, false);
            this.nx = this.binarydoc.swapBytesI(this.nx);
            if (this.nx < 0 || this.nx > 1000) {
                Logger.info((String)("nx=" + this.nx + " not displayable as MRC file"));
                throw new Exception("MRC file type not readable");
            }
            Logger.info((String)"reading little-endian MRC file");
        }
        this.ny = this.binarydoc.readInt();
        this.nz = this.binarydoc.readInt();
        this.mode = this.binarydoc.readInt();
        if (this.mode < 0 || this.mode > 6) {
            this.setStream(null, false);
            this.nx = this.binarydoc.swapBytesI(this.nx);
            this.ny = this.binarydoc.swapBytesI(this.ny);
            this.nz = this.binarydoc.swapBytesI(this.nz);
            this.mode = this.binarydoc.swapBytesI(this.mode);
        }
        Logger.info((String)("MRC header: mode: " + this.mode));
        Logger.info((String)("MRC header: nx ny nz: " + this.nx + " " + this.ny + " " + this.nz));
        this.nxyzStart[0] = this.binarydoc.readInt();
        this.nxyzStart[1] = this.binarydoc.readInt();
        this.nxyzStart[2] = this.binarydoc.readInt();
        Logger.info((String)("MRC header: nxyzStart: " + this.nxyzStart[0] + " " + this.nxyzStart[1] + " " + this.nxyzStart[2]));
        this.na = this.binarydoc.readInt();
        this.nb = this.binarydoc.readInt();
        this.nc = this.binarydoc.readInt();
        if (this.na == 0) {
            this.na = this.nx - 1;
        }
        if (this.nb == 0) {
            this.nb = this.ny - 1;
        }
        if (this.nc == 0) {
            this.nc = this.nz - 1;
        }
        Logger.info((String)("MRC header: na nb nc: " + this.na + " " + this.nb + " " + this.nc));
        this.a = this.binarydoc.readFloat();
        this.b = this.binarydoc.readFloat();
        this.c = this.binarydoc.readFloat();
        this.alpha = this.binarydoc.readFloat();
        this.beta = this.binarydoc.readFloat();
        this.gamma = this.binarydoc.readFloat();
        if (this.alpha == 0.0f) {
            this.gamma = 90.0f;
            this.beta = 90.0f;
            this.alpha = 90.0f;
            Logger.info((String)"MRC header: alpha,beta,gamma 0 changed to 90,90,90");
            Logger.info((String)"MRC header: alpha,beta,gamma 0 reversing insideOut sense");
            if (this.params.thePlane == null) {
                this.params.insideOut = !this.params.insideOut;
            }
        }
        this.mapc = this.binarydoc.readInt();
        this.mapr = this.binarydoc.readInt();
        this.maps = this.binarydoc.readInt();
        String s = "" + this.mapc + this.mapr + this.maps;
        Logger.info((String)("MRC header: mapc mapr maps: " + s));
        if (this.params.thePlane == null && "21321".indexOf(s) >= 1) {
            Logger.info((String)"MRC header: data are xy-reversed");
            this.params.dataXYReversed = true;
        }
        this.dmin = this.binarydoc.readFloat();
        this.dmax = this.binarydoc.readFloat();
        this.dmean = this.binarydoc.readFloat();
        Logger.info((String)("MRC header: dmin,dmax,dmean: " + this.dmin + "," + this.dmax + "," + this.dmean));
        int ispg = this.binarydoc.readInt();
        int nsymbt = this.binarydoc.readInt();
        Logger.info((String)("MRC header: ispg,nsymbt: " + ispg + "," + nsymbt));
        this.binarydoc.readByteArray(extra, 0, extra.length);
        this.origin.x = this.binarydoc.readFloat();
        this.origin.y = this.binarydoc.readFloat();
        this.origin.z = this.binarydoc.readFloat();
        Logger.info((String)("MRC header: origin: " + this.origin));
        this.binarydoc.readByteArray(map, 0, map.length);
        this.binarydoc.readByteArray(machst, 0, machst.length);
        float rmsDeviation = this.binarydoc.readFloat();
        Logger.info((String)("MRC header: rms: " + rmsDeviation));
        int nlabel = this.binarydoc.readInt();
        Logger.info((String)("MRC header: labels: " + nlabel));
        this.labels = new String[nlabel];
        if (nlabel > 0) {
            this.labels[0] = "Jmol MrcBinaryReader";
        }
        for (i = 0; i < 10; ++i) {
            s = this.binarydoc.readString(80).trim();
            if (i >= nlabel) continue;
            this.labels[i] = s;
            Logger.info((String)this.labels[i]);
        }
        for (i = 0; i < nsymbt; i += 80) {
            long position = this.binarydoc.getPosition();
            s = this.binarydoc.readString(80).trim();
            if (s.indexOf(0) != s.lastIndexOf(0)) {
                Logger.error((String)("File indicates " + nsymbt + " symmetry lines, but " + i + " found!"));
                this.binarydoc.seek(position);
                break;
            }
            Logger.info((String)("MRC file symmetry information: " + s));
        }
        Logger.info((String)("MRC header: bytes read: " + this.binarydoc.getPosition() + "\n"));
        this.getVectorsAndOrigin();
        if (this.params.thePlane == null && (this.params.cutoffAutomatic || !Float.isNaN(this.params.sigma))) {
            float sigma = this.params.sigma < 0.0f || Float.isNaN(this.params.sigma) ? 1.0f : this.params.sigma;
            this.params.cutoff = rmsDeviation * sigma + this.dmean;
            Logger.info((String)("Cutoff set to (mean + rmsDeviation*" + sigma + " = " + this.params.cutoff + ")\n"));
        }
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("MRC DATA ").append(nlabel > 0 ? this.labels[0] : "").append("\n");
        this.jvxlFileHeaderBuffer.append("see http://ami.scripps.edu/software/mrctools/mrc_specification.php\n");
    }

    @Override
    protected float nextVoxel() throws Exception {
        float voxelValue;
        switch (this.mode) {
            case 0: {
                voxelValue = this.binarydoc.readByte();
                break;
            }
            case 1: {
                voxelValue = this.binarydoc.readShort();
                break;
            }
            default: {
                voxelValue = this.binarydoc.readFloat();
                break;
            }
            case 3: {
                voxelValue = this.binarydoc.readShort();
                this.binarydoc.readShort();
                break;
            }
            case 4: {
                voxelValue = this.binarydoc.readFloat();
                this.binarydoc.readFloat();
                break;
            }
            case 6: {
                voxelValue = this.binarydoc.readUnsignedShort();
            }
        }
        this.nBytes = this.binarydoc.getPosition();
        if (voxelValue > 1000.0f) {
            System.out.println(this.nBytes + " " + voxelValue);
        }
        return voxelValue;
    }

    @Override
    protected void skipData(int nPoints) throws Exception {
        block5: for (int i = 0; i < nPoints; ++i) {
            switch (this.mode) {
                case 0: {
                    this.binarydoc.readByte();
                    continue block5;
                }
                case 1: 
                case 6: {
                    this.binarydoc.readByteArray(b8, 0, 2);
                    continue block5;
                }
                default: {
                    this.binarydoc.readByteArray(b8, 0, 4);
                    continue block5;
                }
                case 4: {
                    this.binarydoc.readByteArray(b8, 0, 8);
                }
            }
        }
    }
}

