/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.ConcatRope;
import org.jruby.truffle.core.rope.LazyIntRope;
import org.jruby.truffle.core.rope.LazyRope;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.RepeatingRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeBuffer;
import org.jruby.truffle.core.rope.RopeGuards;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.rope.SubstringRope;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=RopeNodes.class)
public final class RopeNodesFactory {

    @GeneratedBy(value=RopeNodes.FlattenNode.class)
    @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
    public static final class FlattenNodeGen
    extends RopeNodes.FlattenNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode rope_;
        @Node.Child
        private BaseNode_ specialization_;

        private FlattenNodeGen(RubyContext context, SourceSection sourceSection, RubyNode rope) {
            super(context, sourceSection);
            this.rope_ = rope;
            this.specialization_ = UninitializedNode_.create(this);
        }

        @Override
        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public LeafRope executeFlatten(Rope ropeValue) {
            return this.specialization_.executeLeafRope(ropeValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        @Override
        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        @Override
        public Node deepCopy() {
            return SpecializationNode.updateRoot(super.deepCopy());
        }

        public static RopeNodes.FlattenNode create(RubyContext context, SourceSection sourceSection, RubyNode rope) {
            return new FlattenNodeGen(context, sourceSection, rope);
        }

        @GeneratedBy(methodName="flatten(Rope)", value=RopeNodes.FlattenNode.class)
        private static final class FlattenNode_
        extends BaseNode_ {
            FlattenNode_(FlattenNodeGen root) {
                super(root, 3);
            }

            @Override
            public LeafRope executeLeafRope(Rope ropeValue) {
                if (!RopeGuards.isLeafRope(ropeValue) && ropeValue.getRawBytes() == null) {
                    return this.root.flatten(ropeValue);
                }
                return this.getNext().executeLeafRope(ropeValue);
            }

            @Override
            public LeafRope executeLeafRope_(Object ropeValue) {
                Rope ropeValue_;
                if (ropeValue instanceof Rope && !RopeGuards.isLeafRope(ropeValue_ = (Rope)ropeValue) && ropeValue_.getRawBytes() == null) {
                    return this.root.flatten(ropeValue_);
                }
                return this.getNext().executeLeafRope_(ropeValue);
            }

            static BaseNode_ create(FlattenNodeGen root) {
                return new FlattenNode_(root);
            }
        }

        @GeneratedBy(methodName="flattenNonLeafWithBytes(Rope)", value=RopeNodes.FlattenNode.class)
        private static final class FlattenNonLeafWithBytesNode_
        extends BaseNode_ {
            FlattenNonLeafWithBytesNode_(FlattenNodeGen root) {
                super(root, 2);
            }

            @Override
            public LeafRope executeLeafRope(Rope ropeValue) {
                if (!RopeGuards.isLeafRope(ropeValue) && ropeValue.getRawBytes() != null) {
                    return this.root.flattenNonLeafWithBytes(ropeValue);
                }
                return this.getNext().executeLeafRope(ropeValue);
            }

            @Override
            public LeafRope executeLeafRope_(Object ropeValue) {
                Rope ropeValue_;
                if (ropeValue instanceof Rope && !RopeGuards.isLeafRope(ropeValue_ = (Rope)ropeValue) && ropeValue_.getRawBytes() != null) {
                    return this.root.flattenNonLeafWithBytes(ropeValue_);
                }
                return this.getNext().executeLeafRope_(ropeValue);
            }

            static BaseNode_ create(FlattenNodeGen root) {
                return new FlattenNonLeafWithBytesNode_(root);
            }
        }

        @GeneratedBy(methodName="flattenLeafRope(LeafRope)", value=RopeNodes.FlattenNode.class)
        private static final class FlattenLeafRopeNode_
        extends BaseNode_ {
            FlattenLeafRopeNode_(FlattenNodeGen root) {
                super(root, 1);
            }

            @Override
            public LeafRope executeLeafRope_(Object ropeValue) {
                if (ropeValue instanceof LeafRope) {
                    LeafRope ropeValue_ = (LeafRope)ropeValue;
                    return this.root.flattenLeafRope(ropeValue_);
                }
                return this.getNext().executeLeafRope_(ropeValue);
            }

            static BaseNode_ create(FlattenNodeGen root) {
                return new FlattenLeafRopeNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.FlattenNode.class)
        private static final class PolymorphicNode_
        extends BaseNode_ {
            PolymorphicNode_(FlattenNodeGen root) {
                super(root, 0);
            }

            @Override
            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object ropeValue) {
                return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, ropeValue));
            }

            @Override
            public LeafRope executeLeafRope_(Object ropeValue) {
                return this.getNext().executeLeafRope_(ropeValue);
            }

            static BaseNode_ create(FlattenNodeGen root) {
                return new PolymorphicNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.FlattenNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(FlattenNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public LeafRope executeLeafRope_(Object ropeValue) {
                return (LeafRope)this.uninitialized((Frame)null, ropeValue);
            }

            static BaseNode_ create(FlattenNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.FlattenNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            @CompilerDirectives.CompilationFinal
            protected FlattenNodeGen root;

            BaseNode_(FlattenNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            @Override
            protected final void setRoot(Node root) {
                this.root = (FlattenNodeGen)root;
            }

            @Override
            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.rope_};
            }

            @Override
            public final Object acceptAndExecute(Frame frameValue, Object ropeValue) {
                return this.executeLeafRope_(ropeValue);
            }

            public abstract LeafRope executeLeafRope_(Object var1);

            public LeafRope executeLeafRope(Rope ropeValue) {
                return this.executeLeafRope_(ropeValue);
            }

            public Object execute(VirtualFrame frameValue) {
                Object ropeValue_ = this.root.rope_.execute(frameValue);
                return this.executeLeafRope_(ropeValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            @Override
            protected final SpecializationNode createNext(Frame frameValue, Object ropeValue) {
                if (ropeValue instanceof LeafRope) {
                    return FlattenLeafRopeNode_.create(this.root);
                }
                if (ropeValue instanceof Rope) {
                    Rope ropeValue_ = (Rope)ropeValue;
                    if (!RopeGuards.isLeafRope(ropeValue_) && ropeValue_.getRawBytes() != null) {
                        return FlattenNonLeafWithBytesNode_.create(this.root);
                    }
                    if (!RopeGuards.isLeafRope(ropeValue_) && ropeValue_.getRawBytes() == null) {
                        return FlattenNode_.create(this.root);
                    }
                }
                return null;
            }

            @Override
            protected final SpecializationNode createPolymorphic() {
                return PolymorphicNode_.create(this.root);
            }

            protected final BaseNode_ getNext() {
                return (BaseNode_)this.next;
            }
        }
    }

    @GeneratedBy(value=RopeNodes.GetByteNode.class)
    @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
    public static final class GetByteNodeGen
    extends RopeNodes.GetByteNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode rope_;
        @Node.Child
        private RubyNode index_;
        @CompilerDirectives.CompilationFinal
        private Class<?> indexType_;
        @Node.Child
        private BaseNode_ specialization_;

        private GetByteNodeGen(RubyNode rope, RubyNode index) {
            this.rope_ = rope;
            this.index_ = index;
            this.specialization_ = UninitializedNode_.create(this);
        }

        @Override
        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public int executeGetByte(Rope ropeValue, int indexValue) {
            return this.specialization_.executeInt1(ropeValue, indexValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        @Override
        public int executeInteger(VirtualFrame frameValue) {
            return this.specialization_.executeInt0(frameValue);
        }

        @Override
        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        @Override
        public Node deepCopy() {
            return SpecializationNode.updateRoot(super.deepCopy());
        }

        private static ConcatRope expectConcatRope(Object value) throws UnexpectedResultException {
            if (value instanceof ConcatRope) {
                return (ConcatRope)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static LazyRope expectLazyRope(Object value) throws UnexpectedResultException {
            if (value instanceof LazyRope) {
                return (LazyRope)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static RepeatingRope expectRepeatingRope(Object value) throws UnexpectedResultException {
            if (value instanceof RepeatingRope) {
                return (RepeatingRope)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static SubstringRope expectSubstringRope(Object value) throws UnexpectedResultException {
            if (value instanceof SubstringRope) {
                return (SubstringRope)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static Rope expectRope(Object value) throws UnexpectedResultException {
            if (value instanceof Rope) {
                return (Rope)value;
            }
            throw new UnexpectedResultException(value);
        }

        public static RopeNodes.GetByteNode create(RubyNode rope, RubyNode index) {
            return new GetByteNodeGen(rope, index);
        }

        @GeneratedBy(methodName="getByteConcatRope(ConcatRope, int, ConditionProfile, ConditionProfile, ConditionProfile)", value=RopeNodes.GetByteNode.class)
        private static final class GetByteConcatRopeNode_
        extends BaseNode_ {
            private final ConditionProfile chooseLeftChildProfile;
            private final ConditionProfile leftChildRawBytesNullProfile;
            private final ConditionProfile rightChildRawBytesNullProfile;
            private final Class<?> indexImplicitType;

            GetByteConcatRopeNode_(GetByteNodeGen root, Object indexValue, ConditionProfile chooseLeftChildProfile, ConditionProfile leftChildRawBytesNullProfile, ConditionProfile rightChildRawBytesNullProfile) {
                super(root, 5);
                this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
                this.chooseLeftChildProfile = chooseLeftChildProfile;
                this.leftChildRawBytesNullProfile = leftChildRawBytesNullProfile;
                this.rightChildRawBytesNullProfile = rightChildRawBytesNullProfile;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.indexImplicitType == ((GetByteConcatRopeNode_)other).indexImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInt0(frameValue);
            }

            @Override
            public int executeInt0(VirtualFrame frameValue) {
                int indexValue_;
                ConcatRope ropeValue_;
                try {
                    ropeValue_ = GetByteNodeGen.expectConcatRope(this.root.rope_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue = this.executeIndex_(frameValue);
                    return this.getNext().executeInt_(ex.getResult(), indexValue);
                }
                try {
                    if (this.indexImplicitType == Integer.TYPE) {
                        indexValue_ = this.root.index_.executeInteger(frameValue);
                    } else {
                        Object indexValue__ = this.executeIndex_(frameValue);
                        indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeInt_(ropeValue_, ex.getResult());
                }
                if (ropeValue_.getRawBytes() == null) {
                    return this.root.getByteConcatRope(ropeValue_, indexValue_, this.chooseLeftChildProfile, this.leftChildRawBytesNullProfile, this.rightChildRawBytesNullProfile);
                }
                return this.getNext().executeInt_(ropeValue_, indexValue_);
            }

            @Override
            public int executeInt1(Rope ropeValue, int indexValue) {
                ConcatRope ropeValue_;
                if (ropeValue instanceof ConcatRope && (ropeValue_ = (ConcatRope)ropeValue).getRawBytes() == null) {
                    return this.root.getByteConcatRope(ropeValue_, indexValue, this.chooseLeftChildProfile, this.leftChildRawBytesNullProfile, this.rightChildRawBytesNullProfile);
                }
                return this.getNext().executeInt1(ropeValue, indexValue);
            }

            @Override
            public int executeInt_(Object ropeValue, Object indexValue) {
                if (ropeValue instanceof ConcatRope && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                    ConcatRope ropeValue_ = (ConcatRope)ropeValue;
                    int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                    if (ropeValue_.getRawBytes() == null) {
                        return this.root.getByteConcatRope(ropeValue_, indexValue_, this.chooseLeftChildProfile, this.leftChildRawBytesNullProfile, this.rightChildRawBytesNullProfile);
                    }
                }
                return this.getNext().executeInt_(ropeValue, indexValue);
            }

            static BaseNode_ create(GetByteNodeGen root, Object indexValue, ConditionProfile chooseLeftChildProfile, ConditionProfile leftChildRawBytesNullProfile, ConditionProfile rightChildRawBytesNullProfile) {
                return new GetByteConcatRopeNode_(root, indexValue, chooseLeftChildProfile, leftChildRawBytesNullProfile, rightChildRawBytesNullProfile);
            }
        }

        @GeneratedBy(methodName="getByteRepeatingRope(RepeatingRope, int, ConditionProfile)", value=RopeNodes.GetByteNode.class)
        private static final class GetByteRepeatingRopeNode_
        extends BaseNode_ {
            private final ConditionProfile childRawBytesNullProfile;
            private final Class<?> indexImplicitType;

            GetByteRepeatingRopeNode_(GetByteNodeGen root, Object indexValue, ConditionProfile childRawBytesNullProfile) {
                super(root, 4);
                this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
                this.childRawBytesNullProfile = childRawBytesNullProfile;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.indexImplicitType == ((GetByteRepeatingRopeNode_)other).indexImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInt0(frameValue);
            }

            @Override
            public int executeInt0(VirtualFrame frameValue) {
                int indexValue_;
                RepeatingRope ropeValue_;
                try {
                    ropeValue_ = GetByteNodeGen.expectRepeatingRope(this.root.rope_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue = this.executeIndex_(frameValue);
                    return this.getNext().executeInt_(ex.getResult(), indexValue);
                }
                try {
                    if (this.indexImplicitType == Integer.TYPE) {
                        indexValue_ = this.root.index_.executeInteger(frameValue);
                    } else {
                        Object indexValue__ = this.executeIndex_(frameValue);
                        indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeInt_(ropeValue_, ex.getResult());
                }
                if (ropeValue_.getRawBytes() == null) {
                    return this.root.getByteRepeatingRope(ropeValue_, indexValue_, this.childRawBytesNullProfile);
                }
                return this.getNext().executeInt_(ropeValue_, indexValue_);
            }

            @Override
            public int executeInt1(Rope ropeValue, int indexValue) {
                RepeatingRope ropeValue_;
                if (ropeValue instanceof RepeatingRope && (ropeValue_ = (RepeatingRope)ropeValue).getRawBytes() == null) {
                    return this.root.getByteRepeatingRope(ropeValue_, indexValue, this.childRawBytesNullProfile);
                }
                return this.getNext().executeInt1(ropeValue, indexValue);
            }

            @Override
            public int executeInt_(Object ropeValue, Object indexValue) {
                if (ropeValue instanceof RepeatingRope && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                    RepeatingRope ropeValue_ = (RepeatingRope)ropeValue;
                    int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                    if (ropeValue_.getRawBytes() == null) {
                        return this.root.getByteRepeatingRope(ropeValue_, indexValue_, this.childRawBytesNullProfile);
                    }
                }
                return this.getNext().executeInt_(ropeValue, indexValue);
            }

            static BaseNode_ create(GetByteNodeGen root, Object indexValue, ConditionProfile childRawBytesNullProfile) {
                return new GetByteRepeatingRopeNode_(root, indexValue, childRawBytesNullProfile);
            }
        }

        @GeneratedBy(methodName="getByteSubstringRope(SubstringRope, int, ConditionProfile)", value=RopeNodes.GetByteNode.class)
        private static final class GetByteSubstringRopeNode_
        extends BaseNode_ {
            private final ConditionProfile childRawBytesNullProfile;
            private final Class<?> indexImplicitType;

            GetByteSubstringRopeNode_(GetByteNodeGen root, Object indexValue, ConditionProfile childRawBytesNullProfile) {
                super(root, 3);
                this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
                this.childRawBytesNullProfile = childRawBytesNullProfile;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.indexImplicitType == ((GetByteSubstringRopeNode_)other).indexImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInt0(frameValue);
            }

            @Override
            public int executeInt0(VirtualFrame frameValue) {
                int indexValue_;
                SubstringRope ropeValue_;
                try {
                    ropeValue_ = GetByteNodeGen.expectSubstringRope(this.root.rope_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue = this.executeIndex_(frameValue);
                    return this.getNext().executeInt_(ex.getResult(), indexValue);
                }
                try {
                    if (this.indexImplicitType == Integer.TYPE) {
                        indexValue_ = this.root.index_.executeInteger(frameValue);
                    } else {
                        Object indexValue__ = this.executeIndex_(frameValue);
                        indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeInt_(ropeValue_, ex.getResult());
                }
                if (ropeValue_.getRawBytes() == null) {
                    return this.root.getByteSubstringRope(ropeValue_, indexValue_, this.childRawBytesNullProfile);
                }
                return this.getNext().executeInt_(ropeValue_, indexValue_);
            }

            @Override
            public int executeInt1(Rope ropeValue, int indexValue) {
                SubstringRope ropeValue_;
                if (ropeValue instanceof SubstringRope && (ropeValue_ = (SubstringRope)ropeValue).getRawBytes() == null) {
                    return this.root.getByteSubstringRope(ropeValue_, indexValue, this.childRawBytesNullProfile);
                }
                return this.getNext().executeInt1(ropeValue, indexValue);
            }

            @Override
            public int executeInt_(Object ropeValue, Object indexValue) {
                if (ropeValue instanceof SubstringRope && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                    SubstringRope ropeValue_ = (SubstringRope)ropeValue;
                    int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                    if (ropeValue_.getRawBytes() == null) {
                        return this.root.getByteSubstringRope(ropeValue_, indexValue_, this.childRawBytesNullProfile);
                    }
                }
                return this.getNext().executeInt_(ropeValue, indexValue);
            }

            static BaseNode_ create(GetByteNodeGen root, Object indexValue, ConditionProfile childRawBytesNullProfile) {
                return new GetByteSubstringRopeNode_(root, indexValue, childRawBytesNullProfile);
            }
        }

        @GeneratedBy(methodName="getByte(LazyRope, int)", value=RopeNodes.GetByteNode.class)
        private static final class GetByte1Node_
        extends BaseNode_ {
            private final Class<?> indexImplicitType;

            GetByte1Node_(GetByteNodeGen root, Object indexValue) {
                super(root, 2);
                this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.indexImplicitType == ((GetByte1Node_)other).indexImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInt0(frameValue);
            }

            @Override
            public int executeInt0(VirtualFrame frameValue) {
                int indexValue_;
                LazyRope ropeValue_;
                try {
                    ropeValue_ = GetByteNodeGen.expectLazyRope(this.root.rope_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue = this.executeIndex_(frameValue);
                    return this.getNext().executeInt_(ex.getResult(), indexValue);
                }
                try {
                    if (this.indexImplicitType == Integer.TYPE) {
                        indexValue_ = this.root.index_.executeInteger(frameValue);
                    } else {
                        Object indexValue__ = this.executeIndex_(frameValue);
                        indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeInt_(ropeValue_, ex.getResult());
                }
                if (ropeValue_.getRawBytes() == null) {
                    return this.root.getByte(ropeValue_, indexValue_);
                }
                return this.getNext().executeInt_(ropeValue_, indexValue_);
            }

            @Override
            public int executeInt1(Rope ropeValue, int indexValue) {
                LazyRope ropeValue_;
                if (ropeValue instanceof LazyRope && (ropeValue_ = (LazyRope)ropeValue).getRawBytes() == null) {
                    return this.root.getByte(ropeValue_, indexValue);
                }
                return this.getNext().executeInt1(ropeValue, indexValue);
            }

            @Override
            public int executeInt_(Object ropeValue, Object indexValue) {
                if (ropeValue instanceof LazyRope && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                    LazyRope ropeValue_ = (LazyRope)ropeValue;
                    int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                    if (ropeValue_.getRawBytes() == null) {
                        return this.root.getByte(ropeValue_, indexValue_);
                    }
                }
                return this.getNext().executeInt_(ropeValue, indexValue);
            }

            static BaseNode_ create(GetByteNodeGen root, Object indexValue) {
                return new GetByte1Node_(root, indexValue);
            }
        }

        @GeneratedBy(methodName="getByte(Rope, int)", value=RopeNodes.GetByteNode.class)
        private static final class GetByte0Node_
        extends BaseNode_ {
            private final Class<?> indexImplicitType;

            GetByte0Node_(GetByteNodeGen root, Object indexValue) {
                super(root, 1);
                this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.indexImplicitType == ((GetByte0Node_)other).indexImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInt0(frameValue);
            }

            @Override
            public int executeInt0(VirtualFrame frameValue) {
                int indexValue_;
                Rope ropeValue_;
                try {
                    ropeValue_ = GetByteNodeGen.expectRope(this.root.rope_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue = this.executeIndex_(frameValue);
                    return this.getNext().executeInt_(ex.getResult(), indexValue);
                }
                try {
                    if (this.indexImplicitType == Integer.TYPE) {
                        indexValue_ = this.root.index_.executeInteger(frameValue);
                    } else {
                        Object indexValue__ = this.executeIndex_(frameValue);
                        indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeInt_(ropeValue_, ex.getResult());
                }
                if (ropeValue_.getRawBytes() != null) {
                    return this.root.getByte(ropeValue_, indexValue_);
                }
                return this.getNext().executeInt_(ropeValue_, indexValue_);
            }

            @Override
            public int executeInt1(Rope ropeValue, int indexValue) {
                if (ropeValue.getRawBytes() != null) {
                    return this.root.getByte(ropeValue, indexValue);
                }
                return this.getNext().executeInt1(ropeValue, indexValue);
            }

            @Override
            public int executeInt_(Object ropeValue, Object indexValue) {
                if (ropeValue instanceof Rope && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                    Rope ropeValue_ = (Rope)ropeValue;
                    int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                    if (ropeValue_.getRawBytes() != null) {
                        return this.root.getByte(ropeValue_, indexValue_);
                    }
                }
                return this.getNext().executeInt_(ropeValue, indexValue);
            }

            static BaseNode_ create(GetByteNodeGen root, Object indexValue) {
                return new GetByte0Node_(root, indexValue);
            }
        }

        @GeneratedBy(value=RopeNodes.GetByteNode.class)
        private static final class PolymorphicNode_
        extends BaseNode_ {
            PolymorphicNode_(GetByteNodeGen root) {
                super(root, 0);
            }

            @Override
            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object ropeValue, Object indexValue) {
                return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, ropeValue, indexValue));
            }

            @Override
            public int executeInt0(VirtualFrame frameValue) {
                Object ropeValue_ = this.root.rope_.execute(frameValue);
                Object indexValue_ = this.executeIndex_(frameValue);
                return this.getNext().executeInt_(ropeValue_, indexValue_);
            }

            @Override
            public int executeInt1(Rope ropeValue, int indexValue) {
                return this.getNext().executeInt1(ropeValue, indexValue);
            }

            @Override
            public int executeInt_(Object ropeValue, Object indexValue) {
                return this.getNext().executeInt_(ropeValue, indexValue);
            }

            static BaseNode_ create(GetByteNodeGen root) {
                return new PolymorphicNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.GetByteNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(GetByteNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public int executeInt_(Object ropeValue, Object indexValue) {
                return (Integer)this.uninitialized((Frame)null, ropeValue, indexValue);
            }

            static BaseNode_ create(GetByteNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.GetByteNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            @CompilerDirectives.CompilationFinal
            protected GetByteNodeGen root;

            BaseNode_(GetByteNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            @Override
            protected final void setRoot(Node root) {
                this.root = (GetByteNodeGen)root;
            }

            @Override
            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.rope_, this.root.index_};
            }

            @Override
            public final Object acceptAndExecute(Frame frameValue, Object ropeValue, Object indexValue) {
                return this.executeInt_(ropeValue, indexValue);
            }

            public abstract int executeInt_(Object var1, Object var2);

            public int executeInt1(Rope ropeValue, int indexValue) {
                return this.executeInt_(ropeValue, indexValue);
            }

            public Object execute(VirtualFrame frameValue) {
                Object ropeValue_ = this.root.rope_.execute(frameValue);
                Object indexValue_ = this.executeIndex_(frameValue);
                return this.executeInt_(ropeValue_, indexValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            public int executeInt0(VirtualFrame frameValue) {
                return (Integer)this.execute(frameValue);
            }

            @Override
            protected final SpecializationNode createNext(Frame frameValue, Object ropeValue, Object indexValue) {
                if (RubyTypesGen.isImplicitInteger(indexValue)) {
                    Rope ropeValue_;
                    if (ropeValue instanceof Rope && (ropeValue_ = (Rope)ropeValue).getRawBytes() != null) {
                        return GetByte0Node_.create(this.root, indexValue);
                    }
                    if (ropeValue instanceof LazyRope && (ropeValue_ = (LazyRope)ropeValue).getRawBytes() == null) {
                        return GetByte1Node_.create(this.root, indexValue);
                    }
                    if (ropeValue instanceof SubstringRope && (ropeValue_ = (SubstringRope)ropeValue).getRawBytes() == null) {
                        ConditionProfile childRawBytesNullProfile3 = ConditionProfile.createBinaryProfile();
                        return GetByteSubstringRopeNode_.create(this.root, indexValue, childRawBytesNullProfile3);
                    }
                    if (ropeValue instanceof RepeatingRope && (ropeValue_ = (RepeatingRope)ropeValue).getRawBytes() == null) {
                        ConditionProfile childRawBytesNullProfile4 = ConditionProfile.createBinaryProfile();
                        return GetByteRepeatingRopeNode_.create(this.root, indexValue, childRawBytesNullProfile4);
                    }
                    if (ropeValue instanceof ConcatRope && (ropeValue_ = (ConcatRope)ropeValue).getRawBytes() == null) {
                        ConditionProfile chooseLeftChildProfile5 = ConditionProfile.createBinaryProfile();
                        ConditionProfile leftChildRawBytesNullProfile5 = ConditionProfile.createBinaryProfile();
                        ConditionProfile rightChildRawBytesNullProfile5 = ConditionProfile.createBinaryProfile();
                        return GetByteConcatRopeNode_.create(this.root, indexValue, chooseLeftChildProfile5, leftChildRawBytesNullProfile5, rightChildRawBytesNullProfile5);
                    }
                }
                return null;
            }

            @Override
            protected final SpecializationNode createPolymorphic() {
                return PolymorphicNode_.create(this.root);
            }

            protected final BaseNode_ getNext() {
                return (BaseNode_)this.next;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected final Object executeIndex_(Frame frameValue) {
                Object object;
                Class indexType_ = this.root.indexType_;
                if (indexType_ == Integer.TYPE) {
                    return this.root.index_.executeInteger((VirtualFrame)frameValue);
                }
                if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Class<Object> _type = Object.class;
                try {
                    Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                    _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                    object = _value;
                }
                catch (Throwable throwable) {
                    try {
                        this.root.indexType_ = _type;
                        throw throwable;
                    }
                    catch (UnexpectedResultException ex) {
                        this.root.indexType_ = Object.class;
                        return ex.getResult();
                    }
                }
                this.root.indexType_ = _type;
                return object;
            }
        }
    }

    @GeneratedBy(value=RopeNodes.WithEncodingNode.class)
    @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
    public static final class WithEncodingNodeGen
    extends RopeNodes.WithEncodingNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode rope_;
        @Node.Child
        private RubyNode encoding_;
        @Node.Child
        private RubyNode codeRange_;
        @Node.Child
        private BaseNode_ specialization_;

        private WithEncodingNodeGen(RubyNode rope, RubyNode encoding, RubyNode codeRange) {
            this.rope_ = rope;
            this.encoding_ = encoding;
            this.codeRange_ = codeRange;
            this.specialization_ = UninitializedNode_.create(this);
        }

        @Override
        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public Rope executeWithEncoding(Rope ropeValue, Encoding encodingValue, CodeRange codeRangeValue) {
            return this.specialization_.executeRope(ropeValue, encodingValue, codeRangeValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        @Override
        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        @Override
        public Node deepCopy() {
            return SpecializationNode.updateRoot(super.deepCopy());
        }

        public static RopeNodes.WithEncodingNode create(RubyNode rope, RubyNode encoding, RubyNode codeRange) {
            return new WithEncodingNodeGen(rope, encoding, codeRange);
        }

        @GeneratedBy(methodName="withEncoding(Rope, Encoding, CodeRange, MakeLeafRopeNode)", value=RopeNodes.WithEncodingNode.class)
        private static final class WithEncodingNode_
        extends BaseNode_ {
            @Node.Child
            private RopeNodes.MakeLeafRopeNode makeLeafRopeNode;

            WithEncodingNode_(WithEncodingNodeGen root, RopeNodes.MakeLeafRopeNode makeLeafRopeNode) {
                super(root, 4);
                this.makeLeafRopeNode = makeLeafRopeNode;
            }

            @Override
            public Rope executeRope(Rope ropeValue, Encoding encodingValue, CodeRange codeRangeValue) {
                if (ropeValue.getEncoding() != encodingValue && ropeValue.getCodeRange() != codeRangeValue && !RopeNodes.WithEncodingNode.isAsciiCompatbileChange(ropeValue, encodingValue)) {
                    return this.root.withEncoding(ropeValue, encodingValue, codeRangeValue, this.makeLeafRopeNode);
                }
                return this.getNext().executeRope(ropeValue, encodingValue, codeRangeValue);
            }

            @Override
            public Rope executeRope_(Object ropeValue, Object encodingValue, Object codeRangeValue) {
                if (ropeValue instanceof Rope && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    Rope ropeValue_ = (Rope)ropeValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (ropeValue_.getEncoding() != encodingValue_ && ropeValue_.getCodeRange() != codeRangeValue_ && !RopeNodes.WithEncodingNode.isAsciiCompatbileChange(ropeValue_, encodingValue_)) {
                        return this.root.withEncoding(ropeValue_, encodingValue_, codeRangeValue_, this.makeLeafRopeNode);
                    }
                }
                return this.getNext().executeRope_(ropeValue, encodingValue, codeRangeValue);
            }

            static BaseNode_ create(WithEncodingNodeGen root, RopeNodes.MakeLeafRopeNode makeLeafRopeNode) {
                return new WithEncodingNode_(root, makeLeafRopeNode);
            }
        }

        @GeneratedBy(methodName="withEncodingCr7Bit(Rope, Encoding, CodeRange, Class<? extends Rope>)", value=RopeNodes.WithEncodingNode.class)
        private static final class WithEncodingCr7BitNode_
        extends BaseNode_ {
            private final Class<? extends Rope> cachedRopeClass;

            WithEncodingCr7BitNode_(WithEncodingNodeGen root, Class<? extends Rope> cachedRopeClass) {
                super(root, 3);
                this.cachedRopeClass = cachedRopeClass;
            }

            @Override
            public boolean isIdentical(SpecializationNode other, Frame frameValue, Object ropeValue, Object encodingValue, Object codeRangeValue) {
                if (ropeValue instanceof Rope && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    Rope ropeValue_ = (Rope)ropeValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (ropeValue_.getEncoding() != encodingValue_ && ropeValue_.getCodeRange() != codeRangeValue_ && RopeNodes.WithEncodingNode.isAsciiCompatbileChange(ropeValue_, encodingValue_) && ropeValue_.getClass() == this.cachedRopeClass) {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Rope executeRope(Rope ropeValue, Encoding encodingValue, CodeRange codeRangeValue) {
                if (ropeValue.getEncoding() != encodingValue && ropeValue.getCodeRange() != codeRangeValue && RopeNodes.WithEncodingNode.isAsciiCompatbileChange(ropeValue, encodingValue) && ropeValue.getClass() == this.cachedRopeClass) {
                    return this.root.withEncodingCr7Bit(ropeValue, encodingValue, codeRangeValue, this.cachedRopeClass);
                }
                return this.getNext().executeRope(ropeValue, encodingValue, codeRangeValue);
            }

            @Override
            public Rope executeRope_(Object ropeValue, Object encodingValue, Object codeRangeValue) {
                if (ropeValue instanceof Rope && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    Rope ropeValue_ = (Rope)ropeValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (ropeValue_.getEncoding() != encodingValue_ && ropeValue_.getCodeRange() != codeRangeValue_ && RopeNodes.WithEncodingNode.isAsciiCompatbileChange(ropeValue_, encodingValue_) && ropeValue_.getClass() == this.cachedRopeClass) {
                        return this.root.withEncodingCr7Bit(ropeValue_, encodingValue_, codeRangeValue_, this.cachedRopeClass);
                    }
                }
                return this.getNext().executeRope_(ropeValue, encodingValue, codeRangeValue);
            }

            static BaseNode_ create(WithEncodingNodeGen root, Class<? extends Rope> cachedRopeClass) {
                return new WithEncodingCr7BitNode_(root, cachedRopeClass);
            }
        }

        @GeneratedBy(methodName="withEncodingSameCodeRange(Rope, Encoding, CodeRange)", value=RopeNodes.WithEncodingNode.class)
        private static final class WithEncodingSameCodeRangeNode_
        extends BaseNode_ {
            WithEncodingSameCodeRangeNode_(WithEncodingNodeGen root) {
                super(root, 2);
            }

            @Override
            public Rope executeRope(Rope ropeValue, Encoding encodingValue, CodeRange codeRangeValue) {
                if (ropeValue.getEncoding() != encodingValue && ropeValue.getCodeRange() == codeRangeValue) {
                    return this.root.withEncodingSameCodeRange(ropeValue, encodingValue, codeRangeValue);
                }
                return this.getNext().executeRope(ropeValue, encodingValue, codeRangeValue);
            }

            @Override
            public Rope executeRope_(Object ropeValue, Object encodingValue, Object codeRangeValue) {
                if (ropeValue instanceof Rope && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    Rope ropeValue_ = (Rope)ropeValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (ropeValue_.getEncoding() != encodingValue_ && ropeValue_.getCodeRange() == codeRangeValue_) {
                        return this.root.withEncodingSameCodeRange(ropeValue_, encodingValue_, codeRangeValue_);
                    }
                }
                return this.getNext().executeRope_(ropeValue, encodingValue, codeRangeValue);
            }

            static BaseNode_ create(WithEncodingNodeGen root) {
                return new WithEncodingSameCodeRangeNode_(root);
            }
        }

        @GeneratedBy(methodName="withEncodingSameEncoding(Rope, Encoding, CodeRange)", value=RopeNodes.WithEncodingNode.class)
        private static final class WithEncodingSameEncodingNode_
        extends BaseNode_ {
            WithEncodingSameEncodingNode_(WithEncodingNodeGen root) {
                super(root, 1);
            }

            @Override
            public Rope executeRope(Rope ropeValue, Encoding encodingValue, CodeRange codeRangeValue) {
                if (ropeValue.getEncoding() == encodingValue) {
                    return this.root.withEncodingSameEncoding(ropeValue, encodingValue, codeRangeValue);
                }
                return this.getNext().executeRope(ropeValue, encodingValue, codeRangeValue);
            }

            @Override
            public Rope executeRope_(Object ropeValue, Object encodingValue, Object codeRangeValue) {
                if (ropeValue instanceof Rope && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    Rope ropeValue_ = (Rope)ropeValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (ropeValue_.getEncoding() == encodingValue_) {
                        return this.root.withEncodingSameEncoding(ropeValue_, encodingValue_, codeRangeValue_);
                    }
                }
                return this.getNext().executeRope_(ropeValue, encodingValue, codeRangeValue);
            }

            static BaseNode_ create(WithEncodingNodeGen root) {
                return new WithEncodingSameEncodingNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.WithEncodingNode.class)
        private static final class PolymorphicNode_
        extends BaseNode_ {
            PolymorphicNode_(WithEncodingNodeGen root) {
                super(root, 0);
            }

            @Override
            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object ropeValue, Object encodingValue, Object codeRangeValue) {
                return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, ropeValue, encodingValue, codeRangeValue));
            }

            @Override
            public Rope executeRope_(Object ropeValue, Object encodingValue, Object codeRangeValue) {
                return this.getNext().executeRope_(ropeValue, encodingValue, codeRangeValue);
            }

            static BaseNode_ create(WithEncodingNodeGen root) {
                return new PolymorphicNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.WithEncodingNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(WithEncodingNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public Rope executeRope_(Object ropeValue, Object encodingValue, Object codeRangeValue) {
                return (Rope)this.uninitialized((Frame)null, ropeValue, encodingValue, codeRangeValue);
            }

            static BaseNode_ create(WithEncodingNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.WithEncodingNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            @CompilerDirectives.CompilationFinal
            protected WithEncodingNodeGen root;

            BaseNode_(WithEncodingNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            @Override
            protected final void setRoot(Node root) {
                this.root = (WithEncodingNodeGen)root;
            }

            @Override
            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.rope_, this.root.encoding_, this.root.codeRange_};
            }

            @Override
            public final Object acceptAndExecute(Frame frameValue, Object ropeValue, Object encodingValue, Object codeRangeValue) {
                return this.executeRope_(ropeValue, encodingValue, codeRangeValue);
            }

            public abstract Rope executeRope_(Object var1, Object var2, Object var3);

            public Rope executeRope(Rope ropeValue, Encoding encodingValue, CodeRange codeRangeValue) {
                return this.executeRope_(ropeValue, encodingValue, (Object)codeRangeValue);
            }

            public Object execute(VirtualFrame frameValue) {
                Object ropeValue_ = this.root.rope_.execute(frameValue);
                Object encodingValue_ = this.root.encoding_.execute(frameValue);
                Object codeRangeValue_ = this.root.codeRange_.execute(frameValue);
                return this.executeRope_(ropeValue_, encodingValue_, codeRangeValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            @Override
            protected final SpecializationNode createNext(Frame frameValue, Object ropeValue, Object encodingValue, Object codeRangeValue) {
                if (ropeValue instanceof Rope && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    BaseNode_ s;
                    Rope ropeValue_ = (Rope)ropeValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (ropeValue_.getEncoding() == encodingValue_) {
                        return WithEncodingSameEncodingNode_.create(this.root);
                    }
                    if (ropeValue_.getEncoding() != encodingValue_ && ropeValue_.getCodeRange() == codeRangeValue_) {
                        return WithEncodingSameCodeRangeNode_.create(this.root);
                    }
                    Class<?> cachedRopeClass3 = ropeValue_.getClass();
                    if (ropeValue_.getEncoding() != encodingValue_ && ropeValue_.getCodeRange() != codeRangeValue_ && RopeNodes.WithEncodingNode.isAsciiCompatbileChange(ropeValue_, encodingValue_) && ropeValue_.getClass() == cachedRopeClass3 && this.countSame(s = WithEncodingCr7BitNode_.create(this.root, cachedRopeClass3)) < this.root.getCacheLimit()) {
                        return s;
                    }
                    if (ropeValue_.getEncoding() != encodingValue_ && ropeValue_.getCodeRange() != codeRangeValue_ && !RopeNodes.WithEncodingNode.isAsciiCompatbileChange(ropeValue_, encodingValue_)) {
                        RopeNodes.MakeLeafRopeNode makeLeafRopeNode4 = RopeNodes.MakeLeafRopeNode.create();
                        return WithEncodingNode_.create(this.root, makeLeafRopeNode4);
                    }
                }
                return null;
            }

            @Override
            protected final SpecializationNode createPolymorphic() {
                return PolymorphicNode_.create(this.root);
            }

            protected final BaseNode_ getNext() {
                return (BaseNode_)this.next;
            }
        }
    }

    @GeneratedBy(value=RopeNodes.DebugPrintRopeNode.class)
    public static final class DebugPrintRopeNodeGen
    extends RopeNodes.DebugPrintRopeNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode rope_;
        @Node.Child
        private RubyNode currentLevel_;
        @Node.Child
        private RubyNode printString_;
        @CompilerDirectives.CompilationFinal
        private Class<?> currentLevelType_;
        @CompilerDirectives.CompilationFinal
        private Class<?> printStringType_;
        @Node.Child
        private BaseNode_ specialization_;

        private DebugPrintRopeNodeGen(RubyNode rope, RubyNode currentLevel, RubyNode printString) {
            this.rope_ = rope;
            this.currentLevel_ = currentLevel;
            this.printString_ = printString;
            this.specialization_ = UninitializedNode_.create(this);
        }

        @Override
        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public DynamicObject executeDebugPrint(Rope ropeValue, int currentLevelValue, boolean printStringValue) {
            return this.specialization_.executeDynamicObject1(ropeValue, currentLevelValue, printStringValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
            return this.specialization_.executeDynamicObject0(frameValue);
        }

        @Override
        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        @Override
        public Node deepCopy() {
            return SpecializationNode.updateRoot(super.deepCopy());
        }

        private static ConcatRope expectConcatRope(Object value) throws UnexpectedResultException {
            if (value instanceof ConcatRope) {
                return (ConcatRope)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static LazyIntRope expectLazyIntRope(Object value) throws UnexpectedResultException {
            if (value instanceof LazyIntRope) {
                return (LazyIntRope)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static LeafRope expectLeafRope(Object value) throws UnexpectedResultException {
            if (value instanceof LeafRope) {
                return (LeafRope)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static RepeatingRope expectRepeatingRope(Object value) throws UnexpectedResultException {
            if (value instanceof RepeatingRope) {
                return (RepeatingRope)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static SubstringRope expectSubstringRope(Object value) throws UnexpectedResultException {
            if (value instanceof SubstringRope) {
                return (SubstringRope)value;
            }
            throw new UnexpectedResultException(value);
        }

        public static RopeNodes.DebugPrintRopeNode create(RubyNode rope, RubyNode currentLevel, RubyNode printString) {
            return new DebugPrintRopeNodeGen(rope, currentLevel, printString);
        }

        @GeneratedBy(methodName="debugPrintLazyInt(LazyIntRope, int, boolean)", value=RopeNodes.DebugPrintRopeNode.class)
        private static final class DebugPrintLazyIntNode_
        extends BaseNode_ {
            private final Class<?> currentLevelImplicitType;

            DebugPrintLazyIntNode_(DebugPrintRopeNodeGen root, Object currentLevelValue) {
                super(root, 5);
                this.currentLevelImplicitType = RubyTypesGen.getImplicitIntegerClass(currentLevelValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.currentLevelImplicitType == ((DebugPrintLazyIntNode_)other).currentLevelImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject0(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                boolean printStringValue_;
                int currentLevelValue_;
                LazyIntRope ropeValue_;
                try {
                    ropeValue_ = DebugPrintRopeNodeGen.expectLazyIntRope(this.root.rope_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object currentLevelValue = this.executeCurrentLevel_(frameValue);
                    Object printStringValue = this.executePrintString_(frameValue);
                    return this.getNext().executeDynamicObject_(ex.getResult(), currentLevelValue, printStringValue);
                }
                try {
                    if (this.currentLevelImplicitType == Integer.TYPE) {
                        currentLevelValue_ = this.root.currentLevel_.executeInteger(frameValue);
                    } else {
                        Object currentLevelValue__ = this.executeCurrentLevel_(frameValue);
                        currentLevelValue_ = RubyTypesGen.expectImplicitInteger(currentLevelValue__, this.currentLevelImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object printStringValue = this.executePrintString_(frameValue);
                    return this.getNext().executeDynamicObject_(ropeValue_, ex.getResult(), printStringValue);
                }
                try {
                    printStringValue_ = this.root.printString_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeDynamicObject_(ropeValue_, currentLevelValue_, ex.getResult());
                }
                return this.root.debugPrintLazyInt(ropeValue_, currentLevelValue_, printStringValue_);
            }

            @Override
            public DynamicObject executeDynamicObject1(Rope ropeValue, int currentLevelValue, boolean printStringValue) {
                if (ropeValue instanceof LazyIntRope) {
                    LazyIntRope ropeValue_ = (LazyIntRope)ropeValue;
                    return this.root.debugPrintLazyInt(ropeValue_, currentLevelValue, printStringValue);
                }
                return this.getNext().executeDynamicObject1(ropeValue, currentLevelValue, printStringValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(Object ropeValue, Object currentLevelValue, Object printStringValue) {
                if (ropeValue instanceof LazyIntRope && RubyTypesGen.isImplicitInteger(currentLevelValue, this.currentLevelImplicitType) && printStringValue instanceof Boolean) {
                    LazyIntRope ropeValue_ = (LazyIntRope)ropeValue;
                    int currentLevelValue_ = RubyTypesGen.asImplicitInteger(currentLevelValue, this.currentLevelImplicitType);
                    boolean printStringValue_ = (Boolean)printStringValue;
                    return this.root.debugPrintLazyInt(ropeValue_, currentLevelValue_, printStringValue_);
                }
                return this.getNext().executeDynamicObject_(ropeValue, currentLevelValue, printStringValue);
            }

            static BaseNode_ create(DebugPrintRopeNodeGen root, Object currentLevelValue) {
                return new DebugPrintLazyIntNode_(root, currentLevelValue);
            }
        }

        @GeneratedBy(methodName="debugPrintRepeatingRope(RepeatingRope, int, boolean)", value=RopeNodes.DebugPrintRopeNode.class)
        private static final class DebugPrintRepeatingRopeNode_
        extends BaseNode_ {
            private final Class<?> currentLevelImplicitType;

            DebugPrintRepeatingRopeNode_(DebugPrintRopeNodeGen root, Object currentLevelValue) {
                super(root, 4);
                this.currentLevelImplicitType = RubyTypesGen.getImplicitIntegerClass(currentLevelValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.currentLevelImplicitType == ((DebugPrintRepeatingRopeNode_)other).currentLevelImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject0(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                boolean printStringValue_;
                int currentLevelValue_;
                RepeatingRope ropeValue_;
                try {
                    ropeValue_ = DebugPrintRopeNodeGen.expectRepeatingRope(this.root.rope_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object currentLevelValue = this.executeCurrentLevel_(frameValue);
                    Object printStringValue = this.executePrintString_(frameValue);
                    return this.getNext().executeDynamicObject_(ex.getResult(), currentLevelValue, printStringValue);
                }
                try {
                    if (this.currentLevelImplicitType == Integer.TYPE) {
                        currentLevelValue_ = this.root.currentLevel_.executeInteger(frameValue);
                    } else {
                        Object currentLevelValue__ = this.executeCurrentLevel_(frameValue);
                        currentLevelValue_ = RubyTypesGen.expectImplicitInteger(currentLevelValue__, this.currentLevelImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object printStringValue = this.executePrintString_(frameValue);
                    return this.getNext().executeDynamicObject_(ropeValue_, ex.getResult(), printStringValue);
                }
                try {
                    printStringValue_ = this.root.printString_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeDynamicObject_(ropeValue_, currentLevelValue_, ex.getResult());
                }
                return this.root.debugPrintRepeatingRope(ropeValue_, currentLevelValue_, printStringValue_);
            }

            @Override
            public DynamicObject executeDynamicObject1(Rope ropeValue, int currentLevelValue, boolean printStringValue) {
                if (ropeValue instanceof RepeatingRope) {
                    RepeatingRope ropeValue_ = (RepeatingRope)ropeValue;
                    return this.root.debugPrintRepeatingRope(ropeValue_, currentLevelValue, printStringValue);
                }
                return this.getNext().executeDynamicObject1(ropeValue, currentLevelValue, printStringValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(Object ropeValue, Object currentLevelValue, Object printStringValue) {
                if (ropeValue instanceof RepeatingRope && RubyTypesGen.isImplicitInteger(currentLevelValue, this.currentLevelImplicitType) && printStringValue instanceof Boolean) {
                    RepeatingRope ropeValue_ = (RepeatingRope)ropeValue;
                    int currentLevelValue_ = RubyTypesGen.asImplicitInteger(currentLevelValue, this.currentLevelImplicitType);
                    boolean printStringValue_ = (Boolean)printStringValue;
                    return this.root.debugPrintRepeatingRope(ropeValue_, currentLevelValue_, printStringValue_);
                }
                return this.getNext().executeDynamicObject_(ropeValue, currentLevelValue, printStringValue);
            }

            static BaseNode_ create(DebugPrintRopeNodeGen root, Object currentLevelValue) {
                return new DebugPrintRepeatingRopeNode_(root, currentLevelValue);
            }
        }

        @GeneratedBy(methodName="debugPrintConcatRope(ConcatRope, int, boolean)", value=RopeNodes.DebugPrintRopeNode.class)
        private static final class DebugPrintConcatRopeNode_
        extends BaseNode_ {
            private final Class<?> currentLevelImplicitType;

            DebugPrintConcatRopeNode_(DebugPrintRopeNodeGen root, Object currentLevelValue) {
                super(root, 3);
                this.currentLevelImplicitType = RubyTypesGen.getImplicitIntegerClass(currentLevelValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.currentLevelImplicitType == ((DebugPrintConcatRopeNode_)other).currentLevelImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject0(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                boolean printStringValue_;
                int currentLevelValue_;
                ConcatRope ropeValue_;
                try {
                    ropeValue_ = DebugPrintRopeNodeGen.expectConcatRope(this.root.rope_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object currentLevelValue = this.executeCurrentLevel_(frameValue);
                    Object printStringValue = this.executePrintString_(frameValue);
                    return this.getNext().executeDynamicObject_(ex.getResult(), currentLevelValue, printStringValue);
                }
                try {
                    if (this.currentLevelImplicitType == Integer.TYPE) {
                        currentLevelValue_ = this.root.currentLevel_.executeInteger(frameValue);
                    } else {
                        Object currentLevelValue__ = this.executeCurrentLevel_(frameValue);
                        currentLevelValue_ = RubyTypesGen.expectImplicitInteger(currentLevelValue__, this.currentLevelImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object printStringValue = this.executePrintString_(frameValue);
                    return this.getNext().executeDynamicObject_(ropeValue_, ex.getResult(), printStringValue);
                }
                try {
                    printStringValue_ = this.root.printString_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeDynamicObject_(ropeValue_, currentLevelValue_, ex.getResult());
                }
                return this.root.debugPrintConcatRope(ropeValue_, currentLevelValue_, printStringValue_);
            }

            @Override
            public DynamicObject executeDynamicObject1(Rope ropeValue, int currentLevelValue, boolean printStringValue) {
                if (ropeValue instanceof ConcatRope) {
                    ConcatRope ropeValue_ = (ConcatRope)ropeValue;
                    return this.root.debugPrintConcatRope(ropeValue_, currentLevelValue, printStringValue);
                }
                return this.getNext().executeDynamicObject1(ropeValue, currentLevelValue, printStringValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(Object ropeValue, Object currentLevelValue, Object printStringValue) {
                if (ropeValue instanceof ConcatRope && RubyTypesGen.isImplicitInteger(currentLevelValue, this.currentLevelImplicitType) && printStringValue instanceof Boolean) {
                    ConcatRope ropeValue_ = (ConcatRope)ropeValue;
                    int currentLevelValue_ = RubyTypesGen.asImplicitInteger(currentLevelValue, this.currentLevelImplicitType);
                    boolean printStringValue_ = (Boolean)printStringValue;
                    return this.root.debugPrintConcatRope(ropeValue_, currentLevelValue_, printStringValue_);
                }
                return this.getNext().executeDynamicObject_(ropeValue, currentLevelValue, printStringValue);
            }

            static BaseNode_ create(DebugPrintRopeNodeGen root, Object currentLevelValue) {
                return new DebugPrintConcatRopeNode_(root, currentLevelValue);
            }
        }

        @GeneratedBy(methodName="debugPrintSubstringRope(SubstringRope, int, boolean)", value=RopeNodes.DebugPrintRopeNode.class)
        private static final class DebugPrintSubstringRopeNode_
        extends BaseNode_ {
            private final Class<?> currentLevelImplicitType;

            DebugPrintSubstringRopeNode_(DebugPrintRopeNodeGen root, Object currentLevelValue) {
                super(root, 2);
                this.currentLevelImplicitType = RubyTypesGen.getImplicitIntegerClass(currentLevelValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.currentLevelImplicitType == ((DebugPrintSubstringRopeNode_)other).currentLevelImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject0(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                boolean printStringValue_;
                int currentLevelValue_;
                SubstringRope ropeValue_;
                try {
                    ropeValue_ = DebugPrintRopeNodeGen.expectSubstringRope(this.root.rope_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object currentLevelValue = this.executeCurrentLevel_(frameValue);
                    Object printStringValue = this.executePrintString_(frameValue);
                    return this.getNext().executeDynamicObject_(ex.getResult(), currentLevelValue, printStringValue);
                }
                try {
                    if (this.currentLevelImplicitType == Integer.TYPE) {
                        currentLevelValue_ = this.root.currentLevel_.executeInteger(frameValue);
                    } else {
                        Object currentLevelValue__ = this.executeCurrentLevel_(frameValue);
                        currentLevelValue_ = RubyTypesGen.expectImplicitInteger(currentLevelValue__, this.currentLevelImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object printStringValue = this.executePrintString_(frameValue);
                    return this.getNext().executeDynamicObject_(ropeValue_, ex.getResult(), printStringValue);
                }
                try {
                    printStringValue_ = this.root.printString_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeDynamicObject_(ropeValue_, currentLevelValue_, ex.getResult());
                }
                return this.root.debugPrintSubstringRope(ropeValue_, currentLevelValue_, printStringValue_);
            }

            @Override
            public DynamicObject executeDynamicObject1(Rope ropeValue, int currentLevelValue, boolean printStringValue) {
                if (ropeValue instanceof SubstringRope) {
                    SubstringRope ropeValue_ = (SubstringRope)ropeValue;
                    return this.root.debugPrintSubstringRope(ropeValue_, currentLevelValue, printStringValue);
                }
                return this.getNext().executeDynamicObject1(ropeValue, currentLevelValue, printStringValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(Object ropeValue, Object currentLevelValue, Object printStringValue) {
                if (ropeValue instanceof SubstringRope && RubyTypesGen.isImplicitInteger(currentLevelValue, this.currentLevelImplicitType) && printStringValue instanceof Boolean) {
                    SubstringRope ropeValue_ = (SubstringRope)ropeValue;
                    int currentLevelValue_ = RubyTypesGen.asImplicitInteger(currentLevelValue, this.currentLevelImplicitType);
                    boolean printStringValue_ = (Boolean)printStringValue;
                    return this.root.debugPrintSubstringRope(ropeValue_, currentLevelValue_, printStringValue_);
                }
                return this.getNext().executeDynamicObject_(ropeValue, currentLevelValue, printStringValue);
            }

            static BaseNode_ create(DebugPrintRopeNodeGen root, Object currentLevelValue) {
                return new DebugPrintSubstringRopeNode_(root, currentLevelValue);
            }
        }

        @GeneratedBy(methodName="debugPrintLeafRope(LeafRope, int, boolean)", value=RopeNodes.DebugPrintRopeNode.class)
        private static final class DebugPrintLeafRopeNode_
        extends BaseNode_ {
            private final Class<?> currentLevelImplicitType;

            DebugPrintLeafRopeNode_(DebugPrintRopeNodeGen root, Object currentLevelValue) {
                super(root, 1);
                this.currentLevelImplicitType = RubyTypesGen.getImplicitIntegerClass(currentLevelValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.currentLevelImplicitType == ((DebugPrintLeafRopeNode_)other).currentLevelImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject0(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                boolean printStringValue_;
                int currentLevelValue_;
                LeafRope ropeValue_;
                try {
                    ropeValue_ = DebugPrintRopeNodeGen.expectLeafRope(this.root.rope_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object currentLevelValue = this.executeCurrentLevel_(frameValue);
                    Object printStringValue = this.executePrintString_(frameValue);
                    return this.getNext().executeDynamicObject_(ex.getResult(), currentLevelValue, printStringValue);
                }
                try {
                    if (this.currentLevelImplicitType == Integer.TYPE) {
                        currentLevelValue_ = this.root.currentLevel_.executeInteger(frameValue);
                    } else {
                        Object currentLevelValue__ = this.executeCurrentLevel_(frameValue);
                        currentLevelValue_ = RubyTypesGen.expectImplicitInteger(currentLevelValue__, this.currentLevelImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object printStringValue = this.executePrintString_(frameValue);
                    return this.getNext().executeDynamicObject_(ropeValue_, ex.getResult(), printStringValue);
                }
                try {
                    printStringValue_ = this.root.printString_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeDynamicObject_(ropeValue_, currentLevelValue_, ex.getResult());
                }
                return this.root.debugPrintLeafRope(ropeValue_, currentLevelValue_, printStringValue_);
            }

            @Override
            public DynamicObject executeDynamicObject1(Rope ropeValue, int currentLevelValue, boolean printStringValue) {
                if (ropeValue instanceof LeafRope) {
                    LeafRope ropeValue_ = (LeafRope)ropeValue;
                    return this.root.debugPrintLeafRope(ropeValue_, currentLevelValue, printStringValue);
                }
                return this.getNext().executeDynamicObject1(ropeValue, currentLevelValue, printStringValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(Object ropeValue, Object currentLevelValue, Object printStringValue) {
                if (ropeValue instanceof LeafRope && RubyTypesGen.isImplicitInteger(currentLevelValue, this.currentLevelImplicitType) && printStringValue instanceof Boolean) {
                    LeafRope ropeValue_ = (LeafRope)ropeValue;
                    int currentLevelValue_ = RubyTypesGen.asImplicitInteger(currentLevelValue, this.currentLevelImplicitType);
                    boolean printStringValue_ = (Boolean)printStringValue;
                    return this.root.debugPrintLeafRope(ropeValue_, currentLevelValue_, printStringValue_);
                }
                return this.getNext().executeDynamicObject_(ropeValue, currentLevelValue, printStringValue);
            }

            static BaseNode_ create(DebugPrintRopeNodeGen root, Object currentLevelValue) {
                return new DebugPrintLeafRopeNode_(root, currentLevelValue);
            }
        }

        @GeneratedBy(value=RopeNodes.DebugPrintRopeNode.class)
        private static final class PolymorphicNode_
        extends BaseNode_ {
            PolymorphicNode_(DebugPrintRopeNodeGen root) {
                super(root, 0);
            }

            @Override
            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object ropeValue, Object currentLevelValue, Object printStringValue) {
                return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, ropeValue, currentLevelValue, printStringValue));
            }

            @Override
            public DynamicObject executeDynamicObject_(Object ropeValue, Object currentLevelValue, Object printStringValue) {
                return this.getNext().executeDynamicObject_(ropeValue, currentLevelValue, printStringValue);
            }

            static BaseNode_ create(DebugPrintRopeNodeGen root) {
                return new PolymorphicNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.DebugPrintRopeNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(DebugPrintRopeNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public DynamicObject executeDynamicObject_(Object ropeValue, Object currentLevelValue, Object printStringValue) {
                return (DynamicObject)this.uninitialized((Frame)null, ropeValue, currentLevelValue, printStringValue);
            }

            static BaseNode_ create(DebugPrintRopeNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.DebugPrintRopeNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            @CompilerDirectives.CompilationFinal
            protected DebugPrintRopeNodeGen root;

            BaseNode_(DebugPrintRopeNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            @Override
            protected final void setRoot(Node root) {
                this.root = (DebugPrintRopeNodeGen)root;
            }

            @Override
            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.rope_, this.root.currentLevel_, this.root.printString_};
            }

            @Override
            public final Object acceptAndExecute(Frame frameValue, Object ropeValue, Object currentLevelValue, Object printStringValue) {
                return this.executeDynamicObject_(ropeValue, currentLevelValue, printStringValue);
            }

            public abstract DynamicObject executeDynamicObject_(Object var1, Object var2, Object var3);

            public DynamicObject executeDynamicObject1(Rope ropeValue, int currentLevelValue, boolean printStringValue) {
                return this.executeDynamicObject_(ropeValue, currentLevelValue, printStringValue);
            }

            public Object execute(VirtualFrame frameValue) {
                Object ropeValue_ = this.root.rope_.execute(frameValue);
                Object currentLevelValue_ = this.executeCurrentLevel_(frameValue);
                Object printStringValue_ = this.executePrintString_(frameValue);
                return this.executeDynamicObject_(ropeValue_, currentLevelValue_, printStringValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                return (DynamicObject)this.execute(frameValue);
            }

            @Override
            protected final SpecializationNode createNext(Frame frameValue, Object ropeValue, Object currentLevelValue, Object printStringValue) {
                if (RubyTypesGen.isImplicitInteger(currentLevelValue) && printStringValue instanceof Boolean) {
                    if (ropeValue instanceof LeafRope) {
                        return DebugPrintLeafRopeNode_.create(this.root, currentLevelValue);
                    }
                    if (ropeValue instanceof SubstringRope) {
                        return DebugPrintSubstringRopeNode_.create(this.root, currentLevelValue);
                    }
                    if (ropeValue instanceof ConcatRope) {
                        return DebugPrintConcatRopeNode_.create(this.root, currentLevelValue);
                    }
                    if (ropeValue instanceof RepeatingRope) {
                        return DebugPrintRepeatingRopeNode_.create(this.root, currentLevelValue);
                    }
                    if (ropeValue instanceof LazyIntRope) {
                        return DebugPrintLazyIntNode_.create(this.root, currentLevelValue);
                    }
                }
                return null;
            }

            @Override
            protected final SpecializationNode createPolymorphic() {
                return PolymorphicNode_.create(this.root);
            }

            protected final BaseNode_ getNext() {
                return (BaseNode_)this.next;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected final Object executeCurrentLevel_(Frame frameValue) {
                Object object;
                Class currentLevelType_ = this.root.currentLevelType_;
                if (currentLevelType_ == Integer.TYPE) {
                    return this.root.currentLevel_.executeInteger((VirtualFrame)frameValue);
                }
                if (currentLevelType_ != null) return this.root.currentLevel_.execute((VirtualFrame)frameValue);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Class<Object> _type = Object.class;
                try {
                    Object _value = this.root.currentLevel_.execute((VirtualFrame)frameValue);
                    _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                    object = _value;
                }
                catch (Throwable throwable) {
                    try {
                        this.root.currentLevelType_ = _type;
                        throw throwable;
                    }
                    catch (UnexpectedResultException ex) {
                        this.root.currentLevelType_ = Object.class;
                        return ex.getResult();
                    }
                }
                this.root.currentLevelType_ = _type;
                return object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected final Object executePrintString_(Frame frameValue) {
                Object object;
                Class printStringType_ = this.root.printStringType_;
                if (printStringType_ == Boolean.TYPE) {
                    return this.root.printString_.executeBoolean((VirtualFrame)frameValue);
                }
                if (printStringType_ != null) return this.root.printString_.execute((VirtualFrame)frameValue);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Class<Object> _type = Object.class;
                try {
                    Object _value = this.root.printString_.execute((VirtualFrame)frameValue);
                    _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                    object = _value;
                }
                catch (Throwable throwable) {
                    try {
                        this.root.printStringType_ = _type;
                        throw throwable;
                    }
                    catch (UnexpectedResultException ex) {
                        this.root.printStringType_ = Object.class;
                        return ex.getResult();
                    }
                }
                this.root.printStringType_ = _type;
                return object;
            }
        }
    }

    @GeneratedBy(value=RopeNodes.MakeRepeatingNode.class)
    @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
    public static final class MakeRepeatingNodeGen
    extends RopeNodes.MakeRepeatingNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode base_;
        @Node.Child
        private RubyNode times_;
        @CompilerDirectives.CompilationFinal
        private Class<?> timesType_;
        @Node.Child
        private BaseNode_ specialization_;

        private MakeRepeatingNodeGen(RubyNode base, RubyNode times) {
            this.base_ = base;
            this.times_ = times;
            this.specialization_ = UninitializedNode_.create(this);
        }

        @Override
        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public Rope executeMake(Rope baseValue, int timesValue) {
            return this.specialization_.executeRope(baseValue, timesValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        @Override
        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        @Override
        public Node deepCopy() {
            return SpecializationNode.updateRoot(super.deepCopy());
        }

        private static RopeBuffer expectRopeBuffer(Object value) throws UnexpectedResultException {
            if (value instanceof RopeBuffer) {
                return (RopeBuffer)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static Rope expectRope(Object value) throws UnexpectedResultException {
            if (value instanceof Rope) {
                return (Rope)value;
            }
            throw new UnexpectedResultException(value);
        }

        public static RopeNodes.MakeRepeatingNode create(RubyNode base, RubyNode times) {
            return new MakeRepeatingNodeGen(base, times);
        }

        @GeneratedBy(methodName="repeat(Rope, int)", value=RopeNodes.MakeRepeatingNode.class)
        private static final class RepeatNode_
        extends BaseNode_ {
            private final Class<?> timesImplicitType;

            RepeatNode_(MakeRepeatingNodeGen root, Object timesValue) {
                super(root, 5);
                this.timesImplicitType = RubyTypesGen.getImplicitIntegerClass(timesValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.timesImplicitType == ((RepeatNode_)other).timesImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int timesValue_;
                Rope baseValue_;
                try {
                    baseValue_ = MakeRepeatingNodeGen.expectRope(this.root.base_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object timesValue = this.executeTimes_(frameValue);
                    return this.getNext().executeRope_(ex.getResult(), timesValue);
                }
                try {
                    if (this.timesImplicitType == Integer.TYPE) {
                        timesValue_ = this.root.times_.executeInteger(frameValue);
                    } else {
                        Object timesValue__ = this.executeTimes_(frameValue);
                        timesValue_ = RubyTypesGen.expectImplicitInteger(timesValue__, this.timesImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeRope_(baseValue_, ex.getResult());
                }
                if (!RopeGuards.isRopeBuffer(baseValue_) && !RopeGuards.isSingleByteString(baseValue_) && timesValue_ > 1) {
                    return this.root.repeat(baseValue_, timesValue_);
                }
                return this.getNext().executeRope_(baseValue_, timesValue_);
            }

            @Override
            public Rope executeRope(Rope baseValue, int timesValue) {
                if (!RopeGuards.isRopeBuffer(baseValue) && !RopeGuards.isSingleByteString(baseValue) && timesValue > 1) {
                    return this.root.repeat(baseValue, timesValue);
                }
                return this.getNext().executeRope(baseValue, timesValue);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object timesValue) {
                if (baseValue instanceof Rope && RubyTypesGen.isImplicitInteger(timesValue, this.timesImplicitType)) {
                    Rope baseValue_ = (Rope)baseValue;
                    int timesValue_ = RubyTypesGen.asImplicitInteger(timesValue, this.timesImplicitType);
                    if (!RopeGuards.isRopeBuffer(baseValue_) && !RopeGuards.isSingleByteString(baseValue_) && timesValue_ > 1) {
                        return this.root.repeat(baseValue_, timesValue_);
                    }
                }
                return this.getNext().executeRope_(baseValue, timesValue);
            }

            static BaseNode_ create(MakeRepeatingNodeGen root, Object timesValue) {
                return new RepeatNode_(root, timesValue);
            }
        }

        @GeneratedBy(methodName="multiplySingleByteString(Rope, int, MakeLeafRopeNode)", value=RopeNodes.MakeRepeatingNode.class)
        private static final class MultiplySingleByteStringNode_
        extends BaseNode_ {
            @Node.Child
            private RopeNodes.MakeLeafRopeNode makeLeafRopeNode;
            private final Class<?> timesImplicitType;

            MultiplySingleByteStringNode_(MakeRepeatingNodeGen root, Object timesValue, RopeNodes.MakeLeafRopeNode makeLeafRopeNode) {
                super(root, 4);
                this.timesImplicitType = RubyTypesGen.getImplicitIntegerClass(timesValue);
                this.makeLeafRopeNode = makeLeafRopeNode;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.timesImplicitType == ((MultiplySingleByteStringNode_)other).timesImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int timesValue_;
                Rope baseValue_;
                try {
                    baseValue_ = MakeRepeatingNodeGen.expectRope(this.root.base_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object timesValue = this.executeTimes_(frameValue);
                    return this.getNext().executeRope_(ex.getResult(), timesValue);
                }
                try {
                    if (this.timesImplicitType == Integer.TYPE) {
                        timesValue_ = this.root.times_.executeInteger(frameValue);
                    } else {
                        Object timesValue__ = this.executeTimes_(frameValue);
                        timesValue_ = RubyTypesGen.expectImplicitInteger(timesValue__, this.timesImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeRope_(baseValue_, ex.getResult());
                }
                if (!RopeGuards.isRopeBuffer(baseValue_) && RopeGuards.isSingleByteString(baseValue_) && timesValue_ > 1) {
                    return this.root.multiplySingleByteString(baseValue_, timesValue_, this.makeLeafRopeNode);
                }
                return this.getNext().executeRope_(baseValue_, timesValue_);
            }

            @Override
            public Rope executeRope(Rope baseValue, int timesValue) {
                if (!RopeGuards.isRopeBuffer(baseValue) && RopeGuards.isSingleByteString(baseValue) && timesValue > 1) {
                    return this.root.multiplySingleByteString(baseValue, timesValue, this.makeLeafRopeNode);
                }
                return this.getNext().executeRope(baseValue, timesValue);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object timesValue) {
                if (baseValue instanceof Rope && RubyTypesGen.isImplicitInteger(timesValue, this.timesImplicitType)) {
                    Rope baseValue_ = (Rope)baseValue;
                    int timesValue_ = RubyTypesGen.asImplicitInteger(timesValue, this.timesImplicitType);
                    if (!RopeGuards.isRopeBuffer(baseValue_) && RopeGuards.isSingleByteString(baseValue_) && timesValue_ > 1) {
                        return this.root.multiplySingleByteString(baseValue_, timesValue_, this.makeLeafRopeNode);
                    }
                }
                return this.getNext().executeRope_(baseValue, timesValue);
            }

            static BaseNode_ create(MakeRepeatingNodeGen root, Object timesValue, RopeNodes.MakeLeafRopeNode makeLeafRopeNode) {
                return new MultiplySingleByteStringNode_(root, timesValue, makeLeafRopeNode);
            }
        }

        @GeneratedBy(methodName="multiplyBuffer(RopeBuffer, int)", value=RopeNodes.MakeRepeatingNode.class)
        private static final class MultiplyBufferNode_
        extends BaseNode_ {
            private final Class<?> timesImplicitType;

            MultiplyBufferNode_(MakeRepeatingNodeGen root, Object timesValue) {
                super(root, 3);
                this.timesImplicitType = RubyTypesGen.getImplicitIntegerClass(timesValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.timesImplicitType == ((MultiplyBufferNode_)other).timesImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int timesValue_;
                RopeBuffer baseValue_;
                try {
                    baseValue_ = MakeRepeatingNodeGen.expectRopeBuffer(this.root.base_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object timesValue = this.executeTimes_(frameValue);
                    return this.getNext().executeRope_(ex.getResult(), timesValue);
                }
                try {
                    if (this.timesImplicitType == Integer.TYPE) {
                        timesValue_ = this.root.times_.executeInteger(frameValue);
                    } else {
                        Object timesValue__ = this.executeTimes_(frameValue);
                        timesValue_ = RubyTypesGen.expectImplicitInteger(timesValue__, this.timesImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeRope_(baseValue_, ex.getResult());
                }
                if (timesValue_ > 1) {
                    return this.root.multiplyBuffer(baseValue_, timesValue_);
                }
                return this.getNext().executeRope_(baseValue_, timesValue_);
            }

            @Override
            public Rope executeRope(Rope baseValue, int timesValue) {
                if (baseValue instanceof RopeBuffer) {
                    RopeBuffer baseValue_ = (RopeBuffer)baseValue;
                    if (timesValue > 1) {
                        return this.root.multiplyBuffer(baseValue_, timesValue);
                    }
                }
                return this.getNext().executeRope(baseValue, timesValue);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object timesValue) {
                if (baseValue instanceof RopeBuffer && RubyTypesGen.isImplicitInteger(timesValue, this.timesImplicitType)) {
                    RopeBuffer baseValue_ = (RopeBuffer)baseValue;
                    int timesValue_ = RubyTypesGen.asImplicitInteger(timesValue, this.timesImplicitType);
                    if (timesValue_ > 1) {
                        return this.root.multiplyBuffer(baseValue_, timesValue_);
                    }
                }
                return this.getNext().executeRope_(baseValue, timesValue);
            }

            static BaseNode_ create(MakeRepeatingNodeGen root, Object timesValue) {
                return new MultiplyBufferNode_(root, timesValue);
            }
        }

        @GeneratedBy(methodName="repeatOne(Rope, int, WithEncodingNode)", value=RopeNodes.MakeRepeatingNode.class)
        private static final class RepeatOneNode_
        extends BaseNode_ {
            @Node.Child
            private RopeNodes.WithEncodingNode withEncodingNode;
            private final Class<?> timesImplicitType;

            RepeatOneNode_(MakeRepeatingNodeGen root, Object timesValue, RopeNodes.WithEncodingNode withEncodingNode) {
                super(root, 2);
                this.timesImplicitType = RubyTypesGen.getImplicitIntegerClass(timesValue);
                this.withEncodingNode = withEncodingNode;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.timesImplicitType == ((RepeatOneNode_)other).timesImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int timesValue_;
                Rope baseValue_;
                try {
                    baseValue_ = MakeRepeatingNodeGen.expectRope(this.root.base_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object timesValue = this.executeTimes_(frameValue);
                    return this.getNext().executeRope_(ex.getResult(), timesValue);
                }
                try {
                    if (this.timesImplicitType == Integer.TYPE) {
                        timesValue_ = this.root.times_.executeInteger(frameValue);
                    } else {
                        Object timesValue__ = this.executeTimes_(frameValue);
                        timesValue_ = RubyTypesGen.expectImplicitInteger(timesValue__, this.timesImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeRope_(baseValue_, ex.getResult());
                }
                if (timesValue_ == 1) {
                    return this.root.repeatOne(baseValue_, timesValue_, this.withEncodingNode);
                }
                return this.getNext().executeRope_(baseValue_, timesValue_);
            }

            @Override
            public Rope executeRope(Rope baseValue, int timesValue) {
                if (timesValue == 1) {
                    return this.root.repeatOne(baseValue, timesValue, this.withEncodingNode);
                }
                return this.getNext().executeRope(baseValue, timesValue);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object timesValue) {
                if (baseValue instanceof Rope && RubyTypesGen.isImplicitInteger(timesValue, this.timesImplicitType)) {
                    Rope baseValue_ = (Rope)baseValue;
                    int timesValue_ = RubyTypesGen.asImplicitInteger(timesValue, this.timesImplicitType);
                    if (timesValue_ == 1) {
                        return this.root.repeatOne(baseValue_, timesValue_, this.withEncodingNode);
                    }
                }
                return this.getNext().executeRope_(baseValue, timesValue);
            }

            static BaseNode_ create(MakeRepeatingNodeGen root, Object timesValue, RopeNodes.WithEncodingNode withEncodingNode) {
                return new RepeatOneNode_(root, timesValue, withEncodingNode);
            }
        }

        @GeneratedBy(methodName="repeatZero(Rope, int, WithEncodingNode)", value=RopeNodes.MakeRepeatingNode.class)
        private static final class RepeatZeroNode_
        extends BaseNode_ {
            @Node.Child
            private RopeNodes.WithEncodingNode withEncodingNode;
            private final Class<?> timesImplicitType;

            RepeatZeroNode_(MakeRepeatingNodeGen root, Object timesValue, RopeNodes.WithEncodingNode withEncodingNode) {
                super(root, 1);
                this.timesImplicitType = RubyTypesGen.getImplicitIntegerClass(timesValue);
                this.withEncodingNode = withEncodingNode;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.timesImplicitType == ((RepeatZeroNode_)other).timesImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int timesValue_;
                Rope baseValue_;
                try {
                    baseValue_ = MakeRepeatingNodeGen.expectRope(this.root.base_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object timesValue = this.executeTimes_(frameValue);
                    return this.getNext().executeRope_(ex.getResult(), timesValue);
                }
                try {
                    if (this.timesImplicitType == Integer.TYPE) {
                        timesValue_ = this.root.times_.executeInteger(frameValue);
                    } else {
                        Object timesValue__ = this.executeTimes_(frameValue);
                        timesValue_ = RubyTypesGen.expectImplicitInteger(timesValue__, this.timesImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeRope_(baseValue_, ex.getResult());
                }
                if (timesValue_ == 0) {
                    return this.root.repeatZero(baseValue_, timesValue_, this.withEncodingNode);
                }
                return this.getNext().executeRope_(baseValue_, timesValue_);
            }

            @Override
            public Rope executeRope(Rope baseValue, int timesValue) {
                if (timesValue == 0) {
                    return this.root.repeatZero(baseValue, timesValue, this.withEncodingNode);
                }
                return this.getNext().executeRope(baseValue, timesValue);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object timesValue) {
                if (baseValue instanceof Rope && RubyTypesGen.isImplicitInteger(timesValue, this.timesImplicitType)) {
                    Rope baseValue_ = (Rope)baseValue;
                    int timesValue_ = RubyTypesGen.asImplicitInteger(timesValue, this.timesImplicitType);
                    if (timesValue_ == 0) {
                        return this.root.repeatZero(baseValue_, timesValue_, this.withEncodingNode);
                    }
                }
                return this.getNext().executeRope_(baseValue, timesValue);
            }

            static BaseNode_ create(MakeRepeatingNodeGen root, Object timesValue, RopeNodes.WithEncodingNode withEncodingNode) {
                return new RepeatZeroNode_(root, timesValue, withEncodingNode);
            }
        }

        @GeneratedBy(value=RopeNodes.MakeRepeatingNode.class)
        private static final class PolymorphicNode_
        extends BaseNode_ {
            PolymorphicNode_(MakeRepeatingNodeGen root) {
                super(root, 0);
            }

            @Override
            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object baseValue, Object timesValue) {
                return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, baseValue, timesValue));
            }

            @Override
            public Rope executeRope_(Object baseValue, Object timesValue) {
                return this.getNext().executeRope_(baseValue, timesValue);
            }

            static BaseNode_ create(MakeRepeatingNodeGen root) {
                return new PolymorphicNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.MakeRepeatingNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(MakeRepeatingNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object timesValue) {
                return (Rope)this.uninitialized((Frame)null, baseValue, timesValue);
            }

            static BaseNode_ create(MakeRepeatingNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.MakeRepeatingNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            @CompilerDirectives.CompilationFinal
            protected MakeRepeatingNodeGen root;

            BaseNode_(MakeRepeatingNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            @Override
            protected final void setRoot(Node root) {
                this.root = (MakeRepeatingNodeGen)root;
            }

            @Override
            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.base_, this.root.times_};
            }

            @Override
            public final Object acceptAndExecute(Frame frameValue, Object baseValue, Object timesValue) {
                return this.executeRope_(baseValue, timesValue);
            }

            public abstract Rope executeRope_(Object var1, Object var2);

            public Rope executeRope(Rope baseValue, int timesValue) {
                return this.executeRope_(baseValue, timesValue);
            }

            public Object execute(VirtualFrame frameValue) {
                Object baseValue_ = this.root.base_.execute(frameValue);
                Object timesValue_ = this.executeTimes_(frameValue);
                return this.executeRope_(baseValue_, timesValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            @Override
            protected final SpecializationNode createNext(Frame frameValue, Object baseValue, Object timesValue) {
                if (RubyTypesGen.isImplicitInteger(timesValue)) {
                    int timesValue_ = RubyTypesGen.asImplicitInteger(timesValue);
                    if (baseValue instanceof Rope) {
                        if (timesValue_ == 0) {
                            RopeNodes.WithEncodingNode withEncodingNode1 = RopeNodes.WithEncodingNode.create();
                            return RepeatZeroNode_.create(this.root, timesValue, withEncodingNode1);
                        }
                        if (timesValue_ == 1) {
                            RopeNodes.WithEncodingNode withEncodingNode2 = RopeNodes.WithEncodingNode.create();
                            return RepeatOneNode_.create(this.root, timesValue, withEncodingNode2);
                        }
                    }
                    if (baseValue instanceof RopeBuffer && timesValue_ > 1) {
                        return MultiplyBufferNode_.create(this.root, timesValue);
                    }
                    if (baseValue instanceof Rope) {
                        Rope baseValue_ = (Rope)baseValue;
                        if (!RopeGuards.isRopeBuffer(baseValue_) && RopeGuards.isSingleByteString(baseValue_) && timesValue_ > 1) {
                            RopeNodes.MakeLeafRopeNode makeLeafRopeNode4 = RopeNodes.MakeLeafRopeNode.create();
                            return MultiplySingleByteStringNode_.create(this.root, timesValue, makeLeafRopeNode4);
                        }
                        if (!RopeGuards.isRopeBuffer(baseValue_) && !RopeGuards.isSingleByteString(baseValue_) && timesValue_ > 1) {
                            return RepeatNode_.create(this.root, timesValue);
                        }
                    }
                }
                return null;
            }

            @Override
            protected final SpecializationNode createPolymorphic() {
                return PolymorphicNode_.create(this.root);
            }

            protected final BaseNode_ getNext() {
                return (BaseNode_)this.next;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected final Object executeTimes_(Frame frameValue) {
                Object object;
                Class timesType_ = this.root.timesType_;
                if (timesType_ == Integer.TYPE) {
                    return this.root.times_.executeInteger((VirtualFrame)frameValue);
                }
                if (timesType_ != null) return this.root.times_.execute((VirtualFrame)frameValue);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Class<Object> _type = Object.class;
                try {
                    Object _value = this.root.times_.execute((VirtualFrame)frameValue);
                    _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                    object = _value;
                }
                catch (Throwable throwable) {
                    try {
                        this.root.timesType_ = _type;
                        throw throwable;
                    }
                    catch (UnexpectedResultException ex) {
                        this.root.timesType_ = Object.class;
                        return ex.getResult();
                    }
                }
                this.root.timesType_ = _type;
                return object;
            }
        }
    }

    @GeneratedBy(value=RopeNodes.MakeLeafRopeNode.class)
    public static final class MakeLeafRopeNodeGen
    extends RopeNodes.MakeLeafRopeNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode bytes_;
        @Node.Child
        private RubyNode encoding_;
        @Node.Child
        private RubyNode codeRange_;
        @Node.Child
        private RubyNode characterLength_;
        @CompilerDirectives.CompilationFinal
        private Class<?> characterLengthType_;
        @Node.Child
        private BaseNode_ specialization_;

        private MakeLeafRopeNodeGen(RubyNode bytes, RubyNode encoding, RubyNode codeRange, RubyNode characterLength) {
            this.bytes_ = bytes;
            this.encoding_ = encoding;
            this.codeRange_ = codeRange;
            this.characterLength_ = characterLength;
            this.specialization_ = UninitializedNode_.create(this);
        }

        @Override
        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public LeafRope executeMake(byte[] bytesValue, Encoding encodingValue, CodeRange codeRangeValue, Object characterLengthValue) {
            return this.specialization_.executeLeafRope(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        @Override
        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        @Override
        public Node deepCopy() {
            return SpecializationNode.updateRoot(super.deepCopy());
        }

        private static CodeRange expectCodeRange(Object value) throws UnexpectedResultException {
            if (value instanceof CodeRange) {
                return (CodeRange)((Object)value);
            }
            throw new UnexpectedResultException(value);
        }

        private static Encoding expectEncoding(Object value) throws UnexpectedResultException {
            if (value instanceof Encoding) {
                return (Encoding)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static byte[] expectByteArray(Object value) throws UnexpectedResultException {
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            throw new UnexpectedResultException(value);
        }

        public static RopeNodes.MakeLeafRopeNode create(RubyNode bytes, RubyNode encoding, RubyNode codeRange, RubyNode characterLength) {
            return new MakeLeafRopeNodeGen(bytes, encoding, codeRange, characterLength);
        }

        @GeneratedBy(methodName="makeUnknownLeafRope(byte[], Encoding, CodeRange, Object, ConditionProfile, ConditionProfile)", value=RopeNodes.MakeLeafRopeNode.class)
        private static final class MakeUnknownLeafRopeNode_
        extends BaseNode_ {
            private final ConditionProfile discovered7BitProfile;
            private final ConditionProfile discoveredValidProfile;

            MakeUnknownLeafRopeNode_(MakeLeafRopeNodeGen root, ConditionProfile discovered7BitProfile, ConditionProfile discoveredValidProfile) {
                super(root, 9);
                this.discovered7BitProfile = discovered7BitProfile;
                this.discoveredValidProfile = discoveredValidProfile;
            }

            @Override
            public LeafRope executeLeafRope(byte[] bytesValue, Encoding encodingValue, CodeRange codeRangeValue, Object characterLengthValue) {
                if (RopeNodes.MakeLeafRopeNode.isUnknown(codeRangeValue) && !RopeNodes.MakeLeafRopeNode.isEmpty(bytesValue) && !RopeNodes.MakeLeafRopeNode.isBinaryString(encodingValue) && !RopeNodes.MakeLeafRopeNode.isAsciiCompatible(encodingValue)) {
                    return this.root.makeUnknownLeafRope(bytesValue, encodingValue, codeRangeValue, characterLengthValue, this.discovered7BitProfile, this.discoveredValidProfile);
                }
                return this.getNext().executeLeafRope(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            @Override
            public LeafRope executeLeafRope_(Object bytesValue, Object encodingValue, Object codeRangeValue, Object characterLengthValue) {
                if (bytesValue instanceof byte[] && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    byte[] bytesValue_ = (byte[])bytesValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (RopeNodes.MakeLeafRopeNode.isUnknown(codeRangeValue_) && !RopeNodes.MakeLeafRopeNode.isEmpty(bytesValue_) && !RopeNodes.MakeLeafRopeNode.isBinaryString(encodingValue_) && !RopeNodes.MakeLeafRopeNode.isAsciiCompatible(encodingValue_)) {
                        return this.root.makeUnknownLeafRope(bytesValue_, encodingValue_, codeRangeValue_, characterLengthValue, this.discovered7BitProfile, this.discoveredValidProfile);
                    }
                }
                return this.getNext().executeLeafRope_(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            static BaseNode_ create(MakeLeafRopeNodeGen root, ConditionProfile discovered7BitProfile, ConditionProfile discoveredValidProfile) {
                return new MakeUnknownLeafRopeNode_(root, discovered7BitProfile, discoveredValidProfile);
            }
        }

        @GeneratedBy(methodName="makeUnknownLeafRopeAsciiCompatible(byte[], Encoding, CodeRange, Object, ConditionProfile, ConditionProfile)", value=RopeNodes.MakeLeafRopeNode.class)
        private static final class MakeUnknownLeafRopeAsciiCompatibleNode_
        extends BaseNode_ {
            private final ConditionProfile discovered7BitProfile;
            private final ConditionProfile discoveredValidProfile;

            MakeUnknownLeafRopeAsciiCompatibleNode_(MakeLeafRopeNodeGen root, ConditionProfile discovered7BitProfile, ConditionProfile discoveredValidProfile) {
                super(root, 8);
                this.discovered7BitProfile = discovered7BitProfile;
                this.discoveredValidProfile = discoveredValidProfile;
            }

            @Override
            public LeafRope executeLeafRope(byte[] bytesValue, Encoding encodingValue, CodeRange codeRangeValue, Object characterLengthValue) {
                if (RopeNodes.MakeLeafRopeNode.isUnknown(codeRangeValue) && !RopeNodes.MakeLeafRopeNode.isEmpty(bytesValue) && !RopeNodes.MakeLeafRopeNode.isBinaryString(encodingValue) && RopeNodes.MakeLeafRopeNode.isAsciiCompatible(encodingValue)) {
                    return this.root.makeUnknownLeafRopeAsciiCompatible(bytesValue, encodingValue, codeRangeValue, characterLengthValue, this.discovered7BitProfile, this.discoveredValidProfile);
                }
                return this.getNext().executeLeafRope(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            @Override
            public LeafRope executeLeafRope_(Object bytesValue, Object encodingValue, Object codeRangeValue, Object characterLengthValue) {
                if (bytesValue instanceof byte[] && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    byte[] bytesValue_ = (byte[])bytesValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (RopeNodes.MakeLeafRopeNode.isUnknown(codeRangeValue_) && !RopeNodes.MakeLeafRopeNode.isEmpty(bytesValue_) && !RopeNodes.MakeLeafRopeNode.isBinaryString(encodingValue_) && RopeNodes.MakeLeafRopeNode.isAsciiCompatible(encodingValue_)) {
                        return this.root.makeUnknownLeafRopeAsciiCompatible(bytesValue_, encodingValue_, codeRangeValue_, characterLengthValue, this.discovered7BitProfile, this.discoveredValidProfile);
                    }
                }
                return this.getNext().executeLeafRope_(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            static BaseNode_ create(MakeLeafRopeNodeGen root, ConditionProfile discovered7BitProfile, ConditionProfile discoveredValidProfile) {
                return new MakeUnknownLeafRopeAsciiCompatibleNode_(root, discovered7BitProfile, discoveredValidProfile);
            }
        }

        @GeneratedBy(methodName="makeUnknownLeafRopeBinary(byte[], Encoding, CodeRange, Object, ConditionProfile)", value=RopeNodes.MakeLeafRopeNode.class)
        private static final class MakeUnknownLeafRopeBinaryNode_
        extends BaseNode_ {
            private final ConditionProfile discovered7BitProfile;

            MakeUnknownLeafRopeBinaryNode_(MakeLeafRopeNodeGen root, ConditionProfile discovered7BitProfile) {
                super(root, 7);
                this.discovered7BitProfile = discovered7BitProfile;
            }

            @Override
            public LeafRope executeLeafRope(byte[] bytesValue, Encoding encodingValue, CodeRange codeRangeValue, Object characterLengthValue) {
                if (RopeNodes.MakeLeafRopeNode.isUnknown(codeRangeValue) && !RopeNodes.MakeLeafRopeNode.isEmpty(bytesValue) && RopeNodes.MakeLeafRopeNode.isBinaryString(encodingValue)) {
                    return this.root.makeUnknownLeafRopeBinary(bytesValue, encodingValue, codeRangeValue, characterLengthValue, this.discovered7BitProfile);
                }
                return this.getNext().executeLeafRope(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            @Override
            public LeafRope executeLeafRope_(Object bytesValue, Object encodingValue, Object codeRangeValue, Object characterLengthValue) {
                if (bytesValue instanceof byte[] && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    byte[] bytesValue_ = (byte[])bytesValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (RopeNodes.MakeLeafRopeNode.isUnknown(codeRangeValue_) && !RopeNodes.MakeLeafRopeNode.isEmpty(bytesValue_) && RopeNodes.MakeLeafRopeNode.isBinaryString(encodingValue_)) {
                        return this.root.makeUnknownLeafRopeBinary(bytesValue_, encodingValue_, codeRangeValue_, characterLengthValue, this.discovered7BitProfile);
                    }
                }
                return this.getNext().executeLeafRope_(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            static BaseNode_ create(MakeLeafRopeNodeGen root, ConditionProfile discovered7BitProfile) {
                return new MakeUnknownLeafRopeBinaryNode_(root, discovered7BitProfile);
            }
        }

        @GeneratedBy(methodName="makeUnknownLeafRopeEmpty(byte[], Encoding, CodeRange, Object, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile)", value=RopeNodes.MakeLeafRopeNode.class)
        private static final class MakeUnknownLeafRopeEmptyNode_
        extends BaseNode_ {
            private final ConditionProfile isUTF8;
            private final ConditionProfile isUSAscii;
            private final ConditionProfile isAscii8Bit;
            private final ConditionProfile isAsciiCompatible;

            MakeUnknownLeafRopeEmptyNode_(MakeLeafRopeNodeGen root, ConditionProfile isUTF8, ConditionProfile isUSAscii, ConditionProfile isAscii8Bit, ConditionProfile isAsciiCompatible) {
                super(root, 6);
                this.isUTF8 = isUTF8;
                this.isUSAscii = isUSAscii;
                this.isAscii8Bit = isAscii8Bit;
                this.isAsciiCompatible = isAsciiCompatible;
            }

            @Override
            public LeafRope executeLeafRope(byte[] bytesValue, Encoding encodingValue, CodeRange codeRangeValue, Object characterLengthValue) {
                if (RopeNodes.MakeLeafRopeNode.isUnknown(codeRangeValue) && RopeNodes.MakeLeafRopeNode.isEmpty(bytesValue)) {
                    return this.root.makeUnknownLeafRopeEmpty(bytesValue, encodingValue, codeRangeValue, characterLengthValue, this.isUTF8, this.isUSAscii, this.isAscii8Bit, this.isAsciiCompatible);
                }
                return this.getNext().executeLeafRope(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            @Override
            public LeafRope executeLeafRope_(Object bytesValue, Object encodingValue, Object codeRangeValue, Object characterLengthValue) {
                if (bytesValue instanceof byte[] && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    byte[] bytesValue_ = (byte[])bytesValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (RopeNodes.MakeLeafRopeNode.isUnknown(codeRangeValue_) && RopeNodes.MakeLeafRopeNode.isEmpty(bytesValue_)) {
                        return this.root.makeUnknownLeafRopeEmpty(bytesValue_, encodingValue_, codeRangeValue_, characterLengthValue, this.isUTF8, this.isUSAscii, this.isAscii8Bit, this.isAsciiCompatible);
                    }
                }
                return this.getNext().executeLeafRope_(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            static BaseNode_ create(MakeLeafRopeNodeGen root, ConditionProfile isUTF8, ConditionProfile isUSAscii, ConditionProfile isAscii8Bit, ConditionProfile isAsciiCompatible) {
                return new MakeUnknownLeafRopeEmptyNode_(root, isUTF8, isUSAscii, isAscii8Bit, isAsciiCompatible);
            }
        }

        @GeneratedBy(methodName="makeInvalidLeafRope(byte[], Encoding, CodeRange, Object)", value=RopeNodes.MakeLeafRopeNode.class)
        private static final class MakeInvalidLeafRopeNode_
        extends BaseNode_ {
            MakeInvalidLeafRopeNode_(MakeLeafRopeNodeGen root) {
                super(root, 5);
            }

            @Override
            public LeafRope executeLeafRope(byte[] bytesValue, Encoding encodingValue, CodeRange codeRangeValue, Object characterLengthValue) {
                if (RopeNodes.MakeLeafRopeNode.isBroken(codeRangeValue)) {
                    return this.root.makeInvalidLeafRope(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
                }
                return this.getNext().executeLeafRope(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            @Override
            public LeafRope executeLeafRope_(Object bytesValue, Object encodingValue, Object codeRangeValue, Object characterLengthValue) {
                if (bytesValue instanceof byte[] && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    byte[] bytesValue_ = (byte[])bytesValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (RopeNodes.MakeLeafRopeNode.isBroken(codeRangeValue_)) {
                        return this.root.makeInvalidLeafRope(bytesValue_, encodingValue_, codeRangeValue_, characterLengthValue);
                    }
                }
                return this.getNext().executeLeafRope_(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            static BaseNode_ create(MakeLeafRopeNodeGen root) {
                return new MakeInvalidLeafRopeNode_(root);
            }
        }

        @GeneratedBy(methodName="makeValidLeafRope(byte[], Encoding, CodeRange, Object)", value=RopeNodes.MakeLeafRopeNode.class)
        private static final class MakeValidLeafRopeNode_
        extends BaseNode_ {
            MakeValidLeafRopeNode_(MakeLeafRopeNodeGen root) {
                super(root, 4);
            }

            @Override
            public LeafRope executeLeafRope(byte[] bytesValue, Encoding encodingValue, CodeRange codeRangeValue, Object characterLengthValue) {
                if (RopeNodes.MakeLeafRopeNode.isValid(codeRangeValue) && !RopeNodes.MakeLeafRopeNode.isFixedWidth(encodingValue) && RubyGuards.wasNotProvided(characterLengthValue)) {
                    return this.root.makeValidLeafRope(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
                }
                return this.getNext().executeLeafRope(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            @Override
            public LeafRope executeLeafRope_(Object bytesValue, Object encodingValue, Object codeRangeValue, Object characterLengthValue) {
                if (bytesValue instanceof byte[] && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    byte[] bytesValue_ = (byte[])bytesValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (RopeNodes.MakeLeafRopeNode.isValid(codeRangeValue_) && !RopeNodes.MakeLeafRopeNode.isFixedWidth(encodingValue_) && RubyGuards.wasNotProvided(characterLengthValue)) {
                        return this.root.makeValidLeafRope(bytesValue_, encodingValue_, codeRangeValue_, characterLengthValue);
                    }
                }
                return this.getNext().executeLeafRope_(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            static BaseNode_ create(MakeLeafRopeNodeGen root) {
                return new MakeValidLeafRopeNode_(root);
            }
        }

        @GeneratedBy(methodName="makeValidLeafRopeFixedWidthEncoding(byte[], Encoding, CodeRange, Object)", value=RopeNodes.MakeLeafRopeNode.class)
        private static final class MakeValidLeafRopeFixedWidthEncodingNode_
        extends BaseNode_ {
            MakeValidLeafRopeFixedWidthEncodingNode_(MakeLeafRopeNodeGen root) {
                super(root, 3);
            }

            @Override
            public LeafRope executeLeafRope(byte[] bytesValue, Encoding encodingValue, CodeRange codeRangeValue, Object characterLengthValue) {
                if (RopeNodes.MakeLeafRopeNode.isValid(codeRangeValue) && RopeNodes.MakeLeafRopeNode.isFixedWidth(encodingValue) && RubyGuards.wasNotProvided(characterLengthValue)) {
                    return this.root.makeValidLeafRopeFixedWidthEncoding(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
                }
                return this.getNext().executeLeafRope(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            @Override
            public LeafRope executeLeafRope_(Object bytesValue, Object encodingValue, Object codeRangeValue, Object characterLengthValue) {
                if (bytesValue instanceof byte[] && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    byte[] bytesValue_ = (byte[])bytesValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (RopeNodes.MakeLeafRopeNode.isValid(codeRangeValue_) && RopeNodes.MakeLeafRopeNode.isFixedWidth(encodingValue_) && RubyGuards.wasNotProvided(characterLengthValue)) {
                        return this.root.makeValidLeafRopeFixedWidthEncoding(bytesValue_, encodingValue_, codeRangeValue_, characterLengthValue);
                    }
                }
                return this.getNext().executeLeafRope_(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            static BaseNode_ create(MakeLeafRopeNodeGen root) {
                return new MakeValidLeafRopeFixedWidthEncodingNode_(root);
            }
        }

        @GeneratedBy(methodName="makeValidLeafRopeWithCharacterLength(byte[], Encoding, CodeRange, int)", value=RopeNodes.MakeLeafRopeNode.class)
        private static final class MakeValidLeafRopeWithCharacterLengthNode_
        extends BaseNode_ {
            private final Class<?> characterLengthImplicitType;

            MakeValidLeafRopeWithCharacterLengthNode_(MakeLeafRopeNodeGen root, Object characterLengthValue) {
                super(root, 2);
                this.characterLengthImplicitType = RubyTypesGen.getImplicitIntegerClass(characterLengthValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.characterLengthImplicitType == ((MakeValidLeafRopeWithCharacterLengthNode_)other).characterLengthImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int characterLengthValue_;
                CodeRange codeRangeValue_;
                Encoding encodingValue_;
                byte[] bytesValue_;
                try {
                    bytesValue_ = MakeLeafRopeNodeGen.expectByteArray(this.root.bytes_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object encodingValue = this.root.encoding_.execute(frameValue);
                    Object codeRangeValue = this.root.codeRange_.execute(frameValue);
                    Object characterLengthValue = this.executeCharacterLength_(frameValue);
                    return this.getNext().executeLeafRope_(ex.getResult(), encodingValue, codeRangeValue, characterLengthValue);
                }
                try {
                    encodingValue_ = MakeLeafRopeNodeGen.expectEncoding(this.root.encoding_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object codeRangeValue = this.root.codeRange_.execute(frameValue);
                    Object characterLengthValue = this.executeCharacterLength_(frameValue);
                    return this.getNext().executeLeafRope_(bytesValue_, ex.getResult(), codeRangeValue, characterLengthValue);
                }
                try {
                    codeRangeValue_ = MakeLeafRopeNodeGen.expectCodeRange(this.root.codeRange_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object characterLengthValue = this.executeCharacterLength_(frameValue);
                    return this.getNext().executeLeafRope_(bytesValue_, encodingValue_, ex.getResult(), characterLengthValue);
                }
                try {
                    if (this.characterLengthImplicitType == Integer.TYPE) {
                        characterLengthValue_ = this.root.characterLength_.executeInteger(frameValue);
                    } else {
                        Object characterLengthValue__ = this.executeCharacterLength_(frameValue);
                        characterLengthValue_ = RubyTypesGen.expectImplicitInteger(characterLengthValue__, this.characterLengthImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeLeafRope_(bytesValue_, encodingValue_, (Object)codeRangeValue_, ex.getResult());
                }
                if (RopeNodes.MakeLeafRopeNode.isValid(codeRangeValue_) && RubyGuards.wasProvided(characterLengthValue_)) {
                    return this.root.makeValidLeafRopeWithCharacterLength(bytesValue_, encodingValue_, codeRangeValue_, characterLengthValue_);
                }
                return this.getNext().executeLeafRope_(bytesValue_, encodingValue_, (Object)codeRangeValue_, characterLengthValue_);
            }

            @Override
            public LeafRope executeLeafRope(byte[] bytesValue, Encoding encodingValue, CodeRange codeRangeValue, Object characterLengthValue) {
                if (RubyTypesGen.isImplicitInteger(characterLengthValue, this.characterLengthImplicitType)) {
                    int characterLengthValue_ = RubyTypesGen.asImplicitInteger(characterLengthValue, this.characterLengthImplicitType);
                    if (RopeNodes.MakeLeafRopeNode.isValid(codeRangeValue) && RubyGuards.wasProvided(characterLengthValue_)) {
                        return this.root.makeValidLeafRopeWithCharacterLength(bytesValue, encodingValue, codeRangeValue, characterLengthValue_);
                    }
                }
                return this.getNext().executeLeafRope(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            @Override
            public LeafRope executeLeafRope_(Object bytesValue, Object encodingValue, Object codeRangeValue, Object characterLengthValue) {
                if (bytesValue instanceof byte[] && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange && RubyTypesGen.isImplicitInteger(characterLengthValue, this.characterLengthImplicitType)) {
                    byte[] bytesValue_ = (byte[])bytesValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    int characterLengthValue_ = RubyTypesGen.asImplicitInteger(characterLengthValue, this.characterLengthImplicitType);
                    if (RopeNodes.MakeLeafRopeNode.isValid(codeRangeValue_) && RubyGuards.wasProvided(characterLengthValue_)) {
                        return this.root.makeValidLeafRopeWithCharacterLength(bytesValue_, encodingValue_, codeRangeValue_, characterLengthValue_);
                    }
                }
                return this.getNext().executeLeafRope_(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            static BaseNode_ create(MakeLeafRopeNodeGen root, Object characterLengthValue) {
                return new MakeValidLeafRopeWithCharacterLengthNode_(root, characterLengthValue);
            }
        }

        @GeneratedBy(methodName="makeAsciiOnlyLeafRope(byte[], Encoding, CodeRange, Object)", value=RopeNodes.MakeLeafRopeNode.class)
        private static final class MakeAsciiOnlyLeafRopeNode_
        extends BaseNode_ {
            MakeAsciiOnlyLeafRopeNode_(MakeLeafRopeNodeGen root) {
                super(root, 1);
            }

            @Override
            public LeafRope executeLeafRope(byte[] bytesValue, Encoding encodingValue, CodeRange codeRangeValue, Object characterLengthValue) {
                if (RopeNodes.MakeLeafRopeNode.is7Bit(codeRangeValue)) {
                    return this.root.makeAsciiOnlyLeafRope(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
                }
                return this.getNext().executeLeafRope(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            @Override
            public LeafRope executeLeafRope_(Object bytesValue, Object encodingValue, Object codeRangeValue, Object characterLengthValue) {
                if (bytesValue instanceof byte[] && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    byte[] bytesValue_ = (byte[])bytesValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (RopeNodes.MakeLeafRopeNode.is7Bit(codeRangeValue_)) {
                        return this.root.makeAsciiOnlyLeafRope(bytesValue_, encodingValue_, codeRangeValue_, characterLengthValue);
                    }
                }
                return this.getNext().executeLeafRope_(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            static BaseNode_ create(MakeLeafRopeNodeGen root) {
                return new MakeAsciiOnlyLeafRopeNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.MakeLeafRopeNode.class)
        private static final class PolymorphicNode_
        extends BaseNode_ {
            PolymorphicNode_(MakeLeafRopeNodeGen root) {
                super(root, 0);
            }

            @Override
            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object bytesValue, Object encodingValue, Object codeRangeValue, Object characterLengthValue) {
                return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, bytesValue, encodingValue, codeRangeValue, characterLengthValue));
            }

            @Override
            public LeafRope executeLeafRope_(Object bytesValue, Object encodingValue, Object codeRangeValue, Object characterLengthValue) {
                return this.getNext().executeLeafRope_(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            static BaseNode_ create(MakeLeafRopeNodeGen root) {
                return new PolymorphicNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.MakeLeafRopeNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(MakeLeafRopeNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public LeafRope executeLeafRope_(Object bytesValue, Object encodingValue, Object codeRangeValue, Object characterLengthValue) {
                return (LeafRope)this.uninitialized((Frame)null, bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            static BaseNode_ create(MakeLeafRopeNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.MakeLeafRopeNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            @CompilerDirectives.CompilationFinal
            protected MakeLeafRopeNodeGen root;

            BaseNode_(MakeLeafRopeNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            @Override
            protected final void setRoot(Node root) {
                this.root = (MakeLeafRopeNodeGen)root;
            }

            @Override
            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.bytes_, this.root.encoding_, this.root.codeRange_, this.root.characterLength_};
            }

            @Override
            public final Object acceptAndExecute(Frame frameValue, Object bytesValue, Object encodingValue, Object codeRangeValue, Object characterLengthValue) {
                return this.executeLeafRope_(bytesValue, encodingValue, codeRangeValue, characterLengthValue);
            }

            public abstract LeafRope executeLeafRope_(Object var1, Object var2, Object var3, Object var4);

            public LeafRope executeLeafRope(byte[] bytesValue, Encoding encodingValue, CodeRange codeRangeValue, Object characterLengthValue) {
                return this.executeLeafRope_(bytesValue, encodingValue, (Object)codeRangeValue, characterLengthValue);
            }

            public Object execute(VirtualFrame frameValue) {
                Object bytesValue_ = this.root.bytes_.execute(frameValue);
                Object encodingValue_ = this.root.encoding_.execute(frameValue);
                Object codeRangeValue_ = this.root.codeRange_.execute(frameValue);
                Object characterLengthValue_ = this.executeCharacterLength_(frameValue);
                return this.executeLeafRope_(bytesValue_, encodingValue_, codeRangeValue_, characterLengthValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            @Override
            protected final SpecializationNode createNext(Frame frameValue, Object bytesValue, Object encodingValue, Object codeRangeValue, Object characterLengthValue) {
                if (bytesValue instanceof byte[] && encodingValue instanceof Encoding && codeRangeValue instanceof CodeRange) {
                    byte[] bytesValue_ = (byte[])bytesValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    CodeRange codeRangeValue_ = (CodeRange)((Object)codeRangeValue);
                    if (RopeNodes.MakeLeafRopeNode.is7Bit(codeRangeValue_)) {
                        return MakeAsciiOnlyLeafRopeNode_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitInteger(characterLengthValue)) {
                        int characterLengthValue_ = RubyTypesGen.asImplicitInteger(characterLengthValue);
                        if (RopeNodes.MakeLeafRopeNode.isValid(codeRangeValue_) && RubyGuards.wasProvided(characterLengthValue_)) {
                            return MakeValidLeafRopeWithCharacterLengthNode_.create(this.root, characterLengthValue);
                        }
                    }
                    if (RopeNodes.MakeLeafRopeNode.isValid(codeRangeValue_) && RopeNodes.MakeLeafRopeNode.isFixedWidth(encodingValue_) && RubyGuards.wasNotProvided(characterLengthValue)) {
                        return MakeValidLeafRopeFixedWidthEncodingNode_.create(this.root);
                    }
                    if (RopeNodes.MakeLeafRopeNode.isValid(codeRangeValue_) && !RopeNodes.MakeLeafRopeNode.isFixedWidth(encodingValue_) && RubyGuards.wasNotProvided(characterLengthValue)) {
                        return MakeValidLeafRopeNode_.create(this.root);
                    }
                    if (RopeNodes.MakeLeafRopeNode.isBroken(codeRangeValue_)) {
                        return MakeInvalidLeafRopeNode_.create(this.root);
                    }
                    if (RopeNodes.MakeLeafRopeNode.isUnknown(codeRangeValue_) && RopeNodes.MakeLeafRopeNode.isEmpty(bytesValue_)) {
                        ConditionProfile isUTF86 = ConditionProfile.createBinaryProfile();
                        ConditionProfile isUSAscii6 = ConditionProfile.createBinaryProfile();
                        ConditionProfile isAscii8Bit6 = ConditionProfile.createBinaryProfile();
                        ConditionProfile isAsciiCompatible6 = ConditionProfile.createBinaryProfile();
                        return MakeUnknownLeafRopeEmptyNode_.create(this.root, isUTF86, isUSAscii6, isAscii8Bit6, isAsciiCompatible6);
                    }
                    if (RopeNodes.MakeLeafRopeNode.isUnknown(codeRangeValue_) && !RopeNodes.MakeLeafRopeNode.isEmpty(bytesValue_) && RopeNodes.MakeLeafRopeNode.isBinaryString(encodingValue_)) {
                        ConditionProfile discovered7BitProfile7 = ConditionProfile.createBinaryProfile();
                        return MakeUnknownLeafRopeBinaryNode_.create(this.root, discovered7BitProfile7);
                    }
                    if (RopeNodes.MakeLeafRopeNode.isUnknown(codeRangeValue_) && !RopeNodes.MakeLeafRopeNode.isEmpty(bytesValue_) && !RopeNodes.MakeLeafRopeNode.isBinaryString(encodingValue_) && RopeNodes.MakeLeafRopeNode.isAsciiCompatible(encodingValue_)) {
                        ConditionProfile discovered7BitProfile8 = ConditionProfile.createBinaryProfile();
                        ConditionProfile discoveredValidProfile8 = ConditionProfile.createBinaryProfile();
                        return MakeUnknownLeafRopeAsciiCompatibleNode_.create(this.root, discovered7BitProfile8, discoveredValidProfile8);
                    }
                    if (RopeNodes.MakeLeafRopeNode.isUnknown(codeRangeValue_) && !RopeNodes.MakeLeafRopeNode.isEmpty(bytesValue_) && !RopeNodes.MakeLeafRopeNode.isBinaryString(encodingValue_) && !RopeNodes.MakeLeafRopeNode.isAsciiCompatible(encodingValue_)) {
                        ConditionProfile discovered7BitProfile9 = ConditionProfile.createBinaryProfile();
                        ConditionProfile discoveredValidProfile9 = ConditionProfile.createBinaryProfile();
                        return MakeUnknownLeafRopeNode_.create(this.root, discovered7BitProfile9, discoveredValidProfile9);
                    }
                }
                return null;
            }

            @Override
            protected final SpecializationNode createPolymorphic() {
                return PolymorphicNode_.create(this.root);
            }

            protected final BaseNode_ getNext() {
                return (BaseNode_)this.next;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected final Object executeCharacterLength_(Frame frameValue) {
                Object object;
                Class characterLengthType_ = this.root.characterLengthType_;
                if (characterLengthType_ == Integer.TYPE) {
                    return this.root.characterLength_.executeInteger((VirtualFrame)frameValue);
                }
                if (characterLengthType_ != null) return this.root.characterLength_.execute((VirtualFrame)frameValue);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Class<Object> _type = Object.class;
                try {
                    Object _value = this.root.characterLength_.execute((VirtualFrame)frameValue);
                    _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                    object = _value;
                }
                catch (Throwable throwable) {
                    try {
                        this.root.characterLengthType_ = _type;
                        throw throwable;
                    }
                    catch (UnexpectedResultException ex) {
                        this.root.characterLengthType_ = Object.class;
                        return ex.getResult();
                    }
                }
                this.root.characterLengthType_ = _type;
                return object;
            }
        }
    }

    @GeneratedBy(value=RopeNodes.MakeConcatNode.class)
    public static final class MakeConcatNodeGen
    extends RopeNodes.MakeConcatNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode left_;
        @Node.Child
        private RubyNode right_;
        @Node.Child
        private RubyNode encoding_;
        @Node.Child
        private BaseNode_ specialization_;

        private MakeConcatNodeGen(RubyNode left, RubyNode right, RubyNode encoding) {
            this.left_ = left;
            this.right_ = right;
            this.encoding_ = encoding;
            this.specialization_ = UninitializedNode_.create(this);
        }

        @Override
        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public Rope executeMake(Rope leftValue, Rope rightValue, Encoding encodingValue) {
            return this.specialization_.executeRope(leftValue, rightValue, encodingValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        @Override
        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        @Override
        public Node deepCopy() {
            return SpecializationNode.updateRoot(super.deepCopy());
        }

        public static RopeNodes.MakeConcatNode create(RubyNode left, RubyNode right, RubyNode encoding) {
            return new MakeConcatNodeGen(left, right, encoding);
        }

        @GeneratedBy(methodName="concat(Rope, Rope, Encoding, ConditionProfile, ConditionProfile, ConditionProfile)", value=RopeNodes.MakeConcatNode.class)
        private static final class ConcatNode_
        extends BaseNode_ {
            private final ConditionProfile sameCodeRangeProfile;
            private final ConditionProfile brokenCodeRangeProfile;
            private final ConditionProfile isLeftSingleByteOptimizableProfile;

            ConcatNode_(MakeConcatNodeGen root, ConditionProfile sameCodeRangeProfile, ConditionProfile brokenCodeRangeProfile, ConditionProfile isLeftSingleByteOptimizableProfile) {
                super(root, 2);
                this.sameCodeRangeProfile = sameCodeRangeProfile;
                this.brokenCodeRangeProfile = brokenCodeRangeProfile;
                this.isLeftSingleByteOptimizableProfile = isLeftSingleByteOptimizableProfile;
            }

            @Override
            public Rope executeRope(Rope leftValue, Rope rightValue, Encoding encodingValue) {
                if (!RopeNodes.MakeConcatNode.isMutableRope(leftValue)) {
                    return this.root.concat(leftValue, rightValue, encodingValue, this.sameCodeRangeProfile, this.brokenCodeRangeProfile, this.isLeftSingleByteOptimizableProfile);
                }
                return this.getNext().executeRope(leftValue, rightValue, encodingValue);
            }

            @Override
            public Rope executeRope_(Object leftValue, Object rightValue, Object encodingValue) {
                if (leftValue instanceof Rope && rightValue instanceof Rope && encodingValue instanceof Encoding) {
                    Rope leftValue_ = (Rope)leftValue;
                    Rope rightValue_ = (Rope)rightValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    if (!RopeNodes.MakeConcatNode.isMutableRope(leftValue_)) {
                        return this.root.concat(leftValue_, rightValue_, encodingValue_, this.sameCodeRangeProfile, this.brokenCodeRangeProfile, this.isLeftSingleByteOptimizableProfile);
                    }
                }
                return this.getNext().executeRope_(leftValue, rightValue, encodingValue);
            }

            static BaseNode_ create(MakeConcatNodeGen root, ConditionProfile sameCodeRangeProfile, ConditionProfile brokenCodeRangeProfile, ConditionProfile isLeftSingleByteOptimizableProfile) {
                return new ConcatNode_(root, sameCodeRangeProfile, brokenCodeRangeProfile, isLeftSingleByteOptimizableProfile);
            }
        }

        @GeneratedBy(methodName="concatMutableRope(RopeBuffer, Rope, Encoding, ConditionProfile)", value=RopeNodes.MakeConcatNode.class)
        private static final class ConcatMutableRopeNode_
        extends BaseNode_ {
            private final ConditionProfile differentEncodingProfile;

            ConcatMutableRopeNode_(MakeConcatNodeGen root, ConditionProfile differentEncodingProfile) {
                super(root, 1);
                this.differentEncodingProfile = differentEncodingProfile;
            }

            @Override
            public Rope executeRope(Rope leftValue, Rope rightValue, Encoding encodingValue) {
                RopeBuffer leftValue_;
                if (leftValue instanceof RopeBuffer && RopeNodes.MakeConcatNode.isMutableRope(leftValue_ = (RopeBuffer)leftValue)) {
                    return this.root.concatMutableRope(leftValue_, rightValue, encodingValue, this.differentEncodingProfile);
                }
                return this.getNext().executeRope(leftValue, rightValue, encodingValue);
            }

            @Override
            public Rope executeRope_(Object leftValue, Object rightValue, Object encodingValue) {
                if (leftValue instanceof RopeBuffer && rightValue instanceof Rope && encodingValue instanceof Encoding) {
                    RopeBuffer leftValue_ = (RopeBuffer)leftValue;
                    Rope rightValue_ = (Rope)rightValue;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    if (RopeNodes.MakeConcatNode.isMutableRope(leftValue_)) {
                        return this.root.concatMutableRope(leftValue_, rightValue_, encodingValue_, this.differentEncodingProfile);
                    }
                }
                return this.getNext().executeRope_(leftValue, rightValue, encodingValue);
            }

            static BaseNode_ create(MakeConcatNodeGen root, ConditionProfile differentEncodingProfile) {
                return new ConcatMutableRopeNode_(root, differentEncodingProfile);
            }
        }

        @GeneratedBy(value=RopeNodes.MakeConcatNode.class)
        private static final class PolymorphicNode_
        extends BaseNode_ {
            PolymorphicNode_(MakeConcatNodeGen root) {
                super(root, 0);
            }

            @Override
            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object leftValue, Object rightValue, Object encodingValue) {
                return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, leftValue, rightValue, encodingValue));
            }

            @Override
            public Rope executeRope_(Object leftValue, Object rightValue, Object encodingValue) {
                return this.getNext().executeRope_(leftValue, rightValue, encodingValue);
            }

            static BaseNode_ create(MakeConcatNodeGen root) {
                return new PolymorphicNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.MakeConcatNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(MakeConcatNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public Rope executeRope_(Object leftValue, Object rightValue, Object encodingValue) {
                return (Rope)this.uninitialized((Frame)null, leftValue, rightValue, encodingValue);
            }

            static BaseNode_ create(MakeConcatNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.MakeConcatNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            @CompilerDirectives.CompilationFinal
            protected MakeConcatNodeGen root;

            BaseNode_(MakeConcatNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            @Override
            protected final void setRoot(Node root) {
                this.root = (MakeConcatNodeGen)root;
            }

            @Override
            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.left_, this.root.right_, this.root.encoding_};
            }

            @Override
            public final Object acceptAndExecute(Frame frameValue, Object leftValue, Object rightValue, Object encodingValue) {
                return this.executeRope_(leftValue, rightValue, encodingValue);
            }

            public abstract Rope executeRope_(Object var1, Object var2, Object var3);

            public Rope executeRope(Rope leftValue, Rope rightValue, Encoding encodingValue) {
                return this.executeRope_(leftValue, rightValue, encodingValue);
            }

            public Object execute(VirtualFrame frameValue) {
                Object leftValue_ = this.root.left_.execute(frameValue);
                Object rightValue_ = this.root.right_.execute(frameValue);
                Object encodingValue_ = this.root.encoding_.execute(frameValue);
                return this.executeRope_(leftValue_, rightValue_, encodingValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            @Override
            protected final SpecializationNode createNext(Frame frameValue, Object leftValue, Object rightValue, Object encodingValue) {
                if (rightValue instanceof Rope && encodingValue instanceof Encoding) {
                    Rope leftValue_;
                    if (leftValue instanceof RopeBuffer && RopeNodes.MakeConcatNode.isMutableRope(leftValue_ = (RopeBuffer)leftValue)) {
                        ConditionProfile differentEncodingProfile1 = ConditionProfile.createBinaryProfile();
                        return ConcatMutableRopeNode_.create(this.root, differentEncodingProfile1);
                    }
                    if (leftValue instanceof Rope && !RopeNodes.MakeConcatNode.isMutableRope(leftValue_ = (Rope)leftValue)) {
                        ConditionProfile sameCodeRangeProfile2 = ConditionProfile.createBinaryProfile();
                        ConditionProfile brokenCodeRangeProfile2 = ConditionProfile.createBinaryProfile();
                        ConditionProfile isLeftSingleByteOptimizableProfile2 = ConditionProfile.createBinaryProfile();
                        return ConcatNode_.create(this.root, sameCodeRangeProfile2, brokenCodeRangeProfile2, isLeftSingleByteOptimizableProfile2);
                    }
                }
                return null;
            }

            @Override
            protected final SpecializationNode createPolymorphic() {
                return PolymorphicNode_.create(this.root);
            }

            protected final BaseNode_ getNext() {
                return (BaseNode_)this.next;
            }
        }
    }

    @GeneratedBy(value=RopeNodes.MakeSubstringNode.class)
    @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
    public static final class MakeSubstringNodeGen
    extends RopeNodes.MakeSubstringNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode base_;
        @Node.Child
        private RubyNode offset_;
        @Node.Child
        private RubyNode byteLength_;
        @CompilerDirectives.CompilationFinal
        private Class<?> offsetType_;
        @CompilerDirectives.CompilationFinal
        private Class<?> byteLengthType_;
        @Node.Child
        private BaseNode_ specialization_;

        private MakeSubstringNodeGen(RubyNode base, RubyNode offset, RubyNode byteLength) {
            this.base_ = base;
            this.offset_ = offset;
            this.byteLength_ = byteLength;
            this.specialization_ = UninitializedNode_.create(this);
        }

        @Override
        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public Rope executeMake(Rope baseValue, int offsetValue, int byteLengthValue) {
            return this.specialization_.executeRope(baseValue, offsetValue, byteLengthValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        @Override
        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        @Override
        public Node deepCopy() {
            return SpecializationNode.updateRoot(super.deepCopy());
        }

        private static ConcatRope expectConcatRope(Object value) throws UnexpectedResultException {
            if (value instanceof ConcatRope) {
                return (ConcatRope)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static LazyRope expectLazyRope(Object value) throws UnexpectedResultException {
            if (value instanceof LazyRope) {
                return (LazyRope)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static LeafRope expectLeafRope(Object value) throws UnexpectedResultException {
            if (value instanceof LeafRope) {
                return (LeafRope)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static RepeatingRope expectRepeatingRope(Object value) throws UnexpectedResultException {
            if (value instanceof RepeatingRope) {
                return (RepeatingRope)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static SubstringRope expectSubstringRope(Object value) throws UnexpectedResultException {
            if (value instanceof SubstringRope) {
                return (SubstringRope)value;
            }
            throw new UnexpectedResultException(value);
        }

        private static Rope expectRope(Object value) throws UnexpectedResultException {
            if (value instanceof Rope) {
                return (Rope)value;
            }
            throw new UnexpectedResultException(value);
        }

        public static RopeNodes.MakeSubstringNode create(RubyNode base, RubyNode offset, RubyNode byteLength) {
            return new MakeSubstringNodeGen(base, offset, byteLength);
        }

        @GeneratedBy(methodName="substringConcatRope(ConcatRope, int, int, ConditionProfile, ConditionProfile)", value=RopeNodes.MakeSubstringNode.class)
        private static final class SubstringConcatRopeNode_
        extends BaseNode_ {
            private final ConditionProfile is7BitProfile;
            private final ConditionProfile isBinaryStringProfile;
            private final Class<?> offsetImplicitType;
            private final Class<?> byteLengthImplicitType;

            SubstringConcatRopeNode_(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue, ConditionProfile is7BitProfile, ConditionProfile isBinaryStringProfile) {
                super(root, 8);
                this.offsetImplicitType = RubyTypesGen.getImplicitIntegerClass(offsetValue);
                this.byteLengthImplicitType = RubyTypesGen.getImplicitIntegerClass(byteLengthValue);
                this.is7BitProfile = is7BitProfile;
                this.isBinaryStringProfile = isBinaryStringProfile;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.offsetImplicitType == ((SubstringConcatRopeNode_)other).offsetImplicitType && this.byteLengthImplicitType == ((SubstringConcatRopeNode_)other).byteLengthImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int byteLengthValue_;
                int offsetValue_;
                ConcatRope baseValue_;
                try {
                    baseValue_ = MakeSubstringNodeGen.expectConcatRope(this.root.base_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object offsetValue = this.executeOffset_(frameValue);
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(ex.getResult(), offsetValue, byteLengthValue);
                }
                try {
                    if (this.offsetImplicitType == Integer.TYPE) {
                        offsetValue_ = this.root.offset_.executeInteger(frameValue);
                    } else {
                        Object offsetValue__ = this.executeOffset_(frameValue);
                        offsetValue_ = RubyTypesGen.expectImplicitInteger(offsetValue__, this.offsetImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(baseValue_, ex.getResult(), byteLengthValue);
                }
                try {
                    if (this.byteLengthImplicitType == Integer.TYPE) {
                        byteLengthValue_ = this.root.byteLength_.executeInteger(frameValue);
                    } else {
                        Object byteLengthValue__ = this.executeByteLength_(frameValue);
                        byteLengthValue_ = RubyTypesGen.expectImplicitInteger(byteLengthValue__, this.byteLengthImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeRope_(baseValue_, offsetValue_, ex.getResult());
                }
                if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                    return this.root.substringConcatRope(baseValue_, offsetValue_, byteLengthValue_, this.is7BitProfile, this.isBinaryStringProfile);
                }
                return this.getNext().executeRope_(baseValue_, offsetValue_, byteLengthValue_);
            }

            @Override
            public Rope executeRope(Rope baseValue, int offsetValue, int byteLengthValue) {
                if (baseValue instanceof ConcatRope) {
                    ConcatRope baseValue_ = (ConcatRope)baseValue;
                    if (byteLengthValue > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue, byteLengthValue)) {
                        return this.root.substringConcatRope(baseValue_, offsetValue, byteLengthValue, this.is7BitProfile, this.isBinaryStringProfile);
                    }
                }
                return this.getNext().executeRope(baseValue, offsetValue, byteLengthValue);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object offsetValue, Object byteLengthValue) {
                if (baseValue instanceof ConcatRope && RubyTypesGen.isImplicitInteger(offsetValue, this.offsetImplicitType) && RubyTypesGen.isImplicitInteger(byteLengthValue, this.byteLengthImplicitType)) {
                    ConcatRope baseValue_ = (ConcatRope)baseValue;
                    int offsetValue_ = RubyTypesGen.asImplicitInteger(offsetValue, this.offsetImplicitType);
                    int byteLengthValue_ = RubyTypesGen.asImplicitInteger(byteLengthValue, this.byteLengthImplicitType);
                    if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                        return this.root.substringConcatRope(baseValue_, offsetValue_, byteLengthValue_, this.is7BitProfile, this.isBinaryStringProfile);
                    }
                }
                return this.getNext().executeRope_(baseValue, offsetValue, byteLengthValue);
            }

            static BaseNode_ create(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue, ConditionProfile is7BitProfile, ConditionProfile isBinaryStringProfile) {
                return new SubstringConcatRopeNode_(root, offsetValue, byteLengthValue, is7BitProfile, isBinaryStringProfile);
            }
        }

        @GeneratedBy(methodName="substringLazyRope(LazyRope, int, int, ConditionProfile, ConditionProfile)", value=RopeNodes.MakeSubstringNode.class)
        private static final class SubstringLazyRopeNode_
        extends BaseNode_ {
            private final ConditionProfile is7BitProfile;
            private final ConditionProfile isBinaryStringProfile;
            private final Class<?> offsetImplicitType;
            private final Class<?> byteLengthImplicitType;

            SubstringLazyRopeNode_(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue, ConditionProfile is7BitProfile, ConditionProfile isBinaryStringProfile) {
                super(root, 7);
                this.offsetImplicitType = RubyTypesGen.getImplicitIntegerClass(offsetValue);
                this.byteLengthImplicitType = RubyTypesGen.getImplicitIntegerClass(byteLengthValue);
                this.is7BitProfile = is7BitProfile;
                this.isBinaryStringProfile = isBinaryStringProfile;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.offsetImplicitType == ((SubstringLazyRopeNode_)other).offsetImplicitType && this.byteLengthImplicitType == ((SubstringLazyRopeNode_)other).byteLengthImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int byteLengthValue_;
                int offsetValue_;
                LazyRope baseValue_;
                try {
                    baseValue_ = MakeSubstringNodeGen.expectLazyRope(this.root.base_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object offsetValue = this.executeOffset_(frameValue);
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(ex.getResult(), offsetValue, byteLengthValue);
                }
                try {
                    if (this.offsetImplicitType == Integer.TYPE) {
                        offsetValue_ = this.root.offset_.executeInteger(frameValue);
                    } else {
                        Object offsetValue__ = this.executeOffset_(frameValue);
                        offsetValue_ = RubyTypesGen.expectImplicitInteger(offsetValue__, this.offsetImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(baseValue_, ex.getResult(), byteLengthValue);
                }
                try {
                    if (this.byteLengthImplicitType == Integer.TYPE) {
                        byteLengthValue_ = this.root.byteLength_.executeInteger(frameValue);
                    } else {
                        Object byteLengthValue__ = this.executeByteLength_(frameValue);
                        byteLengthValue_ = RubyTypesGen.expectImplicitInteger(byteLengthValue__, this.byteLengthImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeRope_(baseValue_, offsetValue_, ex.getResult());
                }
                if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                    return this.root.substringLazyRope(baseValue_, offsetValue_, byteLengthValue_, this.is7BitProfile, this.isBinaryStringProfile);
                }
                return this.getNext().executeRope_(baseValue_, offsetValue_, byteLengthValue_);
            }

            @Override
            public Rope executeRope(Rope baseValue, int offsetValue, int byteLengthValue) {
                if (baseValue instanceof LazyRope) {
                    LazyRope baseValue_ = (LazyRope)baseValue;
                    if (byteLengthValue > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue, byteLengthValue)) {
                        return this.root.substringLazyRope(baseValue_, offsetValue, byteLengthValue, this.is7BitProfile, this.isBinaryStringProfile);
                    }
                }
                return this.getNext().executeRope(baseValue, offsetValue, byteLengthValue);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object offsetValue, Object byteLengthValue) {
                if (baseValue instanceof LazyRope && RubyTypesGen.isImplicitInteger(offsetValue, this.offsetImplicitType) && RubyTypesGen.isImplicitInteger(byteLengthValue, this.byteLengthImplicitType)) {
                    LazyRope baseValue_ = (LazyRope)baseValue;
                    int offsetValue_ = RubyTypesGen.asImplicitInteger(offsetValue, this.offsetImplicitType);
                    int byteLengthValue_ = RubyTypesGen.asImplicitInteger(byteLengthValue, this.byteLengthImplicitType);
                    if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                        return this.root.substringLazyRope(baseValue_, offsetValue_, byteLengthValue_, this.is7BitProfile, this.isBinaryStringProfile);
                    }
                }
                return this.getNext().executeRope_(baseValue, offsetValue, byteLengthValue);
            }

            static BaseNode_ create(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue, ConditionProfile is7BitProfile, ConditionProfile isBinaryStringProfile) {
                return new SubstringLazyRopeNode_(root, offsetValue, byteLengthValue, is7BitProfile, isBinaryStringProfile);
            }
        }

        @GeneratedBy(methodName="substringRepeatingRope(RepeatingRope, int, int, ConditionProfile, ConditionProfile, ConditionProfile)", value=RopeNodes.MakeSubstringNode.class)
        private static final class SubstringRepeatingRopeNode_
        extends BaseNode_ {
            private final ConditionProfile is7BitProfile;
            private final ConditionProfile isBinaryStringProfile;
            private final ConditionProfile matchesChildProfile;
            private final Class<?> offsetImplicitType;
            private final Class<?> byteLengthImplicitType;

            SubstringRepeatingRopeNode_(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue, ConditionProfile is7BitProfile, ConditionProfile isBinaryStringProfile, ConditionProfile matchesChildProfile) {
                super(root, 6);
                this.offsetImplicitType = RubyTypesGen.getImplicitIntegerClass(offsetValue);
                this.byteLengthImplicitType = RubyTypesGen.getImplicitIntegerClass(byteLengthValue);
                this.is7BitProfile = is7BitProfile;
                this.isBinaryStringProfile = isBinaryStringProfile;
                this.matchesChildProfile = matchesChildProfile;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.offsetImplicitType == ((SubstringRepeatingRopeNode_)other).offsetImplicitType && this.byteLengthImplicitType == ((SubstringRepeatingRopeNode_)other).byteLengthImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int byteLengthValue_;
                int offsetValue_;
                RepeatingRope baseValue_;
                try {
                    baseValue_ = MakeSubstringNodeGen.expectRepeatingRope(this.root.base_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object offsetValue = this.executeOffset_(frameValue);
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(ex.getResult(), offsetValue, byteLengthValue);
                }
                try {
                    if (this.offsetImplicitType == Integer.TYPE) {
                        offsetValue_ = this.root.offset_.executeInteger(frameValue);
                    } else {
                        Object offsetValue__ = this.executeOffset_(frameValue);
                        offsetValue_ = RubyTypesGen.expectImplicitInteger(offsetValue__, this.offsetImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(baseValue_, ex.getResult(), byteLengthValue);
                }
                try {
                    if (this.byteLengthImplicitType == Integer.TYPE) {
                        byteLengthValue_ = this.root.byteLength_.executeInteger(frameValue);
                    } else {
                        Object byteLengthValue__ = this.executeByteLength_(frameValue);
                        byteLengthValue_ = RubyTypesGen.expectImplicitInteger(byteLengthValue__, this.byteLengthImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeRope_(baseValue_, offsetValue_, ex.getResult());
                }
                if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                    return this.root.substringRepeatingRope(baseValue_, offsetValue_, byteLengthValue_, this.is7BitProfile, this.isBinaryStringProfile, this.matchesChildProfile);
                }
                return this.getNext().executeRope_(baseValue_, offsetValue_, byteLengthValue_);
            }

            @Override
            public Rope executeRope(Rope baseValue, int offsetValue, int byteLengthValue) {
                if (baseValue instanceof RepeatingRope) {
                    RepeatingRope baseValue_ = (RepeatingRope)baseValue;
                    if (byteLengthValue > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue, byteLengthValue)) {
                        return this.root.substringRepeatingRope(baseValue_, offsetValue, byteLengthValue, this.is7BitProfile, this.isBinaryStringProfile, this.matchesChildProfile);
                    }
                }
                return this.getNext().executeRope(baseValue, offsetValue, byteLengthValue);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object offsetValue, Object byteLengthValue) {
                if (baseValue instanceof RepeatingRope && RubyTypesGen.isImplicitInteger(offsetValue, this.offsetImplicitType) && RubyTypesGen.isImplicitInteger(byteLengthValue, this.byteLengthImplicitType)) {
                    RepeatingRope baseValue_ = (RepeatingRope)baseValue;
                    int offsetValue_ = RubyTypesGen.asImplicitInteger(offsetValue, this.offsetImplicitType);
                    int byteLengthValue_ = RubyTypesGen.asImplicitInteger(byteLengthValue, this.byteLengthImplicitType);
                    if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                        return this.root.substringRepeatingRope(baseValue_, offsetValue_, byteLengthValue_, this.is7BitProfile, this.isBinaryStringProfile, this.matchesChildProfile);
                    }
                }
                return this.getNext().executeRope_(baseValue, offsetValue, byteLengthValue);
            }

            static BaseNode_ create(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue, ConditionProfile is7BitProfile, ConditionProfile isBinaryStringProfile, ConditionProfile matchesChildProfile) {
                return new SubstringRepeatingRopeNode_(root, offsetValue, byteLengthValue, is7BitProfile, isBinaryStringProfile, matchesChildProfile);
            }
        }

        @GeneratedBy(methodName="substringSubstringRope(SubstringRope, int, int, ConditionProfile, ConditionProfile)", value=RopeNodes.MakeSubstringNode.class)
        private static final class SubstringSubstringRopeNode_
        extends BaseNode_ {
            private final ConditionProfile is7BitProfile;
            private final ConditionProfile isBinaryStringProfile;
            private final Class<?> offsetImplicitType;
            private final Class<?> byteLengthImplicitType;

            SubstringSubstringRopeNode_(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue, ConditionProfile is7BitProfile, ConditionProfile isBinaryStringProfile) {
                super(root, 5);
                this.offsetImplicitType = RubyTypesGen.getImplicitIntegerClass(offsetValue);
                this.byteLengthImplicitType = RubyTypesGen.getImplicitIntegerClass(byteLengthValue);
                this.is7BitProfile = is7BitProfile;
                this.isBinaryStringProfile = isBinaryStringProfile;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.offsetImplicitType == ((SubstringSubstringRopeNode_)other).offsetImplicitType && this.byteLengthImplicitType == ((SubstringSubstringRopeNode_)other).byteLengthImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int byteLengthValue_;
                int offsetValue_;
                SubstringRope baseValue_;
                try {
                    baseValue_ = MakeSubstringNodeGen.expectSubstringRope(this.root.base_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object offsetValue = this.executeOffset_(frameValue);
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(ex.getResult(), offsetValue, byteLengthValue);
                }
                try {
                    if (this.offsetImplicitType == Integer.TYPE) {
                        offsetValue_ = this.root.offset_.executeInteger(frameValue);
                    } else {
                        Object offsetValue__ = this.executeOffset_(frameValue);
                        offsetValue_ = RubyTypesGen.expectImplicitInteger(offsetValue__, this.offsetImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(baseValue_, ex.getResult(), byteLengthValue);
                }
                try {
                    if (this.byteLengthImplicitType == Integer.TYPE) {
                        byteLengthValue_ = this.root.byteLength_.executeInteger(frameValue);
                    } else {
                        Object byteLengthValue__ = this.executeByteLength_(frameValue);
                        byteLengthValue_ = RubyTypesGen.expectImplicitInteger(byteLengthValue__, this.byteLengthImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeRope_(baseValue_, offsetValue_, ex.getResult());
                }
                if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                    return this.root.substringSubstringRope(baseValue_, offsetValue_, byteLengthValue_, this.is7BitProfile, this.isBinaryStringProfile);
                }
                return this.getNext().executeRope_(baseValue_, offsetValue_, byteLengthValue_);
            }

            @Override
            public Rope executeRope(Rope baseValue, int offsetValue, int byteLengthValue) {
                if (baseValue instanceof SubstringRope) {
                    SubstringRope baseValue_ = (SubstringRope)baseValue;
                    if (byteLengthValue > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue, byteLengthValue)) {
                        return this.root.substringSubstringRope(baseValue_, offsetValue, byteLengthValue, this.is7BitProfile, this.isBinaryStringProfile);
                    }
                }
                return this.getNext().executeRope(baseValue, offsetValue, byteLengthValue);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object offsetValue, Object byteLengthValue) {
                if (baseValue instanceof SubstringRope && RubyTypesGen.isImplicitInteger(offsetValue, this.offsetImplicitType) && RubyTypesGen.isImplicitInteger(byteLengthValue, this.byteLengthImplicitType)) {
                    SubstringRope baseValue_ = (SubstringRope)baseValue;
                    int offsetValue_ = RubyTypesGen.asImplicitInteger(offsetValue, this.offsetImplicitType);
                    int byteLengthValue_ = RubyTypesGen.asImplicitInteger(byteLengthValue, this.byteLengthImplicitType);
                    if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                        return this.root.substringSubstringRope(baseValue_, offsetValue_, byteLengthValue_, this.is7BitProfile, this.isBinaryStringProfile);
                    }
                }
                return this.getNext().executeRope_(baseValue, offsetValue, byteLengthValue);
            }

            static BaseNode_ create(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue, ConditionProfile is7BitProfile, ConditionProfile isBinaryStringProfile) {
                return new SubstringSubstringRopeNode_(root, offsetValue, byteLengthValue, is7BitProfile, isBinaryStringProfile);
            }
        }

        @GeneratedBy(methodName="substringLeafRope(LeafRope, int, int, ConditionProfile, ConditionProfile)", value=RopeNodes.MakeSubstringNode.class)
        private static final class SubstringLeafRopeNode_
        extends BaseNode_ {
            private final ConditionProfile is7BitProfile;
            private final ConditionProfile isBinaryStringProfile;
            private final Class<?> offsetImplicitType;
            private final Class<?> byteLengthImplicitType;

            SubstringLeafRopeNode_(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue, ConditionProfile is7BitProfile, ConditionProfile isBinaryStringProfile) {
                super(root, 4);
                this.offsetImplicitType = RubyTypesGen.getImplicitIntegerClass(offsetValue);
                this.byteLengthImplicitType = RubyTypesGen.getImplicitIntegerClass(byteLengthValue);
                this.is7BitProfile = is7BitProfile;
                this.isBinaryStringProfile = isBinaryStringProfile;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.offsetImplicitType == ((SubstringLeafRopeNode_)other).offsetImplicitType && this.byteLengthImplicitType == ((SubstringLeafRopeNode_)other).byteLengthImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int byteLengthValue_;
                int offsetValue_;
                LeafRope baseValue_;
                try {
                    baseValue_ = MakeSubstringNodeGen.expectLeafRope(this.root.base_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object offsetValue = this.executeOffset_(frameValue);
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(ex.getResult(), offsetValue, byteLengthValue);
                }
                try {
                    if (this.offsetImplicitType == Integer.TYPE) {
                        offsetValue_ = this.root.offset_.executeInteger(frameValue);
                    } else {
                        Object offsetValue__ = this.executeOffset_(frameValue);
                        offsetValue_ = RubyTypesGen.expectImplicitInteger(offsetValue__, this.offsetImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(baseValue_, ex.getResult(), byteLengthValue);
                }
                try {
                    if (this.byteLengthImplicitType == Integer.TYPE) {
                        byteLengthValue_ = this.root.byteLength_.executeInteger(frameValue);
                    } else {
                        Object byteLengthValue__ = this.executeByteLength_(frameValue);
                        byteLengthValue_ = RubyTypesGen.expectImplicitInteger(byteLengthValue__, this.byteLengthImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeRope_(baseValue_, offsetValue_, ex.getResult());
                }
                if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                    return this.root.substringLeafRope(baseValue_, offsetValue_, byteLengthValue_, this.is7BitProfile, this.isBinaryStringProfile);
                }
                return this.getNext().executeRope_(baseValue_, offsetValue_, byteLengthValue_);
            }

            @Override
            public Rope executeRope(Rope baseValue, int offsetValue, int byteLengthValue) {
                if (baseValue instanceof LeafRope) {
                    LeafRope baseValue_ = (LeafRope)baseValue;
                    if (byteLengthValue > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue, byteLengthValue)) {
                        return this.root.substringLeafRope(baseValue_, offsetValue, byteLengthValue, this.is7BitProfile, this.isBinaryStringProfile);
                    }
                }
                return this.getNext().executeRope(baseValue, offsetValue, byteLengthValue);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object offsetValue, Object byteLengthValue) {
                if (baseValue instanceof LeafRope && RubyTypesGen.isImplicitInteger(offsetValue, this.offsetImplicitType) && RubyTypesGen.isImplicitInteger(byteLengthValue, this.byteLengthImplicitType)) {
                    LeafRope baseValue_ = (LeafRope)baseValue;
                    int offsetValue_ = RubyTypesGen.asImplicitInteger(offsetValue, this.offsetImplicitType);
                    int byteLengthValue_ = RubyTypesGen.asImplicitInteger(byteLengthValue, this.byteLengthImplicitType);
                    if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                        return this.root.substringLeafRope(baseValue_, offsetValue_, byteLengthValue_, this.is7BitProfile, this.isBinaryStringProfile);
                    }
                }
                return this.getNext().executeRope_(baseValue, offsetValue, byteLengthValue);
            }

            static BaseNode_ create(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue, ConditionProfile is7BitProfile, ConditionProfile isBinaryStringProfile) {
                return new SubstringLeafRopeNode_(root, offsetValue, byteLengthValue, is7BitProfile, isBinaryStringProfile);
            }
        }

        @GeneratedBy(methodName="substringSameAsBase(Rope, int, int)", value=RopeNodes.MakeSubstringNode.class)
        private static final class SubstringSameAsBaseNode_
        extends BaseNode_ {
            private final Class<?> offsetImplicitType;
            private final Class<?> byteLengthImplicitType;

            SubstringSameAsBaseNode_(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue) {
                super(root, 3);
                this.offsetImplicitType = RubyTypesGen.getImplicitIntegerClass(offsetValue);
                this.byteLengthImplicitType = RubyTypesGen.getImplicitIntegerClass(byteLengthValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.offsetImplicitType == ((SubstringSameAsBaseNode_)other).offsetImplicitType && this.byteLengthImplicitType == ((SubstringSameAsBaseNode_)other).byteLengthImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int byteLengthValue_;
                int offsetValue_;
                Rope baseValue_;
                try {
                    baseValue_ = MakeSubstringNodeGen.expectRope(this.root.base_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object offsetValue = this.executeOffset_(frameValue);
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(ex.getResult(), offsetValue, byteLengthValue);
                }
                try {
                    if (this.offsetImplicitType == Integer.TYPE) {
                        offsetValue_ = this.root.offset_.executeInteger(frameValue);
                    } else {
                        Object offsetValue__ = this.executeOffset_(frameValue);
                        offsetValue_ = RubyTypesGen.expectImplicitInteger(offsetValue__, this.offsetImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(baseValue_, ex.getResult(), byteLengthValue);
                }
                try {
                    if (this.byteLengthImplicitType == Integer.TYPE) {
                        byteLengthValue_ = this.root.byteLength_.executeInteger(frameValue);
                    } else {
                        Object byteLengthValue__ = this.executeByteLength_(frameValue);
                        byteLengthValue_ = RubyTypesGen.expectImplicitInteger(byteLengthValue__, this.byteLengthImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeRope_(baseValue_, offsetValue_, ex.getResult());
                }
                if (byteLengthValue_ > 1 && RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                    return this.root.substringSameAsBase(baseValue_, offsetValue_, byteLengthValue_);
                }
                return this.getNext().executeRope_(baseValue_, offsetValue_, byteLengthValue_);
            }

            @Override
            public Rope executeRope(Rope baseValue, int offsetValue, int byteLengthValue) {
                if (byteLengthValue > 1 && RopeNodes.MakeSubstringNode.sameAsBase(baseValue, offsetValue, byteLengthValue)) {
                    return this.root.substringSameAsBase(baseValue, offsetValue, byteLengthValue);
                }
                return this.getNext().executeRope(baseValue, offsetValue, byteLengthValue);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object offsetValue, Object byteLengthValue) {
                if (baseValue instanceof Rope && RubyTypesGen.isImplicitInteger(offsetValue, this.offsetImplicitType) && RubyTypesGen.isImplicitInteger(byteLengthValue, this.byteLengthImplicitType)) {
                    Rope baseValue_ = (Rope)baseValue;
                    int offsetValue_ = RubyTypesGen.asImplicitInteger(offsetValue, this.offsetImplicitType);
                    int byteLengthValue_ = RubyTypesGen.asImplicitInteger(byteLengthValue, this.byteLengthImplicitType);
                    if (byteLengthValue_ > 1 && RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                        return this.root.substringSameAsBase(baseValue_, offsetValue_, byteLengthValue_);
                    }
                }
                return this.getNext().executeRope_(baseValue, offsetValue, byteLengthValue);
            }

            static BaseNode_ create(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue) {
                return new SubstringSameAsBaseNode_(root, offsetValue, byteLengthValue);
            }
        }

        @GeneratedBy(methodName="substringOneByte(Rope, int, int, ConditionProfile, ConditionProfile, ConditionProfile, GetByteNode)", value=RopeNodes.MakeSubstringNode.class)
        private static final class SubstringOneByteNode_
        extends BaseNode_ {
            private final ConditionProfile isUTF8;
            private final ConditionProfile isUSAscii;
            private final ConditionProfile isAscii8Bit;
            @Node.Child
            private RopeNodes.GetByteNode getByteNode;
            private final Class<?> offsetImplicitType;
            private final Class<?> byteLengthImplicitType;

            SubstringOneByteNode_(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue, ConditionProfile isUTF8, ConditionProfile isUSAscii, ConditionProfile isAscii8Bit, RopeNodes.GetByteNode getByteNode) {
                super(root, 2);
                this.offsetImplicitType = RubyTypesGen.getImplicitIntegerClass(offsetValue);
                this.byteLengthImplicitType = RubyTypesGen.getImplicitIntegerClass(byteLengthValue);
                this.isUTF8 = isUTF8;
                this.isUSAscii = isUSAscii;
                this.isAscii8Bit = isAscii8Bit;
                this.getByteNode = getByteNode;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.offsetImplicitType == ((SubstringOneByteNode_)other).offsetImplicitType && this.byteLengthImplicitType == ((SubstringOneByteNode_)other).byteLengthImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int byteLengthValue_;
                int offsetValue_;
                Rope baseValue_;
                try {
                    baseValue_ = MakeSubstringNodeGen.expectRope(this.root.base_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object offsetValue = this.executeOffset_(frameValue);
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(ex.getResult(), offsetValue, byteLengthValue);
                }
                try {
                    if (this.offsetImplicitType == Integer.TYPE) {
                        offsetValue_ = this.root.offset_.executeInteger(frameValue);
                    } else {
                        Object offsetValue__ = this.executeOffset_(frameValue);
                        offsetValue_ = RubyTypesGen.expectImplicitInteger(offsetValue__, this.offsetImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(baseValue_, ex.getResult(), byteLengthValue);
                }
                try {
                    if (this.byteLengthImplicitType == Integer.TYPE) {
                        byteLengthValue_ = this.root.byteLength_.executeInteger(frameValue);
                    } else {
                        Object byteLengthValue__ = this.executeByteLength_(frameValue);
                        byteLengthValue_ = RubyTypesGen.expectImplicitInteger(byteLengthValue__, this.byteLengthImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeRope_(baseValue_, offsetValue_, ex.getResult());
                }
                if (byteLengthValue_ == 1) {
                    return this.root.substringOneByte(baseValue_, offsetValue_, byteLengthValue_, this.isUTF8, this.isUSAscii, this.isAscii8Bit, this.getByteNode);
                }
                return this.getNext().executeRope_(baseValue_, offsetValue_, byteLengthValue_);
            }

            @Override
            public Rope executeRope(Rope baseValue, int offsetValue, int byteLengthValue) {
                if (byteLengthValue == 1) {
                    return this.root.substringOneByte(baseValue, offsetValue, byteLengthValue, this.isUTF8, this.isUSAscii, this.isAscii8Bit, this.getByteNode);
                }
                return this.getNext().executeRope(baseValue, offsetValue, byteLengthValue);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object offsetValue, Object byteLengthValue) {
                if (baseValue instanceof Rope && RubyTypesGen.isImplicitInteger(offsetValue, this.offsetImplicitType) && RubyTypesGen.isImplicitInteger(byteLengthValue, this.byteLengthImplicitType)) {
                    Rope baseValue_ = (Rope)baseValue;
                    int offsetValue_ = RubyTypesGen.asImplicitInteger(offsetValue, this.offsetImplicitType);
                    int byteLengthValue_ = RubyTypesGen.asImplicitInteger(byteLengthValue, this.byteLengthImplicitType);
                    if (byteLengthValue_ == 1) {
                        return this.root.substringOneByte(baseValue_, offsetValue_, byteLengthValue_, this.isUTF8, this.isUSAscii, this.isAscii8Bit, this.getByteNode);
                    }
                }
                return this.getNext().executeRope_(baseValue, offsetValue, byteLengthValue);
            }

            static BaseNode_ create(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue, ConditionProfile isUTF8, ConditionProfile isUSAscii, ConditionProfile isAscii8Bit, RopeNodes.GetByteNode getByteNode) {
                return new SubstringOneByteNode_(root, offsetValue, byteLengthValue, isUTF8, isUSAscii, isAscii8Bit, getByteNode);
            }
        }

        @GeneratedBy(methodName="substringZeroBytes(Rope, int, int, ConditionProfile, ConditionProfile, ConditionProfile, WithEncodingNode)", value=RopeNodes.MakeSubstringNode.class)
        private static final class SubstringZeroBytesNode_
        extends BaseNode_ {
            private final ConditionProfile isUTF8;
            private final ConditionProfile isUSAscii;
            private final ConditionProfile isAscii8Bit;
            @Node.Child
            private RopeNodes.WithEncodingNode withEncodingNode;
            private final Class<?> offsetImplicitType;
            private final Class<?> byteLengthImplicitType;

            SubstringZeroBytesNode_(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue, ConditionProfile isUTF8, ConditionProfile isUSAscii, ConditionProfile isAscii8Bit, RopeNodes.WithEncodingNode withEncodingNode) {
                super(root, 1);
                this.offsetImplicitType = RubyTypesGen.getImplicitIntegerClass(offsetValue);
                this.byteLengthImplicitType = RubyTypesGen.getImplicitIntegerClass(byteLengthValue);
                this.isUTF8 = isUTF8;
                this.isUSAscii = isUSAscii;
                this.isAscii8Bit = isAscii8Bit;
                this.withEncodingNode = withEncodingNode;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.offsetImplicitType == ((SubstringZeroBytesNode_)other).offsetImplicitType && this.byteLengthImplicitType == ((SubstringZeroBytesNode_)other).byteLengthImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int byteLengthValue_;
                int offsetValue_;
                Rope baseValue_;
                try {
                    baseValue_ = MakeSubstringNodeGen.expectRope(this.root.base_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object offsetValue = this.executeOffset_(frameValue);
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(ex.getResult(), offsetValue, byteLengthValue);
                }
                try {
                    if (this.offsetImplicitType == Integer.TYPE) {
                        offsetValue_ = this.root.offset_.executeInteger(frameValue);
                    } else {
                        Object offsetValue__ = this.executeOffset_(frameValue);
                        offsetValue_ = RubyTypesGen.expectImplicitInteger(offsetValue__, this.offsetImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object byteLengthValue = this.executeByteLength_(frameValue);
                    return this.getNext().executeRope_(baseValue_, ex.getResult(), byteLengthValue);
                }
                try {
                    if (this.byteLengthImplicitType == Integer.TYPE) {
                        byteLengthValue_ = this.root.byteLength_.executeInteger(frameValue);
                    } else {
                        Object byteLengthValue__ = this.executeByteLength_(frameValue);
                        byteLengthValue_ = RubyTypesGen.expectImplicitInteger(byteLengthValue__, this.byteLengthImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeRope_(baseValue_, offsetValue_, ex.getResult());
                }
                if (byteLengthValue_ == 0) {
                    return this.root.substringZeroBytes(baseValue_, offsetValue_, byteLengthValue_, this.isUTF8, this.isUSAscii, this.isAscii8Bit, this.withEncodingNode);
                }
                return this.getNext().executeRope_(baseValue_, offsetValue_, byteLengthValue_);
            }

            @Override
            public Rope executeRope(Rope baseValue, int offsetValue, int byteLengthValue) {
                if (byteLengthValue == 0) {
                    return this.root.substringZeroBytes(baseValue, offsetValue, byteLengthValue, this.isUTF8, this.isUSAscii, this.isAscii8Bit, this.withEncodingNode);
                }
                return this.getNext().executeRope(baseValue, offsetValue, byteLengthValue);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object offsetValue, Object byteLengthValue) {
                if (baseValue instanceof Rope && RubyTypesGen.isImplicitInteger(offsetValue, this.offsetImplicitType) && RubyTypesGen.isImplicitInteger(byteLengthValue, this.byteLengthImplicitType)) {
                    Rope baseValue_ = (Rope)baseValue;
                    int offsetValue_ = RubyTypesGen.asImplicitInteger(offsetValue, this.offsetImplicitType);
                    int byteLengthValue_ = RubyTypesGen.asImplicitInteger(byteLengthValue, this.byteLengthImplicitType);
                    if (byteLengthValue_ == 0) {
                        return this.root.substringZeroBytes(baseValue_, offsetValue_, byteLengthValue_, this.isUTF8, this.isUSAscii, this.isAscii8Bit, this.withEncodingNode);
                    }
                }
                return this.getNext().executeRope_(baseValue, offsetValue, byteLengthValue);
            }

            static BaseNode_ create(MakeSubstringNodeGen root, Object offsetValue, Object byteLengthValue, ConditionProfile isUTF8, ConditionProfile isUSAscii, ConditionProfile isAscii8Bit, RopeNodes.WithEncodingNode withEncodingNode) {
                return new SubstringZeroBytesNode_(root, offsetValue, byteLengthValue, isUTF8, isUSAscii, isAscii8Bit, withEncodingNode);
            }
        }

        @GeneratedBy(value=RopeNodes.MakeSubstringNode.class)
        private static final class PolymorphicNode_
        extends BaseNode_ {
            PolymorphicNode_(MakeSubstringNodeGen root) {
                super(root, 0);
            }

            @Override
            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object baseValue, Object offsetValue, Object byteLengthValue) {
                return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, baseValue, offsetValue, byteLengthValue));
            }

            @Override
            public Rope executeRope_(Object baseValue, Object offsetValue, Object byteLengthValue) {
                return this.getNext().executeRope_(baseValue, offsetValue, byteLengthValue);
            }

            static BaseNode_ create(MakeSubstringNodeGen root) {
                return new PolymorphicNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.MakeSubstringNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(MakeSubstringNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public Rope executeRope_(Object baseValue, Object offsetValue, Object byteLengthValue) {
                return (Rope)this.uninitialized((Frame)null, baseValue, offsetValue, byteLengthValue);
            }

            static BaseNode_ create(MakeSubstringNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=RopeNodes.MakeSubstringNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            @CompilerDirectives.CompilationFinal
            protected MakeSubstringNodeGen root;

            BaseNode_(MakeSubstringNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            @Override
            protected final void setRoot(Node root) {
                this.root = (MakeSubstringNodeGen)root;
            }

            @Override
            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.base_, this.root.offset_, this.root.byteLength_};
            }

            @Override
            public final Object acceptAndExecute(Frame frameValue, Object baseValue, Object offsetValue, Object byteLengthValue) {
                return this.executeRope_(baseValue, offsetValue, byteLengthValue);
            }

            public abstract Rope executeRope_(Object var1, Object var2, Object var3);

            public Rope executeRope(Rope baseValue, int offsetValue, int byteLengthValue) {
                return this.executeRope_(baseValue, offsetValue, byteLengthValue);
            }

            public Object execute(VirtualFrame frameValue) {
                Object baseValue_ = this.root.base_.execute(frameValue);
                Object offsetValue_ = this.executeOffset_(frameValue);
                Object byteLengthValue_ = this.executeByteLength_(frameValue);
                return this.executeRope_(baseValue_, offsetValue_, byteLengthValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            @Override
            protected final SpecializationNode createNext(Frame frameValue, Object baseValue, Object offsetValue, Object byteLengthValue) {
                if (RubyTypesGen.isImplicitInteger(offsetValue) && RubyTypesGen.isImplicitInteger(byteLengthValue)) {
                    Rope baseValue_;
                    int offsetValue_ = RubyTypesGen.asImplicitInteger(offsetValue);
                    int byteLengthValue_ = RubyTypesGen.asImplicitInteger(byteLengthValue);
                    if (baseValue instanceof Rope) {
                        baseValue_ = (Rope)baseValue;
                        if (byteLengthValue_ == 0) {
                            ConditionProfile isUTF81 = ConditionProfile.createBinaryProfile();
                            ConditionProfile isUSAscii1 = ConditionProfile.createBinaryProfile();
                            ConditionProfile isAscii8Bit1 = ConditionProfile.createBinaryProfile();
                            RopeNodes.WithEncodingNode withEncodingNode1 = RopeNodes.WithEncodingNode.create();
                            return SubstringZeroBytesNode_.create(this.root, offsetValue, byteLengthValue, isUTF81, isUSAscii1, isAscii8Bit1, withEncodingNode1);
                        }
                        if (byteLengthValue_ == 1) {
                            ConditionProfile isUTF82 = ConditionProfile.createBinaryProfile();
                            ConditionProfile isUSAscii2 = ConditionProfile.createBinaryProfile();
                            ConditionProfile isAscii8Bit2 = ConditionProfile.createBinaryProfile();
                            RopeNodes.GetByteNode getByteNode2 = RopeNodes.GetByteNode.create();
                            return SubstringOneByteNode_.create(this.root, offsetValue, byteLengthValue, isUTF82, isUSAscii2, isAscii8Bit2, getByteNode2);
                        }
                        if (byteLengthValue_ > 1 && RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                            return SubstringSameAsBaseNode_.create(this.root, offsetValue, byteLengthValue);
                        }
                    }
                    if (baseValue instanceof LeafRope) {
                        baseValue_ = (LeafRope)baseValue;
                        if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                            ConditionProfile is7BitProfile4 = ConditionProfile.createBinaryProfile();
                            ConditionProfile isBinaryStringProfile4 = ConditionProfile.createBinaryProfile();
                            return SubstringLeafRopeNode_.create(this.root, offsetValue, byteLengthValue, is7BitProfile4, isBinaryStringProfile4);
                        }
                    }
                    if (baseValue instanceof SubstringRope) {
                        baseValue_ = (SubstringRope)baseValue;
                        if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                            ConditionProfile is7BitProfile5 = ConditionProfile.createBinaryProfile();
                            ConditionProfile isBinaryStringProfile5 = ConditionProfile.createBinaryProfile();
                            return SubstringSubstringRopeNode_.create(this.root, offsetValue, byteLengthValue, is7BitProfile5, isBinaryStringProfile5);
                        }
                    }
                    if (baseValue instanceof RepeatingRope) {
                        baseValue_ = (RepeatingRope)baseValue;
                        if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                            ConditionProfile is7BitProfile6 = ConditionProfile.createBinaryProfile();
                            ConditionProfile isBinaryStringProfile6 = ConditionProfile.createBinaryProfile();
                            ConditionProfile matchesChildProfile6 = ConditionProfile.createBinaryProfile();
                            return SubstringRepeatingRopeNode_.create(this.root, offsetValue, byteLengthValue, is7BitProfile6, isBinaryStringProfile6, matchesChildProfile6);
                        }
                    }
                    if (baseValue instanceof LazyRope) {
                        baseValue_ = (LazyRope)baseValue;
                        if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                            ConditionProfile is7BitProfile7 = ConditionProfile.createBinaryProfile();
                            ConditionProfile isBinaryStringProfile7 = ConditionProfile.createBinaryProfile();
                            return SubstringLazyRopeNode_.create(this.root, offsetValue, byteLengthValue, is7BitProfile7, isBinaryStringProfile7);
                        }
                    }
                    if (baseValue instanceof ConcatRope) {
                        baseValue_ = (ConcatRope)baseValue;
                        if (byteLengthValue_ > 1 && !RopeNodes.MakeSubstringNode.sameAsBase(baseValue_, offsetValue_, byteLengthValue_)) {
                            ConditionProfile is7BitProfile8 = ConditionProfile.createBinaryProfile();
                            ConditionProfile isBinaryStringProfile8 = ConditionProfile.createBinaryProfile();
                            return SubstringConcatRopeNode_.create(this.root, offsetValue, byteLengthValue, is7BitProfile8, isBinaryStringProfile8);
                        }
                    }
                }
                return null;
            }

            @Override
            protected final SpecializationNode createPolymorphic() {
                return PolymorphicNode_.create(this.root);
            }

            protected final BaseNode_ getNext() {
                return (BaseNode_)this.next;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected final Object executeOffset_(Frame frameValue) {
                Object object;
                Class offsetType_ = this.root.offsetType_;
                if (offsetType_ == Integer.TYPE) {
                    return this.root.offset_.executeInteger((VirtualFrame)frameValue);
                }
                if (offsetType_ != null) return this.root.offset_.execute((VirtualFrame)frameValue);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Class<Object> _type = Object.class;
                try {
                    Object _value = this.root.offset_.execute((VirtualFrame)frameValue);
                    _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                    object = _value;
                }
                catch (Throwable throwable) {
                    try {
                        this.root.offsetType_ = _type;
                        throw throwable;
                    }
                    catch (UnexpectedResultException ex) {
                        this.root.offsetType_ = Object.class;
                        return ex.getResult();
                    }
                }
                this.root.offsetType_ = _type;
                return object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected final Object executeByteLength_(Frame frameValue) {
                Object object;
                Class byteLengthType_ = this.root.byteLengthType_;
                if (byteLengthType_ == Integer.TYPE) {
                    return this.root.byteLength_.executeInteger((VirtualFrame)frameValue);
                }
                if (byteLengthType_ != null) return this.root.byteLength_.execute((VirtualFrame)frameValue);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Class<Object> _type = Object.class;
                try {
                    Object _value = this.root.byteLength_.execute((VirtualFrame)frameValue);
                    _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                    object = _value;
                }
                catch (Throwable throwable) {
                    try {
                        this.root.byteLengthType_ = _type;
                        throw throwable;
                    }
                    catch (UnexpectedResultException ex) {
                        this.root.byteLengthType_ = Object.class;
                        return ex.getResult();
                    }
                }
                this.root.byteLengthType_ = _type;
                return object;
            }
        }
    }
}

