/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractConnector;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.Rectangle;

public class ChopBoxConnector
extends AbstractConnector {
    private static final long serialVersionUID = -1461450322712345462L;

    public ChopBoxConnector() {
    }

    public ChopBoxConnector(Figure figure) {
        super(figure);
    }

    public Point findStart(ConnectionFigure connectionFigure) {
        Figure figure = connectionFigure.start().owner();
        Rectangle rectangle = connectionFigure.end().displayBox();
        Point point = null;
        point = connectionFigure.pointCount() == 2 ? new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2) : connectionFigure.pointAt(1);
        return this.chop(figure, point);
    }

    public Point findEnd(ConnectionFigure connectionFigure) {
        Figure figure = connectionFigure.end().owner();
        Rectangle rectangle = connectionFigure.start().displayBox();
        Point point = null;
        point = connectionFigure.pointCount() == 2 ? new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2) : connectionFigure.pointAt(connectionFigure.pointCount() - 2);
        return this.chop(figure, point);
    }

    protected Point chop(Figure figure, Point point) {
        Rectangle rectangle = figure.displayBox();
        return Geom.angleToPoint(rectangle, Geom.pointToAngle(rectangle, point));
    }
}

