/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import org.sejda.conversion.AdapterUtils;
import org.sejda.conversion.PdfPageTransitionAdapter;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.exception.SejdaRuntimeException;
import org.sejda.model.pdf.transition.PdfPageTransition;

public class PageNumberWithPdfPageTransitionAdapter {
    private static final int PAGE_NUMBER_INDEX = 3;
    private static final int MIN_SEPARATOR_OCCURENCES = 4;
    private Integer pageNumber;
    private PdfPageTransition pdfPageTransition;

    public PageNumberWithPdfPageTransitionAdapter(String input) {
        try {
            this.doParse(input);
        }
        catch (SejdaRuntimeException e) {
            throw new ConversionException("Unparsable page transition definition: '" + input + "'. " + e.getMessage(), e);
        }
    }

    private void doParse(String input) {
        String[] tokens = AdapterUtils.splitAndTrim(input);
        if (tokens.length < 4) {
            throw new ConversionException("Expected format is: 'transitionType:transitionDurationInSec:pageDisplayDurationInSec:pageNumber'");
        }
        this.pdfPageTransition = new PdfPageTransitionAdapter(tokens[0] + ":" + tokens[1] + ":" + tokens[2]).getPdfPageTransition();
        this.pageNumber = AdapterUtils.parseInt(tokens[3], "page number");
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public final PdfPageTransition getPdfPageTransition() {
        return this.pdfPageTransition;
    }
}

