/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.context;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.common.XMLUtils;
import org.sejda.core.context.ConfigurationStrategy;
import org.sejda.core.context.ConfigurationStreamProvider;
import org.sejda.core.notification.strategy.AsyncNotificationStrategy;
import org.sejda.core.notification.strategy.NotificationStrategy;
import org.sejda.core.notification.strategy.SyncNotificationStrategy;
import org.sejda.model.exception.ConfigurationException;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class XmlConfigurationStrategy
implements ConfigurationStrategy {
    private static final String ROOT_NODE = "/sejda";
    private static final String VALIDATION_ATTRIBUTENAME = "validation";
    private static final String IGNORE_XML_CONFIG_VALIDATION_ATTRIBUTENAME = "ignore_xml_config";
    private static final String NOTIFICATION_XPATH = "/notification";
    private static final String NOTIFICATION_ASYNC_ATTRIBUTENAME = "async";
    private static final String TASKS_XPATH = "/tasks/task";
    private static final String TASK_PARAM_ATTRIBUTENAME = "parameters";
    private static final String TASK_VALUE_ATTRIBUTENAME = "task";
    private static final String DEFAULT_SEJDA_CONFIG = "sejda.xsd";
    private XPathFactory xpathFactory = XPathFactory.newInstance();
    private Class<? extends NotificationStrategy> notificationStrategy;
    private Map<Class<? extends TaskParameters>, Class<? extends Task>> tasks;
    private boolean validation = false;
    private boolean ignoreXmlConfig = true;

    private XmlConfigurationStrategy(InputStream input) throws ConfigurationException {
        this.initializeFromInputStream(input);
    }

    private void initializeFromInputStream(InputStream input) throws ConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.initializeSchemaValidation(factory);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(input);
            this.notificationStrategy = this.getNotificationStrategy(document);
            this.tasks = this.getTasksMap(document);
            this.validation = this.getValidation(document);
            this.ignoreXmlConfig = this.getIgnoreXmlConfig(document);
        }
        catch (IOException | SAXException e) {
            throw new ConfigurationException(e);
        }
        catch (ParserConfigurationException | XPathExpressionException e) {
            throw new ConfigurationException("Unable to create DocumentBuilder.", e);
        }
    }

    private void initializeSchemaValidation(DocumentBuilderFactory factory) throws SAXException {
        if (Boolean.getBoolean("sejda.perform.schema.validation")) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setSchema(schemaFactory.newSchema(new Source[]{new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_SEJDA_CONFIG))}));
            factory.setNamespaceAware(true);
        }
    }

    @Override
    public Class<? extends NotificationStrategy> getNotificationStrategy() {
        return this.notificationStrategy;
    }

    @Override
    public Map<Class<? extends TaskParameters>, Class<? extends Task>> getTasksMap() {
        return this.tasks;
    }

    @Override
    public boolean isValidation() {
        return this.validation;
    }

    @Override
    public boolean isIgnoreXmlConfiguration() {
        return this.ignoreXmlConfig;
    }

    private Map<Class<? extends TaskParameters>, Class<? extends Task>> getTasksMap(Document document) throws ConfigurationException, XPathExpressionException {
        HashMap<Class<? extends TaskParameters>, Class<? extends Task>> retMap = new HashMap<Class<? extends TaskParameters>, Class<? extends Task>>();
        NodeList nodes = (NodeList)this.xpathFactory.newXPath().evaluate("/sejda/tasks/task", document, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            Class<TaskParameters> paramClass = this.getClassFromNode(node, TASK_PARAM_ATTRIBUTENAME, TaskParameters.class);
            Class<Task> taksClass = this.getClassFromNode(node, TASK_VALUE_ATTRIBUTENAME, Task.class);
            retMap.put(paramClass, taksClass);
        }
        return retMap;
    }

    private <T> Class<? extends T> getClassFromNode(Node node, String attributeName, Class<T> assignableInterface) throws ConfigurationException {
        String attributeValue = XMLUtils.nullSafeGetStringAttribute(node, attributeName);
        if (StringUtils.isNotBlank(attributeValue)) {
            Class<?> clazz;
            try {
                clazz = Class.forName(attributeValue.trim());
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(String.format("Unable to find the configured %s", attributeValue), e);
            }
            if (assignableInterface.isAssignableFrom(clazz)) {
                return clazz.asSubclass(assignableInterface);
            }
            throw new ConfigurationException(String.format("The configured %s is not a subtype of %s", clazz, assignableInterface));
        }
        throw new ConfigurationException(String.format("Missing %s configuration parameter.", attributeName));
    }

    private Class<? extends NotificationStrategy> getNotificationStrategy(Document document) throws XPathExpressionException {
        Node node = (Node)this.xpathFactory.newXPath().evaluate("/sejda/notification", document, XPathConstants.NODE);
        if (XMLUtils.nullSafeGetBooleanAttribute(node, NOTIFICATION_ASYNC_ATTRIBUTENAME)) {
            return AsyncNotificationStrategy.class;
        }
        return SyncNotificationStrategy.class;
    }

    private boolean getValidation(Document document) throws XPathExpressionException {
        Node node = (Node)this.xpathFactory.newXPath().evaluate(ROOT_NODE, document, XPathConstants.NODE);
        return XMLUtils.nullSafeGetBooleanAttribute(node, VALIDATION_ATTRIBUTENAME);
    }

    private boolean getIgnoreXmlConfig(Document document) throws XPathExpressionException {
        Node node = (Node)this.xpathFactory.newXPath().evaluate(ROOT_NODE, document, XPathConstants.NODE);
        return XMLUtils.nullSafeGetBooleanAttribute(node, IGNORE_XML_CONFIG_VALIDATION_ATTRIBUTENAME, true);
    }

    static XmlConfigurationStrategy newInstance(ConfigurationStreamProvider provider) throws ConfigurationException {
        InputStream stream = null;
        try {
            stream = provider.getConfigurationStream();
            XmlConfigurationStrategy xmlConfigurationStrategy = new XmlConfigurationStrategy(stream);
            return xmlConfigurationStrategy;
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }
}

