/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot.parser;

import com.baselet.element.elementnew.plot.parser.DataSet;
import com.baselet.element.elementnew.plot.parser.KeyValue;
import com.baselet.element.elementnew.plot.parser.ParserException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class PlotState {
    private final List<PlotState> subPlots = new ArrayList<PlotState>();
    private DataSet dataset;
    private final HashMap<String, KeyValue> values;
    private final int plotLineNr;

    protected PlotState(int plotLineNr, HashMap<String, KeyValue> values) {
        this.plotLineNr = plotLineNr;
        this.values = values;
    }

    protected void setDataSet(DataSet dataset) {
        this.dataset = dataset;
    }

    public void addSubPlot(PlotState plotState) {
        this.subPlots.add(plotState);
    }

    public List<PlotState> getSubplots() {
        return this.subPlots;
    }

    public DataSet getDataSet() {
        return this.dataset;
    }

    public boolean containsKey(String key) {
        return this.values.containsKey(key);
    }

    public int getLine(String key) {
        if (this.values.get(key) != null) {
            return this.values.get(key).getLine();
        }
        return -1;
    }

    public int getPlotLineNr() {
        return this.plotLineNr;
    }

    public String getValue(String key, String defaultValue) {
        KeyValue keyValue = this.values.get(key);
        if (keyValue != null) {
            keyValue.setUsed(true);
        }
        if (keyValue == null || keyValue.getValue().equals("auto")) {
            return defaultValue;
        }
        return keyValue.getValue();
    }

    public String getValueValidated(String key, String defaultValue, List<String> validValues) {
        String value = this.getValue(key, defaultValue);
        if (!validValues.contains(value)) {
            throw new ParserException(key, value, this.getLine(key));
        }
        return value;
    }

    public Double getValueAsDouble(String key, Double defaultValue) {
        try {
            String value = this.getValue(key, null);
            if (value == null) {
                return defaultValue;
            }
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            throw new ParserException(key, this.values.get(key).getValue(), this.values.get(key).getLine());
        }
    }

    public Integer getValueAsInt(String key, Integer defaultValue) {
        try {
            String value = this.getValue(key, null);
            if (value == null) {
                return defaultValue;
            }
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new ParserException(key, this.values.get(key).getValue(), this.values.get(key).getLine());
        }
    }

    public Boolean getValueAsBoolean(String key, Boolean defaultValue) {
        String value = this.getValue(key, null);
        if (value == null) {
            return defaultValue;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new ParserException(key, this.values.get(key).getValue(), this.values.get(key).getLine());
    }

    public List<String> getValueList(String key, List<String> defaultValue) {
        String value = this.getValue(key, null);
        List<String> returnArray = value == null ? defaultValue : Arrays.asList(value.split(","));
        return returnArray;
    }

    public List<String> getValueListValidated(String key, List<String> defaultValue, List<String> validValues, boolean doubleValuesAllowed) {
        List<String> valueList = this.getValueList(key, defaultValue);
        for (String value : valueList) {
            boolean intAllowedAndValueIsInt;
            boolean bl = intAllowedAndValueIsInt = doubleValuesAllowed && this.isDoubleValue(value);
            if (validValues.contains(value) || intAllowedAndValueIsInt) continue;
            throw new ParserException(key, value, this.getLine(key));
        }
        return valueList;
    }

    private boolean isDoubleValue(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void checkIfAllValuesUsed() {
        StringBuilder sb = new StringBuilder("");
        for (KeyValue keyValue : this.values.values()) {
            if (keyValue.isUsed()) continue;
            sb.append("\"").append(keyValue.getKey()).append("=").append(keyValue.getValue()).append("\" (line ").append(keyValue.getLine()).append(") ");
        }
        String unusedVariables = sb.toString();
        if (!unusedVariables.isEmpty()) {
            throw new ParserException("Invalid variables: " + unusedVariables);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        sb.append("PlotState (").append(this.plotLineNr).append(")\n");
        if (this.dataset != null) {
            sb.append("\tdataset -> ").append(this.dataset.getLineNr()).append("\n");
        }
        for (KeyValue keyValue : this.values.values()) {
            sb.append("\t").append(keyValue).append("\n");
        }
        if (!this.subPlots.isEmpty()) {
            sb.append("---Begin Subplots---\n");
            for (PlotState subPlot : this.subPlots) {
                sb.append(subPlot.toString());
            }
            sb.append("---End Subplots---\n");
        }
        return sb.toString();
    }
}

