/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JTree;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class PopupMenuExportURLs
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private static final String CRLF = "\r\n";
    private ExtensionHistory extension = null;
    private static Logger log = Logger.getLogger(PopupMenuExportURLs.class);

    public PopupMenuExportURLs() {
        this.initialize();
    }

    public PopupMenuExportURLs(String string) {
        super(string);
    }

    private void initialize() {
        this.setText(Constant.messages.getString("exportUrls.popup"));
        this.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                JTree jTree = PopupMenuExportURLs.this.extension.getView().getSiteTreePanel().getTreeSite();
                File file = PopupMenuExportURLs.this.getOutputFile();
                if (file == null) {
                    return;
                }
                boolean bl = true;
                if (file.exists()) {
                    n = PopupMenuExportURLs.this.extension.getView().showYesNoCancelDialog(Constant.messages.getString("file.overwrite.warning"));
                    if (n == 2) {
                        return;
                    }
                    if (!n) {
                        bl = false;
                    }
                }
                n = file.getName().toLowerCase().endsWith(".htm") || file.getName().toLowerCase().endsWith(".html") ? 1 : 0;
                BufferedWriter bufferedWriter = null;
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter(file, bl));
                    PopupMenuExportURLs.this.exportURLs((SiteNode)jTree.getModel().getRoot(), bufferedWriter, n != 0);
                }
                catch (Exception exception) {
                    log.warn((Object)exception.getStackTrace(), (Throwable)exception);
                    PopupMenuExportURLs.this.extension.getView().showWarningDialog(Constant.messages.getString("file.save.error") + file.getAbsolutePath());
                }
                finally {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {
                        log.warn((Object)exception.getStackTrace(), (Throwable)exception);
                    }
                }
            }
        });
    }

    public void setExtension(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }

    private void exportURLs(SiteNode siteNode, BufferedWriter bufferedWriter, boolean bl) {
        Object object;
        if (siteNode == null) {
            return;
        }
        try {
            if (siteNode.getHistoryReference() != null && (siteNode.getHistoryReference().getHistoryType() == 1 || siteNode.getHistoryReference().getHistoryType() == 15 || siteNode.getHistoryReference().getHistoryType() == 2) && (object = siteNode.getHistoryReference().getHttpMessage()) != null && ((HttpMessage)object).getRequestHeader().getURI() != null) {
                bufferedWriter.write(((HttpMessage)object).getRequestHeader().getMethod());
                bufferedWriter.write("\t");
                if (bl) {
                    bufferedWriter.write("<a href=\"");
                    bufferedWriter.write(((HttpMessage)object).getRequestHeader().getURI().toString());
                    bufferedWriter.write("\">");
                    bufferedWriter.write(((HttpMessage)object).getRequestHeader().getURI().toString());
                    bufferedWriter.write("</a><br>");
                } else {
                    bufferedWriter.write(((HttpMessage)object).getRequestHeader().getURI().toString());
                }
                bufferedWriter.write(CRLF);
            }
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            log.warn((Object)httpMalformedHeaderException.getStackTrace(), (Throwable)httpMalformedHeaderException);
        }
        catch (IOException iOException) {
            log.warn((Object)iOException.getStackTrace(), (Throwable)iOException);
        }
        catch (DatabaseException databaseException) {
            log.warn((Object)databaseException.getStackTrace(), (Throwable)databaseException);
        }
        object = siteNode.children();
        while (object.hasMoreElements()) {
            this.exportURLs((SiteNode)object.nextElement(), bufferedWriter, bl);
        }
    }

    private File getOutputFile() {
        JFileChooser jFileChooser = new JFileChooser(this.extension.getModel().getOptionsParam().getUserDirectory());
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(Constant.messages.getString("file.format.ascii"), "txt");
        FileNameExtensionFilter fileNameExtensionFilter2 = new FileNameExtensionFilter(Constant.messages.getString("file.format.html"), "html", "htm");
        jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
        jFileChooser.addChoosableFileFilter(fileNameExtensionFilter2);
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        File file = null;
        int n = jFileChooser.showSaveDialog(this.extension.getView().getMainFrame());
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
            if (file == null) {
                return file;
            }
            this.extension.getModel().getOptionsParam().setUserDirectory(jFileChooser.getCurrentDirectory());
            String string = file.getAbsolutePath().toLowerCase();
            if (!(string.endsWith(".txt") || string.endsWith(".htm") || string.endsWith(".html"))) {
                String string2 = fileNameExtensionFilter2.equals(jFileChooser.getFileFilter()) ? ".html" : ".txt";
                file = new File(file.getAbsolutePath() + string2);
            }
            return file;
        }
        return file;
    }
}

