/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.widgets;

import java.io.File;
import java.nio.file.Files;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;

public class WritableFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -8600149638325315049L;
    private static final int MINIMUM_SPACE_REQUIREMENT_MB = 5000000;

    public WritableFileChooser() {
    }

    public WritableFileChooser(File file) {
        super(file);
    }

    @Override
    public void approveSelection() {
        int n;
        File file = this.getSelectedFile();
        File file2 = file;
        boolean bl = file2.exists();
        if (!bl) {
            file2 = file2.getParentFile();
        }
        if (file2.getUsableSpace() < 5000000L && (n = JOptionPane.showConfirmDialog(this, Constant.messages.getString("report.write.diskspace.warning.dialog.message"), Constant.messages.getString("report.write.diskspace.warning.dialog.title"), 0)) != 0) {
            return;
        }
        if (!Files.isWritable(file.getParentFile().toPath())) {
            this.warnNotWritable("report.write.permission.dir.dialog.message", file.getParentFile().getAbsolutePath());
            return;
        }
        if (bl) {
            if (!Files.isWritable(file.toPath())) {
                this.warnNotWritable("report.write.permission.file.dialog.message", file.getAbsolutePath());
                return;
            }
            n = JOptionPane.showConfirmDialog(this, Constant.messages.getString("report.write.overwrite.dialog.message"), Constant.messages.getString("report.write.overwrite.dialog.title"), 0);
            switch (n) {
                case 0: {
                    super.approveSelection();
                    return;
                }
                case -1: 
                case 1: {
                    return;
                }
            }
        }
        Model.getSingleton().getOptionsParam().setUserDirectory(this.getCurrentDirectory());
        super.approveSelection();
    }

    private void warnNotWritable(String string, String string2) {
        JOptionPane.showMessageDialog(this, MessageFormat.format(Constant.messages.getString(string), string2), Constant.messages.getString("report.write.permission.dialog.title"), 0);
    }
}

