/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.ApplicationBase;
import com.sun.glass.ui.Clipboard;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.EventLoop;
import com.sun.glass.ui.Launchable;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Platform;
import com.sun.glass.ui.PlatformFactory;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.utils.Disposer;
import com.sun.glass.utils.NativeLibLoader;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Application
extends ApplicationBase {
    private EventHandler eventHandler;
    private boolean initialActiveEventReceived = false;
    private String[] initialOpenedFiles = null;
    private static boolean loaded = false;
    private static Application application;
    private Thread eventThread;
    private static Map deviceDetails;
    private boolean terminateWhenLastWindowClosed = true;
    private static int nestedEventLoopCounter;

    public static synchronized void loadNativeLibrary(String libname) {
        if (!loaded) {
            NativeLibLoader.loadLibrary(libname);
            loaded = true;
        }
    }

    public static synchronized void loadNativeLibrary() {
        Application.loadNativeLibrary("glass");
    }

    public static void setDeviceDetails(Map details) {
        deviceDetails = details;
    }

    public static Map getDeviceDetails() {
        return deviceDetails;
    }

    public static void Run(String[] args, String title, Launchable launchable) {
        System.err.println("com.sun.glass.ui.Application.Run(String args[], String title, final Launchable launchable) is deprecated and will go away soon");
        Application.Run(args, launchable);
    }

    public static void Run(String[] args, Launchable launchable) {
        Disposer.init();
        application = PlatformFactory.getPlatformFactory().createApplication();
        Application.application.platform = Platform.DeterminePlatform();
        Application.application.args = args;
        Application.application.name = "java";
        Application.application.launchable = launchable;
        application.run();
    }

    private void run() {
        try {
            this.runLoop(this.args, this.launchable);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected abstract void runLoop(String[] var1, Launchable var2);

    protected void finishTerminating() {
    }

    private void notifyWillFinishLaunching() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleWillFinishLaunchingAction(this, System.nanoTime());
        }
    }

    private void notifyDidFinishLaunching() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleDidFinishLaunchingAction(this, System.nanoTime());
        }
    }

    private void notifyWillBecomeActive() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleWillBecomeActiveAction(this, System.nanoTime());
        }
    }

    private void notifyDidBecomeActive() {
        this.initialActiveEventReceived = true;
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleDidBecomeActiveAction(this, System.nanoTime());
        }
    }

    private void notifyWillResignActive() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleWillResignActiveAction(this, System.nanoTime());
        }
    }

    private void notifyDidResignActive() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleDidResignActiveAction(this, System.nanoTime());
        }
    }

    private void notifyWillHide() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleWillHideAction(this, System.nanoTime());
        }
    }

    private void notifyDidHide() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleDidHideAction(this, System.nanoTime());
        }
    }

    private void notifyWillUnhide() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleWillUnhideAction(this, System.nanoTime());
        }
    }

    private void notifyDidUnhide() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleDidUnhideAction(this, System.nanoTime());
        }
    }

    private void notifyOpenFiles(String[] files) {
        EventHandler handler;
        if (!this.initialActiveEventReceived && this.initialOpenedFiles == null) {
            this.initialOpenedFiles = files;
        }
        if ((handler = this.getEventHandler()) != null && files != null) {
            handler.handleOpenFilesAction(this, System.nanoTime(), files);
        }
    }

    private void notifyWillQuit() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleQuitAction(this, System.nanoTime());
        }
    }

    public void installDefaultMenus(MenuBar menubar) {
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        boolean resendOpenFiles = this.eventHandler != null && this.initialOpenedFiles != null;
        this.eventHandler = eventHandler;
        if (resendOpenFiles) {
            this.notifyOpenFiles(this.initialOpenedFiles);
        }
    }

    public final boolean shouldTerminateWhenLastWindowClosed() {
        return this.terminateWhenLastWindowClosed;
    }

    public final void setTerminateWhenLastWindowClosed(boolean b) {
        this.terminateWhenLastWindowClosed = b;
    }

    public boolean shouldUpdateWindow() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        try {
            Application application = this;
            synchronized (application) {
                Vector<Window> windows = new Vector<Window>(Window.getWindows());
                for (Window window : windows) {
                    window.setVisible(false);
                }
                for (Window window : windows) {
                    window.close();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.finishTerminating();
        }
    }

    public static Application GetApplication() {
        return application;
    }

    protected final void setEventThread(Thread thread) {
        this.eventThread = thread;
    }

    protected final Thread getEventThread() {
        return this.eventThread;
    }

    public static boolean checkEventThread(boolean throwException, String msg) {
        if (Thread.currentThread().equals(Application.GetApplication().getEventThread())) {
            return true;
        }
        if (throwException) {
            throw new RuntimeException(msg != null ? msg : "This operation is permitted on the event thread only");
        }
        return false;
    }

    public static boolean checkEventThread(boolean throwException) {
        return Application.checkEventThread(throwException, null);
    }

    public static void checkEventThread() {
        Application.checkEventThread(true);
    }

    protected abstract void _invokeAndWait(Runnable var1);

    public static void invokeAndWait(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (Application.checkEventThread(false, "")) {
            runnable.run();
        } else {
            Application.GetApplication()._invokeAndWait(runnable);
        }
    }

    protected abstract void _invokeLater(Runnable var1);

    public static void invokeLater(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        Application.GetApplication()._invokeLater(runnable);
    }

    protected abstract void _postOnEventQueue(Runnable var1);

    public static void postOnEventQueue(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        Application.GetApplication()._postOnEventQueue(runnable);
    }

    protected abstract Object _enterNestedEventLoop();

    protected abstract void _leaveNestedEventLoop(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object enterNestedEventLoop() {
        Application.checkEventThread();
        ++nestedEventLoopCounter;
        try {
            Object object = Application.GetApplication()._enterNestedEventLoop();
            return object;
        }
        finally {
            --nestedEventLoopCounter;
        }
    }

    public static void leaveNestedEventLoop(Object retValue) {
        Application.checkEventThread();
        if (nestedEventLoopCounter == 0) {
            throw new IllegalStateException("Not in a nested event loop");
        }
        Application.GetApplication()._leaveNestedEventLoop(retValue);
    }

    public void menuAboutAction() {
        System.err.println("about");
    }

    public abstract Window createWindow(Window var1, Screen var2, int var3);

    public Window createWindow(Screen screen, int styleMask) {
        return this.createWindow(null, screen, styleMask);
    }

    public abstract Window createWindow(long var1);

    public abstract View createView(Pen var1);

    protected Clipboard createClipboard(String name) {
        return Clipboard.get(name);
    }

    public abstract Cursor createCursor(int var1);

    public abstract Cursor createCursor(int var1, int var2, Pixels var3);

    protected abstract void staticCursor_setVisible(boolean var1);

    protected abstract Size staticCursor_getBestSize(int var1, int var2);

    public Cursor createCursor(Pixels pixels) {
        return this.createCursor(pixels.getWidth() / 2, pixels.getHeight() / 2, pixels);
    }

    public Menu createMenu(String title) {
        return new Menu(title);
    }

    public Menu createMenu(String title, boolean enabled) {
        return new Menu(title, enabled);
    }

    public MenuBar createMenuBar() {
        return new MenuBar();
    }

    public MenuItem createMenuItem(String title) {
        return this.createMenuItem(title, null);
    }

    public MenuItem createMenuItem(String title, MenuItem.Callback callback) {
        return this.createMenuItem(title, callback, 0, 0);
    }

    public MenuItem createMenuItem(String title, MenuItem.Callback callback, int shortcutKey, int shortcutModifiers) {
        return this.createMenuItem(title, callback, shortcutKey, shortcutModifiers, null);
    }

    public MenuItem createMenuItem(String title, MenuItem.Callback callback, int shortcutKey, int shortcutModifiers, Pixels pixels) {
        return new MenuItem(title, callback, shortcutKey, shortcutModifiers, pixels);
    }

    public abstract Pixels createPixels(int var1, int var2, ByteBuffer var3);

    public abstract Pixels createPixels(int var1, int var2, IntBuffer var3);

    public abstract Pixels createPixels(int var1, int var2, IntBuffer var3, float var4);

    protected abstract int staticPixels_getNativeFormat();

    static Pixels createPixels(int width, int height, int[] data, float scale) {
        return Application.GetApplication().createPixels(width, height, IntBuffer.wrap(data), scale);
    }

    static float getScaleFactor(int x, int y, int w, int h) {
        float scale = 0.0f;
        for (Screen s : Screen.getScreens()) {
            int sx = s.getX();
            int sy = s.getY();
            int sw = s.getWidth();
            int sh = s.getHeight();
            if (x >= sx + sw || x + w <= sx || y >= sy + sh || y + h <= sy || !(scale < s.getScale())) continue;
            scale = s.getScale();
        }
        return scale == 0.0f ? 1.0f : scale;
    }

    public abstract Robot createRobot();

    protected abstract Screen staticScreen_getDeepestScreen();

    protected abstract Screen staticScreen_getMainScreen();

    protected abstract Screen staticScreen_getScreenForLocation(int var1, int var2);

    protected abstract Screen staticScreen_getScreenForPtr(long var1);

    protected abstract List<Screen> staticScreen_getScreens();

    public abstract Timer createTimer(Runnable var1);

    protected abstract int staticTimer_getMinPeriod();

    protected abstract int staticTimer_getMaxPeriod();

    public final EventLoop createEventLoop() {
        return new EventLoop();
    }

    protected abstract List<File> staticCommonDialogs_showFileChooser(Window var1, String var2, String var3, String var4, int var5, boolean var6, CommonDialogs.ExtensionFilter[] var7);

    protected abstract File staticCommonDialogs_showFolderChooser(Window var1, String var2, String var3);

    protected abstract long staticView_getMultiClickTime();

    protected abstract int staticView_getMultiClickMaxX();

    protected abstract int staticView_getMultiClickMaxY();

    protected void staticView_notifyRenderingEnd() {
    }

    public abstract boolean supportsTransparentWindows();

    protected boolean _supportsSystemMenu() {
        return false;
    }

    public boolean supportsSystemMenu() {
        Application.checkEventThread();
        return this._supportsSystemMenu();
    }

    static {
        deviceDetails = null;
        nestedEventLoopCounter = 0;
    }

    public static class EventHandler {
        public void handleWillFinishLaunchingAction(Application app, long time) {
        }

        public void handleDidFinishLaunchingAction(Application app, long time) {
        }

        public void handleWillBecomeActiveAction(Application app, long time) {
        }

        public void handleDidBecomeActiveAction(Application app, long time) {
        }

        public void handleWillResignActiveAction(Application app, long time) {
        }

        public void handleDidResignActiveAction(Application app, long time) {
        }

        public void handleWillHideAction(Application app, long time) {
        }

        public void handleDidHideAction(Application app, long time) {
        }

        public void handleWillUnhideAction(Application app, long time) {
        }

        public void handleDidUnhideAction(Application app, long time) {
        }

        public void handleOpenFilesAction(Application app, long time, String[] files) {
        }

        public void handleQuitAction(Application app, long time) {
        }
    }
}

