/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.AbstractEventLoop;
import java.util.concurrent.Callable;
import javafx.application.Platform;

public final class FxEventLoop {
    private static final Impl impl = new Impl();

    public static void enterNestedLoop() {
        impl.start();
    }

    public static void leaveNestedLoop() {
        impl.stop();
    }

    public static void sendEvent(Runnable runnable) {
        impl.send(runnable);
    }

    public static <V> V sendEvent(Callable<V> callable) {
        return impl.send(callable);
    }

    public static boolean isNestedLoopRunning() {
        return impl.isNestedLoopRunning();
    }

    private static final class Impl
    extends AbstractEventLoop {
        private final Object NESTED_EVENT_LOOP_KEY = new Object();
        private Object nestedEventLoopToken;
        private int depth;

        private Impl() {
        }

        @Override
        public void send(Runnable runnable) {
            if (Platform.isFxApplicationThread()) {
                runnable.run();
                return;
            }
            super.send(runnable);
        }

        @Override
        public <V> V send(Callable<V> callable) {
            if (Platform.isFxApplicationThread()) {
                try {
                    return callable.call();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            return super.send(callable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() {
            if (Platform.isFxApplicationThread()) {
                assert (this.depth == 0);
                ++this.depth;
                try {
                    this.nestedEventLoopToken = Toolkit.getToolkit().enterNestedEventLoop(this.NESTED_EVENT_LOOP_KEY);
                }
                finally {
                    --this.depth;
                }
            } else {
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        FxEventLoop.enterNestedLoop();
                    }
                });
            }
        }

        @Override
        public void stop() {
            if (Platform.isFxApplicationThread()) {
                Toolkit.getToolkit().exitNestedEventLoop(this.NESTED_EVENT_LOOP_KEY, this.nestedEventLoopToken);
                this.nestedEventLoopToken = null;
            } else {
                this.send(new Runnable(){

                    @Override
                    public void run() {
                        FxEventLoop.leaveNestedLoop();
                    }
                });
            }
        }

        @Override
        protected void schedule(Runnable runnable) {
            Platform.runLater(runnable);
        }

        boolean isNestedLoopRunning() {
            assert (Platform.isFxApplicationThread());
            return this.depth != 0;
        }
    }
}

